# -*- coding: UTF-8 -*-
import common
import cliUtil

from cli_util_cache import get_lun_detail_cache

LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = py_java_env.get("lang")
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    执行入口
    :param cli: ssh连接
    :return: cmd display
    """
    cli_ret_list = []
    try:
        hyperMetroLunCmd = "show hyper_metro_pair general |filterRow" \
                           " column=Type predict=equal_to value=LUN " \
                           "|filterColumn include " \
                           "columnList=WWN,Local\\sID"
        isSucc, echos, errMsg = \
            cliUtil.excuteCmdTimeOutInCliMode(cli, hyperMetroLunCmd,
                                              True, LANG, 3 * 60)
        cli_ret_list.append(echos)
        if cliUtil.queryResultWithNoRecord(echos):
            return True, "\n".join(cli_ret_list), ''

        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        pair_list = cliUtil.getHorizontalNostandardCliRet4Martiu(echos)
        if not pair_list:
            return True, "\n".join(cli_ret_list), ""

        hyper_lun_ids = [info.get("Local ID") for info in pair_list]
        mapped_lun, ret_list = get_mapped_lun(PY_JAVA_ENV, cli, hyper_lun_ids)
        cli_ret_list.extend(ret_list)
        LOGGER.logInfo("exist mapped lun: %s" % str(mapped_lun))
        if not mapped_lun:
            return True, "\n".join(cli_ret_list), ""
        common.refreshProcess(PY_JAVA_ENV, 99, LOGGER)

        deviceNode = common.getCurDeviceInfo(PY_JAVA_ENV)
        devSn = str(deviceNode.getDeviceSerialNumber())
        lunWwnDicts = PY_JAVA_ENV.get("allStrgHyprMtrLns")
        if not lunWwnDicts:
            LOGGER.logInfo("No hyper lun wwn info in context, quit!")
            tmp_msg = "No hyper metro lun wwn info in context."
            cli_ret_list.append(tmp_msg)
            key = "storage.query.hyperMetro.mapped.lun.failed"
            return (cliUtil.RESULT_NOCHECK, "\n".join(cli_ret_list),
                    common.getMsg(LANG, key))

        curDeviceLunStates = {}
        for lunWwn in lunWwnDicts:
            lunDeviceSns = lunWwnDicts[lunWwn].get("deviceSn", "")
            hostAluaStatus = lunWwnDicts[lunWwn].get("hostAluaStatus", "")
            lunIds = lunWwnDicts[lunWwn].get("lunId", "")
            if devSn in lunDeviceSns:
                poi = lunDeviceSns.split(",").index(devSn)
                lunId = len(lunIds.split(",")) > poi and lunIds.split(",")[poi] or "UNKNOWN"
                curDeviceLunStates[lunId] = hostAluaStatus
        if not curDeviceLunStates:
            LOGGER.logInfo("current device should have A-A luns but detected none , quit!")
            err_key = "storage.query.hyperMetro.mapped.lun.failed"
            return (cliUtil.RESULT_NOCHECK, "\n".join(cli_ret_list),
                    common.getMsg(LANG, err_key))

        undealt_luns = [lunId for lunId in curDeviceLunStates if int(curDeviceLunStates[lunId]) == 0]
        LOGGER.logInfo("current device's luns that is undiscoverable: %s." % str(",".join(undealt_luns)))
        result_status = True
        err_msg = ''
        if undealt_luns:
            # 开局巡检，主机未添加或者未添加完全，结果返回建议优化；日常巡检为不通过
            result_status = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(PY_JAVA_ENV) else False
            err_msg = common.getMsg(LANG, "follow.aa.lun.not.discovered.on.hosts", ",".join(undealt_luns))
            errMsg = getNotAddedHostInfo()
            err_msg += errMsg
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
        return result_status, "\n".join(cli_ret_list), err_msg
    except BaseException as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n".join(cli_ret_list),
                common.getMsg(LANG, "query.result.abnormal"))


def get_mapped_lun(context, cli, hyper_lun_ids):
    """获取已映射的双活LUN
    :param context: 上下文
    :param cli: ssh连接
    :param hyper_lun_ids: 双活LUN ID
    :return: 是否存在映射的LUN，回文
    """
    cli_ret_list = []
    process = 1
    exist_mapped_lun_list = []
    if not hyper_lun_ids:
        return exist_mapped_lun_list, cli_ret_list

    per_lun_process = (99.00 - process) / len(hyper_lun_ids)
    tmp_process = 0.0
    for lun_id in hyper_lun_ids:
        ret_list, cli_ret = get_lun_detail_cache(context, cli, LOGGER,
                                                 lun_id)
        cli_ret_list.append(cli_ret)
        for lun_info in ret_list:
            if lun_info.get("Exposed To Initiator", '') == "Yes":
                exist_mapped_lun_list.append(lun_id)

        tmp_process += per_lun_process
        if tmp_process >= 1:
            process += tmp_process
            tmp_process -= 1
            common.refreshProcess(PY_JAVA_ENV, process, LOGGER)

    return exist_mapped_lun_list, cli_ret_list


def getNotAddedHostInfo():
    """
    @summary: 获取未添加的主机信息。
    """
    objectForPy = PY_JAVA_ENV.get("objectForPy")
    notAddedHostsInfo = objectForPy.get("notAddedHostsInfo")
    if not notAddedHostsInfo:
        return ""
    localDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()
    notAddedHosts = notAddedHostsInfo.get(localDevSn)
    title = {"zh": u"\n上述双活LUN对应的主机信息如下(主机名称:启动器信息):",
             "en": "The information about hosts corresponding to the preceding HyperMetro "
                   "LUNs is as follows(Host Name:initiator):\n"}.get(
        LANG)
    if notAddedHosts:
        return title + str(notAddedHosts)

    return ""
