# -*- coding: UTF-8 -*-

from cbb.business.checkitems import SystemInnerCheck
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

# 界面状态 com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag
STATUS_MAP_DICT = {
    "0": 7,  # 等待执行
    "1": 6,  # 执行中
    "2": 0,  # 执行成功
    "3": 1,  # 执行失败
    "4": 2,  # 执行错误
    "5": 3,  # 忽略
}


def execute(cli):
    data_dict = get_data_dict()

    context = get_context(py_java_env, cli)
    check_type = py_java_env.get("check_type")
    context["checkType"] = check_type

    LOGGER.info("start system inner check.check_type:{}".format(check_type))
    context["observer"] = UiObserver(data_dict)
    # 执行修复脚本
    rest_service = SystemInnerCheck.RestService(context)
    rest_service.excuteCheck(check_type, "")
    flag, check_items = SystemInnerCheck.UpgradeCheck(context).query_repair_result()

    LOGGER.info("flag:{} check items:{}".format(flag, check_items))

    if not flag:
        return cliUtil.RESULT_NOCHECK, "", baseUtil.getPyResource(LANG, "SystemInnerCheck.check.conn.error")
    for check_item in check_items:
        status = check_item.get("status")
        if status == 0:
            return True, "", ""
        return False, "", check_item.get("detail")


def get_data_dict():
    data_dict = PY_JAVA_ENV
    data_dict['checkType'] = "DiagnoseCliProcessClean"
    data_dict["logger"] = LOGGER
    data_dict["lang"] = LANG
    return data_dict


def get_context(py_java_env, cli):
    # 测试时方便mock，在方法内import
    from cbb.frame.checkitem.context_adapter import InspectContext
    inspect_context = InspectContext(py_java_env, cli)
    return inspect_context.get_context()


class UiObserver():
    def __init__(self, data_dict):
        self.data_dict = data_dict

    def toUiStatus(self, status):
        return STATUS_MAP_DICT.get(status, 7)
