# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.base import baseUtil
from common_utils import is_support_read_only_user_enter_debug, is_super_administrator, is_flush_through_mode

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
    @summary: cache分区Fault页面检查
    1 如果有“Blocked Counter”字段的值不为0，则检查不通过。\n 其它情况检查通过。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    allerrMsg = ""
    allcliRet = ""
   
    try:

        # V5R7C60SPC200以上的版本和DoradoV6,不用判断权限
        productVer = str(py_java_env.get("devInfo").getProductVersion())
        device_type = str(py_java_env.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(device_type) and is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", errMsg)

        isDoradoV6 = baseUtil.isDoradoV6Dev(device_type)
        if not isDoradoV6 and not (
                productVer >= "V500R007C60SPC200"):

            # 判断当前用户的是否是超级管理员权限级别
            # 如果不是则检查结果为未检查
            if not is_super_administrator(
                cli, py_java_env.get("devInfoMap").get("userName"),
                    LANG) and not \
                    is_support_read_only_user_enter_debug(
                        productVer,
                        str(py_java_env.get("devInfo").getHotPatchVersion())):
                flag = cliUtil.RESULT_NOCHECK
                return flag, cliRet, common.getMsg(
                    LANG, "loginUser.name.level.must.be.super.admin")

        #步骤1：获取所有控制器ID
        checkRet = cliUtil.getControllerIdListWithRet(cli, LANG)
        if checkRet[0] == False: 
            return (cliUtil.RESULT_NOCHECK, checkRet[3], checkRet[2])
        if checkRet[0] != True: 
            return (checkRet[0], checkRet[3], checkRet[2])
        controllerIdList = checkRet[1]
        allcliRet += checkRet[3]
        #步骤2：在Develope模式下面执行查询命令
        flagList  = []  
        for ctrlId in controllerIdList:
            flag, cliRet, errMsg = checkCacheFaultPage(cli, LANG, ctrlId)
            allerrMsg = ''.join((allerrMsg, errMsg))
            allcliRet = '\n'.join((allcliRet, cliRet))
            flagList.append(flag)
            
        for eachFlag in flagList:
            if eachFlag != True:
                return (eachFlag, allcliRet, allerrMsg)

        if flag:
            LOGGER.logPass()        
            
        return flag, allcliRet, errMsg
               
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
def checkCacheFaultPage(cli, lang,ctrlId):
    '''
    @summary: 单个控制器cache分区Fault页面检查
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    try:
        
        cmd = "show cache blocked_page controller=%s" %ctrlId
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloper(cli, cmd, True, lang)
        if flag == False: 
            errMsg = common.getMsg(lang, "cannot.get.cachefault.info", (ctrlId))
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        if flag != True: 
            return (flag, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.cachefault.info", (ctrlId))
            LOGGER.logNoPass("Cannot get cache page information of controller[%s]" %ctrlId)
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        for lineDict in cliRetLinesList:
            blockedCnt = lineDict.get("Blocked Counter")
            if not blockedCnt.isdigit():
                errMsg = common.getMsg(lang, "cannot.get.cachefault.info", (ctrlId))
                LOGGER.logNoPass("There is an error in Sequence[cachePartitionFaultPage]!")
                return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
            else:
                if int(blockedCnt) != 0:
                    flag = False
                    errMsg = common.getMsg(lang, "check.cache.fault.notpass", (ctrlId,blockedCnt))
        return (flag, cliRet, errMsg)
    except Exception, exception:
        LOGGER.logException(exception)        
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
    
