# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import common_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    """
    @summary: 配置了双活功能的设备，建议每个控制器绑定至少两个远程复制链路，每个控制器均绑定了至少一条状态正常的复制链路到同一双活远端设备的相同控制器，否则将影响可靠性。
    """
    allCliRet = ""
    allErrMsg = ""
    try:
        flag, cliRet, errMsg, idList = getRemoteDeviceID(cli)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, allCliRet, errMsg)
        if not idList:
            return (True, allCliRet, errMsg)
        
        flag, controIdList, errMsg, cliRet= cliUtil.getControllerIdListWithRet(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        (
            flag,
            cliRet,
            errMsg,
            contrBandLinkNumDict,
            contrRemoteContrBandLinkNumDict,
            remote_device_use_fc_linked,
        ) = getContrBandLinkNum(cli, idList)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("contrBandLinkNumDict is %s" % str(contrBandLinkNumDict))
        LOGGER.logInfo("contrRemoteContrBandLinkNumDict is %s" % str(contrRemoteContrBandLinkNumDict))

        flagCheckContr, errMsg = checkContrBandLinkNum(contrBandLinkNumDict, controIdList)
        allErrMsg = common.joinLines(allErrMsg, errMsg)
        LOGGER.logInfo("remote dev is use fc linked is {}".format(
            str(remote_device_use_fc_linked)))
        flagContrRemoteContr, errMsg, cli_ret = checkRemoteContrBandLinkNum(
            cli,
            contrRemoteContrBandLinkNumDict,
            controIdList,
            remote_device_use_fc_linked
        )
        allCliRet = common.joinLines(allCliRet, cli_ret)
        allErrMsg = common.joinLines(allErrMsg, errMsg)
        if flagCheckContr != True:
            if flagContrRemoteContr is not True:
                return (flagContrRemoteContr, allCliRet, allErrMsg)
            return (flagCheckContr, allCliRet, allErrMsg)
        return (flagContrRemoteContr, allCliRet, allErrMsg)

        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def getRemoteDeviceID(cli):
    """
    @summary: 检查设备上是否存在双活特性,记录双活远端设备ID（Remote Device ID）
    @return: (CLI命令执行结果，CLI回显，错误提示信息，双活远端设备ID)
    """
    idList = []
    cmd = "show hyper_metro_domain general|filterColumn include columnList=Remote\sDevice\sID"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)

    if not cliUtil.hasCliExecPrivilege(cliRet):
        return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg, idList)

    if flag != True:
        LOGGER.logSysAbnormal()
        return (flag, cliRet, errMsg, idList)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, "", idList)

    retList = cliUtil.getHorizontalNostandardCliRet(cliRet)
    if not retList:
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"), idList)
    for retDict in retList:
        remoteDeviceID = retDict.get("Remote Device ID")
        if remoteDeviceID == '--' or not remoteDeviceID:
            continue
        idList.append(remoteDeviceID)

    return (True, cliRet, "", idList)


def getContrBandLinkNum(cli, id_list):
    """
    @summary: 获取控制器到远程设备状态正常的复制链路数量，控制器到远端设备相同控制器绑定的正常的链路数量
    @return: (是否获取成功，CLI回显，CLI执行失败的原因，控制器与远端设备绑定的正常的链路数量，控制器与远端设备相同控制器绑定的正常的链路数量)
    """
    contr_band_link_num_dict = {}
    contr_remote_contr_band_link_num_dict = {}
    err_msg = ""
    all_cli_ret = ""
    cli_ret_dict_list = []
    remote_device_use_fc_linked = {}
    for device_id in id_list:
        remote_device_use_fc_linked[device_id] = True
        cmd = "show remote_device link remote_device_id=%s" % str(device_id)
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True,
                                                            LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            LOGGER.logSysAbnormal()
            return (
                False,
                all_cli_ret,
                err_msg,
                contr_band_link_num_dict,
                contr_remote_contr_band_link_num_dict,
                remote_device_use_fc_linked,
            )

        fc_link_index = cli_ret.find("FC Link:")
        iscsi_link_index = cli_ret.find("iSCSI Link:")
        ip_link_index = cli_ret.find("IP Link:")
        if fc_link_index == -1:
            err_msg = common.getMsg(LANG, "cannot.get.link.info", "")
            LOGGER.logNoPass("Cannot get information about Link")
            return (
                False,
                all_cli_ret,
                err_msg,
                contr_band_link_num_dict,
                contr_remote_contr_band_link_num_dict,
                remote_device_use_fc_linked,
            )
        fc_cli_ret_dict_list = []
        iscsi_cli_ret_dict_list = []
        ip_link_cli_ret_dict_list = []
        # 如果回显中不包含ISCSI LINK
        if iscsi_link_index == -1:
            # 如果回显中不包含IP LINK
            if ip_link_index == -1:
                fc_link_cli_ret = cli_ret[fc_link_index:]
                fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    fc_link_cli_ret)
            # 如果回显中包含IP LINK
            else:
                fc_link_cli_ret = cli_ret[fc_link_index:ip_link_index]
                fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    fc_link_cli_ret)
                ip_link_cli_ret = cli_ret[ip_link_index:]
                ip_link_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    ip_link_cli_ret)
        # 如果回显中包含ISCSI LINK
        else:
            # 如果回显中不包含IP LINK
            if ip_link_index == -1:
                fc_link_cli_ret = cli_ret[fc_link_index:iscsi_link_index]
                fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    fc_link_cli_ret)
                iscsi_link_cli_ret = cli_ret[iscsi_link_index:]
                iscsi_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    iscsi_link_cli_ret)
            # 如果回显中包含IP LINK
            else:
                fc_link_cli_ret = cli_ret[fc_link_index:iscsi_link_index]
                fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    fc_link_cli_ret)
                iscsi_link_cli_ret = cli_ret[iscsi_link_index:ip_link_index]
                iscsi_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    iscsi_link_cli_ret)
                ip_link_cli_ret = cli_ret[ip_link_index:]
                ip_link_cli_ret_dict_list = cliUtil.getHorizontalCliRet(
                    ip_link_cli_ret)

        # 当存在ISCSI时，没有FC链路或FC的都是link down.
        if iscsi_cli_ret_dict_list and (
                not fc_cli_ret_dict_list or not check_all_fc_link(
                fc_cli_ret_dict_list)):
            remote_device_use_fc_linked[device_id] = False

        cli_ret_dict_list = (
                    cli_ret_dict_list + fc_cli_ret_dict_list +
                    iscsi_cli_ret_dict_list + ip_link_cli_ret_dict_list)
        LOGGER.logInfo("cliRetDictList is %s" % str(cli_ret_dict_list))

    for cli_ret_dict in cli_ret_dict_list:
        is_in_remote_device = cli_ret_dict.get("In Remote Device")
        remote_device_id = cli_ret_dict.get("Remote Device ID")
        # 控制器与远端设备绑定的状态正常的远程复制链路
        controller = cli_ret_dict.get("Local Controller")

        remote_controller = cli_ret_dict.get("Remote Controller")

        tmp_dict = contr_band_link_num_dict.get(remote_device_id, {})
        contr_band_link_num_dict[remote_device_id] = tmp_dict
        tmp_dict_contr = contr_remote_contr_band_link_num_dict.get(
            remote_device_id, {})
        contr_remote_contr_band_link_num_dict[
            remote_device_id] = tmp_dict_contr

        # 非远程复制链路
        if is_in_remote_device != "Yes" or remote_device_id == '--' \
                or not remote_device_id:
            continue

        health_status = cli_ret_dict.get("Health Status")
        running_status = cli_ret_dict.get("Running Status")
        # 非正常状态链路
        if health_status != "Normal" or running_status != "Link Up":
            continue

        link_num = tmp_dict.get(controller, 0)
        tmp_dict[controller] = link_num + 1
        contr_band_link_num_dict[remote_device_id] = tmp_dict

        link_num_contr = tmp_dict_contr.get(controller, 0)
        if controller == remote_controller:
            tmp_dict_contr[controller] = link_num_contr + 1
        else:
            tmp_dict_contr[controller] = link_num_contr
        contr_remote_contr_band_link_num_dict[
            remote_device_id] = tmp_dict_contr

    return (
        True,
        all_cli_ret,
        err_msg,
        contr_band_link_num_dict,
        contr_remote_contr_band_link_num_dict,
        remote_device_use_fc_linked,
    )


def check_all_fc_link(ret_list):
    """
    判断是否包含FC连接
    :param ret_list:
    :return: True:Fc链路检查，False：iscsi检查
    """
    for cli_ret_dict in ret_list:
        is_in_remote_device = cli_ret_dict.get("In Remote Device")
        remote_device_id = cli_ret_dict.get("Remote Device ID")
        # 非远程复制链路
        if is_in_remote_device != "Yes" or remote_device_id == '--' \
                or not remote_device_id:
            continue

        health_status = cli_ret_dict.get("Health Status")
        running_status = cli_ret_dict.get("Running Status")
        # 非正常状态链路
        if health_status != "Normal" or running_status != "Link Up":
            continue

        return True

    return False


def checkContrBandLinkNum(contrBandLinkNumDict, controIdList):
    """
    @summary: 检查每个控制器是否均绑定了至少两条状态正常的远程复制链路到同一双活远端设备
    """
    errMsg = ""
    for remoteDeviceId in contrBandLinkNumDict:
        ctrlLinkDict = contrBandLinkNumDict.get(remoteDeviceId, {})
        for ctrlId in controIdList:
            if ctrlLinkDict.get(ctrlId, 0) < 2:
                errMsg += common.getMsg(LANG, "contor.band.remote.replication.link.less.2", (ctrlId, remoteDeviceId))
    if errMsg:
        return (cliUtil.RESULT_WARNING, errMsg)

    return (True, "")


def checkRemoteContrBandLinkNum(cli, contrRemoteContrBandLinkNumDict,
                                controIdList, remote_device_use_fc_linked):
    """
    @summary: 检查每个控制器是否均绑定了至少一条状态正常的复制链路到同一双活远端设备的相同控制器
    """
    errMsg = ""
    no_check_msg = ""
    cli_ret = ''
    remote_title = "\n\nON REMOTE DEVICE(SN:{})"
    for remoteDeviceId in contrRemoteContrBandLinkNumDict:
        ctrlLinkDict = contrRemoteContrBandLinkNumDict.get(remoteDeviceId, {})
        for ctrlId in controIdList:
            if ctrlLinkDict.get(ctrlId, 0) < 1:
                # 如果是ISCSI链路则检查结果为建议优化
                if not remote_device_use_fc_linked.get(remoteDeviceId):
                    err_key = "contor.band.remote.replication.link.less.1"
                    errMsg += common.getMsg(
                        LANG,
                        err_key,
                        (ctrlId, remoteDeviceId, ctrlId)
                    )
                    continue

                remote_sn = get_remote_sn(cli, remoteDeviceId)
                flag, added_sn_list, err_msg = common.checkAddedRemoteDevSn(
                    py_java_env, LANG)
                if remote_sn not in added_sn_list:
                    no_check_msg += common.getMsg(
                        LANG,
                        "not.add.remote.device.again",
                        remote_sn
                    )
                    break

                # 如果设备为支持共享卡的设备，检查通过
                p_model, p_kp_version, ret = get_remote_product_info(remote_sn)

                cli_ret = common.joinLines(
                    cli_ret,
                    remote_title.format(remote_sn)
                )
                if ret not in cli_ret:
                    cli_ret = common.joinLines(cli_ret, ret)
                p_version, ret = get_remote_version(remote_sn)
                if ret not in cli_ret:
                    cli_ret = common.joinLines(cli_ret, ret)
                if all([p_model in config.HIGH_SHARE_CARD_MODEL,
                        "Kunpeng" in p_kp_version,
                        p_version >= "V500R007C60SPC200"]):
                    break

                err_key = "contor.band.remote.replication.link.less.1"
                errMsg += common.getMsg(
                    LANG,
                    err_key,
                    (ctrlId, remoteDeviceId, ctrlId)
                )

    if no_check_msg:
        return (cliUtil.RESULT_NOCHECK, errMsg + no_check_msg, cli_ret)

    if errMsg:
        return (cliUtil.RESULT_WARNING, errMsg, cli_ret)
    
    return (True, "", cli_ret)


def get_remote_sn(cli, remote_device_id):
    remote_device_info, cli_ret = common_cache.get_remote_device_info_cache(
        py_java_env, cli, LOGGER)
    return remote_device_info.get(remote_device_id)


def get_remote_product_info(remote_sn):
    """
    从文件中获取远端型号信息和是否Kunpeng标识
    :param remote_sn:
    :return:
    """
    cmd = "show system general"
    flag, ret, msg = common.getObjFromFile(py_java_env, LOGGER,
                                           remote_sn, cmd, LANG)
    if flag is not True:
        raise common.UnCheckException(msg, ret)
    p_model = ''
    p_kunpeng_version = ''
    ret_list = cliUtil.getVerticalCliRet(ret)
    for res_info in ret_list:
        p_model = res_info.get("Product Model")
        p_kunpeng_version = res_info.get("Product Version")
    return p_model, p_kunpeng_version, ret


def get_remote_version(remote_sn):
    """
    从文件中获取远端获版本信息
    :param remote_sn:
    :return:
    """
    cmd = "show upgrade package"
    flag, ret, msg = common.getObjFromFile(py_java_env, LOGGER, remote_sn, cmd,
                                           LANG)
    if flag is not True:
        raise common.UnCheckException(msg, ret)
    p_version = ''
    ver_index = ret.find("Software Version")
    patch_index = ret.find("HotPatch Version")
    v_ret_list = cliUtil.getHorizontalCliRet(ret[ver_index:patch_index])
    for v_ret_info in v_ret_list:
        p_version = v_ret_info.get("Current Version")
    return p_version, ret
