# -*- coding: UTF-8 -*-
import collections
import cliUtil
from common_cache import not_support_nas_domain
import common
"""
@version: Toolkit V200R006C00
@time: 2019/11/19
@file: check_item_service_hypermetro_remote_replication_link_doradov6.py
@function:
@modify:
"""
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
DEVICE_FC_REMOTE_LINK = 'FC'
DEVICE_IP_REMOTE_LINK = 'IP'
FC_LINK_LOCAL_PORT = 'Local Port ID'

CMD_DOMAIN_SAN = "show hyper_metro_domain general|filterColumn include columnList=Remote\sDevice\sID"
CMD_DOMAIN_NAS = "show fs_hyper_metro_domain general|filterColumn include columnList=Remote\sDevice\sID"


def execute(cli):
    all_cli_ret = ''
    try:
        # 设备是否有双活远端设备
        flag, cli_ret, err_msg, id_list = get_remote_device_id(cli, CMD_DOMAIN_SAN)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return flag, all_cli_ret, err_msg

        flag, cli_ret, err_msg, temp_id_list = get_remote_device_id(cli, CMD_DOMAIN_NAS)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        id_list.extend(temp_id_list)
        id_list = list(set(id_list))

        if flag is not True:
            return flag, all_cli_ret, err_msg
        if not id_list:
            return True, all_cli_ret, ''
        # 校验双活复制链路
        check_flag, check_cli_ret, check_error = \
            check_remote_device_link(cli, id_list)
        all_cli_ret = common.joinLines(all_cli_ret, check_cli_ret)
        # 如果有异常链路，返回建议优化
        if check_flag is False:
            check_flag = cliUtil.RESULT_WARNING
        return check_flag, all_cli_ret, check_error
    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, all_cli_ret, common.\
            getMsg(LANG, "query.result.abnormal")


def get_remote_device_id(cli, cmd):
    """
    检查设备上是否存在双活特性,记录双活远端设备ID（Remote Device ID）
    :param cli:
    :return: : CLI命令执行结果，CLI回显，错误提示信息，双活远端设备ID
    """
    id_list = []
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True,
                                                        LANG)
    if not_support_nas_domain(cli_ret):
        return True, cli_ret, '', id_list

    if flag is not True:
        LOGGER.logSysAbnormal()
        return flag, cli_ret, err_msg, id_list

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, cli_ret, '', id_list

    ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for retDict in ret_list:
        remote_device_id = retDict.get("Remote Device ID")
        if remote_device_id == '--' or not remote_device_id:
            continue
        id_list.append(remote_device_id)
    return True, cli_ret, '', id_list


def check_remote_device_link(cli, id_list):
    """
    循环阵列检查链路冗余
    :param cli:
    :param id_list:
    :return:
    """
    all_cli_ret = ''
    check_flag = True
    all_error_msg = ''
    # 获取控制器和引擎信息
    controller_ret, controller_id_list, engine_id_list = \
        get_controller_and_engine(cli)
    all_cli_ret = common.joinLines(all_cli_ret, controller_ret[1])
    if controller_ret[0] is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, controller_ret[2]
    # 检查与双活复制设备链路
    for device_id in id_list:
        device_error = ''
        # 解析复制链路
        execute_flag, execute_cli_ret, execute_error, remote_device_link = \
            get_remote_device_link(cli, device_id)
        all_cli_ret = common.joinLines(all_cli_ret, str(execute_cli_ret))
        if execute_flag is not True or not bool(remote_device_link):
            return cliUtil.RESULT_NOCHECK, all_cli_ret, \
                   common.getMsg(
                       LANG,
                       "hypermetro.remote.replication.link."
                       "doradov6.remotedevice.showlink.error", device_id)
        # 是否混合使用链路
        if is_mix_replication_link_device(remote_device_link):
            check_flag = False
            device_error = \
                common.joinLines(
                    device_error,
                    common.getMsg(LANG,
                                  "hypermetro.remote."
                                  "replication.link.doradov6."
                                  "mix.link.error"))
            all_error_msg = \
                common.joinLines(
                    all_error_msg,
                    common.getMsg(
                        LANG,
                        "hypermetro.remote.replication.link."
                        "doradov6.remotedevice.error", device_id))
            all_error_msg = common.joinLines(all_error_msg, device_error)
            continue
        # 通过FC链路本端Controller决定是否是共享卡设备
        fc_link_info_lists = remote_device_link.get(DEVICE_FC_REMOTE_LINK)
        if fc_link_info_lists:
            if is_share_card_device(fc_link_info_lists):
                # 按共享卡的方式进行复制链路检查
                fc_check_flag, fc_check_error = \
                    check_share_card_link(engine_id_list,
                                          fc_link_info_lists)
                if fc_check_flag is not True:
                    check_flag = False
                    device_error = \
                        common.joinLines(
                            device_error,
                            common.getMsg(LANG,
                                          "hypermetro.remote."
                                          "replication.link.doradov6."
                                          "remotedevice.linktype.error",
                                          DEVICE_FC_REMOTE_LINK))
                    device_error = common.joinLines(device_error,
                                                    fc_check_error)
                # 检查完成后从待检查集合中移除FC链路
                remote_device_link.pop(DEVICE_FC_REMOTE_LINK)
        # 其他类型按照普通控制器冗余检查
        for link_info in remote_device_link.keys():
            link_info_list = remote_device_link.get(link_info)
            link_check_result, link_err_msg = \
                check_link_by_controller(link_info_list, controller_id_list)
            if link_check_result is not True:
                check_flag = False
                device_error = common.joinLines(device_error, common.getMsg(
                    LANG,
                    "hypermetro.remote.replication.link."
                    "doradov6.remotedevice.linktype.error", link_info))
                device_error = common.joinLines(device_error,
                                                link_err_msg)
        if bool(device_error):
            all_error_msg = \
                common.joinLines(
                    all_error_msg,
                    common.getMsg(
                        LANG,
                        "hypermetro.remote.replication.link."
                        "doradov6.remotedevice.error", device_id))
            all_error_msg = common.joinLines(all_error_msg, device_error)
    return check_flag, all_cli_ret, all_error_msg


def is_mix_replication_link_device(remote_device_link):
    """
    检查是否混用链路
    :param remote_device_link:
    :return:
    """
    if bool(remote_device_link) and len(remote_device_link) > 1:
        return True
    return False


def get_controller_and_engine(cli):
    """
    获取检查设备的控制器与引擎信息
    :param cli:
    :return:
    """
    flag, controller_id_list, err_msg, cli_ret = \
        cliUtil.getControllerIdListWithRet(cli, LANG)
    if flag is not True:
        return (False, cli_ret, err_msg), [], []
    engine_id_list = []
    if not bool(controller_id_list):
        return (False, cli_ret,
                common.getMsg(LANG,
                              "hypermetro.remote.replication."
                              "link.doradov6.no.controller")), [], []
    for controller_id in controller_id_list:
        engine_id_list.extend(controller_id[0][0])
    return (True, cli_ret, err_msg), controller_id_list, list(
        set(engine_id_list))


def check_link_by_controller(link_info_list, controller_id_list):
    """
        @summary: 配置了双活功能的设备，建议每个控制器绑定至少两个远程复制链路，
        每个控制器均绑定了至少一条状态正常的复制链路到
        同一双活远端设备的相同控制器，否则将影响可靠性。
        """
    all_err_msg = ''
    all_check_result = True
    ctrl_normal_link_dict = \
        get_correct_controller_link_pair(controller_id_list, link_info_list)
    for controller_id in ctrl_normal_link_dict.keys():
        normal_link_list = ctrl_normal_link_dict.get(controller_id)
        # 控制器下状态正常复制链路少于两条
        if not bool(normal_link_list) or len(normal_link_list) < 2:
            all_check_result = False
            all_err_msg = common.joinLines(
                all_err_msg, common.getMsg(LANG, "hypermetro.remote."
                                                 "replication.link."
                                                 "doradov6."
                                                 "ctrl.not.enough.link",
                                           controller_id))
    if not all_check_result:
        all_err_msg += common.getMsg(LANG, "ctrl.not.enough.link.sugg")
    return all_check_result, all_err_msg


def check_share_card_link(engine_id_list, link_info_list):
    """
    检查共享卡链路
    :param engine_id_list:
    :param link_info_list:
    :return:
    """
    engine_normal_link_dict = get_correct_engine_link_pair(engine_id_list,
                                                           link_info_list)
    share_card_link_check_flag, share_card_link_check_error = \
        check_share_card_link_info(engine_normal_link_dict)
    return share_card_link_check_flag, share_card_link_check_error


def is_share_card_device(fc_link_info_lists):
    """
    是否为共享卡设备（查看FC链路本端控制器是否为--）
    :param fc_link_info_lists:
    :return:
    """
    for fc_link_info in fc_link_info_lists:
        if '--' == fc_link_info.get('Local Controller'):
            return True
    return False


def get_correct_engine_link_pair(engine_id_list, link_info_list):
    """
    按引擎分组，获取每个引擎下正常的复制链路信息
    :param engine_id_list:
    :param link_info_list:
    :return:
    """
    engine_normal_link_dict = {}
    if not bool(engine_id_list):
        return engine_normal_link_dict
    for engine_id in engine_id_list:
        engine_name = 'CTE' + engine_id
        normal_link_list = []
        for link_info in link_info_list:
            if is_normal_remote_link(link_info):
                port_name = link_info.get(FC_LINK_LOCAL_PORT)
                port_engine_name, port_interface_card_name = \
                    get_port_engine_and_interface_card(port_name)
                if engine_name == port_engine_name:
                    normal_link_list.append(link_info)
        engine_normal_link_dict[engine_name] = normal_link_list
    return engine_normal_link_dict


def get_correct_controller_link_pair(controller_id_list, link_info_list):
    """
    按控制器分组，获取每个控制器下正常的复制链路信息
    :param controller_id_list:
    :param link_info_list:
    :return:
    """
    ctrl_normal_link_dict = {}
    if not bool(controller_id_list):
        return ctrl_normal_link_dict
    for ctrl_id in controller_id_list:
        normal_link_list = []
        for link_info in link_info_list:
            if is_normal_remote_link(link_info):
                controller = link_info.get("Local Controller")
                if ctrl_id == controller:
                    normal_link_list.append(link_info)
        ctrl_normal_link_dict[ctrl_id] = normal_link_list
    return ctrl_normal_link_dict


def check_share_card_link_info(engine_normal_link_dict):
    """
    检查共享卡模式下双活复制远程设备FC链路冗余情况：
    检查标准：
    1.每个引擎下至少需要两条正常链路
    2.链路需要分布在H,L上下两个物理平面上
    :param engine_normal_link_dict:
    :return:
    """
    share_card_link_check_flag = True
    share_card_link_check_error = ''
    # 检查每个引擎下复制链路冗余情况
    for engine_name in engine_normal_link_dict.keys():
        link_list = engine_normal_link_dict.get(engine_name)
        # 每个引擎至少需要上下平面各两条链路
        # 链路需要分布在H,L两个物理平面内
        if not bool(link_list) or \
                check_redundant_port(link_list) is not True:
            share_card_link_check_flag = False
            share_card_link_check_error = \
                common.joinLines(share_card_link_check_error,
                                 common.getMsg(LANG,
                                               "hypermetro.remote."
                                               "replication.link.doradov6."
                                               "engine.not.enough.link",
                                               engine_name))
    if not share_card_link_check_flag:
        share_card_link_check_error += common.getMsg(LANG, "engine.not.enough.link.sugg")
    return share_card_link_check_flag, share_card_link_check_error


def get_remote_device_link(cli, device_id):
    """
        获取每个双活远端设备链路情况
    :param cli:
    :param device_id:
    :return:获取信息是否成功，cli回显，错误信息，链路集合
    """
    remote_device_link = collections.OrderedDict()
    cmd = "show remote_device link remote_device_id=%s" % str(device_id)
    flag, cli_ret, err_rsg = cliUtil.excuteCmdInCliMode(cli, cmd, True,
                                                        LANG)
    if flag is not True:
        LOGGER.logSysAbnormal()
        return False, cli_ret, err_rsg, remote_device_link
    fc_link_index = cli_ret.find("FC Link:")
    ip_link_index = cli_ret.find("IP Link:")
    if fc_link_index == -1:
        LOGGER.logNoPass("Cannot get information about Link")
        return False, cli_ret, common.getMsg(LANG, "cannot.get.link.info",
                                             device_id), remote_device_link
    # FC Link
    fc_link_cli_ret = cli_ret[fc_link_index:ip_link_index]
    fc_cli_ret_dict_list = cliUtil.getHorizontalCliRet(fc_link_cli_ret)
    # IP Link
    ip_link_cli_ret = cli_ret[ip_link_index:]
    ip_link_cli_ret_dict_list = cliUtil.getHorizontalCliRet(ip_link_cli_ret)
    # 封装所有链路数据
    if bool(fc_cli_ret_dict_list):
        remote_device_link[DEVICE_FC_REMOTE_LINK] = fc_cli_ret_dict_list
    if bool(ip_link_cli_ret_dict_list):
        remote_device_link[DEVICE_IP_REMOTE_LINK] = \
            ip_link_cli_ret_dict_list
    return True, cli_ret, '', remote_device_link


def check_redundant_port(link_list):
    """
    检查端口是否物理平面冗余;端口ID第三位为接口卡信息，链路中需要同时
        分布在Hx和Lx上下两个物理平面的接口卡上
    :param link_list:
    :return:
    """
    upper_plane_link = []
    lower_plane_link = []
    for link_info in link_list:
        port_name = link_info.get(FC_LINK_LOCAL_PORT)
        engine_name, interface_card_name = \
            get_port_engine_and_interface_card(port_name)
        if not bool(interface_card_name):
            continue
        if interface_card_name.upper().startswith("H"):
            upper_plane_link.append(link_info)
            continue
        if interface_card_name.upper().startswith("L"):
            lower_plane_link.append(link_info)
    return len(upper_plane_link) > 1 and len(lower_plane_link) > 1


def get_port_engine_and_interface_card(port_name):
    """
    解析共享卡模式下端口信息，获取所在引擎和所在接口卡名称：
    以.分割，得到数组第一位为引擎名称，倒数第二位为接口卡名称
    若端口ID不包含.则引擎名称和接口卡名称均为空
    若分割后数组长度小于四，则接口卡名称为空
    :param port_name:
    :return:引擎名称，接口卡名称
    """
    if '.' not in port_name:
        LOGGER.logError('port id [%s] do not have point' % port_name)
        return '', ''
    port_info = port_name.split('.')
    engine_name = port_info[0]
    if len(port_info) < 4:
        LOGGER.logError('port id [%s] style is not A.B.C.D' % port_name)
        return engine_name, ''
    return engine_name, port_info[len(port_info) - 2]


def is_normal_remote_link(link_info):
    """
    是否是正常的远程复制链路
    :param link_info:
    :return: True，False
    """
    is_in_remote_device = link_info.get("In Remote Device")
    health_status = link_info.get("Health Status")
    running_status = link_info.get("Running Status")
    # 非正常远程复制链路
    if is_in_remote_device != "Yes" or health_status != "Normal" \
            or running_status != "Link Up":
        return False
    return True
