# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    SAN克隆空间预留检查 ； 
            检查步骤：
                步骤1 以admin用户登录设备；
                步骤2 执行命令show clone general，查询克隆特性；
                步骤3 执行命令show storage_pool general，记录所有Pool的总容量（Total Capacity字段值）和空闲容量（Free Capacity字段的值）；
                步骤4 执行show lun general pool_id=PO0LID|filterColumn include columnList=ID，（剩余容量小于1%的pool）记录pool中LUN LIST；
                步骤5 依次检查pool中LUN是否有克隆LUN，执行命令show lun general lun_id=LUNID|filterColumn include columnList=ID,Subscribed
                 Capacity,HyperMetro\sID(s),Remote\sReplication\sID(s),Split\sClone\sID(s),Snapshot\sID(s),LUN\sMigration,
                 Mirror\sType。如果克隆split clone字段不为--，记录下LUN ID，pool id和Subscribed Capacity，计算相同pool下的克隆lun
                                             容量总和，检查是否配置有其它特性并做标记。
            检查标准：
        1. 若不存在克隆配置则检查通过，否则继续步骤3；
        2. 如果所有Pool均满足：空闲容量（Free Capacity字段的值）大于Pool的总容量（Total Capacity字段值）的1%，则检查通过，否则继续；
        3. 如果只有克隆，则使用pool下的克隆LUN容量总和 * 0.005与pool的剩余容量进行比较，如果小于则检查通过，如果大于或者等于则提示用户需要对pool进行扩容；
        4. 如果除了克隆还有其它特性，则使用pool下的克隆LUN容量总和 * 0.01与pool的剩余容量进行比较，如果小于则检查通过，如果大于或者等于则提示用户需要对pool进行扩容；
    '''
    
    flag = True
    allCliRet = ""
    errMsg = ""
    standard = "0.01"
    
    try:
        #查询是否存在克隆配置
        flag, cliRet, errMsg, featureExist = isFeatureExist(cli, LANG)
        allCliRet += cliRet
        
        #查询是否存在克隆配置失败（下发命令失败或发生异常）
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if not featureExist:
            return (True, allCliRet, errMsg)
        
        #检查存储池空闲容量
        flag, cliRet, errMsg, freeCapDict = common.checkPoolFreeCapacity(cli, LANG, standard, LOGGER)
        allCliRet += cliRet
        
        #查询存储池详情失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)

        if not freeCapDict:
            return (True, allCliRet, '')

        #检查增值LUN的总容量是否达标
        flag, cliRet, reachStandrd, errMsg = common.compareFreeCapacity(cli, freeCapDict, 'Split Clone ID(s)', LANG, py_java_env, LOGGER)        
        allCliRet += cliRet
        #查询LUN信息失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if reachStandrd == False:
            return (False, allCliRet, errMsg)
                       
        return (True, allCliRet, '')
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

    
def isFeatureExist(cli, lang):
    """
    @summary: 执行命令show clone general，
                                    查询克隆特性是否存在；
    @return: 
        isSucc：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的错误消息
        featureExist: True(存在克隆配置)
                      False(不存在克隆配置)
    """
    
    isSucc = True
    cliRet = ""
    errMsg = ""
    featureExist = False
    
    try:
        cmd = "show clone general"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = execRet[1]
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            errMsg = cliUtil.getMsg(lang, "has.not.cli.privilege")
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "", featureExist)
        
        #命令执行失败
        if execRet[0] == False:
            errMsg = common.getMsg(lang, "can.not.get.clone.info")            
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg, featureExist)

        if execRet[0] != True:          
            return (execRet[0], cliRet, execRet[2], featureExist)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, featureExist)
        
        #走到这里说明命令成功执行且回显正常，回显正常即说明有对应特性
        featureExist = True
                
        return (isSucc,cliRet,errMsg,featureExist)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"), featureExist)

    
    