# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    Smart Cache检查：
        1 如果Smart Cache不存在表示正常；
        2 默认分区个数与正常引擎个数相同表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show smart_cache_partition general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        if checkRet[0] != True: 
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return (cliUtil.RESULT_NOSUPPORT, cliRet, "")  
            if not checkRet[0]:               
                return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "cannot.get.info", "Smart Cache"))  
            LOGGER.logSysAbnormal()
            return checkRet
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.smartcache.info")
            LOGGER.logNoPass("Cannot get information about Smart Cache")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        defaultPartitionList = []
        for line in cliRetLinesList:
            Id = line.get("ID")
            isDefault = line.get("Is Default")
            if isDefault == common.STATUS_YES:
                defaultPartitionList.append(Id)
                
        getEngineSetRet = common.getEngineSet(cli, LANG)
        if getEngineSetRet[0] != True:
            cliRet += getEngineSetRet[1]
            errMsg = getEngineSetRet[2]
            LOGGER.logNoPass("Cannot get set of engines")
            if getEngineSetRet[0] == False:
                errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"引擎集合", "en":"set of engines"}.get(LANG))
                return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
            return (getEngineSetRet[0], cliRet, errMsg)
        
        engineSet = getEngineSetRet[1]
        numberOfdefaultPartion = len(defaultPartitionList)
        numberOfengines = len(engineSet)
        if numberOfdefaultPartion != numberOfengines:
            errMsg = common.getMsg(LANG, "smartcache.partion.abnormal", (numberOfdefaultPartion, numberOfengines))
            LOGGER.logNoPass(
             "The number of default partition is not identical with the number of engines (Number of default partition:%s, Number of engines:%s)" % 
             (numberOfdefaultPartion, numberOfengines))
            return (False, cliRet, errMsg)

        if flag:
            cliRet += getEngineSetRet[2]
            LOGGER.logPass()

        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
