#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
#

"""
@version: Toolkit V200R006C00
@time 2020/03/07
@file check_item_software_checking_node_flow_fault_logs.py
@function:
@modify
"""

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

all_rec = []


def execute(cli):
    '''
    双转单流程日志检查 检查是否记录指定内容日志
    若正常的系统中残留了节点业务双转单流程失败日志，当一控制器复位时，会触发该日志流程重做，导致系统业务异常。
    :param cli: 连接
    :return: flag,all_rec,err_msg
    '''
    global all_rec
    cli_con = ''
    try:
        # 如果是18000执行debug命令获取阵列链接
        flag, cli_con, err_msg = \
            common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        # 连接不成功且不再svp内则提示到svp内巡检
        if not flag and not PY_JAVA_ENV.get("isInSvp"):
            return (cliUtil.RESULT_NOCHECK, '\n'.join(all_rec),
                    common.getMsg(LANG, "maybe.need.check.in.svp"))

        flag, cliRet, errMsg = cliUtil.enterDeveloperMode(cli_con, LANG)
        all_rec.append(cliRet)
        if flag is not True:
            return (flag, '\n'.join(all_rec), errMsg)

        cliRet = cli_con.execCmd("minisystem")
        all_rec.append(cliRet)
        if not cliUtil.isInMinisystemMode(cliRet):
            return (cliUtil.RESULT_NOCHECK, '\n'.join(all_rec),
                    common.getMsg(LANG, "has.not.cli.privilege"))

        if flag is not True:
            return flag, '\n'.join(all_rec), errMsg

        cmd = "sys.sh showsyslog"
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli_con, cmd,
            LANG)
        all_rec.append(cliRet)
        if flag is not True:
            return (flag, '\n'.join(all_rec), errMsg)

        rec_list = cliUtil.getHorizontalCliRet(cliRet)
        if len(rec_list)==0:
            LOGGER.logInfo("rec list is empty,check pass.")
            return True, '\n'.join(all_rec), ''

        risk_key_1 = "NodeFaultPreLog"
        risk_key_2 = "NodeFaultPostLog"
        key = "FlowType"
        for line in rec_list:
            value = line.get(key, "")
            if value==risk_key_1 or value==risk_key_2:
                LOGGER.logInfo("find double transfersingle process log risk.")
                return (False, '\n'.join(all_rec), common.getMsg(LANG,
                        "node.flow.fault.logs.check.notpass"))

        return True, '\n'.join(all_rec), ''
    except (ToolException, Exception) as e:
        LOGGER.logException(e)
        return (cliUtil.RESULT_NOCHECK, '\n'.join(all_rec), common.getMsg(
            LANG, "query.result.abnormal"))
    finally:
        # 如果是18000,关闭新链接
        if cli_con != "":
            if common.is18000(PY_JAVA_ENV, cli_con) and cli_con is not cli:
                common.closeConnection(cli_con, PY_JAVA_ENV, LOGGER)
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo(
            "enter cli mode from some model ret is %s" % str(ret))

        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
