# -*- coding: UTF-8 -*-
import re
import os
from cbb.frame.util.tar_util import decompress_tar_all_file_with_detail
import cliUtil
import common


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
context = py_java_env
#导出日志类型
EXPORT_TYPE_EVENT = "event"
ALARM_IDS = ("0xF0015001D", "0xF00150032")


def execute(cli):
    '''
            主机多路径兼容性匹配检查 ；
                步骤1 使用CLI命令show alarm_mask查询屏蔽的告警ID。
                步骤2 确认是否有 ALARM_IDS 的告警ID，如果没有则检查通过，如果有，则进行第3步检查。
                步骤3 检查告警ID为 ALARM_IDS 的参数Existed Flag是否为true，
                    如果是False则检查通过，若为True，则进行第4步检查。
                步骤4 执行CLI命令show file export_path file_type = event将设备告警导出（在 / OSM / export_import目录下生成压缩包event_export.tgz）。
            检查标准：
               在导出的event压缩包中搜索alarm ID为 ALARM_IDS 的告警，若多路径的
               版本以2开头，那么则检查通过；若不是以2开头，则检查不通过，建议一线升
               级多路径版本。
    '''

    flag = True
    allCliRet = ""
    errMsg = ""

    try:
        #查询是否存在屏蔽告警
        execRet = checkAlarmIgnored(cli, LANG)
        allCliRet += execRet[1]

        #查询告警屏蔽信息失败（下发命令失败或发生异常）
        if not execRet[0]:
            errMsg += execRet[2]
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        alarmIgnored = execRet[-1]

        if not alarmIgnored:
            return (True, allCliRet, errMsg)

        #收集告警日志
        execRet = cliUtil.exportLog(cli, LANG, EXPORT_TYPE_EVENT, context, LOGGER)

        #收集告警日志失败
        if not execRet[0]:
            errMsg += execRet[-1]
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        localDirInfo = execRet[1]

        #检查告警日志中的多路径版本
        execRet = checkUltraPath(localDirInfo)

        if not execRet[0]:
            errMsg += execRet[1]
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        checkPass = execRet[-1]
        if not checkPass:
            flag = False
            errMsg += execRet[1]

        return (flag, allCliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkAlarmIgnored(cli, lang):
    """
    @summary: 执行命令show alarm_mask，
                                    检查是否屏蔽了ID为 ALARM_IDS 的告警；
    @return:
        isSucc：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的错误消息
        alarmIgnored: True(ID为 ALARM_IDS 的告警被屏蔽了)
                      False(ID为 ALARM_IDS 的告警未被屏蔽)
    """

    isSucc = True
    cliRet = ""
    errMsg = ""
    alarmIgnored = False

    try:
        cmd = "show alarm_mask"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = execRet[1]

        #命令执行失败
        if execRet[0] == cliUtil.RESULT_NOCHECK or not execRet[0]:
            errMsg = common.getMsg(lang, "can.not.get.alarm.mask.info")
            if cliUtil.isNoneLicense(execRet[1]):
                errMsg = execRet[2]

            return (False, cliRet, errMsg, alarmIgnored)

        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, alarmIgnored)

        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        for line in cliRetLinesList:
            alarmId = line.get("Alarm ID")
            existed = line.get("Existed Flag")
            #没有Existed Flag字段或Existed Flag字段值为“--”
            if not existed or existed == "--":
                errMsg += common.getMsg(lang, "can.not.get.existed.flag")
                return (False, cliRet, errMsg, alarmIgnored)

            if alarmId in ALARM_IDS and existed == "True":
                alarmIgnored = True
                break

        return (isSucc, cliRet, errMsg, alarmIgnored)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"), alarmIgnored)


def checkUltraPath(localDirInfo):
    '''
    @summary: 判断收集的告警日志中是否存在ID为 ALARM_IDS 的告警，且多路径版本以2开头
    @param fileDirList:  收回的告警日志包列表
    @return : flag : 方法执行是否异常标志位
              errMsg : 错误消息
              checkPass : 是否满足目标条件标志位
    '''
    errMsg = ""
    checkPass = True
    try:
        for dirInfo in localDirInfo:
            folderDir = dirInfo.get("path")
            fileName = dirInfo.get("name")
            fileDir = folderDir + fileName

            #打开tgz文件对象，解压包中的子文件到当前目录
            subFileList = []
            result, file_names, _ = decompress_tar_all_file_with_detail(
                fileDir, folderDir)
            if result:
                subFileList.extend(file_names)

            #遍历检查压缩包中解压出的文件
            for subFileName in subFileList:
                subFile = folderDir + subFileName
                checkRet = checkFile(subFile)
                os.remove(subFile)

                absFileDir = os.path.abspath(fileDir)

                if not checkRet[0]:
                    errMsg += checkRet[1]
                    errMsg += common.getMsg(LANG, "file.abs.directory", (absFileDir))
                    return (False, errMsg, checkPass)

                checkPass = checkRet[-1]
                if not checkPass:
                    errMsg += checkRet[1]
                    errMsg += common.getMsg(LANG, "file.abs.directory", (absFileDir))
                    return (True, errMsg, checkPass)

        return (True, errMsg, checkPass)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, common.getMsg(LANG, "query.result.abnormal"), checkPass)

def checkFile(fileDir):
    '''
    @summary: 判断收集的告警日志中是否存在ID为 ALARM_IDS 的告警，且多路径版本以2开头
    @param fileDir:  文件路径
    @return :
              ultralPathNum : 多路径版本号
              checkPass : 是否满足目标条件标志位
    '''
    ultralPathNum = ""
    errMsg = ""
    checkPass = True
    try:
        fileObj = open(fileDir, "r")
        content = fileObj.readlines()
        #释放资源
        fileObj.close()

        #文件中Fault list下记录的告警列表
        faultList = []
        isReadingFaultList = False
        for line in content:
            #读取Fault list下记录的告警
            if line.strip() == "Event list":
                break

            if not isReadingFaultList and line.strip() == "Fault list":
                isReadingFaultList = True
                continue

            if isReadingFaultList:
                faultList.append(line)

        #保留键列表用于处理错误消息
        orderedKeys = faultList[0].strip().split("    ")

        dictList = cliUtil.getHerizontalDictList(faultList)
        alarmIdList = []
        unPassedVersion = []
        unPassedLines = ""
        for line in dictList:
            alarmId = line.get("Alarm ID")
            alarmIdList.append(alarmId)
            description = line.get("Description")
            if alarmId in ALARM_IDS:
                if re.search(r'UltraPath[^a-zA-Z0-9]*version[^a-zA-Z0-9]*\d+', description, re.IGNORECASE):
                    ultraPath = re.search(r'UltraPath[^a-zA-Z0-9]*version[^a-zA-Z0-9]*\d+', description, re.IGNORECASE).group()
                    ultralPathNum = re.search(r'\d+', ultraPath, re.IGNORECASE).group()
                    unPassedVersion.append(ultralPathNum)
                    if not ultralPathNum.startswith("2"):
                        checkPass = False
                        values = []
                        #最后的suggestion字段包含很多内容且多次换行，不在界面上体现
                        for key in orderedKeys[0:-1]:
                            value = line.get(key)
                            values.append(value)

                        lineStr = "    ".join(values) + "\n"
                        unPassedLines += lineStr
                else:
                    #无法获取多路径版本
                    return (False, common.getMsg(LANG, "can.not.get.ultra.path.number"), checkPass)

        #走到收集告警日志，日志包中应包含对应的告警记录
        alarm_id_exists = set(ALARM_IDS) & set(alarmIdList)
        if not alarm_id_exists:
            return (
                False,
                common.getMsg(
                    LANG, "alarm.event.content.error", ' / '.join(ALARM_IDS)),
                checkPass
            )

        if not checkPass:
            errMsg += common.getMsg(LANG, "ultraPath.version.low", (",".join(unPassedVersion), unPassedLines))

        return (True, errMsg, checkPass)
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, common.getMsg(LANG, "query.result.abnormal"), checkPass)

