# -*- coding: UTF-8 -*-
import common
from cbb.business.checkitems.check_coffer_disk import CofferDiskCheck


def execute(cli):
    """
    保险箱盘logzone分区检测
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show upgrade package，获取系统软件版本、历史版本及热补丁版
    本信息；
    步骤3 执行命令：show disk general |filterRow column=Coffer Disk predict=
          equal_to value=Yes|filterColumn include columnList=ID,Run Time(Day)
          ，获取前四盘的运行时间。

    1 若步骤2中，系统软件版本和热补丁版本关系如下，且存在历史版本记录，则继续
    检查否
      则检查结果为通过：V300R002C00SPC100：V300R002C00SPH105之前版本补丁或
      无补丁；
      V300R002C10SPC100：V300R002C10SPH112之前版本补丁或无补丁；V300R002C20：
      V300R002C20SPH002之前版本补丁或无补丁；
    2 若步骤3中，同一引擎内任意两块硬盘的时间差小于7天，则检查结果为通过，
    否则检查结果为不通过。
    :param cli:
    :return:
    """
    logger = common.getLogger(PY_LOGGER, __file__)
    lang = common.getLang(py_java_env)
    logger.logInfo("coffer disk status check start---")
    coffer_disk_check = CofferDiskCheck(cli, lang, logger)
    flag, err_msg = coffer_disk_check.execute_check()

    return flag, '\n'.join(coffer_disk_check.all_cli_ret), err_msg
