# -*- coding: UTF-8 -*-
import common
import common_utils
import cliUtil as cliUtils
from cbb.business.checkitems.check_item_daemon_process import (
    CheckDeamonProcess,
)
from cbb.frame.context import contextUtil
from cbb.frame.cli.execute_on_all_controllers import ExeOnAllCtrlContext
from cbb.frame.cli.execute_on_all_controllers import ResultType
from com.huawei.ism.tool.obase.exception import ToolException

import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

# 进度总剩余时间
LIMIT_TIME = 120
# 进度刷新间隔
INTERVAL = 2


def execute(cli):
    """
    系统daemon进程检查
    步骤1 以admin用户登录设备；
    步骤2 执行命令：change user_mode current_mode user_mode=developer，
    进入developer模式；
    步骤3 执行命令：minisystem，进入minisystem模式；
    步骤4 执行命令：ps -C daemon，查询daemon进程的PID；
    步骤5 登录当前设备所有控制器重复执行步骤2~步骤4。
    否则检查结果为不通过。
    若任意控制器中步骤4回显不包含daemon字样，则检查结果为不通过，否则检查通过。
    :param cli:
    :return:
    """
    check_deamonprocess = None
    conn_cli = None
    exe_context = None
    try:
        # 进度条刷新
        common.threadUpProcess(PY_JAVA_ENV, LIMIT_TIME, INTERVAL, LOGGER)
        # 进度开始
        common.inProcess(PY_JAVA_ENV)

        # 不是超级管理员账号,报未完成检查
        if not common_utils.is_super_administrator(
                cli, PY_JAVA_ENV.get("devInfoMap").get("userName"), LANG):
            err_msg = common.getMsg(LANG,
                                    "loginUser.name.level.must.be.super.admin")
            return cliUtils.RESULT_NOCHECK, "", err_msg
        flag, conn_cli, err_msg = common.createDeviceCliContFor18000(
            cli, PY_JAVA_ENV, LOGGER, LANG
        )
        if flag is not True:
            return cliUtils.RESULT_NOCHECK, '', err_msg

        context = contextUtil.getContext(PY_JAVA_ENV)
        dev_node = PY_JAVA_ENV.get("devInfo")
        new_dev_node = EntityUtils.toNewDev(dev_node)
        context["cli"] = conn_cli
        context["logger"] = PY_LOGGER
        context["lang"] = LANG
        context["dev"] = new_dev_node
        exe_context = ExeOnAllCtrlContext(context)
        LOGGER.logInfo("CheckDeamonProcess start----")
        check_deamonprocess = CheckDeamonProcess(exe_context, PY_LOGGER, LANG,
                                                 conn_cli)
        result_type, err_mag = check_deamonprocess.execute_check()
        return (get_restlt(result_type),
                check_deamonprocess.all_ret_list, err_mag, )
    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return (
            cliUtils.RESULT_NOCHECK,
            check_deamonprocess.all_ret_list if check_deamonprocess else '',
            common.getMsg(LANG, "query.result.abnormal"),
        )
    finally:
        if conn_cli:
            if (
                    common.is18000(PY_JAVA_ENV, conn_cli)
                    and conn_cli is not cli
            ):
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtils.enterCliModeFromSomeModel(cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.finishProcess(PY_JAVA_ENV)
        if exe_context and exe_context.dev_info._cli is not cli:
            common.closeConnection(exe_context.dev_info._cli, PY_JAVA_ENV, LOGGER)
            LOGGER.logInfo("close sdk conn:{} success.".format(exe_context.dev_info._cli))
        LOGGER.logInfo("finish process!")


def get_restlt(result_type):
    trans_dict = {
        ResultType.SUCCESS: True,
        ResultType.FAILED: False,
        ResultType.NOT_FINISHED: cliUtils.RESULT_NOCHECK,
        ResultType.NOT_SUPPORT: cliUtils.RESULT_NOSUPPORT,
        ResultType.WARNING: cliUtils.RESULT_WARNING,
    }
    return trans_dict.get(result_type)
