# -*- coding: UTF-8 -*-
from cbb.business.checkitems.cache_obj_num_check import CheckItem
from cbb.frame.checkitem.context_adapter import InspectContext
from cbb.frame.checkitem.base_dsl_check import CheckStatus
from com.huawei.ism.tool.obase.exception import ToolException
import common
from cbb.frame.cli import cliUtil
from common_utils import is_super_administrator

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    # 进度条刷新
    conn_cli = ""
    all_ret = ""

    PY_JAVA_ENV["logger"] = PY_LOGGER
    PY_JAVA_ENV["lang"] = LANG
    inspect_context = InspectContext(PY_JAVA_ENV, cli)
    my_pthread = common.AsynProgress(PY_JAVA_ENV, LOGGER)
    my_pthread.start_thread()
    try:
        # 不是超级管理员账号,报未完成检查
        if not is_super_administrator(cli, PY_JAVA_ENV.get("devInfoMap").get("userName"), LANG):
            return cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "loginUser.name.level.must.be.super.admin")
        # 如果是18000执行debug命令获取阵列链接
        createRet = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER,
                                                       LANG)
        if createRet[0] is not True:
            return inspect_context.get_result(CheckStatus.NOCHECK, createRet[2],
                                              all_ret)
        conn_cli = createRet[1]
        check_obj = CheckItem(inspect_context.get_context())
        status, err_msg = check_obj.check()
        all_ret = check_obj.get_origin_info()
        return inspect_context.get_result(status, err_msg, all_ret)
    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, all_ret, common.getMsg(
            LANG, "query.result.abnormal")
    finally:
        my_pthread.setStopFlag(True)
        if conn_cli != "":
            if common.is18000(PY_JAVA_ENV, conn_cli) and conn_cli is not cli:
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.finishProcess(PY_JAVA_ENV)
