# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘域硬盘数量检查: 
        1） 当硬盘域不存在时，则检查通过；
        2） 当所有硬盘域每层tier包含硬盘数小于等于50且三层tier硬盘数总和小于等于100，则检查通过；否则检查结果为建议优化；
        3） 其他情况检查结果为不通过；

    '''
    flag = True
    cliRet = ""
    errMsg = ""


    try:
        standardNum = 100
        devType = py_java_env.get("devInfo").getDeviceType().toString()
        Product_18000V1 = ("HVS85T", "HVS88T", "18500", "18800", "18800F")
        Product_TV2 = ("S6800T", "S5800T", "S5600T", "S5500T", "S2600T")
        if devType in Product_18000V1 or devType in Product_TV2:
            standardNum = 96
        cmd = "show disk_domain general |filterColumn include columnList=ID,Tier0\\sDisk\\sNumber,Tier1\\sDisk\\sNumber,Tier2\\sDisk\\sNumber"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        if not cliUtil.hasCliExecPrivilege(cliRet):
            cmd = "show disk_domain general |filterColumn include colunmList=ID,Tier0\\sDisk\\sNumber,Tier1\\sDisk\\sNumber,Tier2\\sDisk\\sNumber"
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRet = checkRet[1]
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.domain.info")
            LOGGER.logNoPass("Cannot get information about disk domain")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
        
        passFlag = False
        warningFlag = False
        for line in cliRetLinesList:
            Id = line.get("ID")
            tier0Num = int(line.get("Tier0 Disk Number"))
            tier1Num = int(line.get("Tier1 Disk Number"))
            tier2Num = int(line.get("Tier2 Disk Number"))
            if tier0Num <= standardNum and tier1Num <= standardNum and tier2Num <= standardNum: 
                passFlag = True
            else:
                warningFlag = True
                errMsg += common.getMsg(LANG, "diskdomain.disknum.info",(Id, tier0Num, tier1Num, tier2Num))
                LOGGER.logNoPass("diskdomain disknum check fail")

        if warningFlag == True:
            flag = cliUtil.RESULT_WARNING
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

