# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        巡检工具增加针对硬盘域同一层级中硬盘容量不一致导致大容量的硬盘容量被截断或者性能下降风险的检查： 
        背景：新扩容的1.8T SSD盘，实际可用容量只有900G。扩容后的可用容量小于规划的可用容量，不满足客户需求。
        步骤1 以admin用户登录设备
       步骤2 执行命令：show upgrade package，查询系统版本。
       步骤3 执行命令：show disk general,统计所有盘的类型和容量。
    '''
    
    allCliRet = ""
    errMsg = ""
    differNum = 50
    #涉及问题版本
    bugVersionList = ["V300R005C00.*", "V300R001C10.*", "V300R001C20.*", "V300R002C00.*", \
                      "V300R002C10.*", "V300R003C00.*", "V300R003C10.*", "V300R003C20$", \
                      "V300R003C20SPC100$", "V200R001C00.*", "V200R002C00.*","V200R002C20.*", "V200R002C30.*"]

    try:
        #查询设备型版本
        checkRet = checkVersion(cli, bugVersionList, LANG)
        allCliRet += checkRet[1]
        #检查过程异常退出
        if not checkRet[0]:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2])
                
        #非问题版本
        if checkRet[3]:
            LOGGER.logNoPass("The product version is %s." % (checkRet[4]))
            return (True, allCliRet, errMsg)
                
        #获取所有盘的信息
        cmd = "show disk general"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet += checkRet[1]
        if checkRet[0] != True:
            errMsg += checkRet[2]
            return (checkRet[0], allCliRet, errMsg)
        
        #判断回显信息是否有效
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
 
        #检查同一种类型的硬盘存在空闲盘，且空闲盘与成员盘的容量相差大于等于50GB
        checkRet = checkFreeAndMembDiskDifferCap(checkRet[1], differNum, LOGGER, LANG)
        if not checkRet[0]:
            errMsg += checkRet[1]
            return (False, allCliRet, errMsg) 
        #建议优化时给出建议
        errMsg += common.getMsg(LANG, "optimization.recommended")       
        return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
def checkVersion(cli, bugVersionList, LANG):
    """
    @summary: 检查设备版本是否为问题版本
    @param bugVersionList: 问题版本，版本为正则表达式， "V300R005C00.*"表示V300R005C00所以版本           
    @return: 
        isSucc：True/False，方法是否正常结束
        allCliRet：所有CLID回显
        errMsg：方法异常结束时的原因
        isPass：True/False，检查是否通过（设备版本不是问题版本时检查通过）
        productVersion：设备版本
    """
    isSucc = True
    allCliRet = ""
    errMsg = ""
    
    isPass = True
    productVersion = ""
      
    #获取产品软件版本
    checkRet, versionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        isSucc = False
        isPass = False
        errMsg = checkRet[2]
        return (isSucc, allCliRet, errMsg, isPass, productVersion)
    
    #产品版本（版本全称）
    productVersion = versionDictList[0].get("Current Version")
        
    if common.isBugProductVersion(productVersion, bugVersionList):
        #问题版本匹配
        isSucc = True
        isPass = False
        return (isSucc, allCliRet, errMsg, isPass, productVersion)
    else:
        return (isSucc, allCliRet, errMsg, isPass, productVersion)

def checkFreeAndMembDiskDifferCap(cliRet, number, LOGGER, LANG):
    '''
    @summary: 判断同一种类型的空闲盘与成员盘的容量相差值是否大于等于number
    @param number: 空闲盘与成员盘的容量相差值
    @return: True/False(True:否 False:是), errMsg (错误信息)
    '''
    
    errMsg = ""
    freeDiskInfoDict = {} 
    membDiskInfoDict = {}            
    diskInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for diskInfoDict in diskInfoDictList:
        diskRole = diskInfoDict.get("Role", "")
        diskId = diskInfoDict.get("ID", "")  
        diskType = diskInfoDict.get("Type", "")    
        diskCapacity = diskInfoDict.get("Capacity", "")
        if diskRole == "Free Disk":
            freeDiskInfoDict.setdefault(diskId, [diskType, diskCapacity])
        elif diskRole == "Member Disk":
            membDiskInfoDict.setdefault(diskId, [diskType, diskCapacity])
                     
    if not freeDiskInfoDict or not membDiskInfoDict:
        return True, ''
    
    checkFlag = True
    for freeDiskId, freeTypeCapList in freeDiskInfoDict.items():
        differNumBigDiskIdList = []
        freeDiskType = freeTypeCapList[0]
        freeDiskCapacity = freeTypeCapList[1]
        for membDiskId, membTypeCapList in membDiskInfoDict.items():
            membDiskType = membTypeCapList[0]
            if freeDiskType != membDiskType:
                continue
            
            membDiskCapacity = membTypeCapList[1]
            #把各硬盘容量单位统一转换成GB
            freeCheckRet = common.changUnit2GB(freeDiskCapacity)
            membCheckRet = common.changUnit2GB(membDiskCapacity)                                               
            differNum = abs(freeCheckRet[1] - membCheckRet[1])
            if differNum >=  number:
                differNumBigDiskIdList.append(membDiskId)
                
        if  len(differNumBigDiskIdList) != 0:      
            errMsg += common.getMsg(LANG, "free.member.differ.capacity", (freeDiskId, ",".join(differNumBigDiskIdList), number))
    
    #相差大于等于50GB时给出去处理建议            
    if errMsg != "":
        checkFlag = False
        errMsg = common.getMsg(LANG, "notpass.recommended") + errMsg
        
    return checkFlag, errMsg
                 
        

              
                
        

    

    
