# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    Extent迁移状态检查: 
        1 如果POOL不存在表示正常；
        2 Relocation Status值Ready，Relocating或Paused表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            poolId = line.get("ID")
            cmd_general = "show storage_pool general pool_id=%s" % poolId
            LOGGER.logExecCmd(cmd_general)
            checkRetGeneral = cliUtil.excuteCmdInCliMode(cli, cmd_general, True, LANG)
            cliRet += checkRetGeneral[1]
            
            if checkRetGeneral[0] != True: 
                errMsg += checkRetGeneral[2]
                LOGGER.logSysAbnormal()
                return (checkRetGeneral[0], cliRet, errMsg)
            
            cliRetGeneral = checkRetGeneral[1]
            generalList = cliUtil.getVerticalCliRet(cliRetGeneral)
            
            if len(generalList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.relocatioin.status")
                LOGGER.logNoPass("Cannot get information about Relocation Status")
            
            retDict = generalList[0]
            relocationStatus = retDict.get("Relocation Status")
            
            if not relocationStatus in ["Ready", "Relocating", "Paused"]:
                flag = False
                errMsg += common.getMsg(LANG, "pool.relocation.status.abnormal", (poolId, relocationStatus))
                LOGGER.logNoPass("The Relocation Status of POOL [%s] is abnormal (Relocation Status:%s)" 
                     % (poolId, relocationStatus))
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
