# -*- coding: UTF-8 -*-
import cliUtil
import common
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""
CURRENTPROCESS = 0
INT_5 = 5
INT_15 = 15

def execute(cli):
    '''
        文件系统碎片化检查 
        步骤2 执行命令：show system general，获取设备型号及版本型号。
        
        步骤3 执行命令：change user_mode current_mode user_mode=developer，进入developer模式。
        
        步骤4 执行命令：show file_system general，记录关键字” Running Status”字段值为” Online”所对应的文件系统ID。
        
        步骤5 执行命令：show file_system general file_system_id=文件系统ID(步骤4中记录)，记录关键字"Work Controller"字段值为对应文件系统的工作控制器。
        
        步骤6 执行命令：show space grain_alloc file_system_id=文件系统ID(步骤4中记录) controller=工作控制器（步骤5记录），查询关键字"Data B Tree Node Number"所对应的分配树节点数。

    '''
    global CURRENTPROCESS
    errMsg = ""
    try:
        #步骤2，检查设备型号及版本型号   是否在检查范围内
        flag, errMsg = checkModelAndVersion(cli)
        common.refreshProcess(PY_JAVA_ENV, INT_5, LOGGER)
        if flag != False:
            return (flag, allCliRet, errMsg)

        #步骤4 记录符合条件的文件系统ID
        (flag, fileSystemIDList, errMsg) = getFileSystemID(cli)
        common.refreshProcess(PY_JAVA_ENV, INT_15, LOGGER)
        CURRENTPROCESS = INT_15
        if flag != False:
            return (flag, allCliRet, errMsg)

        #步骤5 记录文件系统对应的工作控制器
        (flag, fileIdToControl, errMsg) = getFileSystemToControl(cli, fileSystemIDList)
        if flag != False:
            return (flag, allCliRet, errMsg)

        #步骤6 查询文件系统所对应的当前 分配树节点
        (flag, noPassfileIdList, errMsg) = checkFileSystemToNodetree(cli, fileIdToControl)
        if flag != False:
            return (flag, allCliRet, errMsg)

        #如果在之前代码中没有返回，则证明 有文件系统ID 匹配成功，存在超过1000万的树节点，返回不通过        
        errMsg = common.getMsg(LANG, "fileid.nodetree.overproof.threshold", (','.join(noPassfileIdList)))
        return (False, allCliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkFileSystemToNodetree(cli, fileIdToControl):
    '''
    @summary: 通过记录的文件系统ID及对应的工作控制器，查询所分配的树节点，当该树节点大于一千万时，该文件ID 不通过
    @param cli
    @param fileIdToControl : 文件系统ID key 工作控制器  value
    @return: 
    @return:True / RESULT_NOCHECK 检查项返回
            False 符合条件 继续往下检查
    '''
    global allCliRet
    global CURRENTPROCESS
    cmd = "show space grain_alloc file_system_id=%s controller=%s"
    NODE_NUMBER = 'Data B Tree Node Number'
    noPassfileIdList = []

    #因为 将fileID存入字典中时，id排序顺序错乱，所以此处将字典中fileId重新排序，方便界面原始信息 有序    
    fileIdList = fileIdToControl.keys()
    fileIdList.sort()
    oneObjProcess = (1.0 / len(fileIdList)) * (100 - CURRENTPROCESS)

    for fileId in fileIdList:
        #刷新进度条        
        if int(CURRENTPROCESS + oneObjProcess) - int(CURRENTPROCESS) >= 1:
            common.refreshProcess(PY_JAVA_ENV, CURRENTPROCESS + oneObjProcess, LOGGER)
        CURRENTPROCESS += oneObjProcess

        cmdStr = cmd % (fileId, fileIdToControl.get(fileId, ""))
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmdStr, True, LANG)

        #检查命令权限，若无权限 返回不涉及        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            allCliRet = common.joinLines(allCliRet, cliRet)
            return (cliUtil.RESULT_NOSUPPORT, noPassfileIdList, errMsg)

        #判断是否含异常场景
        if flag != True:
            allCliRet = common.joinLines(allCliRet, cliRet)
            LOGGER.logInfo("Get node tree has same error!")
            return (cliUtil.RESULT_NOCHECK, noPassfileIdList, errMsg)

        #解析垂直回显        
        dictList = cliUtil.getVerticalCliRet(cliRet)
        #若未解析出回显  则返回未检查        
        if len(dictList) == 0:
            allCliRet = common.joinLines(allCliRet, cliRet)
            LOGGER.logInfo("The node tree dictList is Null!")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, noPassfileIdList, errMsg)

        getValueOfEcho(cliRet, NODE_NUMBER)

        #获取关键字Work Controller 字段值
        nodeTreeNumner = dictList[0].get(NODE_NUMBER, "").strip()

        if nodeTreeNumner == "" or nodeTreeNumner == '--':
            #这里加一个定位日志  
            LOGGER.logInfo("Get nodeTreeNumner is -- or Null.")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, noPassfileIdList, errMsg)

        #验证分配树节点是否为纯数字        
        if not nodeTreeNumner.isdigit():
            #这里加一个定位日志            
            continue

        #验证分配树节点是否小于一千万
        if int(nodeTreeNumner) < 10000000:
            continue

        noPassfileIdList.append(fileId)

    #如果  列表为空 则证明没有满足条件的文件ID 检查项通过      
    if len(noPassfileIdList) == 0:
        return (True, noPassfileIdList, errMsg)

    return (False, noPassfileIdList, errMsg)

def getFileSystemToControl(cli, fileSystemIDList):
    '''
    @summary: 通过记录的文件系统ID列表，循环查询文件系统详细信息，记录对应控制器
    @param cli
    @param fileSystemIDList : 文件系统ID列表
    @return: 
    @return:True / RESULT_NOCHECK 检查项返回
            False 符合条件 继续往下检查
    '''
    global allCliRet
    global CURRENTPROCESS
    WORK_CON = 'Work Controller'
    fileIdToControl = {}

    oneObjProcess = (1.0 / len(fileSystemIDList)) * (60 - CURRENTPROCESS)

    cmd = "show file_system general file_system_id=%s"
    for fileId in fileSystemIDList:
        dictList = []

        #进度条刷新        
        if int(CURRENTPROCESS + oneObjProcess) - int(CURRENTPROCESS) >= 1:
            common.refreshProcess(PY_JAVA_ENV, CURRENTPROCESS + oneObjProcess, LOGGER)
        CURRENTPROCESS += oneObjProcess

        cmdStr = cmd % fileId
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmdStr, True, LANG)

        #检查命令是否支持，无此特性， 返回不涉及        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            allCliRet = common.joinLines(allCliRet, cliRet)
            return (cliUtil.RESULT_NOSUPPORT, fileIdToControl, errMsg)

        #判断是否含异常场景
        if flag != True:
            allCliRet = common.joinLines(allCliRet, cliRet)
            LOGGER.logInfo("Get file_system infomation has same error!")
            return (cliUtil.RESULT_NOCHECK, fileIdToControl, errMsg)

        dictList = cliUtil.getVerticalCliRet(cliRet)
        #若未解析出回显  则返回未检查        
        if len(dictList) == 0:
            allCliRet = common.joinLines(allCliRet, cliRet)
            LOGGER.logInfo("The dictList is Null!")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, fileIdToControl, errMsg)

        getValueOfEcho(cliRet, WORK_CON)

        #获取关键字Work Controller 字段值
        workControl = dictList[0].get(WORK_CON, "").strip()

        if workControl == "" or workControl == '--':
            LOGGER.logInfo("Get workControl is -- or Null.")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, fileIdToControl, errMsg)

        fileIdToControl.setdefault(fileId, workControl)

    if len(fileIdToControl) == 0:
        LOGGER.logInfo("Get fileIdKey controlValue map is Null.")
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        return (cliUtil.RESULT_NOCHECK, fileIdToControl, errMsg)

    return (False, fileIdToControl, errMsg)

def getFileSystemID(cli):
    '''
    @summary: 记录符合条件的文件系统 ID
    @param cli
    @return: 
    @return:True / RESULT_NOCHECK 检查项返回
            False 符合条件 继续往下检查
    '''
    global allCliRet

    fileSystemIDList = []
    RUN_STATUS = 'Running Status'
    FILE_ID = 'ID'

    cmd = "show file_system general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, fileSystemIDList, errMsg)
    #检查命令权限，若无权限 返回不涉及        
    if not cliUtil.hasCliExecPrivilege(cliRet):
        return (cliUtil.RESULT_NOSUPPORT, fileSystemIDList, errMsg)

    #判断是否含异常场景
    if flag != True:
        return (cliUtil.RESULT_NOCHECK, fileSystemIDList, errMsg)

    #水平解析回显    
    fileSystemInfoList = cliUtil.getHorizontalCliRet(cliRet)
    #若回文未解析成功，则返回未检查    
    if len(fileSystemInfoList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.filesystem.info")
        LOGGER.logInfo("Cannot get information about file_system general.")
        return (cliUtil.RESULT_NOCHECK, fileSystemIDList, errMsg)

    #解析出 符合条件的端口ID    
    for fileSystemInfo in fileSystemInfoList:
        status = fileSystemInfo.get(RUN_STATUS, "").strip()
        if status == "" or status == '--':
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, fileSystemIDList, errMsg)

        if status.lower() != 'online':
            continue

        filesId = fileSystemInfo.get(FILE_ID, "").strip()
        if filesId == "" or filesId == '--':
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return (cliUtil.RESULT_NOCHECK, fileSystemIDList, errMsg)

        fileSystemIDList.append(filesId)

    #如果解析出没有符合条件的端口ID，则返回通过        
    if len(fileSystemIDList) == 0:
        return (True, fileSystemIDList, errMsg)

    #反之返回False继续往下检查
    return (False, fileSystemIDList, errMsg)

def checkModelAndVersion(cli):
    '''
    @summary: 检查设备的型号及版本   是否在检查范围内
    @param cli
    @return: 
    @return:True / RESULT_NOCHECK 检查项返回
            False 符合条件 继续往下检查
    '''
    global allCliRet
    #问题型号
    checkToModel = config.itemFsTreeCheckToModel
    #问题版本
    checkToVersion = config.itemFsTreeCheckToVersion

    #查询 设备版本，记录回显
    (checkRet, currentVersionDictList, hotPatchVersionList) = common.parse_upgradePackage(cli, LANG)
    allCliRet = common.joinLines(allCliRet, checkRet[1])
    if checkRet[0] != True:
        LOGGER.logInfo("Get device version has same error.")
        return (cliUtil.RESULT_NOCHECK, checkRet[2])

    (result, currentVersion, errMsg) = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        return (cliUtil.RESULT_NOCHECK, errMsg)

    if not currentVersion in checkToVersion:
        LOGGER.logInfo("The device version is in checkList.")
        return (True, errMsg)

    #查询 设备类型，不记录回显           
    flag, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (cliUtil.RESULT_NOCHECK, errMsg)

    if not productModel in checkToModel:
        LOGGER.logInfo("The device model is in checkList.")
        return (True, errMsg)

    return (False, errMsg)

def getValueOfEcho(cliRet, keyWord):
    '''
    @summary: 截取有用回显，其他冗余回显不在界面显示
    @param keyWord: 含有有用回显的关键字
    @return:
    '''
    global allCliRet

    flag = True
    if cliRet:
        for line in cliRet.splitlines():
            #截取第一行 命令行            
            if flag:
                allCliRet = common.joinLines(allCliRet, line)
                flag = False
            #截取带有关键字的有用回显
            if keyWord in line:
                allCliRet = common.joinLines(allCliRet, line)
            if ':/>' in line:
                allCliRet = common.joinLines(allCliRet, line)
                break
