# -*- coding: UTF-8 -*-
import re

import java.lang.Exception as JException

import cliUtil
import common
import common_cache

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    IO时延检查
    :return: (检查结果，CLI回显，错误提示信息）
    """
    all_cli_res = ""
    err_msg = ""
    try:
        flag, cli_res, err_msg = check_model_version(cli)
        all_cli_res = common.joinLines(all_cli_res, cli_res)
        if flag is not False:
            return flag, all_cli_res, err_msg

        flag, cli_res, err_msg = check_fc_port(cli)
        all_cli_res = common.joinLines(all_cli_res, cli_res)
        return flag, all_cli_res, err_msg
    except (Exception, JException) as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, all_cli_res, err_msg


def check_model_version(cli):
    """
    系统软件版本和热补丁版本信息检查
    若热补丁版本大于或等于109则通过检查，否则继续检查
    :return: (检查结果，CLI回显，错误提示信息）
    """
    flag, _, h_patch, ret, err_msg = common_cache.get_version_and_patch_cache(
        PY_JAVA_ENV, cli, LOGGER)

    if flag is not True:
        return flag, ret, err_msg
    # 已确认无SPH17X补丁版本
    match_obj = re.search('SPH(\d+)', h_patch)    # noqa
    flag = bool(match_obj and match_obj.group(1) >= '109')
    return flag, ret, ""


def check_fc_port(cli):
    """
    检查端口最大速率值
    :return: (检查结果，CLI回显，错误提示信息）
    """
    cmd = "show port general physical_type=FC"
    flag, cli_res, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)

    if flag is not True:
        return flag, cli_res, err_msg

    info_dict_list = cliUtil.getHorizontalCliRet(cli_res)

    err_ports = []
    for line in info_dict_list:
        max_speed = line.get('Max Speed(Mbps)')
        if max_speed == '32000':
            port_id = line.get('ID')
            err_ports.append(port_id)
    err_msg = ""
    if err_ports:
        err_ports.sort()
        err_msg = common.getMsg(
            LANG,
            "io_timeout_check_advice",
            ','.join(err_ports)
        )
        return False, cli_res, err_msg
    return True, cli_res, err_msg
