# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import cli_util_cache as cache_util
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

# 检查的回写值
WRITE_POLICY_LIST = ["Write Back",
                     "Write Through",
                     "Write Back Mandatory"]

ALL_CLI_RET_LIST = []

def execute(cli):
    """
    LUN写策略: 
                如果不存在相应的记录表示正常，否则属于不正常状态。
    """
    try:
        process = 1.00
        sn = common.get_sn_from_env(PY_JAVA_ENV)
        common.refreshProcess(PY_JAVA_ENV, process, LOGGER)
        dev_info = PY_JAVA_ENV.get("devInfo")
        obj_py = PY_JAVA_ENV.get("objectForPy")
        # 如果是使用config则不提前查询
        err_lun_list = []
        lun_info_dict_list = cache_util.get_lun_info_from_config(obj_py,
                                                                 LOGGER,
                                                                 sn)
        LOGGER.logInfo("config lun:{0}".format(len(lun_info_dict_list)))
        if lun_info_dict_list:
            lun_id_list = get_all_lun_id(cli, sn)
            for lun_info in lun_info_dict_list:
                lun_id = lun_info.get("ID")
                # V500R007C6x config中没有新增字段Is ROW LUN Child。
                if lun_id_list and lun_id not in lun_id_list:
                    continue

                tmp_list = []
                is_row_lun_child = lun_info.get("Is ROW LUN Child", "No")
                # row lun 的子LUN不检查
                if is_row_lun_child == 'Yes':
                    continue

                write_policy = lun_info.get("Write Policy", "")
                r_write_policy = lun_info.get("Running Write Policy", "")
                tmp_list.append("\nID:{0}".format(lun_id))
                tmp_list.append("Write Policy:{0}".format(write_policy))
                tmp_list.append("Running Write Policy:{0}\n".format(
                    r_write_policy))
                ALL_CLI_RET_LIST.append("\n".join(tmp_list))
                for value in WRITE_POLICY_LIST:
                    if write_policy == value and r_write_policy != value:
                        err_lun_list.append(lun_id)
                        break
        else:
            lun_id_list = get_all_lun_id(cli, sn)
            process += 5
            common.refreshProcess(PY_JAVA_ENV, process, LOGGER)

            if not lun_id_list:
                return True, "\n".join(ALL_CLI_RET_LIST), ""

            err_lun_list = get_inconsistent_write_policy(cli, sn, lun_id_list,
                                                         process)

        LOGGER.logInfo("err_lun_list is :%s" % str(err_lun_list))

        ret = common_cache.save_cli_ret_to_file(
            ALL_CLI_RET_LIST, "software_lun_write_policy", PY_JAVA_ENV, LOGGER)

        if not err_lun_list:
            return True, ret, ''

        err_msg = common.getMsg(LANG, "lun.write.policy.inconsistent",
                                ",".join(err_lun_list))
        LOGGER.logNoPass("The err LUN is [%s]" % ",".join(err_lun_list))

        return False, ret, err_msg
    except common.UnCheckException, un_check_e:
        LOGGER.logException(un_check_e)
        ret = common_cache.save_cli_ret_to_file(
            ALL_CLI_RET_LIST, "software_lun_write_policy", PY_JAVA_ENV, LOGGER)
        return cliUtil.RESULT_NOCHECK, ret, un_check_e.errorMsg

    except Exception, exception:
        LOGGER.logException(exception)
        ret = common_cache.save_cli_ret_to_file(
            ALL_CLI_RET_LIST, "software_lun_write_policy", PY_JAVA_ENV, LOGGER)
        return cliUtil.RESULT_NOCHECK, ret, common.getMsg(
            LANG, "query.result.abnormal")


def get_inconsistent_write_policy(cli, sn, lun_id_list, process):
    """
    检查写策略不一致的lun
    :param cli:
    :param sn:
    :param lun_id_list:
    :param process:
    :return:
    """
    global ALL_CLI_RET_LIST
    err_lun_list = []
    per_lun_process = (100.00 - process) / len(lun_id_list)
    tmp_process = 0.0
    for lun_id in lun_id_list:
        cmd = "show lun general lun_id=%s" % lun_id
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
            PY_JAVA_ENV, cli, cmd, LOGGER)
        ALL_CLI_RET_LIST.append(cli_ret)
        if flag is not True:
            raise common.UnCheckException(err_msg,
                                          "\n".join(ALL_CLI_RET_LIST))

        cli_ret_lines_list = cliUtil.getVerticalCliRet(cli_ret)
        for lun_info in cli_ret_lines_list:
            lun_id = lun_info.get("ID")
            for value in WRITE_POLICY_LIST:
                if lun_info.get("Write Policy") == value and lun_info.get(
                        "Running Write Policy") != value:
                    err_lun_list.append(lun_id)
                    break

        tmp_process += per_lun_process
        if tmp_process >= 1:
            process += tmp_process
            tmp_process -= 1
            common.refreshProcess(PY_JAVA_ENV, process, LOGGER)

    return list(set(err_lun_list))


def get_all_lun_id(cli, sn):
    """
    获取lun
    :param cli:
    :param sn:
    :return:
    """
    global ALL_CLI_RET_LIST

    lun_id_list = []
    cmd = "show lun general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        PY_JAVA_ENV, cli, cmd, LOGGER)
    ALL_CLI_RET_LIST.append(cli_ret)

    if flag is not True:
        raise common.UnCheckException(err_msg,
                                      "\n".join(ALL_CLI_RET_LIST))

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return lun_id_list

    cli_ret_lines_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for lunInfo in cli_ret_lines_list:
        lun_id = lunInfo.get("ID")
        lun_id_list.append(lun_id)

    return lun_id_list
