# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
import re
from common import UnCheckException
from common import AsynProgress

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
NOT_PASS_ERR_MSG = ""
VOL_CHECK_KEY_DICT = {
    'PTT_VOL_DIRTY': 'PTT_VOL_DIRTY\s+\w+\s+\w+\s+(-*\d+)',
    'VOL_DIRTY_LUN': 'VOL_DIRTY_LUN\s+\w+\s+\w+\s+(-*\d+)',
    'VOL_DIRTY_FS': 'VOL_DIRTY_FS\s+\w+\s+\w+\s+(-*\d+)',
    'PTT_HDD_DIRTY': 'PTT_HDD_DIRTY\s+\w+\s+\w+\s+(-*\d+)'
}

PASS_VERSION_OF_V3R6 = "V300R006C50SPC100"
PASS_START_FLAG_V3 = "V3"
PASS_VERSION_OF_V5R7 = "V500R007C30SPC100"
PASS_START_FLAG_V5 = "V5"
def execute(cli):
    """
    分区dirty quota使用总量检查
        检查方法
    步骤1 以admin用户登录设备。
    步骤2 执行命令：change user_mode current_mode user_mode=developer，进入developer模式。
    步骤3 执行命令：debug，进入debug模式。
    步骤4 执行命令：quota show pttinfo [id]，id范围0-8，查看 PTT_VOL_DIRTY，VOL_DIRTY_LUN，VOL_DIRTY_FS，PTT_HDD_DIRTY 项used的数值。
    步骤5 minisystem视图下执行sshtoremoteExt x(x = 节点id % 引擎下节点数量) 命令，实现同引擎内控制器间跳转登录。
    步骤6 登录当前引擎内所有控制器执行步骤2、3、4。
    步骤7 连接集群中所有引擎执行步骤2、3、4、5。

    检查标准
    1、如果步骤4获取到的PTT_VOL_DIRTY，VOL_DIRTY_LUN，VOL_DIRTY_FS，PTT_HDD_DIRTY中任意一项used的数值小于0，巡检“不通过”。否则执行下一步。
    备注：如若检查项不存在，则忽略不存在项的检查。
    2、如果步骤6不能登录引擎内所有控制器，返回未检查。
    3、如果步骤5不能所有引擎都连接并登录，返回未检查。

    修复建议
    请联系技术支持工程师进行处理。

    18000 V1R1Cxx,T V2R2C20,T V2R2C20SPC100,T V2R2C20SPC200,T V2R2C30,T V2R2C30SPC100,T V2R2C30SPC200,18000 V1R1C20,
    18000 V1R1C20SPC100,18000 V1R1C20SPC200,18000 V1R1C30,18000 V1R1C30SPC100,18000 V1R1C30SPC200,
    T V2R2C30SPC300,18000 V1R1C30SPC300,V3R1C00SPC200,V3R1C10,V3R1C10SPC100,V3R1C10SPC200,V3R1C20,V3R1C20SPC100,V3R1C20SPC200,
    V3R2C10,V3R2C10SPC100,V3R2C10SPC200,
    V3R3C00,V3R3C00SPC100,V3R3C10,V3R3C10SPC100,V3R3C20,V3R3C20SPC100,V3R3C20SPC200,
    V3R5C00,V3R5C00SPC300,V3R5C01,
    V3R6C00,V3R6C00SPC100,V3R6C01,V3R6C10,V3R6C10SPC100,V3R6C20,V3R6C20SPC100,V3R6C30,V3R6C50SPC100,
    V5R7C00,V5R7C00SPC100,V5R7C10,V5R7C20,V5R7C30SPC100。
    """

    global ALL_CLI_RET
    my_pthread = AsynProgress(PY_JAVA_ENV, LOGGER, sleepTime=0.3)
    my_pthread.start_thread()
    conn_cli = ""
    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        product_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
        LOGGER.logInfo("product_model is: %s, product_version:%s" % (product_model, product_version))

        # V5R7C30SPC100,V3R6C50SPC100通过
        if (product_version.startswith(PASS_START_FLAG_V3) and product_version > PASS_VERSION_OF_V3R6) or \
                (product_version.startswith(PASS_START_FLAG_V5) and product_version > PASS_VERSION_OF_V5R7):
            return True, ALL_CLI_RET, ''

        # 如果是18000执行debug命令获取阵列链接
        create_ret = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        if create_ret[0] != True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, create_ret[2]
        conn_cli = create_ret[1]

        # 检查VOL_DIRTY_FS项used的数值小于0
        check_vol_dirty_used(conn_cli, PY_JAVA_ENV, LOGGER, LANG, "")

        if NOT_PASS_ERR_MSG:
            return False, ALL_CLI_RET, NOT_PASS_ERR_MSG

        return (True, ALL_CLI_RET, "")
    except UnCheckException, uncheck_ecept:
        LOGGER.logInfo(u"uncheck_ecept, err_msg: %s" % uncheck_ecept.errorMsg)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET + uncheck_ecept.cliRet, uncheck_ecept.errorMsg)
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        my_pthread.setStopFlag(True)
        if conn_cli != "":
            if common.is18000(PY_JAVA_ENV, conn_cli) and conn_cli is not cli:
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def get_vol_dirty_used(cli, LOGGER, LANG):
    """
    获取每个id下key的used值。
    :param cli:
    :param LOGGER:
    :param LANG:
    :return:
    """
    all_cli_ret_t = ""
    not_pass_err_msg = ""
    is_continue = True
    for id in range(0, 9):
        cmd = "quota show pttinfo %s" % str(id)
        flag, cli_ret, err_msg = common.executeOneDebugCommand(cli, cmd, LANG)
        all_cli_ret_t = common.joinLines(all_cli_ret_t, cli_ret)
        if flag != True:
            raise UnCheckException(err_msg, all_cli_ret_t)

        for (check_key, check_rule) in VOL_CHECK_KEY_DICT.items():
            regx = re.compile(check_rule)
            find_res = regx.findall(cli_ret)
            if not find_res:
                continue

            used_value = find_res[0]
            try:
                if int(used_value) < 0:
                    not_pass_err_msg += common.getMsg(LANG, "dirty.quota.voldoirtyfs.some.key.less.0", check_key)
                    is_continue = False
                    break
            except:
                LOGGER.logInfo("convert value to int except:%s" % str(traceback.format_exc()))
        if not is_continue:
            break

    return all_cli_ret_t, not_pass_err_msg


@common.checkAllEngineInClusterWarp
def check_vol_dirty_used(cli, PY_JAVA_ENV, LOGGER, LANG, heart_beat_cli_ret):
    """
    检查是否全部key值都不是小于0的。
    :param cli:
    :param PY_JAVA_ENV:
    :param LOGGER:
    :param LANG:
    :param heart_beat_cli_ret:
    :return:
    """
    global ALL_CLI_RET, NOT_PASS_ERR_MSG
    LOGGER.logInfo("check_vol_dirty_used heart_beat_cli_ret:%s" % heart_beat_cli_ret)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, heart_beat_cli_ret)
    cli_ret, not_pass_err_msg = get_vol_dirty_used(cli, LOGGER, LANG)
    LOGGER.logInfo(u"check_vol_dirty_used not_pass_err_msg:%s" % not_pass_err_msg)
    NOT_PASS_ERR_MSG += not_pass_err_msg
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if not_pass_err_msg:
        return common.CHECK_FLAG_NOT_CONTINUE
    return common.CHECK_FLAG_CONTINUE

