# -*- coding:utf-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
MIN_VERSION = "V300R003C00"
MAX_VERSION = "V500R007C50"
all_cli_list = []
mem_95_list = []


def execute(cli):
    global all_cli_list
    conn_cli = ''
    try:
        # 型号、版本  检查
        if not check_model_version(cli):
            return cliUtil.RESULT_NOSUPPORT, "\n".join(all_cli_list), ""

        # 如果是18000执行debug命令获取阵列链接
        flag, cli_con, err_msg = \
            common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        if not flag:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_list), err_msg
        conn_cli = cli_con

        # 所有引擎，所有控制器下 内存使用情况检查
        check_all_engine_controller_sys_mem(conn_cli, PY_JAVA_ENV, LOGGER,
                                            LANG, '')
        if mem_95_list:
            separator = {"zh": u"，", "en": ","}.get(LANG, "")
            mem_95_list.sort()
            err_msg_all = common.getMsg(LANG, "mem.sys.95",
                                        separator.join(mem_95_list))
            return False, "\n".join(all_cli_list), err_msg_all
        return True, "\n".join(all_cli_list), ""

    except common.UnCheckException as uncheck:
        LOGGER.logError("Failed to check sys_mem_95 :%s" %
                        str(uncheck.errorMsg))
        return cliUtil.RESULT_NOCHECK, "\n".join(
            all_cli_list), uncheck.errorMsg
    except (ToolException, Exception) as ex:
        LOGGER.logError("Failed to check sys_mem_95 :%s" % str(ex))
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_cli_list),
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 如果是18000,关闭新链接
        if conn_cli != "":
            if common.is18000(PY_JAVA_ENV, conn_cli) and conn_cli is not cli:
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_model_version(cli):
    """
    版本、型号检查检查，是否在范围内
    :param cli:
    :return: True在范围内，False不在范围内
    """
    global all_cli_list
    cmd = "show system general"
    LOGGER.logExecCmd(cmd)
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_list.append(cli_ret)
    if flag is not True:
        LOGGER.logSysAbnormal()
        raise common.UnCheckException(err_msg, "")
    flag, cli_ret, err_msg, product_version, hot_patch_version = \
        common.getVersion(cli, LANG)
    all_cli_list.append(cli_ret)
    if flag is not True:
        LOGGER.logSysAbnormal()
        raise common.UnCheckException(err_msg, "")
    product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    return not common.isDorado(
        product_model) and MIN_VERSION <= product_version < MAX_VERSION


@common.checkAllEngineInClusterWarp
def check_all_engine_controller_sys_mem(cli, PY_JAVA_ENV, LOGGER, LANG,
                                        heart_beat_cli_ret):
    """
    所有引擎，所有控制器下 内存使用情况检查
    :param cli:
    :param PY_JAVA_ENV:
    :param LOGGER:
    :param LANG:
    :param heart_beat_cli_ret:
    :return:
    """
    global all_cli_list, mem_95_list
    all_cli_list.append(heart_beat_cli_ret)
    local_node_id = get_local_node_id(cli)

    cmd = "cmm show page statistics"
    LOGGER.logExecCmd(cmd)
    flag, cli_ret, err_msg = common.executeOneDebugCommand(cli, cmd, LANG)
    all_cli_list.append(cli_ret)
    if flag is not True:
        LOGGER.logError("execute command %s failed!" % cmd)
        raise common.UnCheckException(err_msg, "")

    total_page_list = cliUtil.getVerticalCliRet(cli_ret)
    for page in total_page_list:
        total_page_count = long(page.get("Total Page Count", "0"))
        busy_page_count = long(page.get("Total Busy Page", "0"))
    LOGGER.logInfo(
        "local node id:%s, Total Page Count:%s, Busy Page Count:%s" %
        (local_node_id, str(total_page_count), str(busy_page_count)))
    if busy_page_count > 0.95 * total_page_count:
        mem_95_list.append(local_node_id)
    return common.CHECK_FLAG_CONTINUE


def get_local_node_id(cli):
    """
    获取local node id
    :param cli:
    :return:
    """
    local_node_id = ""
    cmd = "sys showcls"
    LOGGER.logExecCmd(cmd)
    flag, cli_ret, err_msg = common.executeOneDebugCommand(cli, cmd, LANG)
    if flag is not True:
        LOGGER.logError("execute command %s failed!" % cmd)
        raise common.UnCheckException(err_msg, "")
    sys_info = cliUtil.getVerticalCliRet(cli_ret)
    for line in sys_info:
        local_node_id = line.get("local node id", "")
    return local_node_id
