# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check software version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showUpgradePackage")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[HotPatchConsistency] execute command: \"show upgrade package\".")
            cliRet = cli.execCmd("show upgrade package")
            py_java_env.put("showUpgradePackage", cliRet)
        PY_LOGGER.info("\nSequence[HotPatchConsistency] execute command result:\n" + unicode(cliRet))
          
        namePatchVerList = []  
        lines = cliRet.splitlines()
        
        isSwitchOn = False
        for line in lines:
            line = line.strip()
            #Need enter to CLI and must in normal mode.
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[HotPatchConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[HotPatchConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            #遇到"Controller:"就打开开关
            if re.search("HotPatch Version", line, re.IGNORECASE):
                isSwitchOn = True
                
            #遇到"admin:"就关闭开关并退出循环
            if re.search("admin:", line, re.IGNORECASE):
                isSwitchOn = False
                break
            
            if isSwitchOn:
                if len(line.split()) >= 6 and "Controller" in line:
                    thisCtrlName = line.split()[1]
                    thisCtrlPatchVer = line.split()[3]
                    namePatchVerList.append((thisCtrlName,thisCtrlPatchVer))
        
        patchVerList = [ver for (name, ver) in namePatchVerList] 
        patchVersionSort = sorted(list(set(patchVerList)))
        
        #判断热补丁版本是否一致
        if len(patchVersionSort) > 1:
            flag = False 
            if 'zh' == lang:
                errMsg += u"\n控制器热补丁版本不一致："
            else:
                errMsg += u"\nThe hot patch versions of controllers are inconsistent:"
                
            for (ctrlName, ver) in namePatchVerList:
                if "zh" == lang:
                    errMsg += u'\n控制器[' + ctrlName + u']，热补丁版本：' + ver + u'。'
                else:
                    errMsg += u'\nController[' + ctrlName + u'], hot patch version:' + ver + u'.'

        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[HotPatchConsistency] catch except of check software version.")
        PY_LOGGER.error("Sequence[HotPatchConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[HotPatchConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[HotPatchConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
