# -*- coding: UTF-8 -*-
import re
import cliResource
import resource
import decimal
import traceback
import os
import time
from java.io import File
from com.huawei.ism.exception import IsmException
from cbb.frame.cli import cliUtil as cliUtilCbb
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache
from cbb.frame.cli.cliResource import NO_LOG_CMD_LIST
from cbb.frame.rest import restUtil
import config


FLAG_CMD_NO_RECORD = "No matching records"
FLAG_CMD_SUCCESS = "Command executed successfully"

NAS_FEATURE_UNSUPPORT_DEVICE = [
"2800 V3",
"2800 V5",
"2600 V3 for Video",
"Dorado3000 V3",
"Dorado5000 V3",
"Dorado6000 V3",
"S2600T",
"S5500T",
"S5600T",
"S5800T",
"S6800T",
"HVS85T",
"HVS88T",
]
CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
DEVELOPER_MODEL_FLAG = "developer:/>"
STORAGE_MODEL_FLAG = "Storage:~ #"
DEBUG_MODEL_FLAG = ":/diagnose>"
MINISYSTEM_MODEL_FLAG = "minisystem>"
CLI_RET_END_FLAG = ":/>"
DIAGNOSE_SYS_SHOW_CLS_CMD = 'sys showcls'

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"

SERIES_T = "T_SERIES"
SERIES_V3 = "V3_SERIES"
SERIES_18000 = "18000_SERIES"
SERIES_V5 = "V5_SERIES"
SERIES_V6 = "V6_SERIES"

STOR_DEV_ARM = ["2100 V3", "2200 V3", "2600 V3", "2800 V5", "2800K V5",
                "2810 V5", "5100 V3", "2210", "2220", "2200 V5",
                "5110 V5", "5110F V5", "5210 V5", "5210F V5", "5300 V5",
                "5310 V5", "5510 V5", "5610 V5", "18510 V5",
                "5810 V5", "5810F V5", "18810 V5", "18810F V5",
                '6800 V5', '6800F V5', '6810 V5', '6810F V5',
                '5300K V5', '5500K V5', '5600K V5', '5800K V5', '6800K V5',
                '18500K V5', '18800K V5',
                "5310F V5", "5510F V5", "5610F V5", "6810F V5", "18510F V5",
                "5210 V5 Enhanced", "5220 V5", "5210F V5 Enhanced",
                "2600 V5", "5110 V5 Enhanced", "5120 V5", "5110F V5 Enhanced"
                ]
STOR_DEV_INFO_DICT = {
    "S2600T": SERIES_T,
    "S5500T": SERIES_T,
    "S5600T": SERIES_T,
    "S5800T": SERIES_T,
    "S6800T": SERIES_T,
    "2100 V3": SERIES_V3,
    "2200 V3": SERIES_V3,
    "2600 V3": SERIES_V3,
    "2200 V3 Enhanced": SERIES_V3,
    "2600 V3 Enhanced": SERIES_V3,
    "2600F V3 Enhanced": SERIES_V3,
    "2600 V3 for Video": SERIES_V3,
    "2800 V3": SERIES_V3,
    "5100 V3": SERIES_V3,
    "5300 V3": SERIES_V3,
    "5500 V3": SERIES_V3,
    "5600 V3": SERIES_V3,
    "5800 V3": SERIES_V3,
    "6800 V3": SERIES_V3,
    "6900 V3": SERIES_V3,
    "2600F V3": SERIES_V3,
    "5500F V3": SERIES_V3,
    "5600F V3": SERIES_V3,
    "5800F V3": SERIES_V3,
    "6800F V3": SERIES_V3,
    "HVS85T": SERIES_18000,
    "HVS88T": SERIES_18000,
    "18500": SERIES_18000,
    "18800": SERIES_18000,
    "18800F": SERIES_18000,
    "18500 V3": SERIES_18000,
    "18800 V3": SERIES_18000,
    "18500F V3": SERIES_18000,
    "18800F V3": SERIES_18000,
    "Dorado18000 V3": SERIES_V3,
    "Dorado6000 V3": SERIES_V3,
    "Dorado5000 V3": SERIES_V3,
    "Dorado3000 V3": SERIES_V3,
    "2800 V5": SERIES_V5,
    "2800K V5": SERIES_V5,
    "2210": SERIES_V5,
    "2220": SERIES_V5,
    "2200 V5": SERIES_V5,
    "2810 V5": SERIES_V5,
    "5110 V5": SERIES_V5,
    "5210 V5": SERIES_V5,
    "2600 V5": SERIES_V5,
    "5110 V5 Enhanced": SERIES_V5,
    "5120 V5": SERIES_V5,
    "5110F V5 Enhanced": SERIES_V5,
    "5200K V5": SERIES_V5,
    "5100K V5": SERIES_V5,
    "5210F V5": SERIES_V5,
    "5110F V5": SERIES_V5,
    "5300 V5": SERIES_V5,
    "5310 V5": SERIES_V5,
    "5310F V5": SERIES_V5,
    "5500 V5": SERIES_V5,
    "5510 V5": SERIES_V5,
    "5510F V5": SERIES_V5,
    "Dorado NAS": SERIES_V5,
    "5600 V5": SERIES_V5,
    "5610 V5": SERIES_V5,
    "5610F V5": SERIES_V5,
    "5800 V5": SERIES_V5,
    "18500 V5": SERIES_18000,
    "18800 V5": SERIES_18000,
    "5300F V5": SERIES_V5,
    "5500F V5": SERIES_V5,
    "5300 V5 Enhanced": SERIES_V5,
    "5600F V5": SERIES_V5,
    "5800F V5": SERIES_V5,
    "5810 V5": SERIES_V5,
    "5810F V5": SERIES_V5,
    "5210 V5 Enhanced": SERIES_V5,
    "5220 V5": SERIES_V5,
    "5210F V5 Enhanced": SERIES_V5,
    "18500F V5": SERIES_18000,
    "18800F V5": SERIES_18000,
    "5500 V5 Elite": SERIES_V5,
    "OceanStor Dorado 3000 V6": SERIES_V6,
    "OceanStor Dorado 2000": SERIES_V6,
    "OceanStor Dorado 2020": SERIES_V6,
    "OceanStor Dorado 2100": SERIES_V6,
    "OceanStor Dorado 5000 V6": SERIES_V6,
    "OceanStor Dorado 5300 V6": SERIES_V6,
    "OceanStor Dorado 5500 V6": SERIES_V6,
    "OceanStor Dorado 5600 V6": SERIES_V6,
    "OceanStor Dorado 5800 V6": SERIES_V6,
    "OceanStor Dorado 6000 V6": SERIES_V6,
    "OceanStor Dorado 6800 V6": SERIES_V6,
    "OceanStor Dorado 8000 V6": SERIES_V6,
    "OceanStor Dorado 18000 V6": SERIES_V6,
    "OceanStor Dorado 18500 V6": SERIES_V6,
    "OceanStor Dorado 18800 V6": SERIES_V6,
    "OceanStor Dorado 18800K V6": SERIES_V6,
    "OceanStor Dorado 5600K V6": SERIES_V6,
    "OceanStor Dorado 3000": SERIES_V6,
    "OceanStor Dorado 5000": SERIES_V6,
    "OceanStor Dorado 5300": SERIES_V6,
    "OceanStor Dorado 5500": SERIES_V6,
    "OceanStor Dorado 5600": SERIES_V6,
    "OceanStor Dorado 6000": SERIES_V6,
    "OceanStor Dorado 6800": SERIES_V6,
    "OceanStor Dorado 8000": SERIES_V6,
    "OceanStor Dorado 18000": SERIES_V6,
    "OceanStor Dorado 18500": SERIES_V6,
    "OceanStor Dorado 18800": SERIES_V6,
    "OceanStor Dorado 18800K": SERIES_V6,
    "OceanStor Dorado 5600K": SERIES_V6,
    "OceanStor 2200": SERIES_V6,
    "OceanStor 2220": SERIES_V6,
    "OceanStor 5120": SERIES_V6,
    "OceanStor 2600": SERIES_V6,
    "OceanStor 2620": SERIES_V6,
    "OceanStor 5210": SERIES_V6,
    "OceanStor 5220": SERIES_V6,
    "OceanStor 5310": SERIES_V6,
    "OceanStor 5310 Capacity Flash": SERIES_V6,
    "OceanStor 5510 Capacity Flash": SERIES_V6,
    "OceanStor A300": SERIES_V6,
    "OceanStor A800": SERIES_V6,
    "OceanStor 5320": SERIES_V6,
    "OceanStor 5510": SERIES_V6,
    "OceanStor 5510S": SERIES_V6,
    "OceanStor 5300K": SERIES_V6,
    "OceanStor 5500K": SERIES_V6,
    "OceanStor 5610": SERIES_V6,
    "OceanStor 5810-HS": SERIES_V6,
    "OceanStor 6810": SERIES_V6,
    "OceanStor 18510": SERIES_V6,
    "OceanStor 18500K": SERIES_V6,
    "OceanStor 18810": SERIES_V6,
    '6800 V5': SERIES_V5,
    '6800F V5': SERIES_V5,
    '6810 V5': SERIES_V5,
    '6810F V5': SERIES_V5,
    '18510 V5': SERIES_V5,
    '18510F V5': SERIES_V5,
    '18810 V5': SERIES_V5,
    '18810F V5': SERIES_V5,
    '5300K V5': SERIES_V5,
    '5500K V5': SERIES_V5,
    '5600K V5': SERIES_V5,
    '5800K V5': SERIES_V5,
    '6800K V5': SERIES_V5,
    '18500K V5': SERIES_V5,
    '18800K V5': SERIES_V5,
    'OceanProtect X3000': SERIES_V6,
    'OceanProtect X8000': SERIES_V6,
    'OceanProtect E8000': SERIES_V6,
    'OceanProtect X9000': SERIES_V6,
    'OceanProtect A8000': SERIES_V6,
    'OceanProtect X6000': SERIES_V6,
    'OceanProtect X8000K': SERIES_V6,
    'OceanProtect X9000K': SERIES_V6,
    'OceanStor Micro 1300': SERIES_V6,
    'OceanStor Micro 1500': SERIES_V6,
    'OceanDisk 1300': SERIES_V6,
    'OceanDisk 1500': SERIES_V6,
    'OceanDisk 1600': SERIES_V6,
    'OceanDisk 1610': SERIES_V6,
    'OceanDisk 1610T': SERIES_V6,
    'OceanDisk 1500T': SERIES_V6,
    'OceanDisk 1600T': SERIES_V6,
    'OceanStor 2910': SERIES_V6
}

# 相同型号，不同版本可能带SVP或不带SVP。需要用版本判断。
NO_SVP_PRODUCT = {"18800F V5":"Kunpeng", "18500F V5":"Kunpeng","18800 V5":"Kunpeng", "18500 V5":"Kunpeng"}


V3_6800 = "6800 V3"
V3_6800F = "6800F V3"
V3_6900 = "6900 V3"
#执行导出命令的超时时间
TIMEOUT_COLLECT = 25 * 60
#执行删除命令的超时时间
TIMEOUT_DELETE = 30

# 大规格超时时间设置
TIME_OUT_BATCH_CLI = 30*60
#导出日志回显判断标准
COLLECT_INFO_RECROD_STANDARD = "File Path :"
#删除阵列端临时文件判断标准
DELETE_REMOTE_DATA_STANDARD = ["System is exporting files"]
#判断新命令执行成功的列表
ISEXEC_CMD_SUCCESS_FLAG = [
                           "File Path : /OSM/export_import/",
                           "File Path : /OSM/coffer_data/omm/export_import"
                            ]
#特定命令所需的指定结束符
endWithSignToAdmin = [":/>", ">", "> "]
endWithSignToDiagnose = [">", "> ", "diagnose>", "/diagnose>"]

def getMsg(lang, msg, args = "", resource = cliResource.MESSAGES_DICT):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.has_key(msg):
            return errMsg

        localeDict = resource.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg

def isChinese(lang):
    '''
    @summary: 判断lang是否为中文
    @param lang: 语言lang
    @return: 
        True: 中文
        False: 非中文
    '''
    if lang == "zh":
        return True
    return False

def isNoneLicense(cliRet):
    '''
    @summary: 判断回显结果里面是否包含需要license
    @param cliRet: cli回显
    @return: 
        True: cli回显包含需要license
        False: cli回显不包含需要license
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "license" in lowerLine and ("error" in lowerLine or "suggestion" in lowerLine):
            return True

    return False

def isNotSupport(cliRet):
    '''
    @summary: 判断回显结果里面是否包含 does not support the VM service
    @param cliRet: cli回显
    @return: 
        True: cli回显包含 does not support the VM service
        False: cli回显不包含does not support the VM service
    '''

    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "does not support" in lowerLine or "is not supported" in lowerLine:
            return True

    return False

def isVMNotStarted(cliRet):
    '''
    @summary: 判断回显结果里面是否包含 The VM service is not started
    @param cliRet: cli回显
    @return: 
        True: cli回显包含 The VM service is not started
        False: cli回显不包含The VM service is not started
    '''

    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "the vm service is not started" in lowerLine:
            return True

    return False

def hasCliExecPrivilege(cliRet):
    '''
    @summary: 判断是否具有执行cli命令的权限
    @param cliRet: cli回显
    @return: 
        True: 具有执行cli命令的权限
        False: 不具有执行cli命令的权限
    '''
    for line in cliRet.splitlines():
        if line.strip() == "^":
            return False
        if "does not have the permission" in line:
            return False
    return True

def queryResultWithNoRecord(cliRet):
    '''
    @summary: 判断回显是否为Command executed successfully
    @param cliRet: cli回显
    @return: 
        True: cli回显中包含Command executed successfully
        False: cli回显中不包含Command executed successfully
    '''
    if re.search(CLI_EXECUTE_CMD_SUCCESS, cliRet, re.IGNORECASE):
        return True
    return False

def isInternalError(cliRet):
    '''
    @summary: 判断回显结果是否包含内部错误信息
    @param cliRet: cli回显
    @return: 
        True: cli回显包含内部错误信息
        False: cli回显不包含内部错误信息
    '''
    lowerCliRet = cliRet.lower()
    if "internal error" in lowerCliRet:
        return True
    else:
        return False

def getUserName(cli, lang):
    '''
    @summary: 获取设备上登录的用户名
    @param cli: cli对象
    @param cli: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，返回设备上登录的用户名
            flag为False时，返回cli回显结果
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""
    userName = ""

    try:
        cmd = "show system general"
        checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            return checkRet

        cliRet = checkRet[1]
        lineList = cliRet.splitlines()

        if len(lineList) == 0:
            errMsg = getMsg(lang, "cannot.get.sys.info")
            return (False, cliRet, errMsg)

        lastLine = lineList[-1]
        if CLI_RET_END_FLAG in lastLine:
            userName = lastLine.replace(" ", "").replace(CLI_RET_END_FLAG, "")
            return (True, userName, errMsg)

    except:
        errMsg = getMsg(lang, "cannot.get.sys.info")
        return (False, cliRet, errMsg)

    return (False, cliRet, errMsg)

def getUserPrivilegeWithCliRet(cli, lang):
    '''
    @summary: 获取用户权限级别
    @param cli: cli对象
    @param cli: 语言lang
    @return: (falg, cliRet, userPrivilege, errMsg)
        flag: 
            True: 获取成功
            False: 获取失败
        cliRet: 返回cli回显结果
        userPrivilege:
            flag为True时，返回用户权限级别
            flag为False时，返回""
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""

    try:
        checkRet = getUserName(cli, lang)
        if checkRet[0] != True:
            return (checkRet[0], checkRet[1], "", checkRet[2])

        userName = checkRet[1]
        cmd = "show user user_name=%s" % userName
        checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            return (checkRet[0], checkRet[1], "", checkRet[2])

        cliRet = checkRet[1]
        cliRetLinesList = getHorizontalCliRet(cliRet)

        if len(cliRetLinesList) == 0:
            errMsg = getMsg(lang, "cannot.get.user.info")
            return (False, cliRet, "", errMsg)

        for line in cliRetLinesList:
            name = line["Name"]
            if name == userName:
                userPrivilege = line["Level"]
                return (True, cliRet, userPrivilege, errMsg)

    except:
        errMsg = getMsg(lang, "cannot.get.user.info")
        return (False, cliRet, "", errMsg)

    return (False, cliRet, "", errMsg)

def getUserPrivilege(cli, lang):
    '''
    @summary: 获取用户权限级别
    @param cli: cli对象
    @param cli: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，返回用户权限级别
            flag为False时，返回cli回显结果
        errMsg: 错误消息
    '''
    cliRet = ""
    errMsg = ""

    try:
        checkRet = getUserName(cli, lang)
        if checkRet[0] != True:
            return checkRet

        userName = checkRet[1]
        cmd = "show user user_name=%s" % userName
        checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            return checkRet

        cliRet = checkRet[1]
        cliRetLinesList = getHorizontalCliRet(cliRet)

        if len(cliRetLinesList) == 0:
            errMsg = getMsg(lang, "cannot.get.user.info")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            name = line["Name"]
            if name == userName:
                userPrivilege = line["Level"]
                return (True, userPrivilege, errMsg)

    except:
        errMsg = getMsg(lang, "cannot.get.user.info")
        return (False, cliRet, errMsg)

    return (False, cliRet, errMsg)

def hasAdminOrSuperAdminPrivilege(cli, lang):
    '''
    @summary: 判断用户是否具有管理员或超级管理员权限
    @param cli: cli对象
    @param cli: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时
                True: 具有管理员或超级管理员权限
                False： 不具有管理员或超级管理员权限
            flag为False时，返回cli回显结果
        errMsg: 错误消息
    '''
    checkRet = getUserPrivilege(cli, lang)
    if checkRet[0] != True:
        return checkRet

    userLevel = checkRet[1]
    if userLevel is None or len(userLevel) == 0 or userLevel.lower() not in ["super_admin", "admin"]:
        return (True, False, "")
    else:
        return (True, True, "")

def enterDeveloperMode(cli, lang):
    '''
    @summary: 进入developer模式，
        使用完后务必调用 cliUtil.enterCliModeFromSomeModel 函数
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, cliRet, errMsg)
        flag:
            True: 进入developer模式成功
            False: 进入developer模式失败
        cliRet: cli回显
        errMsg: 进入developer模式失败时的错误消息
    '''
    cmd = "change user_mode current_mode user_mode=developer"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet
    cliRet = checkRet[1]

    if isInDeveloperMode(cliRet):
        return (True, cliRet, "")

    #dorado c00进入developer需要进行交互,最多三次
    cliRetAll = cliRet
    for times in range(3):
        if re.search("(y/n)", cliRet, re.IGNORECASE):
            checkFlag, cliRet, errInfo = excuteCmdCommon(cli, "y", lang)
            cliRetAll += cliRet
            if not checkFlag:
                return (False, cliRetAll, errInfo)

        if isInDeveloperMode(cliRet):
            return (True, cliRetAll, "")

    errMsg = getMsg(lang, "has.not.cli.privilege")
    return (RESULT_NOCHECK, cliRetAll, errMsg)



def enterMinisystemModeFromDevelopModel(cli, lang):
    '''
    @summary: 进入minisystem模式
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, cliRet, errMsg)
        flag:
            True: 进入minisystem模式成功
            False: 进入minisystem模式失败
        cliRet: cli回显
        errMsg: 进入minisystem模式失败时的错误消息
    '''
    cmd = "minisystem"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg)

    if isInMinisystemMode(cliRet):
        return (True, cliRet, "")

    return (RESULT_NOCHECK, cliRet, errMsg)


def enter_debug_mode_from_developer(cli, lang):
    """
    进入debug模式
    :param cli: ssh连接
    :param lang: 中英文
    :return:
    """
    cmd = "debug"
    flag, ret, err_msg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return flag, ret, err_msg

    if isInDebugMode(ret):
        return True, ret, ""

    return RESULT_NOCHECK, ret, err_msg

def enterDebugModeFromCliMode(cli, lang):
    '''
    @summary: 从cli模式进入debug模式
    '''
    allCliRet = ""

    #进入devoper模式
    checkRet = enterDeveloperMode(cli, lang)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        return checkRet

    cmd = "debug"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], allCliRet, checkRet[2])

    if isInDebugMode(checkRet[1]):
        return (True, allCliRet, "")
    else:
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, allCliRet, errMsg)

def enterMinisystemModeFromDebugMode(cli, lang):
    """
    @summary: 从debug模式进入小系统模式
    """
    allCliRet = ''
    cmd = "exit"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return checkRet

    cmd = "minisystem"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], allCliRet, checkRet[2])

    if "minisystem>" not in checkRet[1]:
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, allCliRet, checkRet[2])

    return (True, allCliRet, "")

def enterCliModeFromDebugModel(cli, lang):
    '''
    @summary: 从debug模式进入cli模式
    '''
    allCliRet = ""
    cmd = "exit"
    #切换到developer
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        return checkRet
    #切换到CLI        
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    return checkRet


def excuteCmdCommon(cli, cmd, lang):
    '''
    @summary: 执行cli命令，只判断是否拿到回显信息
    '''
    cliRet = ""
    errMsg = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (False, cliRet, errMsg)

    try:
        cliRet = cli.execCmd(cmd)
    except:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (False, cliRet, errMsg)

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (False, cliRet, errMsg)

    return (True, cliRet, errMsg)


def enterCliModeFromSomeModel(cli, lang):
    '''
    @summary: 从其他模式进入cli模式
    '''
    excuRet = excuteCmdCommon(cli, "show system general", lang)
    if excuRet[0] == False:
        return excuRet

    if isInDebugMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if isInMinisystemMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if isInDeveloperMode(excuRet[1]) or isInStorageMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if excuRet[1].endswith(":/>"):
        return (True, excuRet[1], "")

    return (False, excuRet[1], excuRet[2])

def exitHeartbeatCli(cli, lang):
    '''
    @summary: Exit from minisystem mode of peer controller to local controller CLI mode.
    @param cli: CLI connection
    @return:None
    '''
    try:
        for _ in range(3):
            (_, cliRet, _) = excuteCmdCommon(cli, "exit", lang)

            while "(y/n)" in cliRet:
                _, cliRet, _ = excuteCmdCommon(cli, "y", lang)

            #Compatible for debug version.
            if isInStorageMode(cliRet):
                (_, cliRet, _) = excuteCmdCommon(cli, "exit", lang)
    except:
        traceback.format_exc(None)


def closeCliConnection(cliCon):
    """关闭CLI连接。

    :param cliCon:
    :return:
    """
    try:
        if not cliCon:
            cliCon.close()
        return
    except:
        return


def isInDebugMode(cliRet):
    '''
    @summary: 判断当前是否在debug模式下
    '''
    if re.search(DEBUG_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False


def isInMinisystemMode(cliRet):
    '''
    @summary: 判断当前是否在minisystem模式下
    '''
    if re.search(MINISYSTEM_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False


def developerMode2CliMode(cli):
    '''
    @summary: developer模式下退回到cli模式
    @param cli: cli对象
    '''
    cliRet = cli.execCmd("exit")
    if "y/n" in cliRet:
        cli.execCmd("n")

    return None

def isInDeveloperMode(cliRet):
    '''
    @summary: 判断当前是否在developer模式下
    @param cliRet: cli回显
    @return: 
        True: 当前在developer模式下
        False: 当前不在developer模式下
    '''
    if re.search(DEVELOPER_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False

def isInStorageMode(cliRet):
    '''
    @summary: 判断当前是否在Storage模式下，debug 版本.
    @param cliRet: cli回显
    @return: 
        True: 当前在Storage模式下
        False: 当前不在Storage模式下
    '''
    if re.search(STORAGE_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False


def sshToRemoteContr(cli, cmd, passWord, lang):
    """
    @summary: 在minisystem模式执行心跳命令到指定的控制器
    """
    allCliRet = ""
    flag, cliRet, errMsg = excuteCmdInMinisystemModel(cli, cmd, lang)
    allCliRet += cliRet
    if flag != True:
        return (flag, cliRet, errMsg)

    if '(yes/no)?' in cliRet:#首次心跳问题.
        allCliRet += "\n" + cliRet
        flag, cliRet, errMsg = excuteCmdInCliMode(cli, 'yes', True, lang)

    if "password:" in cliRet:
        flag, cliRet, errMsg = excuteCmdTimeOutInCliMode(cli, passWord, False, lang, 5 * 60)
        allCliRet += "\n" + cliRet
        #密码不正确时，退出到minisystem模式，防止持续输错密码导致阵列被锁且模式不正常
        if "password:" in cliRet:
            excuteCtrlC(cli)
            
        if flag != True:
            return (flag, allCliRet, errMsg)
    
    if "System Name" not in cliRet:
        errMsg = getMsg(lang, "ssh.remote.failure")
        return (False, allCliRet, errMsg)

    return (True, allCliRet, errMsg)

def excuteCtrlC(cli):
    '''
    @summary: 执行Ctrl+C终止当前交互
    '''
    try:
        #执行Ctrl+C终止当前交互
        cli.getMonitor().sendCmd(3)
    except:
        return
    
def checkLineInBlackList(cliLine, lang):
    '''
    @summary: 判断cli语句行是否在黑名单中
    @param cliLine: cli语句行
    @param lang: 语言lang
    @return: 
        True: cli语句行在黑名单中
        False: cli语句行不在黑名单中
    '''
    errMsg = ""
    for dictItems in cliResource.BLACKLIST_DICT:
        if dictItems.get("key_word") in cliLine:
            if isChinese(lang):
                errMsg = dictItems.get("msg_zh")
            else:
                errMsg = dictItems.get("msg_en")
            return (True, errMsg)
    return (False, errMsg)


def is_need_log(cmd_str, no_log_list):
    """
    检查是否需要打印日志，主要针对大规格命令不打印，防止冲日志。
    :param cmd_str:
    :param no_log_list:
    :return: True: 打印，False: 不打印
    """
    for reg_cmd in no_log_list:
        if reg_cmd in cmd_str:
            return False
    return True


def excuteCmdInCliMode(cli, cmd, isHasLog, lang, endWithSign=None):
    '''
    2019.12.31 由于大规格场景冲日志严重，对齐方案：执行命令都不打日志。
    @summary: 获取cli模式下执行命令后的回显
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, cliRet, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        cliRet: cli回显
        errMsg: 错误消息
    '''
    errMsg = ""
    cliRet = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (RESULT_NOCHECK, "", errMsg)

    try:
        if isHasLog and is_need_log(cmd, NO_LOG_CMD_LIST):
            cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)
        else:
            if endWithSign:
                cliRet = cli.execCmdNoLog(cmd, endWithSign)
            else:
                cliRet = cli.execCmdNoLog(cmd)
    except IsmException:
        #出现异常时，由框架上层处理
        raise

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：回显长度为零，说明命令执行失败，由False改为未检查

    if not hasCliExecPrivilege(cliRet):
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, cliRet, errMsg)

    if isVMNotStarted(cliRet):
        errMsg = getMsg(lang, r"vm.is.not.started")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNotSupport(cliRet):
        errMsg = getMsg(lang, r"does.not.support.vm")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNoneLicense(cliRet):
        errMsg = getMsg(lang, "has.not.license")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)

    if isInternalError(cliRet):
        return (True, cliRet, errMsg)

    lineList = cliRet.splitlines()
    for line in lineList:
        checkRet = checkLineInBlackList(line, lang)
        if checkRet[0]:
            return (RESULT_NOCHECK, cliRet, checkRet[1])

    if "TOOLKIT_SEND_CMD_TIME_OUT" in cliRet or "messages timed out" in cliRet:
        cli.reConnect()
        errMsg = getMsg(lang, "failed.to.time.out", cmd)
        return (RESULT_NOCHECK, cliRet, errMsg)

    return (True, cliRet, errMsg)


def excuteCmdTimeOutInCliMode(cli, cmd, isHasLog, lang, timeOut):
    '''
    @summary: 功能同excuteCmdInCliMode，但可指定命令的执行超时时间
    2019.12.31 由于大规格场景冲日志严重，对齐方案：执行命令都不打日志。
    '''
    errMsg = ""
    cliRet = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (RESULT_NOCHECK, "", errMsg)

    try:
        if isHasLog and is_need_log(cmd, NO_LOG_CMD_LIST):
            cliRet = cli.execCmdWithTimout(cmd, timeOut)
        else:
            cliRet = cli.execCmdNoLogTimout(cmd, timeOut)
    except IsmException:
        #出现异常时，由框架上层处理
        raise

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：回显长度为零，说明命令执行失败，由False改为未检查

    if not hasCliExecPrivilege(cliRet):
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, cliRet, errMsg)

    if isVMNotStarted(cliRet):
        errMsg = getMsg(lang, r"vm.is.not.started")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNotSupport(cliRet):
        errMsg = getMsg(lang, r"does.not.support.vm")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNoneLicense(cliRet):
        errMsg = getMsg(lang, "has.not.license")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)

    if isInternalError(cliRet):
        return (True, cliRet, errMsg)

    lineList = cliRet.splitlines()
    for line in lineList:
        checkRet = checkLineInBlackList(line, lang)
        if checkRet[0]:
            return (RESULT_NOCHECK, cliRet, checkRet[1])  # 修改备注：cli语句行在黑名单中

    if "TOOLKIT_SEND_CMD_TIME_OUT" in cliRet:
        cli.reConnect()
        errMsg = getMsg(lang, "remote.lun.path.status.timeout")
        return RESULT_NOCHECK, cliRet, errMsg

    return (True, cliRet, errMsg)


def excuteCmdInDeveloperMode(cli, cmd, isHasLog, lang):
    '''
    @summary: 获取developer模式下执行命令后的回显
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        ret: cli回显
        errMsg: 错误消息
    '''
    try:
        switch = True
        #兼容部分命令视图切换，先尝试在普通用户模式下执行，再尝试在研发模式下执行
        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        if checkRet[0] == True:
            return checkRet

        checkRet, switch = openDeveloperSwitch(cli, lang)
        if checkRet[0] == False:
            return checkRet

        enterDeveloperCheckRet = enterDeveloperMode(cli, lang)
        if enterDeveloperCheckRet[0] != True:
            return enterDeveloperCheckRet

        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        cliRet = checkRet[1]

        if isInDeveloperMode(cliRet):
            developerMode2CliMode(cli)
        return checkRet
    except IsmException:
        #出现异常时，由框架上层处理
        raise
    finally:
        #关闭开关
        if not switch :
            closeDeveloperSwitch(cli, lang)

def excuteCmdInDeveloper(cli, cmd, isHasLog, lang):
    '''
    @summary: 获取developer模式下执行命令后的回显,直接在研发模式下执行，无需在普通模式下尝试
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        ret: cli回显
        errMsg: 错误消息
    '''
    try:
        switch = True
        checkRet, switch = openDeveloperSwitch(cli, lang)
        if checkRet[0] == False:
            return checkRet

        enterDeveloperCheckRet = enterDeveloperMode(cli, lang)
        if enterDeveloperCheckRet[0] != True:
            return enterDeveloperCheckRet
        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        cliRet = checkRet[1]
        if isInDeveloperMode(cliRet):
            developerMode2CliMode(cli)
        return checkRet
    except IsmException:
        raise
    finally:
        #关闭开关
        if not switch :
            closeDeveloperSwitch(cli, lang)

def execCmdHasEndWithSign(cli, cmd, endWithSign):
    """
    @summary: 查询执行命令时 是否含有指定结束符
    """
    if endWithSign:
        cliRet = cli.execCmd(cmd, endWithSign)
    else:
        cliRet = cli.execCmd(cmd)
    return cliRet

def excuteCmdInDebugModel(cli, cmd, lang, endWithSign=None):
    """
    @summary: 在debug模式下执行命令
    """
    try:
        cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)

        if isInDebugMode(cliRet):
            return (True, cliRet, "")

        if isInMinisystemMode(cliRet):
            cliRet = cli.execCmd("exit")
            if "(y/n)" in cliRet:
                cliRet = cli.execCmd("y")

        if isInDeveloperMode(cliRet):
            cliRet = cli.execCmd("debug")
            if isInDebugMode(cliRet):
                cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)
                return (True, cliRet, "")

            return (False, cliRet, getMsg(lang, "has.not.cli.privilege"))

        flag, cliRet, errMsg = enterDebugModeFromCliMode(cli, lang)
        if flag != True:
            return flag, cliRet, errMsg

        cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)

        return (True, cliRet, "")
    except:
        return (False, cliRet, "")


def excuteCmdInMinisystemModel(cli, cmd, lang):
    """
    @summary: 在minisystem模式下执行命令
    """
    cliRet = cli.execCmd(cmd)
    if "password:" in cliRet:
        return True, cliRet, ''

    if isInMinisystemMode(cliRet):
        return (True, cliRet, "")

    if isInDebugMode(cliRet):
        cliRet = cli.execCmd("exit")
        if "(y/n)" in cliRet:
            cliRet = cli.execCmd("y")

    if isInDeveloperMode(cliRet):
        cliRet = cli.execCmd("minisystem")
        if isInMinisystemMode(cliRet):
            cliRet = cli.execCmd(cmd)
            return (True, cliRet, "")
        
        
        return (False, cliRet, getMsg(lang, "has.not.cli.privilege"))

    flag, cliRet, errMsg = enterDeveloperMode(cli, lang)
    if flag != True:
        return flag, cliRet, errMsg

    cliRet = cli.execCmd("minisystem")
    if not isInMinisystemMode(cliRet):
        return (False, cliRet, getMsg(lang, "has.not.cli.privilege"))

    cliRet = cli.execCmd(cmd)
    return (True, cliRet, "")


def excuteModifydbtableinfoInMinisystemModel(cli, cmd, lang):
    """
    @summary: 在minisystem模式下执行命令:
    Storage: minisystem> modifydbtableinfo.sh q DB_LUN_S 35
    DANGER: You are going to perform a danger command.
    Suggestion: Before you perform this operation, make sure the operation will not affect working of system.
    Have you read danger alert message carefully?(y/n)
    y
    Enter "I have read and understand the consequences associated with performing this operation." to confirm running this command.
    I have read and understand the consequences associated with performing this operation.
    admin:/diagnose>db showtableinfo DB_LUN_S 35
    """
    allCliRet = ''
    cliRet = cli.execCmd(cmd)
    allCliRet = cliRet
    if "(y/n)" in cliRet:
        cliRet = cli.execCmd("y", ["to confirm running this command."])
        allCliRet +=  "\n" + cliRet
    if 'Enter "I have read and understand the consequences associated with performing this operation."' in cliRet:
        cliRet = cli.execCmd("I have read and understand the consequences associated with performing this operation.")
        allCliRet += "\n" + cliRet
        if not cliRet:
            return (RESULT_NOCHECK, cliRet, getMsg(lang, "cannot.get.info", "[%s]" % cmd))

    return (True, allCliRet, "")


def openDeveloperSwitch(cli, lang):
    '''
            打开切换developer模式开关
    '''
    switch = True
    #兼容V3R6版本，查看切developer模式开关是否打开
    developercmd = "show user_mode enabled"
    checkRet = excuteCmdInCliMode(cli, developercmd, True, lang)
    #执行异常等均默认不需要开启模式开关
    if checkRet[0] != True:
        return (True, checkRet[1], checkRet[2]), switch

    cliRetDictList = getVerticalCliRet(checkRet[1])
    developerswitch = ""
    for dict in cliRetDictList:
        if "Developer View" in dict:
            developerswitch = dict.get("Developer View", "")
            break

    if developerswitch == "Disabled":
        switch = False
        #开关关闭则打开 
        opencmd = "change user_mode enabled user_mode=developer enabled=yes"
        checkRet = excuteCmdInCliMode(cli, opencmd, True, lang)
        if checkRet[0] != True:
            return checkRet, switch

    return checkRet, switch

def closeDeveloperSwitch(cli, lang):
    '''
    @summary: 关闭developer视图开关
    '''
    try:
        closecmd = "change user_mode enabled user_mode=developer enabled=no"
        excuteCmdInCliMode(cli, closecmd, True, lang)
    except:
        return

def getProductModelVersion(cli, lang):
    '''
    @summary: 获取产品类型和产品版本
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，产品类型 产品版本 
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    checkRet = getOEMproductModelAndVersion(cli, lang)
    if checkRet[0] == True:
        return (True, " ".join((checkRet[3], checkRet[4])), checkRet[1])
    
    cmd = "show system general"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = ""
    product_version = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Model":
            product_model = fieldValue
        elif fieldName == "Product Version":
            product_version = fieldValue

        if len(product_model) != 0 and len(product_version) != 0 and product_model != "--" and product_version != "--":
            return (True, " ".join((product_model, product_version)), "")

    return (False, cliRet, getMsg(lang, "cannot.get.product.version.info"))


def get_kernel_version(cli, lang):
    """获取内核固件版本

    :param cli: cli连接
    :param lang: 语言
    :return:
    """
    cmd = "upgrade.sh kernel showversion"
    cli_ret = excuteCmdInMinisystemModel(cli, cmd, lang)
    if cli_ret[0] is not True:
        return False, cli_ret, ""
    kernel_info_list = getVerticalCliRet(cli_ret[1])
    ret = enterCliModeFromSomeModel(cli, lang)
    if not ret[0]:
        return ret
    return True, cli_ret[1], kernel_info_list[0].get("kernel version", "")


def getProductModel(cli, lang):
    '''
    @summary: 获取产品类型
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，产品类型
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    checkRet = getOEMproductModel(cli, lang)
    if checkRet[0] == True:
        return (True, checkRet[3], "")
    
    cmd = "show system general"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Model":
            product_model = fieldValue

        if len(product_model) != 0 and product_model != "--":
            return (True, product_model, "")

    return (False, cliRet, getMsg(lang, "cannot.get.product.model.info"))


def getOEMproductModelAndVersion(cli, lang):
    """
    @summary: 获取深度OEM设备的华为型号和版本
    """
    flag, cliRet, errMsg, infoDict = getOEMsysInfo(cli, lang)
    if flag != True:
        return (flag, cliRet, errMsg, "", "")
    
    productModel = infoDict.get("Internal Product Model")
    productVersion = infoDict.get("Product Version")
    
    if productModel and productVersion:
        return (True, cliRet, "",  productModel.strip(), productVersion.strip())
    
    return (False, cliRet, getMsg(lang, "query.result.abnormal", resource = resource.MESSAGES_DICT), "", "")


def getOEMproductModel(cli, lang):
    """
    @summary: 获取深度OEM设备的华为型号和版本
    """
    flag, cliRet, errMsg, infoDict = getOEMsysInfo(cli, lang)
    if flag != True:
        return (flag, cliRet, errMsg, "")
    
    productModel = infoDict.get("Internal Product Model")
    if productModel:
        return (True, cliRet, "",  productModel.strip())
    
    return (False, cliRet, getMsg(lang, "query.result.abnormal", resource = resource.MESSAGES_DICT), "")


def getOEMproductModelAndCurSysDate(cli, lang):
    """
    @summary: 获取深度OEM设备的华为型号和版本设备当前时间
    """
    flag, cliRet, errMsg, infoDict = getOEMsysInfo(cli, lang)
    if flag != True:
        return (flag, cliRet, errMsg, "", "")
    
    productModel = infoDict.get("Internal Product Model")
    sysTime = infoDict.get("Time")
    if productModel and sysTime:
        return (True, cliRet, "",  productModel.strip(), sysTime.strip())
    
    return (False, cliRet, getMsg(lang, "query.result.abnormal", resource = resource.MESSAGES_DICT), "", "")


def getOEMsysInfo(cli, lang):
    """
    @summary: 获取深度OEM设备的华为型号等基本信息（V2R6C10，V5R7及其之后版本show system general获取的是OEM厂商型号）
    """
    product_model = restUtil.CommonRest.getOriginProductModel(cli.getdNode())
    cmd = "show system general|filterColumn exclude columnList=Product\sModel"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg, {})
    
    dictList = getVerticalCliRet(cliRet)
    if len(dictList) == 0:
        return (False, cliRet, getMsg(lang, "query.result.abnormal", resource = resource.MESSAGES_DICT), {})
    if product_model:
        dictList[0]["Internal Product Model"] = product_model
    return (True, cliRet, "", dictList[0])


def getProductModelWithCliRet(cli, lang):
    '''
    @summary: 获取产品类型并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, productModel, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        productModel:
                                产品型号
        ret: 
            cli回显
        errMsg: 错误消息
    '''
    checkRet = getOEMproductModelAndVersion(cli, lang)
    if checkRet[0] == True:
        return (True, checkRet[3], checkRet[1], "")
    
    cmd = "show system general"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return (checkRet[0], '', checkRet[1], checkRet[2])

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Model":
            product_model = fieldValue

        if len(product_model) != 0 and product_model != "--":
            return (True, product_model, cliRet, "")

    return (False, "", cliRet, getMsg(lang, "cannot.get.product.model.info"))

def getManufactoryCliRet(cli, lang):
    '''
    @summary: 获取OEM过后产品配置回文
    @param cli: cli对象
    @param lang: 语言lang
    @return: checkRet[1]
        checkRet[1]: 
            cli回显
    '''
    cmd = "show system manufactory"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    return checkRet[1]

def getProductVersionWithCliRet(cli, lang):
    '''
    @summary: 获取产品版本并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, productModel, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        productModel:
                                产品型号
        ret: 
            cli回显
        errMsg: 错误消息
    '''
    cmd = "show system general"
    flag , cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return flag , "", cliRet, errMsg

    cliRetList = cliRet.splitlines()
    product_version = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Version":
            product_version = fieldValue

        if len(product_version) != 0 and product_version != "--":
            return (True, product_version, cliRet, "")

    return (False, "", cliRet, getMsg(lang, "cannot.get.product.version.info"))

def getProductModelAndVersion(cli, lang):
    '''
    @summary: get product model and version 
    @return isQryStatusOk,boolean
    @return:  product_model,str
    @return:  product_version, str
    @return: errmsg, str
    '''
    checkRet = getOEMproductModelAndVersion(cli, lang)
    if checkRet[0] == True:
        return (True, checkRet[3], checkRet[4], checkRet[1])
    
    cmd = "show system general"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)

    if checkRet[0] != True:
        errMsg = checkRet[2] if len(checkRet) >= 2 else ""
        return (False, "", "", errMsg)

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = ""
    product_version = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Model":
            product_model = fieldValue
        elif fieldName == "Product Version":
            product_version = fieldValue

        if len(product_model) != 0 and len(product_version) != 0 and product_model != "--" and product_version != "--":
            return True, product_model, product_version, cliRet

    return False, product_model, product_version, getMsg(lang, "cannot.get.product.version.info")


def getProductModelAndVersionNotOEM(cli, lang):
    '''
    @summary: get product model and version 执行cmd = "show system general"
    @return isQryStatusOk,boolean
    @return:  product_model,str
    @return:  product_version, str
    @return: errmsg, str
    '''

    cmd = "show system general"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)

    if checkRet[0] != True:
        errMsg = checkRet[2] if len(checkRet) >= 2 else ""
        return (False, "", "", errMsg)

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = restUtil.CommonRest.getOriginProductModel(cli.getdNode())
    product_version = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if not product_model and fieldName == "Product Model":
            product_model = fieldValue
        elif fieldName == "Product Version":
            product_version = fieldValue

        if len(product_model) != 0 and len(product_version) != 0 and product_model != "--" and product_version != "--":
            return True, product_model, product_version, cliRet

    return False, product_model, product_version, getMsg(lang, "cannot.get.product.version.info")


def getStorageType(cli, lang):
    '''
    @summary: 获取存储设备类型
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，存储设备类型
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    getProductModelRet = getProductModel(cli, lang)
    if getProductModelRet[0] != True:
        return getProductModelRet

    pdtModel = getProductModelRet[1]

    if not STOR_DEV_INFO_DICT.has_key(pdtModel):
        errMsg = getMsg(lang, "cannot.get.storage.type.info")
        return (False, "", errMsg)

    storageType = STOR_DEV_INFO_DICT.get(pdtModel)
    return (True, storageType, "")

def getHorizontalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        requiredLineLen = tuple_idxs[-1][0]
        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            #标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            if len(line) <= requiredLineLen:
                continue

            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        return dictList
    except:
        return []

def getVerticalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break

        if re.search("^-+\r*\n*$", line):
            dictList.append(lineDict.copy())
            lineDict.clear()

        fields = line.split(":")
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)

    if len(lineDict) > 0:
        dictList.append(lineDict.copy())

    return dictList


def get_vertical_cli_ret_with_filter(cli_ret, cli_filter):
    """
    按逐行字典的方式获取垂直表格形式的cli回显集合（自定义分隔符）
    :param cli_ret:  cli回显
    :param cli_filter: 分隔符
    :return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,
    处理不正常时，返回空集合
    """
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    dict_list = []
    line_dict = {}
    local_filter = ":"
    if cli_filter:
        local_filter = cli_filter
    for line in cli_ret_list:
        if CLI_RET_END_FLAG in line:
            break

        if re.search("^-+\r*\n*$", line):
            dict_list.append(line_dict.copy())
            line_dict.clear()
        fields = line.split(local_filter)
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = local_filter.join(fields[1:len(fields)]).strip().decode("utf8")

        if key in line_dict:
            key += "_" + str(str(line_dict.keys()).count(key + "_") + 1)
        line_dict.setdefault(key, value)

    if len(line_dict) > 0:
        dict_list.append(line_dict.copy())

    return dict_list


def getVerticalCliRetFilterElabel(cliRet, isParseElcLabel=True):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合（只处理表格中过滤显示电子标签场景）
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    elcLabel = ""
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break
        
        if re.search("^-+\r*\n*$", line):
            if not isParseElcLabel and lineDict.has_key("Electronic Label"):
                lineDict["Electronic Label"] = lineDict["Electronic Label"] + elcLabel
                elcLabel = ""
                
            dictList.append(lineDict.copy())
            lineDict.clear()
            
        fields = line.split(" : ")
        if len(fields) < 2:
            if isParseElcLabel and "=" in line:
                fields = line.split("=")
            elif "=" in line and re.search("^\s{16,}", line):
                elcLabel += line
                continue
            else:
                continue
        
        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")
        
        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)
    
    if len(lineDict) > 0:
        if not isParseElcLabel and lineDict.has_key("Electronic Label"):
            lineDict["Electronic Label"] = lineDict["Electronic Label"] + elcLabel
        dictList.append(lineDict.copy())
    
    return dictList
	
	
def getHorizontalCliRetFilterElabel(cliRet, getDetail = True):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合（只处理水平表格中过滤显示电子标签场景）
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''

    if not ("Electronic\sLabel" in cliRet and "Electronic Label" in cliRet):
        return None

    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            #标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            #处理电子标签属性行
            if not line.startswith(" "):
                if len(dictList) == 0:
                    continue
                lineDict = dictList[-1]
                eLabelValue = lineDict.get("Electronic Label")
                newELabelValue = eLabelValue + "\n" + line
                lineDict["Electronic Label"] = newELabelValue
                dictList[-1] = lineDict.copy()
                continue

            #处理新行    
            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        #处理电子标签详细属性值
        if getDetail:
            for lineDict in dictList:
                eLabelValue = lineDict.get("Electronic Label")
                eLableLines = eLabelValue.splitlines()
                #没有电子标签场景
                if len(eLableLines) <= 1:
                    lineDict["BoardType"] = ""
                    lineDict["BarCode"] = ""
                    lineDict["Item"] = ""
                    lineDict["Description"] = ""
                    lineDict["Manufactured"] = ""
                    lineDict["VendorName"] = ""
                    lineDict["IssueNumber"] = ""
                #存在电子标签属性
                else:
                    propertyList = []
                    for elabelProperty in eLableLines[1:]:
                        if "=" in elabelProperty:
                            propertyList.append(elabelProperty)
                        else:
                            if len(propertyList) == 0:
                                continue
                            propertyList[-1] += elabelProperty
                    for elabelProperty in propertyList:
                        props = elabelProperty.split("=")
                        propKey = props[0].strip().decode("utf8")
                        propValue = "=".join(props[1:]).strip().decode("utf8")
                        lineDict[propKey] = propValue
        return dictList
    except:
        return []

def getSplitedCliRet(cliRet, splitMark):
    '''
    @summary: 按分割标记从回显中获取仅包含该分割标记对应的的回显
    @param cliRet: cli回显
    @param splitMark: 分割标记 
    '''
    cliRetlist = cliRet.split(splitMark)
    if len(cliRetlist) < 2:
        return ""

    splitedCliRet = cliRetlist[1]
    match = re.search("^.*:(/>)*\r*\n*$", splitedCliRet, re.MULTILINE)
    if match:
        splitedCliRet = splitedCliRet[0:match.start()]

    if len(splitedCliRet.strip()) == 0:
        return ""
    else:
        return splitedCliRet

def isEngine0(value):
    '''
    @summary: 根据id判断是否为引擎0
    @param value: 回显中的ID
    @return: 
        True: 是引擎0
        False: 不是引擎0
    '''
    if "ENG0" in value or "CTE0" in value:
        return True
    else:
        return False

def isEngineId(value):
    '''
    @summary: 根据id判断是否为引擎ID
    @param value: 回显中的ID
    @return: 
        True: 是引擎ID
        False: 不是引擎ID
    '''
    if "ENG" in value or "CTE" in value:
        return True
    else:
        return False

def isDiskId(value):
    '''
    @summary: 根据id判断是否为硬盘ID
    @param value: 回显中的ID
    @return: 
        True: 是硬盘ID
        False: 不是硬盘ID
    '''
    if "DAE" in value:
        return True
    else:
        return False

def isDataSwitchId(value):
    '''
    @summary: 根据id判断是否为交换机ID
    @param value: 回显中的ID
    @return: 
        True: 是交换机ID
        False: 不是交换机ID
    '''
    if "DSW" in value:
        return True
    else:
        return False

def isHighDensityDisk(enclosureId, cli, lang):
    '''
    @summary: 判断硬盘框是否为高密框
    @param enclosureId: 框ID
    @param cli: cli对象
    @param lang: 语言lang
    @return: (flag, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，是高密框
            flag为False时，不是高密框
        errMsg: 错误时的消息
    '''
    if not isDiskId(enclosureId):
        return (True, False, "")

    checkRet = getHighDensityDiskEnclosureIdList(cli, lang)
    if checkRet[0] != True:
        return checkRet

    highDensityDiskEnclosureIdList = checkRet[1]
    if enclosureId in highDensityDiskEnclosureIdList:
        return (True, True, "")
    else:
        return (True, False, "")

def getEnclosureHeight(cli, enclosureId, lang):
    '''
    @summary: 根据框ID获取框高度(U)
    @param cli: cli对象
    @param enclosureId: 框ID
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，框ID对应的高度(U)
            flag为False时，cli回显
        errMsg: 错误消息
    '''

    cmd = "show enclosure enclosure_id=%s|filterColumn include columnList=Height(U)" % enclosureId
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Height(U)":
            enclosureHeight = fieldValue
            return (True, enclosureHeight, "")

    errMsg = getMsg(lang, "cannot.get.enclosure.info")
    return (False, cliRet, errMsg)

def getEnclosureType(cli, enclosureId, lang):
    '''
    @summary: 根据框ID获取框类型
    @param cli: cli对象
    @param enclosureId: 框ID
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，框ID对应的类型
            flag为False时，cli回显
        errMsg: 错误消息
    '''

    cmd = "show enclosure enclosure_id=%s|filterColumn include columnList=Type" % enclosureId
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Type":
            enclosureType = fieldValue
            return (True, enclosureType, "")

    errMsg = getMsg(lang, "cannot.get.enclosure.info")
    return (False, cliRet, errMsg)

def getPresentCtrlNodeIdList(cli, lang):
    '''
    @summary: Get all present controller node ID List, such as, [0,1,2,3], not ['0A', '0B']
    @param cli: CLI connection.
    @param lang: Language.
    @return: (isQrySucc, cliRet, errMsg, nodeIdList) 
    '''

    #Implement this method by execute diangose command 'sys showcls'
    isExeSucc, cliRet, _ = excuteCmdInDebugModel(cli, DIAGNOSE_SYS_SHOW_CLS_CMD, lang)
    if not isExeSucc:
        return False, cliRet, getMsg(lang, "failed.to.get.present.nodeid"), []

    presentNodeIdList = []
    for line in cliRet.splitlines():
        fields = line.split()
        if len(fields) < 4 or not fields[0].isdigit():
            continue
        else:
            presentNodeIdList.append(fields[0].strip())

    return True, cliRet, '', presentNodeIdList


def getPresentCtrlNodeIdListForSshToRemote(cli, lang, engine):
    """
    @summary: 获取指定引擎下的节点（控制器）ID，然后转换为心跳参数
    """
    isExeSucc, cliRet, _ = excuteCmdInDebugModel(cli, DIAGNOSE_SYS_SHOW_CLS_CMD, lang)
    if not isExeSucc:
        return False, cliRet, getMsg(lang, "failed.to.get.present.nodeid"), []

    presentNodeIdList = []
    for line in cliRet.splitlines():
        fields = line.split()
        if len(fields) < 4 or not fields[0].isdigit():
            continue

        enigeId = fields[-1].strip()
        if enigeId == engine:
            nodeId = fields[0].strip()
            nodeId = int(nodeId) % 4
            presentNodeIdList.append(nodeId)

    return True, cliRet, '', presentNodeIdList


def getControllerIdList(cli, lang):
    '''
    @summary: 获取设备所有控制器ID
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，设备所有控制器ID列表
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cmd = "show controller general|filterColumn include columnList=Controller"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetLinesList = cliRet.splitlines()
    controlList = []

    for line in cliRetLinesList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Controller":
            ctrlId = fieldValue
            controlList.append(ctrlId)

    if len(controlList) == 0:
        errMsg = getMsg(lang, "cannot.get.controller.info")
        return (False, cliRet, errMsg)

    return (True, controlList, "")

def getControllerIdListWithRet(cli, lang):
    '''
    @summary: 获取设备所有控制器ID
    @param cli: cli对象
    @param lang: 语言lang
    @return: (flag, controlList, errMsg, result)
        flag:
            True: 获取成功
            False: 获取失败
        controlList: 
            flag为True时，设备所有控制器ID列表
            flag为False时，controlList为空
        errMsg: 错误消息
        result: cli回显
    '''
    controlList = []
    cmd = "show controller general|filterColumn include columnList=Controller"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return (checkRet[0], controlList, checkRet[2], checkRet[1])

    cliRet = checkRet[1]
    cliRetLinesList = cliRet.splitlines()

    for line in cliRetLinesList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Controller":
            ctrlId = fieldValue
            controlList.append(ctrlId)

    if len(controlList) == 0:
        errMsg = getMsg(lang, "cannot.get.controller.info")
        return (False, controlList, errMsg, cliRet)

    return (True, controlList, "", cliRet)

def getEng0Id(cli, lang):
    '''
    @summary: 获取引擎0ID
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，引擎0ID
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    cmd = "show enclosure"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetLinesList = getHorizontalCliRet(cliRet)

    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.enclosure.info")
        return (False, cliRet, errMsg)

    for line in cliRetLinesList:
        enclosureId = line["ID"]
        if isEngine0(enclosureId):
            return (True, enclosureId, "")

    return (True, "", "")

def getHighDensityDiskEnclosureIdList(cli, lang):
    '''
    @summary: 获取高密硬盘框ID集合
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，高密硬盘框ID集合
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''
    cmd = "show enclosure"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    highDensityDiskEnclosureIdList = []
    cliRetLinesList = getHorizontalCliRet(cliRet)

    if len(cliRetLinesList) == 0:
        errMsg = getMsg(lang, "cannot.get.enclosure.info")
        return (False, cliRet, errMsg)

    for line in cliRetLinesList:
        enclosureType = line["Type"]
        enclosureId = line["ID"]
        if "4U 75" in enclosureType:
            highDensityDiskEnclosureIdList.append(enclosureId)

    return (True, highDensityDiskEnclosureIdList, "")

def checkDiskInSameEngine(cliRet):
    '''
    @summary: 判断硬盘域中硬盘是否同引擎
    @param cli: cli对象
    @param lang: 语言lang
    @return: 
            True： 判断时正常
            False： 判断时异常
    '''
    flag = True
    engineIdList = []
    cliRetLinesList = getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        matcher = re.match("([A-Z]+)(\d)", line["ID"])
        if matcher:
            engineIdList.append(matcher.group(2))
    standardId = engineIdList[0]
    if len(set(engineIdList)) != 1:
        flag = False
    return flag

def checkDiskCapacity(cliRet, cofferDiskList, standardNum, LOGGER):
    '''
    @summary: 判断硬盘域中同类型的硬盘容量和转速相同
             （保险箱盘除外，保险箱盘最大可比同类型非保险箱盘少10GB）
    @param cliRet: cli回显
    @param cofferDiskList: 系统保险箱盘
    @return: 硬盘类型列表
    '''

    cliRetLinesList = getHorizontalCliRet(cliRet)
    errTypeList = []
    errSpeedTypeList = []
    diskTypeDict = {}

    diskInfoDict = {}

    for line in cliRetLinesList:
        id = line["ID"]
        cap = line["Capacity"]
        type = line["Type"]
        speed = str(line["Speed(RPM)"]).strip()

        if diskTypeDict.has_key(type):
            diskInfoDict = diskTypeDict.get(type)
            diskInfoDict.setdefault(id, (cap, speed))
        else:
            diskTypeDict.setdefault(type, {id:(cap, speed)})

    LOGGER.logNoPass("diskTypeDict" + str(diskTypeDict))

    for diskType in diskTypeDict.keys():

        diskInfoDict = diskTypeDict.get(diskType)

        capSpeedList = diskInfoDict.values()
        diskIdList = diskInfoDict.keys()

        capSpeedNumList = list(set(capSpeedList))
        if len(capSpeedNumList) == 1:
            continue

        speedList = []
        cofferCapList = []
        dataCapList = []

        for diskId in diskIdList:
            capSpeedTuple = diskInfoDict.get(diskId)
            singleCap = capSpeedTuple[0]
            singleSpeed = capSpeedTuple[1]
            speedList.append(singleSpeed)
            if diskId in cofferDiskList:
                cofferCapList.append(singleCap)
            else:
                dataCapList.append(singleCap)

        LOGGER.logNoPass("cofferCapList" + str(cofferCapList))
        LOGGER.logNoPass("dataCapList" + str(dataCapList))

        #所有盘存在不同转速
        if len(set(speedList)) > 1:
            errSpeedTypeList.append(diskType)

        #数据盘存在两种容量，检查失败
        if len(set(dataCapList)) > 1:
            errTypeList.append(diskType)
            continue

        #硬盘域中保险箱盘容量一致性
        if len(set(cofferCapList)) > 1:
            errTypeList.append(diskType)
            continue

        #硬盘域中由保险箱盘和数据盘组成
        dataCapList = list(set(dataCapList))
        cofferCapList = list(set(cofferCapList))

        if len(dataCapList) > 0 and len(cofferCapList) > 0:
            dataDiskCap = dataCapList[0]
            cofferDiskCap = cofferCapList[0]
            num = transferCapToGB(dataDiskCap) - transferCapToGB(cofferDiskCap)
            if num > standardNum or num < 0:
                errTypeList.append(diskType)

    return (list(set(errTypeList)), list(set(errSpeedTypeList)))

def transferCapToGB(capacity):
    num = decimal.Decimal(capacity[:-2])
    unit = capacity[-2:]
    standardNum = 1000
    if unit == "TB":
        return num * standardNum
    if unit == "GB":
        return num
    if unit == "MB":
        return num / standardNum
    return ""

def transferCapToTB(capacity):
    num = float(capacity[:-2])
    unit = capacity[-2:]
    standardNum = 1024
    if unit == "TB":
        return num
    if unit == "GB":
        return num / standardNum
    if unit == "MB":
        return num / standardNum / standardNum
    if unit == "KB":
        return num / standardNum / standardNum / standardNum
    return num


def transfer_capacity(capacity, unit):
    """
    将磁盘容量各单位互相转换
    :param capacity: 带单位的容量描述字符串，如“2TB”， “5GB”
    :param unit: 转换的目标单位，如“KB”， “MB”
    :return: float 转换后的以unit为单位的数字
    """
    unit_order = ("B", "KB", "MB", "GB", "TB", "PB")
    standard_num = 1024
    re_str = r"^([0-9]+\.?[0-9]+)([KMGTP]?B)$"
    num_str, origin_unit = re.findall(re_str, capacity)[0]
    num = float(num_str)
    origin_unit_index = unit_order.index(origin_unit)
    unit_index = unit_order.index(unit)
    return num * standard_num ** (origin_unit_index - unit_index)


def getHorizontalNostandardCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合,此方法用来解析CLI回显未对其情况
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        lenkeys = len(keys)
        dictList = []
        for line in field_words:
            if line.find(":/>") >= 0:
                break

            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            vals = []
            valueList = line.strip().split("  ")

            valueSpaceList = []
            for value in valueList:
                if value != "":
                    vals.append(value.strip().decode("utf8"))
                    valueSpaceList.append(value)
            lenvalue = len(valueSpaceList)
            if lenvalue == lenkeys:
                dictList.append(dict(zip(keys, vals)))

        return dictList
    except:
        return []

def getHorizontalNostandardCliRet4Martiu(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合,此方法用来解析CLI回显未对其情况
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    import re
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        lenkeys = len(keys)
        dictList = []
        for line in field_words:
            if line.find(":/>") >= 0:
                break

            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            vals = []
            valueList = line.strip().split("  ")

            valueSpaceList = []
            for value in valueList:
                if value != "":
                    vals.append(value.strip().decode("utf8"))
                    valueSpaceList.append(value)
            lenvalue = len(valueSpaceList)
            if lenvalue == lenkeys:
                dictList.append(dict(zip(keys, vals)))

        return dictList
    except:
        return []


def getContrManagementIp(cli, lang):
    """
    @summary: 获取设备上每个控制器的管理IP
    """
    flag = True
    cliRet = ""
    errMsg = ""
    contrManagementIpList = []

    cmd = "show system management_ip"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg, contrManagementIpList)

    infoDictList = getVerticalCliRet(cliRet)
    for infoDict in infoDictList:
        IPv4 = infoDict.get("IPv4 Address")
        if IPv4 not in contrManagementIpList:
            contrManagementIpList.append(IPv4)

    return (flag, cliRet, errMsg, contrManagementIpList)


def getEngineIdList(cli, lang):
    """
    @summary: 获取引擎ID
    """
    engineIdList = []
    cmd = "show enclosure|filterRow column=Logic\sType predict=equal_to value=Engine"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg, engineIdList)

    infoDictList = getHorizontalCliRet(cliRet)
    if not infoDictList:
        errMsg = getMsg(lang, "query.result.abnormal")
        return (False, cliRet, errMsg, engineIdList)

    for infoDict in infoDictList:
        engineId = infoDict.get("ID")
        engineIdList.append(engineId)

    return (True, cliRet, errMsg, engineIdList)


def get_lun_id_list_with_cache(cli, lang, py_java_env, logger):
    """
    @summary: 获取设备上所有LUN的ID
    """
    lun_id_list = []

    cmd = "show lun general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        py_java_env, cli, cmd, logger)

    if flag is not True:
        return flag, cli_ret, err_msg, lun_id_list

    if queryResultWithNoRecord(cli_ret):
        return True, cli_ret, err_msg, lun_id_list

    lun_info_dict_list = getHorizontalNostandardCliRet(cli_ret)
    if len(lun_info_dict_list) == 0:
        err_msg = getMsg(lang, "query.result.abnormal")
        return False, cli_ret, err_msg, lun_id_list

    for lunInfoDict in lun_info_dict_list:
        lun_id_list.append(lunInfoDict.get("ID"))

    return True, cli_ret, err_msg, lun_id_list


def getLunIdList(cli, lang):
    """
    @summary: 获取设备上所有LUN的ID
    """
    lunIdList = []

    cmd = "show lun general|filterColumn include columnList=ID"
    flag, cliRet, errMsg = excuteCmdTimeOutInCliMode(cli, cmd, True, lang, TIME_OUT_BATCH_CLI)
    if flag != True:
        return (flag, cliRet, errMsg, lunIdList)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, lunIdList)

    lunInfoDictList = getHorizontalNostandardCliRet(cliRet)
    if len(lunInfoDictList) == 0:
        errMsg = getMsg(lang, "query.result.abnormal")
        return (False, cliRet, errMsg, lunIdList)

    for lunInfoDict in lunInfoDictList:
        lunIdList.append(lunInfoDict.get("ID"))

    return (True, cliRet, errMsg, lunIdList)


def getManagementPortInfo(cli, lang):
    """
    @summary: 获取设备管理端口信息（包含所在的引擎，连接状态，管理IP等）
    """
    managementPortInfo = []
    cmd = "show port general physical_type=ETH logic_type=Management_Port"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg, managementPortInfo)

    managementPortInfo = getHorizontalCliRet(cliRet)
    if len(managementPortInfo) == 0:
        errMsg = getMsg(lang, "query.result.abnormal")
        return (False, cliRet, errMsg, managementPortInfo)

    return (True, cliRet, errMsg, managementPortInfo)

def getCurrentTime(cli, lang, logger):
    """
    @summary: 执行命令show system general获取系统当前时间
    @return: 
        flag：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的原因
        time:   当前系统时间字符串
    """

    flag = True
    cliRet = ""
    errMsg = ""
    timeStr = ""

    try:

        cmd = "show system general"
        execRet = excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = execRet[1]

        #命令执行失败
        if execRet[0] != True:
            flag = execRet[0]
            errMsg = execRet[2]
            return (RESULT_NOCHECK, cliRet, errMsg, timeStr)

        #解析回显为字典列表
        sysInfoDictList = getVerticalCliRet(cliRet)
        if sysInfoDictList:
            sysInfo = sysInfoDictList[0]
            timeStr = sysInfo.get("Time")
            timeStr = timeStr[:timeStr.find("UTC")].strip()

        if not timeStr:
            flag = RESULT_NOCHECK
            errMsg = getMsg(lang, "cannot.get.current.time")

        return (flag, cliRet, errMsg, timeStr)

    except Exception, exception:
        logger.logException(exception)
        return (RESULT_NOCHECK, cliRet, getMsg(lang, "cannot.get.current.time"), timeStr)

def is_dev_of_12GB_SAS_Share_Expansion(pyJavaEnv, productVersion):
    '''
    @summary: Check whether the device is of 12 GB SAS Share Expansion('Big Card') or not.
    @param pyJavaEnv: Java python evrionment variable.
    @param productVersion: Product version.
    @return: True is it is else False.
    @attention: For V5 version, please confirm with product manager or SE.
    '''
    #TODO: To confirm this for V5 Version.
    devNode = pyJavaEnv.get("devInfo")
    devType = devNode.getDeviceType()
    return ('18' in str(devType) and productVersion > 'V300R003')

def existSmartIoCard(cli, lang):
    '''
    @summary: 执行命令“show interface_module |filterRow column=Model predict=equal_to value=4\sport\sSmartIO\sI/O\sModule logicOp=or column=Model predict=equal_to value=8x8G\sFC\sOptical\sInterface\sModule”
                                        查看是否存在4 port SmartIO I/O Module或者8x8G FC Optical Interface Module
    @return: 
        flag：True/False，是否存在SmartIO卡
        cliRet：CLI回显
        errMsg：方法异常结束时的原因
    '''
    bugPortIdList = []
    cmd = "show interface_module |filterRow column=Model predict=equal_to value=4\sport\sSmartIO\sI/O\sModule logicOp=or column=Model predict=equal_to value=8x8G\sFC\sOptical\sInterface\sModule"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    #命令执行失败
    if flag != True:
        return (flag, cliRet, errMsg, bugPortIdList)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, bugPortIdList)
    else:
        interModuleDictList = getHorizontalCliRet(cliRet)
        for interModuleDict in interModuleDictList:
            moduleId = interModuleDict.get("ID","")
            if moduleId:
                bugPortIdList.append(moduleId)
    
    return (flag, cliRet, errMsg, bugPortIdList)

def exportLog(cli, lang, exportType, context, logger):
    '''
    #执行命令，导出系统日志信息
    '''
    from common_utils import is_super_administrator
    try:
        flag = False
        localDirInfo = []
        errMsg = ""

        flag, product_model, err_msg = getProductModel(cli, lang)
        if flag != True:
            errMsg += err_msg
            return (flag, localDirInfo, errMsg)

        if not is_super_administrator(cli, context.get("devInfoMap").get("userName"), lang):
            errMsg += getMsg(lang, "collect.fail.user.level.low", resource=resource.MESSAGES_DICT)
            return (flag, localDirInfo, errMsg)

        cmd = "show file export_path file_type=%s" % (exportType)
        (isSuccess, rec, _) = excuteCmdTimeOutInCliMode(cli, cmd, True, lang, TIMEOUT_COLLECT)
        if isSuccess != True:
            errMsg += getMsg(lang, "collect.fail.when.executing.cli", resource = resource.MESSAGES_DICT)
            deleteRemoteFile(cli, exportType, rec, lang, logger)
            return (flag, localDirInfo, errMsg)

        execSucc = isExecCmdSuccForRec(rec)
        if not execSucc:
            logger.logError("show file... execute failed, deleting file...")
            errMsg += getMsg(lang, "can.not.get.export.path", resource = resource.MESSAGES_DICT)
            deleteRemoteFile(cli, exportType, rec, lang, logger)
            return (flag, localDirInfo, errMsg)

        (loadSucc, localDirInfo) = downloadFile(context, rec, logger)
        if not loadSucc:
            logger.logError("download file failed, deleting file...")
            deleteRemoteFile(cli, exportType, rec, lang, logger)
            errMsg += getMsg(lang, "collect.fail.download.error", resource = resource.MESSAGES_DICT)
            return (flag, localDirInfo, errMsg)

        logger.logInfo("get file success")
        deleteRemoteFile(cli, exportType, rec, lang, logger)

        return (True, localDirInfo, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return (False, localDirInfo, errMsg)

def deleteRemoteFile(cli, exportType, rec, lang, logger):
    '''
    @summary: 删除阵列端生成的文件
    @param cliRet:  devObj=上下文对象
                    type=收集的类型
                    rec=CLI回显信息
    @return:Bool(True or False)
    '''
    try:
        #根据CLI回显信息判断当前环境下，是否允许删除
        deletable = True
        for standard in DELETE_REMOTE_DATA_STANDARD:
            if standard in rec:
                deletable = False
                break

        if deletable:
            cmd = "delete file filetype=%s" % exportType
            logger.logExecCmd("deleting file:%s" % cmd)
            excuteCmdTimeOutInCliMode(cli, cmd, True, lang, TIMEOUT_DELETE)

        return True

    except Exception, exception:
        logger.logException(exception)
        return False

def isExecCmdSuccForRec(rec):
    '''
    @summary: 根据回显判断命令是否执行成功
    @param cliRet:  rec=导出系统信息的回显
    @return 1: True or False,命令执行成功
    '''
    execSucc = False

    for pathStr in ISEXEC_CMD_SUCCESS_FLAG:
        if pathStr in rec:
            execSucc = True
            break

    return execSucc

def downloadFile(context, rec, logger):
    '''
    @summary: 下载收集到得文件信息到本地
    @param cliRet:  devObj=上下文对象
                    type=收集的类型
                    rec=命令执行成功的回显
    @return: True or False
    '''
    try:
        sftp = context.get("sftp")

        #获取和设置日志暂存路径
        localDir = context.get("dataCollectTmpDir")
        if not localDir:
            devNode = context.get("devInfo")
            localDir = 'pytemp' + os.sep + devNode.getDeviceSerialNumber() + "_" + time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())) + os.sep

        try:
            if not os.path.exists(localDir):
                os.makedirs(localDir)
        except Exception, exception:
            logger.logException(exception)
            return (False, None)

        absLocalDir = os.path.abspath(localDir)
        logger.logInfo("dataCollectTmpDir:%s" % absLocalDir)

        #下载信息到本地
        #获取阵列端存放信息的路径和文件名称
        listRemotePaths = getRemotePathAndName(rec)

        #下载到本地的目录信息
        localDirInfo = []
        for temp in listRemotePaths:
            localPath = localDir + temp["name"]
            localFile = File(localPath)
            sftp.getFile(temp["path"], localFile, None)
            tempDict = {"path":localDir, "name":temp["name"]}
            localDirInfo.append(tempDict)

        return (True, localDirInfo)
    except Exception, exception:
        logger.logException(exception)
        return (False, None)

def getRemotePathAndName(rec):
    '''
    @summary: 获取阵列端的文件名称和路径
    @param rec:  执行导出命令后的回显
    @return: name:阵列端产生的文件名称
             path:阵列端产生的文件的路径
    '''
    resultList = []
    cliRetList = rec.splitlines()
    for line in cliRetList:
        #判断回显是否正常
        if COLLECT_INFO_RECROD_STANDARD in line:
            tempDict = {}
            tempList = line.split(" : ")
            path = tempList[1]
            tempList1 = path.split("/")
            name = tempList1[-1]
            tempDict["path"] = path
            tempDict["name"] = name
            resultList.append(tempDict)

    return resultList

def getHerizontalDictList(eventRecord):
    '''
    @summary: 将告警日志文件中的告警记录解析为字典列表，一个字典对应一次告警
    @param eventRecord:  告警记录（类似回显的形式）
    @return : dictList : 字典列表
    '''

    dictList = []
    if not eventRecord:
        return dictList

    #将Fault list解析为字典列表.首行为key，以4个空格拆分
    keys = eventRecord[0].strip().split("    ")
    isHeadLine = True
    for line in eventRecord:
        #首行是key,不解析
        if isHeadLine:
            isHeadLine = False
            continue

        line = line.strip()
        #每两个空行中间是一个告警记录，一个告警记录可能多次换行
        if line == "":
            #放入一个新的空字典
            dictList.append({})
            continue

        valList = line.split("    ")

        #一次告警记录未解析完
        if len(dictList[-1]) < len(keys):
            index = len(dictList[-1])
            eventDict = dictList[-1]
            for val in valList:
                eventDict.setdefault(keys[index], val)
                index += 1

        #字典的键值对数量已经和键的总数相等，但当前行还没到空行，说明当前行是最后一个键对应值的剩余部分
        if len(dictList[-1]) == len(keys):
            lastVal = dictList[-1].get(keys[-1])
            lastVal += line
            dictList[-1].update({keys[-1]: lastVal})

    #去除解析完的字典列表中的空字典
    dictList = [lineDict for lineDict in dictList if len(lineDict) > 0]

    return dictList

def getCliRetDict(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    @注：该方法用于解析回文为XXX：XXX或者XXX|XXX场景
    '''
    try:
        infoDict = {}
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            split_Mark_Colon = ":"
            split_Mark_Equal = "|"
            
            key = ""
            val = ""
            if split_Mark_Colon in line:
                lineList = line.split(split_Mark_Colon)
                key = lineList[0].strip()
                #对值进行有效性判断
                val = lineList[1].strip()
                infoDict.setdefault(key, val)
            if split_Mark_Equal in line:
                lineList = line.split(split_Mark_Equal)
                key = lineList[0].strip()
                val = lineList[1].strip()
                infoDict.setdefault(key, val)
        return infoDict
    except:
        return {}     
    
def getCliRetDictForMinisystem(cliRet):
    '''
    @summary: 按逐行的方式获取水平格形式的cli回显集合（小系统下回文，字段里无空格场景）
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        resLines = cliRet.splitlines()
        findHeadFalg = False
        headList = []
        resList = []
        headLineIndexList = []
        for line in resLines:
            if findHeadFalg:
                
                if len(line.split()) < len(headLineIndexList):
                    continue
                
                eleList = []
                lenHead = len(headLineIndexList)
                for i in range(lenHead):
                    #如果是最后一列需单独处理
                    if i == lenHead - 1 :
                        eleList.append(line[headLineIndexList[i]:])
                    else:
                        eleList.append(line[headLineIndexList[i]:headLineIndexList[i+1]])
                
                resDict = {}
                for i in range(0, len(eleList)):
                    resDict[headList[i]] = eleList[i].strip()
                
                resList.append(resDict)
            else:    
                match_headline = re.search("Device\s+Type\s+Vendor\s+Product\s+Rev", line)
                
                if match_headline:
                    headList = line.split()
                    findHeadFalg = True
                    
                else:
                    match_headline2 = re.search('ID#\s+ATTRIBUTE_NAME\s+FLAG\s+VALUE', line)
                    if match_headline2:
                        headList = line.split()
                        findHeadFalg = True
                if findHeadFalg:
                    for head in headList:
                        headLineIndexList.append(line.index(head))
        return resList
    except:
        return []

def getHostInfo(cli, lang, hostId):
    
    cmd = "show host general host_id=%s" %hostId
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] != True:
        return (False, cliRet, {})
    
    cliRetLinesList = getVerticalCliRet(checkRet[1])
    for info in cliRetLinesList:
        hostId = info.get("ID")
        opSystem = info.get("Operating System")
        if hostId or opSystem:
            return (True, cliRet ,info)
        
    return (False, cliRet, {})
        
def getHostDict(cli, lang):
    '''
    @summary: 获取主机信息
    @return: hostInfo:{ID:{Name:host1,Operating System:Linux}}
    '''
    hostInfo = {}
    cmd = "show host general"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg, hostInfo)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, hostInfo)
    
    cliRetLinesList = getHorizontalNostandardCliRet(cliRet)
    for info in cliRetLinesList:
        hostId = info.get("ID")
        hostInfo[hostId] = info
        
    return (True, cliRet, "", hostInfo)


def getRemoteDevOfHetero(cli, lang):
    '''
    @summary: 获取远端异构设备ID
    '''
    rmDevIdList = []
    cmd = "show remote_device general array_type=heterogeneity"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if hasCliExecPrivilege(cliRet):
        if flag != True:
            return flag, cliRet, errMsg, []
    else:
        cmd = "show remote_device general array_type=other_manufacturer_device"
        flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
        if flag != True:
            return flag, cliRet, errMsg, []

    rmDevList = getHorizontalCliRet(cliRet)
    for dev in rmDevList:
        if dev.get("Running Status")!= "Link Up":
            continue
        rmDevIdList.append(dev.get("ID"))

    return True, cliRet, "",rmDevIdList

def getHeteroLunByRmDevId(cli, lang, remoteDevId):
    '''
    @summary: 获取远端异构设备上的异构LUN
    '''
    lunList = []
    cmd = "show remote_lun general array_type=heterogeneity remote_device_id=%s"%remoteDevId
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if hasCliExecPrivilege(cliRet):
        if flag != True:
            return flag, cliRet, errMsg, []
    else:
        cmd = "show remote_lun general array_type=other_manufacturer_device remote_device_id=%s" % remoteDevId
        flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
        if flag != True:
            return flag, cliRet, errMsg, []

    infoList = getHorizontalNostandardCliRet(cliRet)
    for info in infoList:
        lunList.append(info.get("Lun WWN"))
    return True, cliRet, "",lunList

def getCtrlByLunWwn(cli, lang, lunWwn):
    '''
    @summary: 获取异构LUN的归属控制器
    @:return:控制器列表：如[0A，0B]
    '''
    ctrls = set()
    cmd = "show remote_lun path remote_lun_wwn=%s"%lunWwn
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return False, cliRet, errMsg, None

    infoList = getHorizontalCliRet(cliRet)
    for info in infoList:
        ctrls.add(info.get("Local Controller"))
    return True, cliRet, errMsg, list(ctrls)

def getDiskNum4Ctrl(cli, lang):
    '''
    @summary: 获取每个控制器下的硬盘数量，控制器不存在硬盘则无对应key
    @:return:{ctrlId:diskNum}
    '''
    ctrlMap = {}
    cmd = "show disk general |filterColumn include columnList=ID,Multipathing"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return False, cliRet, errMsg, None

    infoList = getHorizontalCliRet(cliRet)
    for info in infoList:
        if len(info.get("ID")) < 4:
            continue
        
        ctrls = []
        engid = info.get("ID")[3]
        ctrlInfo = info.get("Multipathing")
        groups = re.findall("([A-Z]+, [A-Z]+[0-9]+.[A-Z]+[0-9]+.[A-Z]+[0-9]+)", ctrlInfo)
        if groups:
            for g in groups:
                gList = g.split(",")
                if len(gList) < 2:
                    continue
                ctrl = engid + gList[0].strip()
                if ctrl in ctrls:
                    continue
                else:
                    ctrls.append(ctrl)
                
                ctrlMap[ctrl] = ctrlMap.get(ctrl, 0) + 1
        else:
            gList = ctrlInfo.split(",")
            for g in gList:
                ctrl = engid + g.strip()
                
                if ctrl in ctrls:
                    continue
                else:
                    ctrls.append(ctrl)
                    
                ctrlMap[ctrl] = ctrlMap.get(ctrl, 0) + 1

    return True, cliRet, errMsg, ctrlMap

def getContrIpList(cli, lang):
    """
    获取引擎对应下的控制器IP
    :param cli:
    :param lang:
    :return ipListDict: 节点IP。
    """

    ipListDict = {}

    cmd = "show upgrade package"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, errMsg, ipListDict)

    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = getHorizontalCliRet(cliRet[beginIndex: endIndex])

    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and ip != "--" and contrName != "":
            ipListDict[contrName] = ip

    # 控制器未配置管理IP，无法连接控制器。
    if len(ipListDict) == 0:
        errMsg = getMsg(lang, "contr.not.config.ip")
        return (False, errMsg, ipListDict)

    return (True, errMsg, ipListDict)


def no_record(cli_ret):
    """
    判断查询类的命令执行后是否有数据
    """
    if re.search(FLAG_CMD_NO_RECORD, cli_ret, re.IGNORECASE):
        return True
    if re.search(FLAG_CMD_SUCCESS, cli_ret, re.IGNORECASE):
        return True

    return False


def check_ret(cli_ret, lang):
    """
    检查命令执行的回文是否失败
    :param cli_ret:
    :param lang:
    :return:
    """
    err_msg = ""

    if len(cli_ret) == 0:
        err_msg = getMsg(lang, "cli.result.is.empty")
        return (RESULT_NOCHECK, cli_ret, err_msg)

    if not hasCliExecPrivilege(cli_ret):
        err_msg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, cli_ret, err_msg)

    if queryResultWithNoRecord(cli_ret):
        return (True, cli_ret, err_msg)

    if isInternalError(cli_ret):
        return (True, cli_ret, err_msg)

    lineList = cli_ret.splitlines()
    for line in lineList:
        checkRet = check_line_in_black_list_mini(line, lang)
        if checkRet[0]:
            return (RESULT_NOCHECK, cli_ret, checkRet[1])
    return True, cli_ret, err_msg


def excute_cmd_in_minisystem_with_check(cli, cmd, lang):
    """
    @summary: 在minisystem模式下执行命令，并检查是否执行成功
    """
    flag, cli_ret, err_msg = cliUtilCbb.excuteCmdInMinisystemModel(cli, cmd,
                                                                   lang)
    if flag is True:
        flag, cli_ret, err_msg = check_ret(cli_ret, lang)
    return flag, cli_ret, err_msg


def check_line_in_black_list_mini(cliLine, lang):
    '''
    @summary: 判断cli语句行是否在黑名单中,兼容minisystem场景
    @param cliLine: cli语句行
    @param lang: 语言lang
    @return:
        True: cli语句行在黑名单中
        False: cli语句行不在黑名单中
    '''
    errMsg = ""

    for dictItems in cliResource.BLACKLIST_DICT_MINISTSTEM:
        if dictItems.get("key_word") in cliLine:
            if isChinese(lang):
                errMsg = dictItems.get("msg_zh")
            else:
                errMsg = dictItems.get("msg_en")
            return (True, errMsg)
    return (False, errMsg)


def get_disk_domain_ctrl_by_domain(cli, lang):
    """
    Dorado V6获取硬盘域的归属控制器
    :param cli:
    :param lang:
    :return:
    """
    cmd = "show disk_domain general" \
          "|filterColumn include columnList=ID,Controller"
    flag, ret, err_msg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, [], ret

    if queryResultWithNoRecord(ret):
        return True, [], ret

    ret_list = getHorizontalCliRet(ret)
    return True, ret_list, ret


def get_disk_domain_ctrl_by_disk(cli, lang):
    """
    Dorado V3获取硬盘域的归属控制器
    :param cli:
    :param lang:
    :return:
    """
    flag, ctrl_list, msg = getControllerIdList(cli, lang)
    if flag is not True:
        return False, [], ctrl_list

    cmd = "show disk general " \
          "|filterColumn include columnList=ID,Disk\sDomain\sID"
    flag, ret, err_msg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, [], ret

    if queryResultWithNoRecord(ret):
        return True, [], ret

    ret_list = getHorizontalCliRet(ret)
    domain_info = []
    for d in ret_list:
        domain_id = d.get("Disk Domain ID")
        if not domain_id.isdigit():
            continue
        disk_id = d.get("ID")
        eng_id = disk_id[3]
        pre_ctrl_list = ["%sA"%eng_id, "%sB"%eng_id,
                         "%sC"%eng_id, "%sD"%eng_id,]
        domain_ctrl = ",".join(list(set(ctrl_list)
                                    .intersection(set(pre_ctrl_list))))
        info = {"ID":domain_id, "Controller": domain_ctrl}
        if info not in domain_info:
            domain_info.append(info)

    return True, domain_info, ret


def has_unknown_error(cli_ret):
    """
    无licence，部分命令（show mirror_lun general；show lun_migration general；show vm_service general）返回错误码，
    校验是否包含错误码。
    :param cli_ret:回显
    :return:如果包含错误码返回True，否则false
    """
    return True if re.findall(r'(1073846111|1073806606|1073891101)', cli_ret.lower()) else False
