# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.

import json
import common
from com.huawei.ism.tool.protocol.rest import RestConnectionManager

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_devices, select_devs, all_dev_nodes):
    nodes_ip_from_rest_dir = {}
    size = int(dpa_devices.size())
    for i in range(size):
        dpa_rest = RestConnectionManager.getRestConnection(dpa_devices.get(i))
        dpa_rest.login()
        # 通过rest接口获取dpa中所有节点ip
        dpa_ip = dpa_devices.get(i).getIp()
        nodes_ip_from_rest_dir[dpa_ip] = get_nodes_ip_list(dpa_rest)

    # 获取用户添加的执行巡检的所有设备的ip(从框架获取)
    inspect_devs_ip_list = get_ips(select_devs)
    # 获取用户添加的所有设备（执行巡检+不巡检的设备）的ip(从框架获取)
    all_append_devs_ip_list = get_ips(all_dev_nodes)
    # # 用户未添加的远程设备
    not_add_nodes_device_list = []
    # 用户已添加远程设备到工具但未选择该设备执行巡检
    not_inspect_nodes_device_list = []
    err_msg_list = []

    for dpa_ip, node_ips in nodes_ip_from_rest_dir.items():
        for node_ip in node_ips:
            if node_ip not in all_append_devs_ip_list:
                not_add_nodes_device_list.append(str(node_ip))
            if (node_ip in all_append_devs_ip_list) and (node_ip not in inspect_devs_ip_list):
                not_inspect_nodes_device_list.append(str(node_ip))
        if not_add_nodes_device_list:
            err_msg_list.append(common.getMsg(LANG, "dpa.node.add.abnormal", (dpa_ip, not_add_nodes_device_list)))
            not_add_nodes_device_list = []
        if not_inspect_nodes_device_list:
            err_msg_list.append(common.getMsg(LANG, "dpa.node.select.abnormal",
                                              (dpa_ip, not_inspect_nodes_device_list)))
            not_inspect_nodes_device_list = []

    if err_msg_list:
        return (False, "\n".join(err_msg_list))
    return (True, "")


def get_dpa_rest_record(dpa_rest, url):
    """
    获取dpa巡检rest返回值
    :param dpa_rest:
    :param url:
    :return:
    """
    url = dpa_rest.getBaseUrl() + url
    LOGGER.logInfo(url)
    response_info = dpa_rest.execGet(url)
    data_string = response_info.getContent()
    LOGGER.logInfo(data_string)
    return json.loads(data_string)


def get_nodes_ip_list(dpa_rest):
    """
    :param dpa_rest: dpa的rest连接
    :return: 节点ip列表
    """
    node_query_uri = "/clusters/nodes"
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    return [node_info.get("nodeIp") for node_info in record.get("responseData", {}).get("data", [{}])]


def get_ips(dev_nodes):
    """
    @summary: 获取设备的ip
    """
    return [common.getIpFromDevNode(devNode) for devNode in dev_nodes]
