﻿# -*- coding: UTF-8 -*-

from resource_msg import RESOURCE_MESSAGES_DICT

MESSAGES_DICT = {
    "potential.fault.risk.abnormal":
        {
            "zh": u"\n当前设备存在潜在故障风险。",
            "en": "\nThe current device has potential fault risks.",
        },
    "dpa.node.add.abnormal":
        {
            "zh": u"\n请添加DPA[%s]的Master主机设备%s。",
            "en": "\nPlease add the DPA [%s] master host %s.",
        },
    "dpa.node.select.abnormal":
        {
            "zh": u"\n请勾选DPA[%s]的Master主机%s。",
            "en": "\nPlease select the DPA [%s] master host %s.",
        },
    "dpa.license.active.status.abnormal":
        {
            "zh": u"\nLicense[%s]激活标志异常(Lincense激活标志：%s)",
            "en": "\nThe activeFlag of License [%s] is abnormal (License activeFlag:%s) ",
        },
    "dpa.license.expired.status.abnormal":
        {
            "zh": u"\nLicense[%s]已过期。",
            "en": "\nLicense [%s] Expired.",
        },
    "dpa.volume.status.abnormal":
        {
            "zh": u"\n卷[%s]已用容量超过总容量的80%%。",
            "en": "\nVolume[%s] used capacity exceeds 80%% of the total capacity.",
        },
    "dpa.get.device.node.abnormal":
        {
            "zh": u"\n获取设备节点异常",
            "en": "\nFailed to get the device node.",
        },
    "dpa.node.status.abnormal":
        {
            "zh": u"\n节点[%s]状态异常(节点状态：%s)。",
            "en": "\nThe status of node [%s] is abnormal (Node Status:%s).",
        },
    "dpa.remote.replication.task.abnormal":
        {
            "zh": u"\n当前设备存在执行中的远程复制任务。",
            "en": "\nThere are running remote replication tasks.",
        },
    "dpa.advanced.running.job.abnormal":
        {
            "zh": u"\n当前存在未执行完成且未执行成功的备份任务",
            "en": "\nThere are unfinished and unsuccessful backup tasks.",
        },
    "dpa.base.running.job.abnormal":
        {
            "zh": u"\n当前存在未执行完成且未执行成功的备份任务",
            "en": "\nThere are unfinished and unsuccessful backup tasks.",
        },
    "dpa.get.backup.job.list.abnormal":
        {
            "zh": u"\n未查询到备份计划",
            "en": "\nNo backup plan is found.",
        },
    "dpa.standard.backup.backup.policy.abnormal":
        {
            "zh": u"\n存在备份策略不为至少有一个完全备份策略和增量备份策略的备份任务，ID:%s，Name:%s",
            "en": "\nThe following task policies fail to pass the check,ID:%s，Name:%s",
        },
    "dpa.standard.backup.retention.policy.abnormal":
        {
            "zh": u"\n存在未设置数据保留策略的备份任务，ID:%s，Name:%s",
            "en": "\nA backup task whose data retention policy is not set exists. The ID is %s and the Name is %s.",
        },
    "dpa.backup.volume.status.abnormal":
        {
            "zh": u"\n卷（名称：%s）状态异常",
            "en": "\nThe volume (Name: %s) is abnormal.",
        },
    "dpa.backup.volume.size.abnormal":
        {
            "zh": u"\n以下备份池卷容量检查不通过:(%s,%s)",
            "en": "\nThe following task policies fail to pass the check:(%s,%s).",
        },
    "dpa.check.cdm.alarms.abnormal":
        {
            "zh": u"\n当前设备存在\"%s\"告警",
            "en": "\nThe device has alarm.(%s)",
        },
    "dpa.self.backup.status.abnormal":
        {
            "zh": u"\n最近一天内不存在成功的自备份任务",
            "en": "\nNo successful self-backup task exists in the last day.",
        },
    "dpa.self.backup.runtime.abnormal":
        {
            "zh": u"\n最近一天内自备份任务执行时间超过15分钟",
            "en": "\nThe execution time of the self-backup task in the last day exceeds 15 minutes.",
        },
    "cannot.get.info":
        {
            "zh": u"\n无法获取%s信息。",
            "en": "\nCannot get information about %s.",
        },
    "check.pass":
        {
            "zh": u"\n系统检查通过",
            "en": "\nSystem check pass",
        },
    "sign.exception.info":
        {
            "zh": u"\n业务包文件损坏。",
            "en": "\nThe service package is damaged.",
        },
    "query.result.abnormal":
        {
            "zh": u"\n获取信息失败",
            "en": "\nThere is an error in getting information",
        },
    "query.result.abnormal.out_svp":
        {
            "zh": u'\n获取信息失败，若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的'
                  u'FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。',
            "en": "\nThere is an error in getting information. If the device model is any of 18000 series, install "
                  "SmartKit of the latest version on the SVP where the device is installed or install SmartKit of the "
                  "latest version and add the current device again by referring to the FAQ \"Configuring the "
                  "Access of Tools Outside the SVP of the High-End Storage System\", and select the current check item "
                  "for an inspection again."
        },
    "cannot.get.system.info":
        {
            "zh": u"\n无法获取系统信息",
            "en": "\nCannot get information about system",
        },
    "cannot.get.domain.info":
        {
            "zh": u"\n无法获取硬盘域信息",
            "en": "\nCannot get information about disk domain",
        },
    "cannot.get.domain.task.info":
        {
            "zh": u"\n无法获取硬盘域（ID:%s）的后台任务信息",
            "en": "\nCannot get background tasks information about disk domain(ID:%s)",
        },
    "cannot.get.domain.ctrl.task.info":
        {
            "zh": u"\n无法获取控制器%s上的硬盘域（ID:%s）后台任务信息",
            "en": "\nOn the controller %s, cannot get background tasks information about disk domain(ID:%s) ",
        },
    "cannot.get.domain.ctrl.task.abnormal":
        {
            "zh": u"\n控制器%s上的硬盘域（ID:%s）后台任务异常",
            "en": "\nOn the controller %s, background tasks information about disk domain(ID:%s) are abnormal",
        },
    "cannot.get.product.version.info":
        {
            "zh": u"\n无法获取产品版本信息",
            "en": "\nCannot get information about product version",
        },
    "cannot.get.hot.patch.version.info":
        {
            "zh": u"\n无法获取热补丁版本信息",
            "en": "\nCannot get information about hot patch version",
        },
    "cannot.get.controller.info":
        {
            "zh": u"\n无法获取控制器信息",
            "en": "\nCannot get information about controller",
        },
    "cannot.get.contrller.version.info":
        {
            "zh": u"\n控制器[%s]:无法获取控制器软件版本",
            "en": "\nController[%s]: Failed to obtain the controller software version.",
        },
    "controller.version.not.consistence":
        {
            "zh": u"\n控制器软件版本不一致，请修复后再进行巡检检查。",
            "en": "\nController software versions are inconsistent, "
                  "rectify the fault before performing the inspection.",
        },
    "controller.hot.patch.version.not.consistence":
        {
            "zh": u"\n控制器热补丁版本不一致，请修复后再进行巡检检查。",
            "en": "\nController hot patch versions are inconsistent, "
                  "rectify the fault before performing the inspection.",
        },
    "cannot.get.enclosure.info":
        {
            "zh": u"\n无法获取机框信息",
            "en": "\nCannot get information about enclosure",
        },
    "ses.version.cannot.get.enclosure.info":
        {
            "zh": u"\n无法获取机框信息.\n修复建议：后台正在同步SES版本，请稍后重试。",
            "en": "\nCannot get information about enclosure.\nRecovery Suggestion: The background is "
                  "synchronizing the SES version. Please try again later.",
        },
    "ses.version.cannot.get.version.of.controller":
        {
            "zh": u"\n无法获取控制器版本信息.\n修复建议：后台正在同步SES版本，请稍后重试。",
            "en": "\nCannot get information about version of controllers.\n"
                  "Recovery Suggestion: The background is "
                  "synchronizing the SES version. Please try again later.",
        },
    "ses.version.cannot.get.ses.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的SES版本信息。\n修复建议：后台正在同步SES版本，请稍后重试。",
            "en": "\nCannot get information about SES version of controller [%s]."
                  "\nRecovery Suggestion: The background is synchronizing the SES version. "
                  "Please try again later.",
        },
    "ses.version.cannot.get.ses.version.of.expansion.module":
        {
            "zh": u"\n无法获取级联模块[%s]的SES版本信息。\n修复建议：后台正在同步SES版本，请稍后重试。",
            "en": "\nCannot get information about SES version of expansion module [%s]"
                  "\nRecovery Suggestion: The background is synchronizing the SES version. "
                  "Please try again later.",
        },
    "port.exists.error.bits":
        {
            "zh": u"\n%s端口存在持续增加的误码。请清掉误码统计，等10分钟后再次巡检，如果还存在误码，按照修复建议修复。",
            "en": "\nThe %s port has continuous bit errors. Clear the bit error statistics and"
                  " perform the inspection again 10 minutes later. If bit errors still exist, "
                  "rectify the fault according to the suggestions.",
        },
    "cannot.get.bbu.info":
        {
            "zh": u"\n无法获取BBU信息",
            "en": "\nCannot get information about BBU",
        },

    "cannot.get.bbu.config":
        {
            "zh": u"\n无法获取BBU规格",
            "en": "\nCannot get information about BBU specification",
        },

    "cannot.get.remaining.lifetime.info":
        {
            "zh": u"\n无法获取BBU的生命剩余时间信息",
            "en": "\nCannot get information about lifespan of BBU",
        },

    "cannot.get.bbu.remaining.lifetime":
        {
            "zh": u"\n无法获取BBU[%s]的生命剩余时间信息",
            "en": "\nCannot get information about lifespan of BBU [%s]",
        },

    "cannot.get.fan.info":
        {
            "zh": u"\n无法获取风扇信息",
            "en": "\nCannot get information about fan",
        },

    "cannot.get.fan.config":
        {
            "zh": u"\n无法获取风扇规格",
            "en": "\nCannot get information about fan specification",
        },

    "cannot.get.power.supply.info":
        {
            "zh": u"\n无法获取电源信息",
            "en": "\nCannot get information about power supply",
        },

    "cannot.get.fibre.module.info":
        {
            "zh": u"\n无法获取光模块信息",
            "en": "\nCannot get information about optical module",
        },

    "cannot.get.pcie.switch.info":
        {
            "zh": u"\n无法获取PCIe交换机信息",
            "en": "\nCannot get information about PCIe switch",
        },

    "cannot.get.interface.module.info":
        {
            "zh": u"\n无法获取接口卡信息",
            "en": "\nCannot get information about interface module",
        },

    "cannot.get.port.info":
        {
            "zh": u"\n无法获取%s端口信息",
            "en": "\nCannot get information about %s port",
        },

    "cannot.get.port.working.rate":
        {
            "zh": u"\n无法获取%s端口[%s]速率",
            "en": "\nCannot get working rate of %s port [%s]",
        },

    "cannot.get.management.port.info":
        {
            "zh": u"\n无法获取管理网口信息",
            "en": "\nCannot get information about management port",
        },

    "ib.port.health.status.abnormal":
        {
            "zh": u"\nIB 端口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of ib port [%s] is abnormal (Health Status:%s)",
        },
    "rdma.port.health.status.abnormal":
        {
            "zh": u"\nRDMA 端口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of RDMA port [%s] is "
                  "abnormal (Health Status:%s)",
        },
    "ib.port.bit.error.health.status.abnormal":
        {
            "zh": u"\nIB 端口[%s]健康状态异常(误码:%s, 值：%s)",
            "en": "\nThe health status of ib port [%s] is abnormal (Ib Port Bit Error:%s, Value:%s)",
        },

    "cannot.get.routing.test.status.info":
        {
            "zh": u"\n无法获取硬盘例测状态信息",
            "en": "\nCannot get information about disk routine test status",
        },

    "cannot.get.disk.precopy.info":
        {
            "zh": u"\n无法获取硬盘预拷贝开关信息",
            "en": "\nCannot get information about disk pre-copy switch",
        },

    "cannot.get.bst.config.info":
        {
            "zh": u"\n无法获取BST开关信息",
            "en": "\nCannot get information about BST switch",
        },

    "cannot.get.disk.health.info":
        {
            "zh": u"\n无法获取硬盘健康度信息",
            "en": "\nCannot get information about disk health",
        },

    "cannot.get.disk.info":
        {
            "zh": u"\n无法获取硬盘状态信息",
            "en": "\nCannot get information about disk status",
        },

    "cannot.get.diskinfo":
        {
            "zh": u"\n无法获取硬盘信息",
            "en": "\nCannot get information about disk",
        },

    "cannot.get.front.end.io.info":
        {
            "zh": u"\n无法获取控制器[%s]的前端并发数信息",
            "en": "\nCannot get information about front-end concurrencies of controller [%s]",
        },

    "cannot.get.back.end.io.info":
        {
            "zh": u"\n无法获取控制器[%s]后端并发数信息",
            "en": "\nCannot get information about back-end concurrencies of controller [%s]",
        },

    "cannot.get.cpu.usage.info":
        {
            "zh": u"\n无法获取CPU占用率信息",
            "en": "\nCannot get information about CPU usage",
        },

    "cannot.get.dirty.data.rate.info":
        {
            "zh": u"\n无法获取控制器[%s]的脏页面占用率信息",
            "en": "\nCannot get information about dirty data rate of controller [%s]",
        },

    "cannot.get.used.hot.spare.capacity.info":
        {
            "zh": u"\n无法获取POOL[%s]的hotspare容量信息",
            "en": "\nCannot get information about hotspare capacity of POOL [%s]",
        },

    "cannot.get.device.sn.info":
        {
            "zh": u"\n无法获取设备序列号信息",
            "en": "\nCannot get information about serial number of device",
        },

    "cannot.get.multipathing.info":
        {
            "zh": u"\n无法获取硬盘链路状态信息",
            "en": "\nCannot get information about hard disk path",
        },

    "cannot.get.link.info":
        {
            "zh": u"\n无法获取%s链路信息",
            "en": "\nCannot get information about %s link",
        },

    "cannot.get.version.of.controller":
        {
            "zh": u"\n无法获取控制器版本信息",
            "en": "\nCannot get information about version of controllers",
        },

    "cannot.get.software.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的软件版本信息",
            "en": "\nCannot get information about software version of controller [%s]",
        },

    "cannot.get.bmc.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的BMC版本信息",
            "en": "\nCannot get information about BMC version of controller [%s]",
        },

    "cannot.get.ses.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的SES版本信息",
            "en": "\nCannot get information about SES version of controller [%s]",
        },

    "cannot.get.bios.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的BIOS版本信息",
            "en": "\nCannot get information about BIOS version of controller [%s]",
        },

    "cannot.get.logic.version.of.controller":
        {
            "zh": u"\n无法获取控制器[%s]的Logic版本信息",
            "en": "\nCannot get information about logic version of controller [%s]",
        },

    "cannot.get.ses.version.of.expansion.module":
        {
            "zh": u"\n无法获取级联模块[%s]的SES版本信息",
            "en": "\nCannot get information about SES version of expansion module [%s]",
        },

    "cannot.get.logic.version.of.expansion.module":
        {
            "zh": u"\n无法获取级联模块[%s]的Logic版本信息",
            "en": "\nCannot get information about logic version of expansion module [%s]",
        },

    "cannot.get.firmware.version.info":
        {
            "zh": u"\n无法获取BBU的Firmware版本信息",
            "en": "\nCannot get information about firmware version of BBU",
        },

    "cannot.get.firmware.version.of.bbu":
        {
            "zh": u"\n无法获取BBU[%s]的Firmware版本信息",
            "en": "\nCannot get information about firmware version of BBU [%s]",
        },

    "cannot.get.disk.domain.info":
        {
            "zh": u"\n无法获取硬盘域信息",
            "en": "\nCannot get information about disk domain",
        },

    "cannot.get.filesystem.info":
        {
            "zh": u"\n无法获取文件系统信息",
            "en": "\nCannot get information about File System",
        },

    "cannot.get.pool.info":
        {
            "zh": u"\n无法获取POOL信息",
            "en": "\nCannot get information about POOL",
        },

    "cannot.get.tier.info":
        {
            "zh": u"\n无法获取Tier信息",
            "en": "\nCannot get information about tier",
        },
    "cannot.get.pool.tier.info":
        {
            "zh": u"\n无法获取Pool[ID:%s]的Tier信息",
            "en": "\nFailed to obtain tier information about Pool[ID:%s]",
        },
    "cannot.get.lun.info":
        {
            "zh": u"\n无法获取LUN信息",
            "en": "\nCannot get information about LUN",
        },
    "failed.get.external.lun.id":
        {
            "zh": u"\n获取异构LUN的ID失败。",
            "en": "\nFailed to get ID about external LUN.",
        },
    "cannot.get.lun.copy.info":
        {
            "zh": u"\n无法获取LUN拷贝信息",
            "en": "\nCannot get information about LUN copy",
        },

    "cannot.get.lun.migration.info":
        {
            "zh": u"\n无法获取LUN迁移信息",
            "en": "\nCannot get information about LUN migration",
        },

    "cannot.get.lun.write.policy.info":
        {
            "zh": u"\n无法获取LUN写策略信息",
            "en": "\nCannot get information about LUN write policy",
        },

    "cannot.get.lun.ownership.info":
        {
            "zh": u"\n无法获取LUN归属信息",
            "en": "\nCannto get information about LUN ownership",
        },

    "cannot.get.relocatioin.status":
        {
            "zh": u"\n无法获取Extent迁移状态信息",
            "en": "\nCannot get information about extent migration status",
        },

    "cannot.get.license.service.auth.info":
        {
            "zh": u"\n无法获取license信息",
            "en": "\nCannot get information about license",
        },

    "inner.hypermetro.license.exists":
        {
            "zh": u"\n当前设备存在内双活license",
            "en": "\nThe HyperMetro-Inner license exists in the current device",
        },
    "inner.hypermetro.license.not.exist":
        {
            "zh": u"\n当前设备不存在内双活license",
            "en": "\nThe HyperMetro-Inner license does not exist in the current device",
        },
    "inner.hypermetro.license.expansion.ctrl.num.limit":
        {
            "zh": u"\n当前设备存在内双活license,最大扩控数量为8",
            "en": "\nThe HyperMetro-Inner license exists in the current device,"
                  "Maximum number of controllers to be expanded is 8",
        },
    "cannot.get.smartcache.info":
        {
            "zh": u"\n无法获取Smart Cache信息",
            "en": "\nCannot get information about Smart Cache",
        },
    "cannot.get.snapshot.info":
        {
            "zh": u"\n无法获取快照信息",
            "en": "\nCannot get information about snapshot",
        },

    "cannot.get.clone.info":
        {
            "zh": u"\n无法获取克隆信息",
            "en": "\nCannot get information about clone",
        },

    "cannot.get.remote.replication.info":
        {
            "zh": u"\n无法获取远程复制信息",
            "en": "\nCannot get information about remote replication",
        },

    "cannot.get.consistency.group.info":
        {
            "zh": u"\n无法获取一致性组信息",
            "en": "\nCannot get information about consistency group",
        },

    "cannot.get.remote.lun.info":
        {
            "zh": u"\n无法获取远端LUN信息",
            "en": "\nCannot get information about remote LUN",
        },

    "cannot.get.mirror.lun.info":
        {
            "zh": u"\n无法获取镜像LUN信息",
            "en": "\nCannot get information about mirror LUN",
        },

    "cannot.get.alarm.info":
        {
            "zh": u"\n无法获取告警信息",
            "en": "\nCannot get information about alarm",
        },

    "system.health.status.abnormal":
        {
            "zh": u"\n系统健康状态异常(健康状态：%s)",
            "en": "\nThe health status of system is abnormal (Health Status:%s)",
        },

    "system.running.status.abnormal":
        {
            "zh": u"\n系统运行状态异常(运行状态：%s)",
            "en": "\nThe running status of system is abnormal (Running Status:%s)",
        },

    "controller.health.status.abnormal":
        {
            "zh": u"\n控制器[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of controller [%s] is abnormal (Health Status:%s)",
        },

    "controller.running.status.abnormal":
        {
            "zh": u"\n控制器[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of controller [%s] is abnormal (Running Status:%s)",
        },

    "enclosure.health.status.abnormal":
        {
            "zh": u"\n框[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of enclosure [%s] is abnormal (Health Status:%s)",
        },

    "enclosure.running.status.abnormal":
        {
            "zh": u"\n框[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of enclosure [%s] is abnormal (Running Status:%s)",
        },

    "computer.storage.power.supply.health.status.abnormal":
        {
            "zh": u"\n控制框电源健康状态异常",
            "en": "\nThe health status of control enclosure power supply is abnormal ",
        },

    "power.supply.status.abnormal":
        {
            "zh": u"\n硬盘框电源[%s]状态异常(健康状态：%s，运行状态：%s)",
            "en": "\nThe power supply [%s] of the disk enclosure is abnormal (health status: %s, running status: %s).",
        },

    "power.supply.health.status.abnormal":
        {
            "zh": u"\n电源[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of power supply [%s] is abnormal (Health Status:%s)",
        },

    "power.supply.running.status.abnormal":
        {
            "zh": u"\n电源[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of power supply [%s] is abnormal (Running Status:%s)",
        },

    "bbu.health.status.abnormal":
        {
            "zh": u"\nBBU[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of BBU [%s] is abnormal (Health Status:%s)",
        },

    "bbu.running.status.abnormal":
        {
            "zh": u"\nBBU[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of BBU [%s] is abnormal (Running Status:%s)",
        },

    "bbu.health.status.lowbattery":
        {
            "zh": u"\nBBU[%s]电量低",
            "en": "\nBBU[%s]Low Battery",
        },

    "fan.health.status.abnormal":
        {
            "zh": u"\n风扇[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of fan [%s] is abnormal (Health Status:%s)",
        },

    "power.health.status.abnormal":
        {
            "zh": u"\n电源[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of power [%s] is abnormal (Health Status:%s)",
        },

    "auxiliary.fan.health.status.abnormal":
        {
            "zh": u"\n辅助散热风扇[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of auxiliary fan [%s] is abnormal (Health Status:%s)",
        },

    "filesystem.health.status.abnormal":
        {
            "zh": u"\n文件系统[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of File System [%s] is abnormal (Health Status:%s)",
        },

    "filesystem.clone.split.status.abnormal":
        {
            "zh": u"\n文件系统[ID：%s]分裂状态异常(分裂状态：%s)",
            "en": "\nThe clone split status of file system [ID: %s] is abnormal (Clone Split Status: %s)",
        },

    "fan.running.status.abnormal":
        {
            "zh": u"\n风扇[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of fan [%s] is abnormal (Running Status:%s)",
        },

    "auxiliary.fan.running.status.abnormal":
        {
            "zh": u"\n辅助散热风扇[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of auxiliary fan [%s] is abnormal (Running Status:%s)",
        },

    "disk.health.mark.abnormal":
        {
            "zh": u"\n硬盘[%s]健康状态异常(Health Mark：%s)",
            "en": "\nThe health mark of disk [%s] is abnormal (Health Mark:%s)",
        },

    "disk.status.abnormal":
        {
            "zh": u"\n硬盘[%s]状态异常",
            "en": "\nThe status of disk [%s] is abnormal",
        },

    "dataswitch.health.status.abnormal":
        {
            "zh": u"\n交换机[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of data switch [%s] is abnormal (Health Status:%s)",
        },

    "dataswitch.running.status.abnormal":
        {
            "zh": u"\n交换机[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of data switch [%s] is abnormal (Running Status:%s)",
        },

    "interface.module.health.status.abnormal":
        {
            "zh": u"\n接口卡[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of interface module [%s] is abnormal (Health Status:%s)",
        },

    "interface.module.running.status.abnormal":
        {
            "zh": u"\n接口卡[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of interface module [%s] is abnormal (Running Status:%s)",
        },

    "port.fibre.module.health.status.abnormal":
        {
            "zh": u"\n端口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of port [%s] is abnormal (Health Status:%s)",
        },

    "port.health.status.abnormal":
        {
            "zh": u"\n%s端口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of %s port [%s] is abnormal (Health Status:%s)",
        },

    "pcie.port.running.status.abnormal":
        {
            "zh": u"\n交换机DSW0和DSW1 Link up的端口数量不一致异常",
            "en": "\nThe number of ports on DSW0 and DSW1 in Link Up state is inconsistent.",
        },

    "sas.port.running.status.abnormal":
        {
            "zh": u"\nSAS端口[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of SAS port [%s] is abnormal (Running Status:%s)",
        },

    "management.port.health.status.abnormal":
        {
            "zh": u"\n管理网口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of management port [%s] is abnormal (Health Status:%s)",
        },

    "disk.domain.health.status.abnormal":
        {
            "zh": u"\n硬盘域[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of disk domain [%s] is abnormal (Health Status:%s)",
        },

    "disk.domain.running.status.abnormal":
        {
            "zh": u"\n硬盘域[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of disk domain [%s] is abnormal (Running Status:%s)",
        },

    "pool.health.status.abnormal":
        {
            "zh": u"\nPOOL[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of POOL [%s] is abnormal (Health Status:%s)",
        },

    "pool.running.status.abnormal":
        {
            "zh": u"\nPOOL[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of POOL [%s] is abnormal (Running Status:%s)",
        },

    "pool.relocation.status.abnormal":
        {
            "zh": u"\nPOOL[%s]迁移状态异常(迁移状态：%s)",
            "en": "\nThe relocation status of POOL [%s] is abnormal (Relocation Status:%s)",
        },

    "lun.status.abnormal":
        {
            "zh": u"\nLUN[%s]状态异常",
            "en": "\nThe status of LUN [%s] is abnormal",
        },
    "namespace.status.abnormal":
        {
            "zh": u"\nNamespace[%s]状态异常",
            "en": "\nThe status of Namespace [%s] is abnormal",
        },

    "lun.copy.health.status.abnormal":
        {
            "zh": u"\nLUN拷贝[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of LUN copy [%s] is abnormal (Health Status:%s)",
        },

    "snapshot.health.status.abnormal":
        {
            "zh": u"\n快照[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of snapshot [%s] is abnormal (Health Status:%s)",
        },

    "lun.migration.running.status.abnormal":
        {
            "zh": u"\nLUN迁移[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of LUN migration [%s] is abnormal (Running Status:%s)",
        },

    "clone.health.status.abnormal":
        {
            "zh": u"\n克隆[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of clone [%s] is abnormal (Health Status:%s)",
        },

    "remote.replication.health.status.abnormal":
        {
            "zh": u"\n远程复制[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of remote replication [%s] is abnormal (Health Status:%s)",
        },

    "consistency.group.health.status.abnormal":
        {
            "zh": u"\n一致性组[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of consistency group [%s] is abnormal (Health Status:%s)",
        },

    "mirror.lun.health.status.abnormal":
        {
            "zh": u"\n镜像LUN[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of mirror LUN [%s] is abnormal (Health Status:%s)",
        },

    "port.working.rate.abnormal":
        {
            "zh": u"\n%s端口[%s]工作速率异常(速率：%sMbps)",
            "en": "\nThe working rate of %s port [%s] is abnormal (Working Rate:%sMbps)",
        },

    "management.port.working.rate.abnormal":
        {
            "zh": u"\n管理网口[%s]工作速率异常(速率：%sMbps)",
            "en": "\nThe working rate of management port [%s] is abnormal (Working Rate:%sMbps)",
        },

    "software.version.of.controller.inconsistent":
        {
            "zh": u"\n控制器软件版本不一致(%s)",
            "en": "\nThe software versions of all controllers are inconsistent (%s)",
        },

    "version.of.controller.inconsistent":
        {
            "zh": u"\n控制器%s版本不一致(%s)",
            "en": "\nThe %s versions of all controllers are inconsistent (%s)",
        },

    "version.of.expansion.module.on.disk.inconsistent":
        {
            "zh": u"\n硬盘框（SAS）级联模块%s版本不一致(%s)",
            "en": "\nThe %s versions of all expansion modules in disk enclosures (SAS) are inconsistent (%s)",
        },
    "version.of.nvme.expansion.module.on.disk.inconsistent":
        {
            "zh": u"\n硬盘框（NVMe）级联模块%s版本不一致(%s)",
            "en": "\nThe %s versions of all expansion modules in disk enclosures (NVMe) are inconsistent (%s)",
        },

    "version.of.expansion.module.on.high-density.inconsistent":
        {
            "zh": u"\n高密框[类型：%s]级联模块%s版本不一致(%s)",
            "en": "\nThe %s versions of all expansion modules in "
                  "high-density disk enclosures (type: %s) "
                  "are inconsistent (%s)",
        },

    "firmware.version.of.bbu.inconsistent":
        {
            "zh": u"\nBBU的Firmware版本不一致(%s)",
            "en": "\nThe firmware versions of all BBUs are inconsistent (%s)",
        },

    "firmware.version.of.bbu.inconsistent.upgrading":
        {
            "zh": u"\nBBU正在后台升级中，请等待二十分钟后再进行巡检。",
            "en": "\nThe BBU is being upgraded in "
                  "the background. Wait for 20 minutes "
                  "before performing the check.",
        },
    "firmware.version.of.manager.upgrading":
        {
            "zh": u"\n管理板正在后台升级中，请等待二十分钟后再进行巡检。",
            "en": "\nThe management is being upgraded in "
                  "the background. Wait for 20 minutes "
                  "before performing the check.",
        },
    "engine.may.be.offline":
        {
            "zh": u"\n引擎[%s]存在无法监控的控制器",
            "en": "\nEngine [%s] has controllers that cannot be monitored.",
        },

    "fan.number.not.enough":
        {
            "zh": u"\n框[%s]存在风扇个数不足(满配个数：%s，实际个数：%s)",
            "en": "\nThe number of fans in the enclosure [%s] is insufficient (Required Number:%s, Current Number:%s)",
        },

    "bbu.number.not.enough":
        {
            "zh": u"\n引擎[%s]存在BBU个数不足(满配个数：%s，实际个数：%s)",
            "en": "\nThe number of BBUs in the engine [%s] is insufficient (Required Number:%s, Current Number:%s)",
        },

    "bbu.remaining.lifetime.abnormal":
        {
            "zh": u"\nBBU[%s]的生命剩余时间小于%s天(生命剩余时间：%s天)",
            "en": "\nThe remaining lifetime of BBU [%s] is less than [%s] days (Remaining Lifetime:%sdays)",
        },

    "pcie.switch.number.not.enough":
        {
            "zh": u"\nPCIe交换机个数不足",
            "en": "\nThe number of PCIe switches is insufficient",
        },

    "disk.path.single":
        {
            "zh": u"\n硬盘[%s]单链路",
            "en": "\nThe path of disk [%s] is single",
        },

    "sas.port.link.none.symmetrical":
        {
            "zh": u"\nSAS端口[%s]连接异常，与端口[%s]连接不对称",
            "en": "\nThe SAS port [%s] is improperly connected and is not symmetrical with port [%s]",
        },

    "raid.level.improperly.config":
        {
            "zh": u"\nRAID级别配置不正确(POOL ID：%s, Name：%s, RAID级别：%s)",
            "en": "\nThe RAID level is improperly configured (POOL ID:%s, Name:%s, RAID Level:%s)",
        },
    "raid.level.waring.suggestion":
        {
            "zh": u"\n1从可靠性和性价比等因素综合考虑，高性能层（SSD盘）建议配置RAID10，性能层（SAS盘）建议配置RAID5，"
                  u"容量层（NearLine SAS盘）建议配置RAID6；\n2如果有任何疑问，请联系技术支持工程师协助处理",
            "en": "\n1.From the perspective of reliability and cost-effectiveness, "
                  "it is recommended that RAID 10 be used for the high-performance layer (SSDs), "
                  "RAID 5 for the performance layer (SAS disks), and RAID 6 for the storage layer (NL-SAS disks)."
                  "\n2.If you have any questions, contact technical support engineers.",
        },

    "engine.zero.circle.not.connected":
        {
            "zh": u"\n引擎环路0未连接",
            "en": "\nLoop 0 of the engine is not connected",
        },

    "engine.zero.circle.connect.abnormal":
        {
            "zh": u"\n引擎环路0必须连接，SAS端口[%s]未连接",
            "en": "\nLoop 0 of the engine must be connected. The SAS port [%s] is disconnected",
        },
    "controller.cpu.usage.abnormal":
        {
            "zh": u"\n控制器[%s]CPU占用率超过%s(CPU占用率：%s)",
            "en": "\nThe CPU usage of controller [%s] exceeds %s (CPU usage:%s)",
        },

    "controller.cpu.usage.level2.abnormal":
        {
            "zh": u"\n控制器[%s]CPU占用率超过%s且小于等于%s(CPU占用率：%s)。"
                  u"\n修复建议：阵列业务压力较大，建议降低业务压力。",
            "en": "\nThe CPU usage of controller [%s] exceeds %s"
                  " and is less than or equal to %s (CPU usage:%s).\nRecovery "
                  "Suggestion:Service pressure on the storage array is relatively high. "
                  "You are advised to reduce the service pressure.",
        },

    "pool.used.hot.spare.capacity.abnormal":
        {
            "zh": u"\n硬盘域[ID:%s]的已使用Hotspare容量大于0(容量:%s)",
            "en": "\nThe used hot spare capacity of disk domain [ID:%s] is more than 0 (Capacity:%s)",
        },

    "disk.precopy.status.abnormal":
        {
            "zh": u"\n硬盘预拷贝开关异常(预拷贝开关：%s)",
            "en": "\nThe pre-copy enabled switch of disk is abnormal (Precopy Enabled:%s)",
        },

    "disk.bst.status.abnormal":
        {
            "zh": u"\n硬盘BST开关状态异常(BST开关：%s)",
            "en": "\nThe BST enabled status of disk is abnormal (Enabled:%s)",
        },

    "disk.routine.test.switch.abnormal":
        {
            "zh": u"\n硬盘例测开关异常(例测开关：%s)",
            "en": "\nThe routine test switch of disk is abnormal (Enable Routine Test:%s)",
        },

    "disk.routine.test.period.abnormal":
        {
            "zh": u"\n硬盘例测周期异常(例测周期：%sMinute)",
            "en": "\nThe routine test period of disk is abnormal (Routine Test Period:%sMinute)",
        },
    "device.sn.incorrect":
        {
            "zh": u"\n设备序列号不正确",
            "en": "\nThe serial number information of device is incorrect",
        },

    "system.exists.temporary.license":
        {
            "zh": u"\n存在临时license",
            "en": "\nA temporary license exists",
        },
    "lun.controller.owner.invalid":
        {
            "zh": u"\nLUN[%s]的工作控制器或归属控制器不合法",
            "en": "\nThe work controller or owner controller of LUN [%s] is invalid",
        },
    "lun.write.policy.inconsistent":
        {
            "zh": u"\nLUN[%s]的写策略与当前缓存写策略不一致",
            "en": "\nThe write policy of LUN [%s] is not consistent with running write policy",
        },

    "smartcache.partion.abnormal":
        {
            "zh": u"\n默认分区个数与引擎个数不相同(默认分区个数：%s，引擎个数：%s)",
            "en": "\nThe number of default partition is not identical with the number of engines "
                  "(Number of default partition:%s, Number of engines:%s)",
        },

    "remote.lun.status.abnormal":
        {
            "zh": u"\n远端LUN状态异常",
            "en": "\nThe status of remote LUN is abnormal",
        },

    "remote.lun.path.status.abnormal":
        {
            "zh": u"\n远端LUN路径状态异常",
            "en": "\nThe path status of remote LUN is abnormal",
        },
    "remote.lun.path.status.abnormal.not.pass":
        {
            "zh": u"\n存在状态为[%s]的远端LUN路径。",
            "en": "\nOne or more paths are in [%s] state in remote LUNs."
        },
    "remote.lun.path.status.timeout":
        {
            "zh": u"\n命令执行超时，请排查环境问题后再次执行，如果继续超时请联系技术工程师。",
            "en": "\nThe command execution times out. Check the "
                  "environment and run the command again. If the command "
                  "execution times out again, contact technical support."
        },

    "remote.lun.status.single":
        {
            "zh": u"\n远端LUN链路状态为单链路",
            "en": "\nThe link status of remote LUN is single",
        },

    "host.multipathing.status.abnormal":
        {
            "zh": u"\n主机多路径状态异常(告警ID:%s)",
            "en": "\nThe host multipathing status is abnormal (alarm id:%s)",
        },

    "system.exists.critical.alarm":
        {
            "zh": u"\n系统存在紧急告警",
            "en": "\nSystem exists critical alarm",
        },

    "system.exists.major.alarm":
        {
            "zh": u"\n系统存在重要告警",
            "en": "\nSystem exists major alarm",
        },

    "system.exists.warning.alarm":
        {
            "zh": u"\n系统存在警告告警",
            "en": "\nSystem exists warning alarm",
        },

    "cannot.get.vm.file.system.info":
        {
            "zh": u"\n无法获取虚拟机文件系统",
            "en": "\nCannot get information about VM file system",
        },

    "port.vm.file.system.current.status.abnormal":
        {
            "zh": u"\n虚拟机文件系统[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of VM file system [%s] is abnormal (Health Status:%s)",
        },

    "cannot.get.block.device.info":
        {
            "zh": u"\n没有查询到虚拟机块设备",
            "en": "\nNo VM block device has been queried",
        },

    "port.block.device.health.status.abnormal":
        {
            "zh": u"\n虚拟机块设备[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of VM block device [%s] is abnormal (Health Status:%s)",
        },

    "cannot.get.vm.info":
        {
            "zh": u"\n没有查询到虚拟机",
            "en": "\nNo VM has been queried",
        },

    "port.vm.health.status.abnormal":
        {
            "zh": u"\n虚拟机[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of VM [%s] is abnormal (Health Status:%s)",
        },

    "cannot.get.configured.vm.info":
        {
            "zh": u"\n没有查询到被配置的虚拟机端口",
            "en": "\nNo configured VM port has been queried",
        },

    "port.configured.vm.health.status.abnormal":
        {
            "zh": u"\n虚拟机端口[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of configured VM port [%s] is abnormal (Health Status:%s)",
        },

    "port.system.disk.bus.mode.abnormal":
        {
            "zh": u"\n虚拟机的System Disk Bus Mode不为VIRTIO(虚拟机名：%s，System Disk Bus Mode：%s)",
            "en": "\nThe system disk bus mode of VM is not VIRTIO (VM name:%s, System Disk Bus Mode:%s)",
        },

    "port.vmtool.version.abnormal":
        {
            "zh": u"\n虚拟机的VMtools Version不是有效值(虚拟机名：%s，VMtools Version：%s)",
            "en": "\nThe VMtools Version of VM is not valid (VM name:%s, VMtools Version:%s)",
        },
    "cannot.get.hypervault.info":
        {
            "zh": u"\n无法获取一体化备份信息",
            "en": "\nCannot get information about HyperVault.",
        },
    "hypervault.health.status.abnormal":
        {
            "zh": u"\n一体化备份[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of HyperVault [%s] is abnormal (Health Status:%s)",
        },
    "res.hypervault.health.status":
        {
            "zh": u"\n如果一体化备份的健康状态不为Normal:",
            "en": "\nIf the health status of the HyperVault is not Normal:",
        },
    "cannot.get.quorum.server.link.info":
        {
            "zh": u"\n无法获取双活仲裁链路状态信息",
            "en": "\nFailed to obtain the status of active-active quorum links.",
        },
    "quorum.server.link.status.abnormal":
        {
            "zh": u"\n双活仲裁服务器链路[Link ID:%s]状态异常"
                  u"(链路状态：%s)",
            "en": "\nThe status of the links to active-active quorum "
                  "server [Link ID:%s] is abnormal (link status: %s).",
        },
    "cannot.get.quorum.server.info":
        {
            "zh": u"\n无法获取双活仲裁服务器运行状态信息",
            "en": "\nFailed to obtain the running status of the active-active quorum server.",
        },
    "quorum.server.running.status.abnormal":
        {
            "zh": u"\n双活仲裁服务器[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of active-active quorum server [%s] is abnormal (running status: %s).",
        },
    "cannot.get.hyper.metro.domain.info":
        {
            "zh": u"\n无法获取双活域运行状态信息",
            "en": "\nFailed to obtain the running status of the active-active domain.",
        },
    "hyper.metro.domain.running.status.abnormal":
        {
            "zh": u"\n双活域[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of active-active domain [%s] is abnormal (running status: %s).",
        },
    "cannot.get.hyper.metro.pair.info":
        {
            "zh": u"\n无法获取双活Pair状态信息",
            "en": "\nFailed to obtain the status of the active-active pair.",
        },
    "cannot.get.hyper.consist.group.info":
        {
            "zh": u"\n无法获取双活一致性组状态信息",
            "en": "\nFailed to obtain the information about the status of the active-active consistency groups.",
        },
    "hyper.metro.pair.health.status.abnormal":
        {
            "zh": u"\n双活Pair[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of active-active pair [%s] is abnormal (health status: %s).",
        },
    "hyper.metro.pair.link.status.abnormal":
        {
            "zh": u"\n双活Pair[%s]链路状态异常(链路状态：%s)",
            "en": "\nThe link status of active-active pair [%s] is abnormal (link status: %s).",
        },
    "hyper.metro.pair.running.status.abnormal":
        {
            "zh": u"\n双活Pair[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of active-active pair [%s] is abnormal (running status: %s).",
        },
    "hyper.consist.group.health.status.abnormal":
        {
            "zh": u"\n双活一致性组[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of active-active consistency group [%s] is abnormal (health status: %s).",
        },
    "hyper.consist.group.running.status.abnormal":
        {
            "zh": u"\n双活一致性组[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of active-active consistency group [%s] is abnormal (running status: %s).",
        },
    "snapshot.lun.capacity.not.pass.title":
        {
            "zh": u"\n下列源LUN容量小于快照容量：",
            "en": "\nThe capacity of the following source LUN "
                  "is smaller than that of the snapshot",
        },
    "snapshot.lun.capacity.not.pass.content":
        {
            "zh": u"\n 源LUN ID:%s，快照ID：%s",
            "en": "\nsource LUN ID:%s, snapshot ID:%s",
        },
    "cannot.get.hyper.vstore.pair.info":
        {
            "zh": u"\n无法获取双活租户Pair信息。",
            "en": "\nFailed to obtain the active-active tenant pair information. ",
        },
    "hyper.vstore.pair.health.status.abnormal":
        {
            "zh": u"\n双活租户Pair[%s]健康状态异常(健康状态：%s)",
            "en": "\nThe health status of active-active tenant pair [%s] is abnormal (health status: %s). ",
        },
    "hyper.vstore.pair.running.status.abnormal":
        {
            "zh": u"\n双活租户Pair[%s]运行状态异常(运行状态：%s)",
            "en": "\nThe running status of active-active tenant pair [%s] is abnormal (running status: %s). ",
        },
    "hyper.vstore.pair.link.status.abnormal":
        {
            "zh": u"\n双活租户Pair[%s]链路状态异常(链路状态：%s)",
            "en": "\nThe link status of active-active tenant pair [%s] is abnormal (link status: %s). ",
        },
    "hyper.vstore.pair.config.status.abnormal":
        {
            "zh": u"\n双活租户Pair[%s]运行状态为Normal，但是配置状态异常(配置状态：%s)",
            "en": "\nThe running status of active-active tenant pair [%s] is Normal, but the configuration status "
                  "(configuration status: %s) is abnormal. ",
        },
    "res.consist.group.status":
        {
            "zh": u"\n如果双活一致性组的健康状态不为Normal或者运行状态不为Normal/Synchronizing/Paused中的一种：",
            "en": "\nIf the health status of the active-active consistency groups is not Normal, "
                  "or the running status is not Normal, Synchronizing, or Paused:",
        },
    "res.hyper.pair.status":
        {
            "zh": u"\n如果双活Pair的健康状态不为Normal或者链路状态不为Link Up或者运行状态不为Normal/Synchronizing/Paused中的一种：",
            "en": "\nIf the health status of the active-active pair is not Normal, the link status is not Link Up, "
                  "or the running status is not Normal, Synchronizing, or Paused:",
        },
    "res.hyper.domain.status":
        {
            "zh": u"\n如果双活域的运行状态不为Normal：",
            "en": "\nIf the running status of the HyperMetro domain is not Normal:",
        },
    "res.quorum.server.status":
        {
            "zh": u"\n如果双活仲裁服务器运行状态不为Online：",
            "en": "\nIf the running status of the active-active quorum server is not Online:",
        },
    "res.quorum.server.link.status":
        {
            "zh": u"\n如果双活仲裁服务器链路状态不为Normal：",
            "en": "\nIf the link status to the active-active quorum server is not Normal:",
        },
    "ethport.subnetmask.longer":
        {
            "zh": u"\nETH端口%s Subnet_Mask字段长度大于14（实际长度:%d）",
            "en": "\nThe Subnet_Mask field length of ETH port %s is longer than 14 (trim length:%d)",
        },
    "hardware.bom.info":
        {
            "zh": u"\n硬件[ID:%s]的BOM编码：%s",
            "en": "\nPN(BOM Code/Item) of hardware [ID: %s]:%s",
        },
    "normalhardware.bom.info":
        {
            "zh": u"\n无法获取信息缺失硬件的BOM编码，正常硬件[ID:%s]的BOM编码：%s",
            "en": "\nCannot obtain the PN(BOM Code/Item) of the hardware whose information is missing,"
                  "PN(BOM Code/Item) of the normal hardware [ID: %s]:%s",
        },
    "disk.bom.info":
        {
            "zh": u"\n硬件[ID:%s]的BOM编码：%s",
            "en": "\nBOM number of hardware [ID: %s]:%s",
        },
    "loginUser.name.check.failure":
        {
            "zh": u"\n工具不支持以关键字（developer, diagnose, password, upgrade, minisystem, storage, error）结尾的用户名，"
                  u"请使用其它用户名进行操作。如有任何疑问，请联系技术支持工程师进行处理。",
            "en": "\nThe tool does not support a user name that ends with a keyword "
                  "(developer, diagnose, password, upgrade, minisystem, storage or error), "
                  "please use the other user name for the operation. If you have any questions, "
                  "please contact technical support engineers for further handling.",
        },
    "cannot.ctrl.id.ip":
        {
            "zh": u"\n获取控制器信息失败",
            "en": "\nThere is an error in getting controller information",
        },
    "check.cache.fault.notpass":
        {
            "zh": u"\n控制器[%s]的Blocked Counter不为0(Blocked Counter: %s)",
            "en": "\nThe value of Blocked Counter of controller [%s] is not 0 (Blocked Counter: %s)",
        },
    "cannot.get.cachefault.info":
        {
            "zh": u"\n无法获取控制器的[%s]Cache Fault页面信息",
            "en": "\nCannot get information about fault pages in a Cache of Controller %s",
        },
    "cannot.get.upgrade.package.info":
        {
            "zh": u"\n无法获取升级包信息",
            "en": "\nFailed to obtain the upgrade package.",
        },
    "exist.4K.disk":
        {
            "zh": u"\n设备中存在扇区大小为4096B或4160B的硬盘[ID: %s]",
            "en": "\nDisks [ID: %s] whose sector size is 4096 bytes or 4160 bytes exist in the device.",
        },
    "diskdomain.hotspare.strategy.info":
        {
            "zh": u"\n硬盘域[%s]上tier0的热备策略：%s，tier1的热备策略：%s，tier2的热备策略：%s。",
            "en": "\nHot Spare Strategy for tier0 of disk domain [ID: %s]: %s;Hot spare Strategy for tier1: %s; "
                  "Hot Spare Strategy for tier2: %s.",
        },
    "diskdomain.disknum.info":
        {
            "zh": u"\n硬盘域[%s]上tier0的盘数：%s，tier1的盘数：%s，tier2的盘数：%s。",
            "en": "\nNumber of disks for tier0 of disk domain [ID: %s]: %s;"
                  "Number of disks for tier1: %s; Number of disks for tier2: %s.",
        },
    "diskdomain.engine.info":
        {
            "zh": u"\n硬盘域[ID:%s]跨引擎",
            "en": "\nDisk Domain[ID:%s] in different engines",
        },
    "diskdomain.diskcapacity.info":
        {
            "zh": u"\n硬盘域[ID:%s]中硬盘类型为[%s]的硬盘容量不一致",
            "en": "\nIn disk domain [ID:%s], the capacities of [%s] disks are different. ",
        },
    "diskdomain.diskspeed.info":
        {
            "zh": u"\n硬盘域[ID:%s]中的[%s]硬盘转速不一致",
            "en": "\nIn disk domain [ID:%s], the rotational speed of [%s] disks are different. ",
        },
    "cannot.get.diskindomain.info":
        {
            "zh": u"\n无法获取硬盘域中硬盘信息",
            "en": "\nCannot get information about disks in disk domain",
        },
    "cannot.get.diskindomain.info.param":
        {
            "zh": u"\n无法获取硬盘域（%s）信息",
            "en": "\nCannot get the disk domain (%s) information",
        },
    "cannot.get.diskdomain.info":
        {
            "zh": u"\n无法获取硬盘域信息",
            "en": "\nCannot get the disk domain information",
        },
    "cannot.get.cofferdisk.info":
        {
            "zh": u"\n无法获取保险盘信息",
            "en": "\nCannot get information about coffer disks",
        },
    "cannot.get.force.write.back":
        {
            "zh": u"\n无法获取强制回写状态",
            "en": "\nCannot get status of forcible write-back",
        },
    "system.force.write.back.info":
        {
            "zh": u"\n系统强制回写状态为 : [%s]",
            "en": "\nThe state is : [%s]",
        },
    "Change.unit.failed":
        {
            "zh": u"\n转换单位失败。",
            "en": "\nFailed to convert units.",
        },
    "system.disk.type.abnormal":
        {
            "zh": u"\n系统盘[ID:%s]为SATA盘",
            "en": "\nThe system disk [ID:%s] is of SATA type",
        },
    "tier.capacity.info":
        {
            "zh": u"\nPOOL[ID：%s]中名称为%s的Tier容量过大(容量大小：%s)。",
            "en": "\nIn POOL[ID:%s], the capacity of tier %s is oversized (capacity: %s).",
        },
    "os_partition_offset_error":
        {
            "zh": u"\n当前版本的设备存在OS分区偏移错误。",
            "en": "\nCurrent version of the device has offsets in OS partitions.",
        },
    "not.align.4k.and.is.edevlun":
        {
            "zh": u"\n当前设备中存在非4K对齐的LUN\nLUN ID:[%s]",
            "en": "\nNon-4 KB aligned LUNs "
                  "exist in the device:\nLUN ID:[%s]"
        },
    "cannot.get.lun.disk.location":
        {
            "zh": u"\n无法获取LUN[ID：%s]的Disk Location字段值",
            "en": "\nFailed to obtain the value of Disk Location for LUN [ID:%s]."
        },
    "query.system.date.abnormal":
        {
            "zh": u"\n查询系统日期异常。",
            "en": "\nQuery System Date Error."
        },
    "alarm.3times.repeat.Occur":
        {
            "zh": u"\n最近30天以下告警重复出现%d次：\n%s",
            "en": "\nThe following alarms recur for %d times in the latest 30 days:\n%s"
        },
    "major.alarm.3times.repeat.Occur":
        {
            "zh": u"\n最近30天以下重要级别告警重复出现%d次：\n%s",
            "en": "\nThe following major alarms recur for %d times in the latest 30 days:\n%s"
        },
    "critical.alarm.3times.repeat.Occur":
        {
            "zh": u"\n最近30天以下紧急级别告警重复出现%d次：\n%s",
            "en": "\nThe following critical alarms recur for %d times in the latest 30 days:\n%s"
        },
    "alarm.than3times.repeat.Occur":
        {
            "zh": u"\n最近30天以下告警重复出现%d次(此处只展示%i次)：\n%s",
            "en": "\nThe following alarms recur for %d times in the latest 30 days(%s times can be displayed here):\n%s"
        },
    "logicEngine.capacity.overflow":
        {
            "zh": u"\n逻辑引擎%i的容量为%sTB，超过容量阀值%sTB。若对原有硬盘域进行扩容，可能导致控制器复位。若无需对原有硬盘域扩容，"
                  u"请忽略该检查项",
            "en": "\nThe capacity of logical engine %i is %s TB, exceeding the threshold %s TB."
                  "If you perform capacity expansion on the original disk domain, the controller may reset. "
                  "If you do not need to perform capacity expansion on the original disk domain, skip this check item."
        },
    "loginUser.name.level.check.failure":
        {
            "zh": u"\n当前用户为备份管理员，不支持巡检，请切换其他用户进行巡检。",
            "en": "\nThe current user is a backup administrator who does not support inspect. "
                  "Please switch to another user for inspect."
        },
    "model.version.exist.data.compression.errors":
        {
            "zh": u"\n产品型号[%s],产品版本[%s]低于问题解决版本[%s]。",
            "en": "\nFor product [%s], version [%s] is earlier than the resolved version [%s]."
        },
    "cannot.get.compression.enabled.info":
        {
            "zh": u"\n获取ACC卡压缩功能信息失败。",
            "en": "\nFailed to obtain information about the compression function of ACC module."
        },
    "file.system.compression.yes":
        {
            "zh": u"\n文件系统[ID:%s]的Compression Enabled为Yes。",
            "en": "\nFor file system [ID:%s], the value of Compression Enabled is Yes."
        },
    "lun.compression.yes":
        {
            "zh": u"\nLUN[ID:%s]的Compression Enabled为Yes。",
            "en": "\nFor LUN [ID:%s], the value of Compression Enabled is Yes."
        },
    "cannot.get.acc.module.info":
        {
            "zh": u"\n获取ACC卡信息失败。",
            "en": "\nFailed to obtain information about the ACC module."
        },
    "interface.module.smart.acc.module.abnormal":
        {
            "zh": u"\nSmart ACC Module的压缩功能Diacrisis：%s。",
            "en": "\nThe compression function switch Diacrisis of Smart ACC Module is %s."
        },
    "cannot.get.acc.module.status.info":
        {
            "zh": u"\n获取ACC卡状态信息失败。",
            "en": "\nFailed to obtain information about the ACC module status."
        },
    "interface.module.is.smart.acc.module.status":
        {
            "zh": u"\n接口卡 [ID:%s]的Running Status:%s。",
            "en": "\nFor interface module [ID:%s], the value of Running Status is %s."
        },
    "check.acc.error":
        {
            "zh": u"\n存在ACC卡。",
            "en": "\nACC Module exists."
        },
    "cannot.get.cli.config.info":
        {"zh": u"\n无法获取Capacity Mode值。",
         "en": "\nFailed to obtain the value of Capacity Mode."
         },
    "get.event.timeout":
        {"zh": u"\n查询设备告警信息超过5分钟，工具停止检查。请按检查方法步骤手动检查。",
         "en": "\nQuery of device alarm information lasts for more than 5 minutes, "
               "the tool stops the check. Please perform the check manually based on the check procedure."
         },
    "unmapped.hypermetro.lun":
        {"zh": u"\n未映射给主机的双活LUN如下：\nID:%s。",
         "en": "\nThe active-active LUNs that are not mapped to the host are:\nID:%s"
         },
    "get.luninfo.timeout":
        {"zh": u"\n查询设备LUN信息超过20分钟，工具停止检查。请按检查方法步骤手动检查。",
         "en": "\nThe time used to query device LUN information exceeds 20 minutes and the tool stops checking. "
               "Please perform the check manually based on the check procedure."
         },
    "cannot.get.lun.hypermetroid":
        {"zh": u"\n无法获取详细信息的LUN如下:\nID:%s。",
         "en": "\nFailed to obtain details of the following LUN:\nID:%s."
         },
    "free.member.differ.capacity":
        {"zh": u"\n空闲盘（ID：%s）容量和成员盘（ID：%s）的容量之差大于等于%sGB。",
         "en": "\nThe difference in capacity of idle disk (ID: %s) and "
               "member disk (ID: %s) is greater than or equal to %s GB."
         },
    "optimization.recommended":
        {"zh": u"\n若涉及扩容，待扩的硬盘型号和容量和已存在的硬盘不一致时，建议将待扩的硬盘新建硬盘域。",
         "en": "\nIf disk expansion is involved in the disk domain, "
               "the type and capacity of disks to be expanded are different from those of existing disks, "
               "you are advised to create a disk domain for the disks to be expanded."
         },
    "notpass.recommended":
        {"zh": u"\n若涉及扩容，请将系统中空闲盘新建硬盘域，扩容硬盘域存在大容量硬盘利用率不高的风险。",
         "en": "\nIf disk expansion is involved in the disk domain,create a disk domain for free disks in the system. "
               "The disk domain may contain large-capacity disks with low usage."
         },
    "exist.hotpatch.error.mseeages":
        {"zh": u"\n当前产品型号为：%s，当前系统软件版本为：%s，建议使用补丁工具安装%s热补丁。\n【备注】补丁包存放路径：%s",
         "en": "\nThe current product model is %s, and the current system software version is %s. "
               "You are advised to use a patch tool to install the %s hot patch. "
               "\n[Note] The patch package can be obtained from %s.",
         },
    "not.exist.hotpatch.error.mseeages":
        {"zh": u"\n当前产品型号为：%s，当前系统软件版本为：%s，建议使用补丁工具安装%s热补丁。\n【备注】补丁包获取路径：%s",
         "en": "\nThe current product model is %s, and the current system software version is %s. "
               "You are advised to use a patch tool to install the %s hot patch. "
               "\n[Note] The patch package can be obtained from %s.",
         },
    "expansion.enclosure.id.abnormal":
        {"zh": u"\n接入系统的硬盘框不是新的硬盘框，无法获取正确的环路号与硬盘框级联深度。",
         "en": "\nThe disk enclosure connected to the system is not a new one. "
               "The loop number and number of cascaded disk enclosures cannot be obtained correctly. "
         },
    "expansion.include.SSD.depth.overrun":
        {"zh": u"\nSAS环路（%s）包含SSD盘且硬盘框级联深度为%i，超过建议值2。",
         "en": "\nSAS loops (%s) contain SSD disks and the number of cascaded disk enclosures is %i, "
               "which exceeds the recommended value 2. "
         },
    "expansion.exclude.SSD.depth.overrun":
        {"zh": u"\nSAS环路（%s）不包含SSD盘且硬盘框级联深度为%i，超过建议值5。",
         "en": "\nSAS loops (%s) do not contain SSD disks and the number of cascaded disk enclosures is %i, "
               "which exceeds the recommended value 5."
         },
    "expansion.18000.exclude.SSD.depth.overrun":
        {"zh": u"\nSAS环路（%s）不包含SSD盘且硬盘框级联深度为%i，超过建议值4。",
         "en": "\nSAS loops (%s) do not contain SSD disks and the number of cascaded disk enclosures is %i, "
               "which exceeds the recommended value 4."
         },
    "expansion.depth.not.Balance":
        {"zh": u"\n引擎%i下SAS环路（%s）与（%s）硬盘框级联深度之差为%i。",
         "en": "\nIn the engine %i, "
               "The difference between number of cascaded disk enclosures in SAS loops (%s) and (%s) is %i."
         },
    "carrierpatchPach":
        {"zh": u"\n运营商下载链接：%s",
         "en": "\nDownload link for carriers: %s",
         },
    "EnterprisepatchPach":
        {"zh": u"\n企业网下载链接：%s",
         "en": "\nDownload link for enterprises: %s",
         },
    "loginUser.name.level.guest.warning":
        {"zh": u"\n当前用户权限不支持此项检查，请切换其他用户重新检查。",
         "en": "\nThe current user does not have sufficient permission, "
               "please switch to another user and perform the check again.",
         },
    "no.online.test.bbuinfo":
        {"zh": u"\n270天内没有进行在线测试的BBU[ID:%s]。",
         "en": "\nBBUs[ID:%s] have not been tested online within last 270 days.",
         },
    "dlm.memory.usage.failed":
        {"zh": u"\n分布式锁内存使用率大于等于80%%的控制器ID：%s。",
         "en": "\nOn controller ID:%s, the memory usage of the distributed lock exceeds 80%%.",
         },
    "cannot.get.dlm.memory.usage.info":
        {"zh": u"\n无法获取分布式锁内存信息。",
         "en": "\nFailed to obtain memory information of distributed locks.",
         },
    "cannot.get.remote.consistency.some.info":
        {
            "zh": u"\n无法获取远程复制一致性组[ID:%s]的Timing Length信息。",
            "en": "\nFailed to obtain Timing Length of remote replication consistency group [ID:%s].",
        },
    "cannot.get.remote.copy.consistency.group.id.info":
        {
            "zh": u"\n无法获取远程复制[ID:%s]的Consistency Group ID信息。",
            "en": "\nFailed to obtain Consistency Group ID of remote replication [ID:%s]. ",
        },
    "cannot.get.remote.copy.Timing.Length.info":
        {
            "zh": u"\n无法获取远程复制[ID:%s]的Timing Length信息。",
            "en": "\nFailed to obtain Timing Length of remote replication [ID:%s].",
        },
    "cannot.get.remote.copy.consistency.group.id.timinglength.info":
        {
            "zh": u"\n无法获取远程复制[ID:%s]的Consistency Group ID和Timing Length信息。",
            "en": "Can not get Consistency Group ID and Timing Length about remote replication[ID:%s].",
        },
    "remote.consistency.timinglength.info":
        {
            "zh": u"\n远程复制一致性组（ID:%s）的Timing Length为%s秒在3秒到30秒之间。",
            "en": "\nFor remote replication consistency group (ID:%s), the value of Timing Length is %s seconds, "
                  "which is between 3 seconds and 30 seconds.",
        },
    "remote.copy.consistency.group.id.timinglength.info":
        {
            "zh": u"\n远程复制（ID:%s）的Consistency Group ID为--且Timing Length为%s秒在3秒到30秒之间。",
            "en": "\nFor remote replication (ID:%s), Consistency Group ID  is --, and Timing Length is %s seconds, "
                  "which is between 3 seconds and 30 seconds.",
        },
    "low.fmversion.disk.info":
        {"zh": u"\n固件版本较低的硬盘如下：\n%s",
         "en": "\nDisks whose firmware versions are too early are as follows: \n%s",
         },
    "canot.get.fmversion.disk.info":
        {"zh": u"\n无法获取固件版本的硬盘如下：\n%s",
         "en": "\nDisks whose firmware version cannot be obtained are as follows: \n%s",
         },
    "disk.10TBNL-SAS.info":
        {"zh": u"\n高密框上存在的10TB NearLine SAS盘的硬盘如下：\n%s",
         "en": "\n10 TB NL-SAS disks in the high-density enclosure are as follows:\n%s",
         },
    "open.password.effective.strategy":
        {"zh": u"\n密码有效期为%s天",
         "en": "\nThe password is valid for %s days."
         },
    "open.user.lock.effective.strategy":
        {"zh": u"\n用户%s天不登录将被锁定",
         "en": "\nA user that does not log in to the system in %s days will be locked."
         },
    "bond.port.id.in.slot.0":
        {"zh": u"\n以太网绑定端口（ID: %s）的成员端口（ID: %s）在0号槽位",
         "en": "\nFor Ethernet bond port (ID: %s), its member port (ID: %s) is in slot 0. "
         },
    "can.not.get.bond.portId.info":
        {"zh": u"\n无法获取以太网绑定端口(ID: %s)的成员端口信息。",
         "en": "\nFailed to obtain information about member ports of the Ethernet bond port(ID: %s)."
         },
    "can.not.get.bond.info":
        {"zh": u"\n无法获取以太网绑定端口信息。",
         "en": "\nFailed to obtain information about the Ethernet bond port."
         },
    "can.not.get.role":
        {"zh": u"\n获取端口的工作角色（Role）失败。",
         "en": "\nFailed to obtain the value of Role for the port."
         },
    "parse.product.hotpatch.file.filed":
        {"zh": u"\n获取补丁配套关系失败。",
         "en": "\nFailed to obtain the mapping relationship between the storage versions and patch versions."
         },
    "ini.and.TGT.port.warning.model":
        {"zh": u"\n端口%s的Role显示为：INI and TGT，且接口卡的Model为：%s",
         "en": "\nThe value of Role for port %s is INI and TGT, and the value of Model for the interface module is %s."
         },
    "can.not.get.port.interface.model":
        {"zh": u"\n获取接口卡[ID: %s]的model失败。",
         "en": "\nFailed to obtain the value of Model for interface module [ID: %s]."
         },
    "heart.beat.to.node.failed":
        {"zh": u"\n通过心跳连接到控制器节点：%s 失败。",
         "en": "\nFailed to connect to controller node %s based on the heartbeat."
         },
    "build.ssh.connection.to.controller.failed":
        {
            "zh": u"工具建立到控制器的SSH连接失败。你可按以下方式处理：\n1 请在SVP内执行评估，或安装最新工具箱后，参照工具箱的FAQ“高端"
                  u"存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。 \n2 请恢复SVP到控制器的连接，然后重"
                  u"新检查。\n3 请联系技术工程师协助解决。",
            "en": "Failed to build SSH connection to controllers. You can perform the following operations:\n1. "
                  "Perform evaluation on the SVP or install SmartKit of the latest version "
                  "and add the current device again "
                  "by referring to the FAQ \"Configuring the Access of Tools Outside the SVP of the High-End Storage "
                  "System\", and select the current check item for an inspection again.\n2. Recover the connection "
                  "between the SVP and controllers, and perform a check again. "
                  "\n3. Contact technical support engineers.",
        },
    "failed.to.get.present.nodeid":
        {"zh": u"\n查询在线的控制器的节点ID失败。",
         "en": "\nFailed to obtain the node ID of the online controller."
         },
    "snapshot.write.mirror.status.not.check.as.license.file.missing":
        {"zh": u"\nLicense文件不存在，查询快照信息失败。若存储系统存在快照，则所有快照的cache镜像功能未完成检查，"
               u"请导入License后重新检查；若存储系统不存在快照，请忽略此提示信息。",
         "en": "\nFailed to query the snapshot information because no license file exists. "
               "If there are snapshots in the system, the cache mirroring function of all snapshots are not completed. "
               "Import a license and check again. If there is no snapshot in the system, skip this prompt message."
         },
    "dedupCompress.lun.write.mirror.status.not.check.as.license.file.missing":
        {
            "zh": u"\nLicense文件不存在，查询开启过重删压缩开关的LUN的信息失败。若存储系统存在开启过重删压缩开关的LUN，"
                  u"则所有开启过重删压缩开关的LUN的cache镜像功能未完成检查，请导入License后重新检查；"
                  u"若存储系统不存在开启过重删压缩开关的LUN，请忽略此提示信息。",
            "en": "\nFailed to query information about LUNs whose deduplication and compression are enabled "
                  "because no license file exists."
                  " If there are LUNs whose deduplication and compression functions are enabled in the system, "
                  "the cache mirroring function of all LUNs with deduplication "
                  "and compression enabled are not completed. Import a license and check again. "
                  "If there is no LUNs whose deduplication and compression are enabled in the system, "
                  "skip this prompt message."
            },
    "dev.connEngine.failure":
        {
            "zh": u"工具连接以下引擎失败，引擎编号为：%s。"
                  u"你可按以下方式处理：\n1 若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后"
                  u"参照工具箱的FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。\n"
                  u"2 请恢复工具到编号为以下的引擎的连接：%s，"
                  u"然后重新检查。\n3 请联系技术工程师协助解决。",
            "en": "Failed to connect to engines whose numbers are: %s. "
                  "You can perform the following operations:\n"
                  "1. If the device model is any of 18000 series, "
                  "install SmartKit of the latest version on the SVP "
                  "where the device is installed or install SmartKit of the latest version and add the current device "
                  "again by referring to the FAQ \"Configuring"
                  " the Access of Tools Outside the SVP of the High-End Storage System\", and select "
                  "the current check item for an inspection again.\n"
                  "2. Recover the connection between the tool and "
                  "engine whose engine number are:%s,"
                  " and perform a check again. \n"
                  "3. Contact technical support engineers.",
        },
    "lun.not.mirror":
        {"zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
               u"\n存储设备上以下LUN的Cache镜像功能关闭， LUN ID为：\n%s",
         "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
               "If such an operation exists, wait for the operation to complete and retry the inspection."
               "\nThe cache mirror functions of the following LUNs on the storage device are disabled. LUN IDs are:\n%s"
         },
    "lun.work.in.single.ctrl.mode":
        {
            "zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
                  u"\n存储设备上以下LUN工作在单控模式，存在将LUN的Cache镜像功能由关闭更改为开启的操作。LUN ID为：\n%s",
            "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  "\nThe following LUNs on the storage device work in single-controller mode, "
                  "and the cache mirroring states of the LUNs are changed from disabled to enabled. LUN IDs are:\n%s"
            },
    "snapshot.not.mirror":
        {
            "zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
                  u"\n存储设备上以下快照的Cache镜像功能关闭，快照存在风险，建议删除并重新创建快照， 快照 ID为：\n%s",
            "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  "\nThe cache mirroring functions of the following snapshots on the storage device are disabled. "
                  "The snapshots have risks. You are advised to delete them and create new ones. Snapshot IDs are:\n%s"
            },
    "dedupCompress.lun.not.mirror":
        {
            "zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
                  u"\n存储设备上以下开启过重删压缩开关的LUN的Cache镜像功能关闭， 开启过重删压缩开关的LUN的ID为：\n%s",
            "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  "\nThe cache mirroring functions of the following LUNs whose deduplication "
                  "and compression are enabled on the storage device are disabled. "
                  "The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
            },
    "snapshot.work.in.single.ctrl.mode":
        {
            "zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
                  u"\n存储设备上以下快照工作在单控模式，存在将快照的Cache镜像功能由关闭更改为开启的操作，快照存在风险，"
                  u"建议删除并重新创建快照， 快照 ID为：\n%s",
            "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  "\nThe following snapshots on the storage device work in single-controller mode, "
                  "and the cache mirroring states of the snapshots are changed from disabled to enabled. "
                  "The snapshots have risks. You are advised to delete them and create new ones. Snapshot IDs are:\n%s"
            },
    "dedupCompress.work.in.single.ctrl.mode":
        {
            "zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。"
                  u"\n存储设备上以下开启过重删压缩开关的LUN工作在单控模式，"
                  u"存在将开启过重删压缩开关的LUN的Cache镜像功能由关闭更改为开启的操作，开启过重删压缩开关的LUN的ID为：\n%s",
            "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  "\nThe following LUNs whose deduplication and compression are enabled on the storage device work "
                  "in single-controller mode, and the cache mirroring states of the LUNs whose deduplication "
                  "and compression are enabled are changed from disabled to enabled. "
                  "The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
            },
    "lun.mirror.status.unknown":
        {"zh": u"\n存储设备上以下LUN的Cache镜像状态查询失败，请联系技术支持工程师协助处理。LUN ID为：\n%s",
         "en": "\nFailed to query the cache mirroring functions of the following LUNs on the storage device, "
               "please contact technical support engineers for help. LUN IDs are:\n%s"
         },
    "snapshot.mirror.status.unknown":
        {"zh": u"\n存储设备上以下快照的Cache镜像状态查询失败，请联系技术支持工程师协助处理， 快照 ID为：\n%s",
         "en": "\nFailed to query the cache mirroring functions of the following snapshots on the storage device, "
               "please contact technical support engineers for help. Snapshot IDs are:\n%s"
         },
    "dedupCompress.lun.mirror.status.unknown":
        {"zh": u"\n存储设备上以下开启过重删压缩开关的LUN的Cache镜像状态查询失败，请联系技术支持工程师协助处理， 开启过重删压缩开关的LUN的ID为：\n%s",
         "en": "\n\nFailed to query the cache mirroring functions of the following LUNs whose deduplication "
               "and compression are enabled on the storage device. Contact technical support engineers.  "
               "The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
         },
    "all.lun.snapshot.write.mirror.plz.chk.further.ref.event.file":
        {"zh": u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。",
         "en": "\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. "
               "If such an operation exists, wait for the operation to complete and retry the inspection."
         },
    "faied.to.transform.lun.to.volume":
        {"zh": u"\n存储设备上以下LUN的ID转化为卷ID失败，请联系技术支持工程师协助处理，LUN ID为：\n%s",
         "en": "\nThe IDs of the following LUNs on the storage device failed to be converted into volume IDs. "
               "Contact technical support. The LUN IDs are \n%s"
         },
    "faied.to.transform.snapshot.to.volume":
        {"zh": u"\n存储设备上以下快照的ID转化为卷ID失败，请联系技术支持工程师协助处理， 快照ID为：\n%s",
         "en": "\nThe IDs of the following snapshots on the storage device failed to be converted into volume IDs. "
               "Contact technical support. The snapshot IDs are \n%s"
         },
    "faied.to.transform.dedupCompressLun.to.volume":
        {"zh": u"\n存储设备上以下开启过重删压缩开关的LUN的ID转化为卷ID失败，请联系技术支持工程师协助处理， 开启过重删压缩开关的LUN的ID为：\n%s",
         "en": "\nThe IDs of the following LUNs whose deduplication and compression are enabled on the storage device "
               "failed to be converted into volume IDs. Contact technical support. "
               "The The IDs of LUNs whose deduplication and compression functions are enabled are: \n%s"
         },
    "faied.to.transform.volume.to.LunOrSnapshot":
        {"zh": u"\n存储设备上以下卷ID转换为快照的ID或者LUN的ID失败，请联系技术支持工程师协助处理， 卷ID为：\n%s",
         "en": "\nThe IDs of the following volumes on the storage device failed to be converted into snapshot IDs"
               "or LUN IDs. Contact technical support. The volume IDs are \n%s"
         },
    "cant.find.lun.mirrorinfo":
        {
            "zh": u"\n存储设备上以下LUN的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，"
                  u"则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 LUN ID为：\n%s",
            "en": "\nMirror information about the LUNs on the storage device failed to be obtained. "
                  "Check whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection."
                  " If no such operation exists, contact technical support. The LUN IDs are \n%s"
            },
    "cant.find.snapshot.mirrorinfo":
        {
            "zh": u"\n存储设备上以下快照的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，"
                  u"则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 快照ID为：\n%s",
            "en": "\nMirror information about the snapshots on the storage device failed to be obtained. "
                  "Check whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection. "
                  "If no such operation exists, contact technical support. The snapshot IDs are \n%s"
            },
    "cant.find.dedupCompressLun.mirrorinfo":
        {
            "zh": u"\n存储设备上以下开启过重删压缩开关的LUN的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。"
                  u"如果正在进行上述操作，则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 "
                  u"开启过重删压缩开关的LUN的ID为：\n%s",
            "en": "\nMirror information about the LUNs whose deduplication and compression are enabled on the "
                  "storage device failed to be obtained. "
                  "Check whether a LUN migration or volume mirroring operation is going on during the inspection. "
                  "If such an operation exists, wait for the operation to complete and retry the inspection. "
                  "If no such operation exists, contact technical support. "
                  "The The IDs of LUNs whose deduplication and compression functions are enabled are: \n%s"
            },
    "ssh.remote.failure":
        {"zh": u"\n连接设备失败，请检查登录账号是否为admin或检查设备是否正常。",
         "en": "\nFailed to connect to the device. "
               "Please check whether the login account is admin or whether the device is normal."
         },
    "cannot.get.disk.info.in.disk.domain":
        {"zh": u"\n无法获取硬盘域下硬盘信息。",
         "en": "\nFailed to obtain information about disks in the disk domain. "
         },
    "disk.domain.exist.high.enclosure":
        {"zh": u"\n硬盘域ID：[%s]下同时存在普通框和高密框下的硬盘。",
         "en": "\nBoth commom and high-density disk enclosures exist in disk enclosure (ID:[%s])."
         },
    "error.during.checking.free.capacity":
        {"zh": u"\n检查[pool id=%s]的存储池时发生了一个错误。",
         "en": "\nAn error occurs during the check of storage pool [pool id=%s]. "
         },
    "pool.low.capacity":
        {"zh": u"\n存储池[pool id=%s]的空闲容量低于10%%。",
         "en": "\nThe free capacity of storage pool [pool id=%s] is smaller than 10%% of the total capacity."
         },
    "pool.id.null":
        {"zh": u"\n无法获取类型为自动迁移的存储池ID列表",
         "en": "\nFailed to obtain IDs of storage pools whose Type is Automatic Relocation."
         },
    "get.free.capacity.failed":
        {"zh": u"\n获取空闲存储容量失败",
         "en": "\nFailed to obtain free capacity."
         },
    "get.total.capacity.failed":
        {"zh": u"\n获取总存储容量失败",
         "en": "\nFailed to obtain total capacity."
         },
    "expansionEnclosure.height.not.same":
        {"zh": u"\nSAS环路（%s）下的硬盘框高度不一致。",
         "en": "\nDisk enclosures in SAS loops (%s) are different in height. "
         },
    "cannot.get.current.time":
        {
            "zh": u"\n无法获取当前系统时间",
            "en": "\nFailed to obtain the current system time.",
        },
    "reseted.in.limit.time":
        {
            "zh": u"\n两小时内发生过系统复位，以下硬盘域存在扩容风险：\n硬盘域ID：%s",
            "en": "\nThe system has been reset within the latest two hours, "
                  "and there is a risk of expansion in the following hard disk domains:\n Disk domains(ID):%s ",
        },
    "usage.not.same":
        {
            "zh": u"\n硬盘域[Disk Domain ID=%s]的Usage Type不一致",
            "en": "\nThe values of Usage Type for disk domain [Disk Domain ID=%s] are not consistent."
        },
    "unInstall.patch":
        {"zh": u"\n当前产品型号为：%s，当前系统软件版本为：%s，建议使用补丁工具安装%s热补丁。",
         "en": "\nThe current product model is %s, and the current system software version is %s, "
               "you are advised to use a patch tool to install the %s hot patch."
         },
    "system.version.low":
        {"zh": u"\n当前产品型号为：%s，当前系统软件版本为：%s，建议升级到%s版本+%s热补丁版本。",
         "en": "\nThe current product model is %s and the current system software version is %s, "
               "you are advised to upgrade the system software to %s and install the %s hot patch."
         },
    "controller.overload.alarm":
        {
            "zh": u"\n一个月内出现过控制器过载告警，请确认系统承载性能是否超限。",
            "en": "\nThere are alarms indicating that controllers are overloaded in the latest 1 month. "
                  "Check whether the system is overloaded."
        },
    "cannot.get.nfs.shere.lock.type":
        {"zh": u"\n无法获取NFS共享的Lock Type信息。",
         "en": "\nFailed to obtain the value of Lock Type for NFS share."
         },
    "nfs.share.lock.type":
        {"zh": u"\nNFS共享（Share ID：%s）的Lock Type为%s",
         "en": "\nThe value of Lock Type for NFS share (Share ID: %s) is %s."
         },
    "cannot.get.fs.Snapshot":
        {
            "zh": u"\n以下文件系统无法获取快照信息：\n%s",
            "en": "\nFailed to obtain snapshot information in the following file systems: \n%s",
        },
    "cannot.get.fs.Snapshot.Reserve":
        {
            "zh": u"\n以下文件系统无法获取快照预留百分比：\n%s",
            "en": "\nFailed to obtain the snapshot reservation percentage in the following file systems: \n%s",
        },
    "fs.Snapshot.Reserve.is":
        {
            "zh": u"\n文件系统（ID：%s）不存在快照，快照预留百分比为%s",
            "en": "\nFile system (ID: %s) does not contain snapshots. The snapshot reservation percentage is %s.",
        },
    "can.not.get.asynch.id":
        {
            "zh": u"\n无法获取远程复制ID列表",
            "en": "\nFailed to obtain the list of remote replication IDs. ",
        },
    "can.not.get.replication.detail":
        {
            "zh": u"\n无法获取远程复制详情[remote_replication_id:%s]",
            "en": "\nFailed to obtain the remote replication details [remote_replication_id:%s].",
        },
    "can.not.get.lun.detail":
        {
            "zh": u"\n无法获取LUN详情[lun_id:%s]",
            "en": "\nFailed to obtain details about LUN[lun_id:%s].",
        },
    "get.LUN.capacity.failed":
        {"zh": u"\n获取LUN容量失败[lun_id:%s]",
         "en": "\nFailed to obtain capacity of LUN[lun_id:%s]."
         },
    "get.pool.capacity.failed":
        {"zh": u"\n获取存储池容量失败[id:%s]",
         "en": "\nFailed to obtain the capacity of storage pool [ID: %s]."
         },
    "get.pool.capacity.totalCap.empty":
        {"zh": u"\n存储池总容量为空[id:%s]",
         "en": "\nEmpty storage pool [ID: %s]."
         },
    "can.not.get.pool.detail":
        {
            "zh": u"\n无法获取存储池详情",
            "en": "\nFailed to obtain the storage pool details.",
        },
    "can.not.get.free.capacity":
        {"zh": u"\n获取存储池空闲容量失败[id:%s]",
         "en": "\n Failed to obtain the available capacity (Free Capacity) of storage pool [id:%s]."
         },
    "pool.lun.capacity.beyond.limit.notpass":
        {
            "zh": u"\n存储池[ID:%s]的剩余容量为%sGB，小于或等于LUN容"
                  u"量总和%sGB的10%%",
            "en": "\nFor storage pool [ID:%s], its available capacity is "
                  "%sGB and smaller than 10%% of the sum of all LUN "
                  "capacities(%sGB). ",
        },
    "pool.source.lun.beyond.limit":
        {
            "zh": u"\n存储池[ID:%s]的剩余容量为%sGB，小于或等于快照源LUN容量总和%sGB的31%%",
            "en": "\nFor storage pool [ID:%s], its available capacity is %sGB and smaller than 31%% of the sum of "
                  "all Source LUN capacities of SnapShot(%sGB). ",
        },
    "low.pool.capacity":
        {
            "zh": u"\n存储池[ID:%s]的空闲容量低于或等于总容量的1%%。",
            "en": "\nFor storage pool [ID: %s], "
                  "the value of Free Capacity is smaller than 1% of that of Total Capacity. ",
        },
    "risk.during.mirror.lun":
        {
            "zh": u"在创建卷镜像业务或者运行卷镜像业务时有风险，请参考修复建议进行修复",
            "en": "Creating or running volume mirroring services is risky. "
                  "Please handle the issue based on suggestions. ",
        },
    "risk.during.lun.migration":
        {
            "zh": u"在创建LUN迁移业务或者运行LUN迁移业务时有风险，请参考修复建议进行修复",
            "en": "Creating or running LUN migration services is risky. Please handle the issue based on suggestions.",
        },
    "risk.during.hyper.metro.pair":
        {
            "zh": u"在创建SAN双活业务或者运行SAN双活业务时有风险，请参考修复建议进行修复",
            "en": "Creating or running active-active SAN services is risky. "
                  "Please handle the issue based on suggestions.",
        },
    "risk.during.clone":
        {
            "zh": u"在创建SAN克隆业务或者运行SAN克隆业务时有风险，请参考修复建议进行修复",
            "en": "Creating or running SAN clone services is risky. Please handle the issue based on suggestions.",
        },
    "can.not.get.replication.info":
        {
            "zh": u"\n无法获取远程复制信息",
            "en": "\nFailed to obtain the remote replication information.",
        },
    "can.not.get.mirror.lun.info":
        {
            "zh": u"\n无法获取卷镜像信息",
            "en": "\nFailed to obtain HyperMirror information.",
        },
    "can.not.get.lun.migration.info":
        {
            "zh": u"\n无法获取LUN迁移信息",
            "en": "\nFailed to obtain LUN migration information.",
        },
    "can.not.get.hyper.metro.pair.info":
        {
            "zh": u"\n无法获取双活信息",
            "en": "\nFailed to obtain HyperMetro information.",
        },
    "can.not.get.clone.info":
        {
            "zh": u"\n无法获取克隆信息",
            "en": "\nFailed to obtain clone information.",
        },
    "can.not.get.snapshot.info":
        {
            "zh": u"\n无法获取快照源LUN的ID列表",
            "en": "\nFailed to obtain IDs of the snapshot source LUNs. ",
        },
    "parse.ndpm.service.configuration.failed":
        {
            "zh": u"\n解析NDMP配置项失败。\n",
            "en": "\nFailed to parse the NDMP configuration. \n."
        },
    "sas.port.number.abnormal":
        {"zh": u"\n引擎%s下SAS端口数为奇数：%i ",
         "en": "\nIn engine %s, the number of SAS ports is an odd number: %i."
         },
    "sasPortNum.greater.than.loopNum":
        {"zh": u"\n引擎[%s]下的硬盘框级联分布不均衡，当前接入%s个硬盘框，建议使用%s个级联端口，并依次均分给每个级联端口。",
         "en": "\nThe distribution of cascading disk enclosures in engine [%s] is unbalanced. "
               "%s disk enclosures are connected currently. You are advised to use %s cascading ports "
               "and allocate the disk enclosures to each cascading port."
         },
    "faile.in.fetching.share.cifs.data.all":
        {
            "zh": u"\n获取CIFS共享ID列表失败。\n",
            "en": "\nFailed to obtain the the share CIFS ID list. \n"
        },
    "following.cifs.share.ids.failed.to.fetch":
        {
            "zh": u"\n获取如下CIFS Share ID对应配置失败：\n%s。\n",
            "en": "\nFailed to obtain configurations corresponding to the following CIFS share IDs :\n %s.\n"
        },
    "cannot.get.device.cache.capacity":
        {
            "zh": u"\n无法获取设备内存容量。\n",
            "en": "\nFailed to obtain the the cache capacity.\n"
        },
    "parse.cifs.global.configuration.failed":
        {
            "zh": u"\n解析CIFS全局配置失败。\n",
            "en": "\nFailed to parse the CIFS global configuration.\n"
        },
    "port.wwn.is.HBA":
        {"zh": u"\n接口卡端口ID：%s的WWN为%s\n如果产品型号是5500 V3并且板载端口和接口卡均不是Smart IO类型，请忽略该检查项结果。",
         "en": "\nThe WWN of the port for interface module (ID: %s) is %s. "
               "\nIf the product model is 5500 V3, "
               "and both the on-board port and interface module are not of the SmartIO type, ignore the check result."
         },
    "lun.edev.total.infolist":
        {"zh": u"\n异构LUN(ID:%s)配置了快照特性、远程复制特性或者双活业务特性，但异构LUN的写策略为透写。",
         "en": "\nHeterogeneous LUN (ID:%s) is configured with the snapshot, remote replication, "
               "or HyperMetro feature, but the write policy of the heterogeneous LUN is write-through."
         },
    "lun.edev.total.infofaile":
        {"zh": u"\n获取(异构lun)信息失败",
         "en": "\nThere is an error in getting information(Heterogeneous LUN)",
         },
    "failed.fetch.following.hosts.initiators.luns.info":
        {
            "zh": u"查询如下主机、启动器或LUN配置信息失败: \n%s\n",
            "en": "Failed to query information about the following hosts, initiators or LUNs:\n%s \n"
        },
    "failed.fetch.hosts.info":
        {
            "zh": u" 主机 %sLUN配置信息查询失败。\n",
            "en": "Failed to query LUN configuration about hosts %s.\n"
        },
    "failed.query.ib.initiators.about.host":
        {
            "zh": u"主机 %s 的IB启动器信息查询失败。\n",
            "en": "Failed to query IB initiator information on host %s.\n"
        },
    "failed.to.query.ib.initiators":
        {
            "zh": u"设备IB启动器信息查询失败。\n",
            "en": "Failed to query IB initiator information.\n"
        },
    "failed.to.query.fc.iscsi.initiators":
        {
            "zh": u"设备FC、ISCSI启动器信息查询失败。\n",
            "en": "Failed to query FC and ISCSI initiator information on the device. \n"
        },
    "failed.fetch.luns.info.on.host":
        {
            "zh": u" 主机 %s下挂载的ID为 %s 的LUN配置信息查询失败。\n",
            "en": "For host %s, the configuration information about LUNs "
                  "whose IDs are %s attached to the host fails to be queried. \n"
        },
    "query.host.info.failed":
        {
            "zh": u" 查询设备关联主机信息查询失败。\n",
            "en": "Failed to query information about the host(s) that is associated with the device.\n"
        },
    "contr.not.config.ip":
        {"zh": u"\n控制器未配置管理IP，无法连接控制器。",
         "en": "\n1. Failed to connect to the controller because no management IP address is configured for it."
         },
    "connect.to.controller.failed":
        {"zh": u"\n连接控制器失败（若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的"
               u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择LUN的Cache镜像状态检查进行巡检）。",
         "en": "\nFailed to connect to the controller. If the device model is any of 18000 series, "
               "install SmartKit of the "
               "latest version on the SVP where the device is installed or install SmartKit of the latest version "
               "and add "
               "the current device again by referring to the FAQ \"Configuring the Access of Tools Outside the SVP of "
               "the High-End Storage System\", and select Checking the Cache Mirror States of LUNs for an inspection."
         },
    "lun.edev.total.inerrorist":
        {"zh": u"\n以下LUN_ID(ID:%s)未完成检查。",
         "en": "\nThe following LUNs (ID:%s) are not completed."
         },
    "can.not.get.alarm.mask.info":
        {
            "zh": u"\n无法获取屏蔽告警信息。",
            "en": "\nFailed to obtain information about the shielded alarms.",
        },
    "can.not.get.existed.flag":
        {
            "zh": u"\n无法获取Existed Flag字段的值，或该值格式错误。",
            "en": "\nFiled to obtain the value of Existed Flag, or the format of this value is incorrect.",
        },
    "collect.fail.user.level.low":
        {
            "zh": u"\n收集日志失败，原因为用户权限过低。",
            "en": "\nFailed to obtain the logs because the user does not have sufficient permission.",
        },
    "collect.fail.when.executing.cli":
        {
            "zh": u"\n收集日志失败，原因为执行导出命令失败。",
            "en": "\nFailed to obtain the logs because the command for exporting logs fails to be executed.",
        },
    "can.not.get.export.path":
        {
            "zh": u"\n收集日志失败，原因为无法获取日志路径。",
            "en": "\nFailed to obtain the logs because the path that saves logs cannot be obtained.",
        },
    "collect.fail.download.error":
        {
            "zh": u"\n收集日志失败，原因为日志下载出错。",
            "en": "\nFailed to obtain the logs because an error occurs when the logs are downloaded.",
        },
    "collect.fail.when.get.system.info":
        {
            "zh": u"\n收集日志失败，原因为无法获取设备当前状态信息。",
            "en": "\nFailed to obtain the logs because the current status of device cannot be obtained.",
        },
    "collect.fail.due.to.system.status":
        {
            "zh": u"\n收集日志失败，原因为当前系统状态异常。",
            "en": "\nFailed to obtain the logs because the current system status is abnormal.",
        },
    "collect.fail.when.get.user.name":
        {
            "zh": u"\n收集日志失败，原因为无法获取登录用户名。",
            "en": "\nFailed to obtain the logs because the login user name cannot be obtained.",
        },
    "collect.fail.when.get.uer.level":
        {
            "zh": u"\n收集日志失败，原因为无法获取登录用户权限。",
            "en": "\nFailed to obtain the logs because the permission of the login user cannot be obtained.",
        },
    "analys.subfile.failed":
        {
            "zh": u"\n解析日志压缩包失败。",
            "en": "\nFailed to parse the package of logs.",
        },
    "can.not.get.ultra.path.number":
        {
            "zh": u"\n无法获取多路径版本。",
            "en": "\nFailed to obtain the version of the multipath software.",
        },
    "alarm.event.content.error":
        {
            "zh": u"\n告警日志中没有alarm id为%s的告警记录。",
            "en": "\nThere is no alarm whose Alarm ID is %s in the alarm logs.",
        },
    "file.abs.directory":
        {
            "zh": u"\n告警日志存放位置为%s，可手动检查。",
            "en": "\nThe alarm logs are stored in %s. You can manually check it.",
        },
    "ultraPath.version.low":
        {
            "zh": u"\n多路径版本[%s]不是以2开头，详细告警记录如下：\n%s",
            "en": "\nThe multipath software version [%s] does not start with 2. "
                  "The detailed alarm logs are as follows:\n%s",
        },
    "can.not.get.bad.sector.info":
        {
            "zh": u"\n无法获取硬盘坏块信息[Disk ID=%s]。",
            "en": "\nFailed to obtain information about bad sectors of disks[Disk ID=%s].",
        },
    "bad.sector.exist.in.disk":
        {
            "zh": u"\n存在硬盘坏块的硬盘ID为[%s]。",
            "en": "\nThe disk whose value of Disk ID is [%s] has back sectors.",
        },
    "exit.ssd.diag.abnormal":
        {"zh": u"\n当前SSD盘诊断功能异常。",
         "en": "\nThe SSD diagnosis function is abnormal."
         },
    "user.level.not.super_admin":
        {"zh": u"\n当前用户级别不支持该检查项。请使用超级管理员用户重新检查。",
         "en": "\nYou are not authorized to perform this check due to low user level. "
               "Log in to the device as an administrator and perform the check again."
         },
    "has.not.cli.privilege":
        {"zh": u"\n当前用户没有权限执行此命令或产品版本不支持此命令，请联系技术工程师协助处理。",
         "en": "\nThe current user does not have the permission to run this "
               "command or product version does not support this command, "
               "Contact technical support engineers for assistance."
         },
    "nas.pages.resource.overproof":
        {"zh": u"\n控制器[%s]的使用页面资源数之差为%s。",
         "en": "\nFor controller [%s], the difference between the calculated used page resources and the value"
               " of Page used obtained in the command output is %s."
         },
    "remote.device.idinfomation":
        {"zh": u"\n获取(远端设备)信息失败",
         "en": "\nThere is an error in getting information(Remote device)",
         },
    "remote.device.total.idfail":
        {"zh": u"\n本端与远端设备（ID:%s）异构LUN的链路存在FC链路和ISCSI链路混插。",
         "en": "\nFC and iSCSI links are used in hybrid mode for the heterogeneous LUNs "
               "between the local storage array and remote storage array (ID:%s). "
         },
    "contor.band.remote.replication.link.less.2":
        {
            "zh": u"\n控制器[%s]未绑定至少两条状态正常的复制链路到远端设备[%s]。",
            "en": "\nController[%s] does not have at least two normal replication links bound to remote device[%s]."
        },
    "contor.band.remote.replication.link.less.1":
        {
            "zh": u"\n控制器[%s]未绑定状态正常的复制链路到远端设备[%s]的控制器[%s]。",
            "en": "\nController[%s] has no normal replication link bound to controller[%s] of remote device[%s]."
        },
    "dns.server.disposelist.overstep":
        {"zh": u"\nDNS Server探测配置列表配置了%s个地址。",
         "en": "\n%s addresses are configured in the configuration list of DNS servers to be detected."
         },
    "cannot.get.dns.server.disposelist":
        {"zh": u"\n获取DNS Server探测配置列表信息失败",
         "en": "\nFailed to obtain information about the configuration list of DNS servers to be detected.",
         },
    "device.not.exit.quorum.server.link":
        {
            "zh": u"设备不存在仲裁链路。\n",
            "en": "There is no quorum link on the device.\n",
        },
    "hyperMetro.domain.not.exit.quorum.server":
        {
            "zh": u"以下双活域未配置仲裁服务器，双活在运行过程中某些场景下存在"
                  u"风险。\n%s\n修复建议：建议为双活域配置仲裁服务器，否则部分"
                  u"故障场景业务有中断风险。",
            "en": "Risks exist in some scenarios when HyperMetro is running "
                  "because no quorum server is configured for the following "
                  "HyperMetro domains:\n%s\nRecovery Suggestion: You are advised to configure a "
                  "quorum server for the HyperMetro domain. Otherwise, services may be "
                  "interrupted in some fault scenarios.",
        },
    "contor.not.band.quorum.server": {
        "zh": u"仲裁服务器[ID:%s]在控制器%s上未绑定Link Status为Link Up的仲裁链路\n",  # noqa
        "en": "Quorum server [ID: %s] is not bound with a quorum link "
              "whose Links Status is Link Up with controllers %s.\n",
        # noqa
    },
    "engine.less.than.two.controllers": {
        "zh": u"仲裁服务器[ID:%s]在以下引擎内未保证两控有仲裁链路：%s。\n",
        "en": "Less than two controllers have quorum links with quorum sever [ID: %s] on the following engines: %s\n",
        # noqa
    },
    "engine.less.than.two.controllers.suggest":
        {
            "zh": u"修复建议：使用了存储设备管理口做仲裁链路，请保证每个引擎内管理口都有仲裁链路。",
            "en": "Recovery Suggestion: If the management port of the storage"
                  " device is used as the quorum link, ensure that the "
                  "management port of each engine has a quorum link.",
        },
    "cannot.get.engine.info": {
        "zh": u"无法获取引擎信息。\n",
        "en": "Cannot get information about engines.\n",
    },
    "controller.server.link.exception":
        {
            "zh": u"\n控制器[%s]与服务器之间链路异常。",
            "en": "\nThe links between controller [%s] and the server are abnormal.",
        },
    "version.does.not.involve":
        {
            "zh": u"\n该版本/该设备形态不涉及。",
            "en": "\nThe version or device model is not involved.",
        },
    "vstore.pair.status.check.failed":
        {
            "zh": u"\npair id 为 %s的租户检查不通过的项如下：",
            "en": "\nThe following items for the HyperMetro vStore whose pair ID is %s do not pass the check: ",
        },
    "chunk.check.getlun.info.failed":
        {
            "zh": u"\n获取lun(lun id为%s)的详细信息失败！",
            "en": "\nFailed to obtain details about LUN (LUN ID: %s).",
        },
    "chunk.check.getremote.asynchronous.lun.info.failed":
        {
            "zh": u"\n获取异步远程复制LUN的信息失败！",
            "en": "\nFailed to obtain information about the asynchronous remote replication LUN.",
        },
    "chunk.check.no.pass.error.msg":
        {
            "zh": u"\nchunk检查不通过，详情请参考检查标准。",
            "en": "\nThe result of the chunk check is Not passed. For details, see the check criteria.",
        },
    "chunk.check.pass.suggesstion.optimization.msg":
        {
            "zh": u"\nchunk检查建议优化，详情请参考检查标准。",
            "en": "\nRisks are found in the chunk check. For details, see the check criteria.",
        },
    "chunk.check.get.controller.node.failed":
        {
            "zh": u"\n获取控制器节点信息失败。",
            "en": "\nFailed to obtain controller node information.",
        },
    "chunk.check.connect.to.controller.failed":
        {"zh": u"\n连接控制器失败（若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的"
               u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检）。",
         "en": "\nFailed to connect to the controller. If the device model is any of 18000 series, "
               "install SmartKit of the "
               "latest version on the SVP where the device is installed or "
               "install SmartKit of the latest version and add "
               "the current device again by referring to the FAQ "
               "\"Configuring the Access of Tools Outside the SVP of the "
               "High-End Storage System\", and select the current check item for an inspection again."
         },
    "can.not.check.6800.conn.fail":
        {
            "zh": u"\n6800 V3连接控制器失败, 请配置引擎[%s]的管理IP后重试，"
                  u"若已配置且仍然无法连接引擎[%s]控制器，请人工检查。",
            "en": "\nFailed to connect to the controller of the 6800 V3. "
                  "Configure the management IP address of the engine [%s] "
                  "and try again. If the management IP address has been "
                  "configured and the controller of the engine [%s] "
                  "cannot be connected, manually check the item."
        },
    "lun.262140GB.warning":
        {
            "zh": u"\n存储设备上以下LUN容量大于等于262140GB，若后续该LUN配置了远程复制或双活，可能会导致远程复制或双活业务受影响。\n%s",
            "en": "\nThe capacity of the following LUNs on the storage device is greater than or equal to 262140 GB. "
                  "If remote replication or active-active feature is to be configured for the LUNs later, "
                  "remote replication or active-active services may be affected.\n%s",
        },
    "lun.262140GB.notpass":
        {
            "zh": u"\n存储设备上以下LUN容量大于等于262140GB，且该LUN配置了远程复制或双活，可能会导致远程复制或双活业务受影响。\n%s",
            "en": "\nThe capacity of the following LUNs on the storage device is greater than 262140 GB, "
                  "and the remote replication or active-active feature is configured for the LUNs, "
                  "remote replication or active-active services may be affected.\n%s"
        },
    "get.manulycheck.bureauScore":
        {
            "zh": u"开局质量标准检查评估得分：%s分。\n",
            "en": "Score of site deployment quality standard evaluation:%s\n",
        },
    "manulycheck.bureauScore.noachieve.criterion":
        {
            "zh": u"开局质量标准检查评估得分未达100分。\n",
            "en": "The score of site deployment quality standard evaluation is not 100.\n",
        },
    "exist.ssd.diag.risk":
        {
            "zh": u"\n当前系统软件版本为%s，热补丁版本为%s。系统可靠性可能受到影响。",
            "en": "\nThe current system software version is %s and the hot patch version is %s. "
                  "The system reliability may be affected.",
        },
    "ssd.diag.switch.disabled":
        {
            "zh": u"\n当前系统软件版本为%s，热补丁版本为%s。且SSD盘诊断功能开启。系统可靠性可能受到影响。",
            "en": "\nThe current system software version is %s and the hot patch version is %s. "
                  "And the SSD diagnosis function is opened. The system reliability may be affected.",
        },
    "only.system.version.low":
        {"zh": u"\n当前产品型号为：%s，当前系统软件版本为：%s，建议升级到%s版本。",
         "en": "\nThe current product model is %s and the current system software version is %s. "
               "You are advised to upgrade the system software to %s.",
         },
    "lun.include.other.features":
        {
            "zh": u"\nLUN[ID:%s]叠加的增值特性：%s。",
            "en": "\nLUN [ID:%s] Overlapped value-added features:%s."
        },
    "pool.free.capacity.lower.standard.one":
        {
            "zh": u"\n存储池[ID:%s]的空闲容量小于或等于%sLUN容量总和的%.1f%%(当前双活LUN容量总和的0.5%%为%s GB)",
            "en": "\nThe free capacity of storage pool [ID:%s] is less than or equal to the total capacity of %s LUNs, "
                  "specifically %.1f%% (0.5%% of current total capacity of hypermetro LUNS is %s GB) "
                  "of the total capacity."
        },
    "pool.free.capacity.lower.standard.two":
        {
            "zh": u"\n存储池[ID:%s]的空闲容量小于或等于%sLUN容量总和的%.f%%(当前双活LUN容量总和的1%%为%s GB)",
            "en": "\nThe free capacity of storage pool [ID:%s] is less than or equal to the total capacity of %s LUNs, "
                  "specifically %.f%% (1%% of current total capacity of hypermetro LUNS is %s GB) "
                  "of the total capacity."
        },
    "thirdparty.multipath.hypermetro.check.unsupported.nopass":
        {
            "zh": u"\n主机[%s]如果未使用第三方多路径，请忽略该检查项。否则主机[%s]可能使用过不支持双活的第三方多路径，"
                  u"请确认主机上当前使用的是否仍为第三方多路径，如果是，请参照修复建议进行处理。",
            "en": "\nIf third-party multipath software is not used on host [%s], ignore this check item. Otherwise, "
                  "third-party multipath software that does not support "
                  "HyperMetro may have ever been used on host [%s]. "
                  "Check whether the third-party multipath software is still used on the host. "
                  "If yes, rectify the fault by referring to the suggestion."
        },
    "thirdparty.multipath.hypermetro.check.supported.nopass":
        {
            "zh": u"\n 主机[%s]如果未使用第三方多路径，请忽略该检查项。否则主机[%s]可能使用过支持双活的第三方多路径，"
                  u"在主机配置启动器时未勾选第三方多路径选项。请确认主机上使用的是否仍为第三方多路径，如果是，请参照修复建议进行处理。",
            "en": "\nIf third-party multipath software is not used on host [%s], ignore this check item. "
                  "Otherwise, third-party multipath software that supports HyperMetro "
                  "may have ever been used on host [%s], and the Use third-party multipath software option "
                  "is not selected during the configuration of a host initiator. "
                  "Check whether the third-party multipath software is still used on the host. "
                  "If yes, rectify the fault by referring to the suggestion."
        },
    "fileSystem.writeThrough.abnormal":
        {
            "zh": u"\n系统中以下文件系统处于异常透写状态且该文件系统归属的存储池可用容量充足。\n%s",
            "en": "\nThe following file systems in the system are in the abnormal write-through state "
                  "and the available capacity of the storage pools to which the file systems belong is sufficient:\n%s"
        },
    "sugges.install.the.hot.patch":
        {
            "zh": u"\n控制器[%s]的系统盘使用策略需要优化, 建议安装%s或之后版本热补丁。",
            "en": "\nThe policy for using system disks on controller [%s] needs to be optimized. "
                  "You are advised to install the hot patch of %s or a later version."
        },
    "sugges.install.the.hot.patch.warning":
        {
            "zh": u"\n建议安装%s或之后版本热补丁。",
            "en": "\nYou are advised to install the hot patch of %s or a later version."
        },
    "contact.technical.support.engineers":
        {
            "zh": u"\n建议升级系统软件到最新推荐的版本。",
            "en": "\nYou are advised to upgrade the system software to the latest version."
        },
    "remaining.life.of.system.disk.is.too.low":
        {
            "zh": u"\n控制器[%s]的系统盘剩余使用率小于等于15%%，请联系技术支持工程师协助处理。",
            "en": "\nThe available rate of the system disk on controller [%s] is smaller than or equal to 15%%. "
                  "Contact technical support engineers."
        },
    'not.mirror.lun.list':
        {
            "zh": u"\n系统存在不镜像的LUN：%s",
            "en": "\nNot mirror LUN exist: %s",
        },
    'not.mirror.snapshot.list':
        {
            "zh": u"\n系统存在不镜像的快照：%s",
            "en": "\nNot mirror snapshot exist: %s",
        },
    'cli.connection.invalid':
        {
            "zh": u"\nSSH连接无效。",
            "en": "\nInvalid SSH connection.",
        },
    'failed.to.get.user.level':
        {
            "zh": u"\n查询用户权限失败。",
            "en": "\nFailed to query the user level.",
        },
    "loginUser.name.level.must.be.super.admin":
        {"zh": u"\n当前用户权限不支持此项检查，请使用超级管理员用户登录并重新检查。",
         "en": "\nThe current user does not have sufficient permission, "
               "please login as a super administrator and perform the check again.",
         },
    "faild.fetch.event.log.export.destination":
        {
            "zh": u"\n获取阵列告警日志失败。",
            "en": "\nFailed to obtain alarm logs of the storage array."
        },
    "failed.decompress.event.log":
        {
            "zh": u"\n解压告警日志文件失败。",
            "en": "\nFailed to decompress the alarm log file."
        },
    "no.support.publickey.forensics":
        {
            "zh": u"\n当前使用了用户名密码和PublicKey鉴权方式，不支持心跳到其他控制器执行检查，请修改鉴权方式为用户名密码鉴权后再执行检查。",
            "en": "\nAccount/Password authentication and public key authentication are used. "
                  "You cannot log in to other controllers through heartbeat connection to perform a check. "
                  "Change the authentication mode to account/password authentication, and then perform the check again."
        },
    "no.capacity.info":
        {
            "zh": u"\n无法获取到详细信息的远程复制Pair的ID有:%s。",
            "en": "\n2.The IDs of remote replication pairs whose details cannot be obtained are: %s."
        },
    "second.resource.capacity.is.lower":
        {
            "zh": u"\n文件远程复制pair[ID:%s]的主端容量为%s GB,从端容量为%s GB。",
            "en": "\nFor the file system remote replication pair [ID: %s], "
                  "the capacity of the primary file system is %s GB, "
                  "and the capacity of the secondary file system is %s GB."
        },
    "cannot.get.info.fs.pair":
        {
            "zh": u"\n无法获取文件系统远程复制Pair信息。",
            "en": "\nCan not get information about file system remote replication pair."
        },
    "ssh.connect.timed.out":
        {
            "zh": u"登录设备失败，请检查输入的登录信息是否正确，以及帐号是否被锁定。",
            "en": "Failed to login to the device. "
                  "Please check whether the login information is correct and the account is locked."
        },
    "ssh.connect.auth.fail":
        {
            "zh": u"登录设备失败，请检查输入的登录信息是否正确，以及帐号是否被锁定。",
            "en": "Failed to login to the device. "
                  "Please check whether the login information is correct and the account is locked."
        },
    "ssh.connect.key.nofound":
        {
            "zh": u"登陆设备失败，密钥文件不存在，请重新选择。",
            "en": "Failed to login to the device. The key file does not exist. Please select another file."
        },
    "ssh.connect.auth.nosupport.key":
        {
            "zh": u"设备不支持使用Publickey鉴权。",
            "en": "The device does not support Publickey authentication."
        },
    "ssh.connect.auth.nosupport.pwd":
        {
            "zh": u"设备不支持使用密码鉴权。",
            "en": "The device does not support password authentication."
        },
    "ssh.connect.fail":
        {
            "zh": u"不能连接到设备，请检查网络及设备状态是否正常，输入的登录信息是否正确，以及帐号是否被锁定。",
            "en": "Failed to connect to device. Please check whether the network and device are normal, "
                  "login information is correct and the account is locked."
        },
    "not.add.remote.device":
        {
            "zh": u"\n未添加远端设备(SN:%s)。",
            "en": "\nRemote device (SN:%s) not added."
        },
    "not.select.remote.device":
        {
            "zh": u"\n未选择远端设备(SN:%s)。",
            "en": "\nRemote device (SN:%s) not selected."
        },
    "inconsistency.prompt":
        {
            "zh": u"\n本端设备（SN：%s）与远端设备（SN：%s）在以下项存在不一致：\n%s；",
            "en": "\nThe local device(SN:%s) and the remote device(SN:%s) "
                  "are inconsistent in the following items:\n%s;",
        },
    "poolanddomain.query.pair.falure":
        {
            "zh": u"\n查询双活pair Id失败。",
            "en": "\nFailed to query the HyperMetro pair ID.",
        },
    "poolanddomain.pairinfo.query.failure":
        {
            "zh": u"\n以下双活pair Id对应的双活信息查询失败：%s。",
            "en": "\nFailed to query the HyperMetro information corresponding "
                  "to the following HyperMetro pair IDs: %s.",
        },
    "poolanddomain.poolid.query.failure":
        {
            "zh": u"\n以下双活pair Id对应的存储池Id查询失败：%s。",
            "en": "\nFailed to query the storage pool ID corresponding to the following HyperMetro pair IDs: %s.",
        },
    "poolanddomain.poolinfo.query.failure":
        {
            "zh": u"\n以下双活pair Id对应的存储池信息查询失败：%s。",
            "en": "\nFailed to query "
                  "the storage pool information corresponding to the following HyperMetro pair IDs: %s.",
        },
    "poolanddomain.domianinfo.query.failure":
        {
            "zh": u"\n以下双活 pair Id对应的硬盘域信息查询失败: %s。",
            "en": "\nFailed to "
                  "query the disk domain information corresponding to the following HyperMetro pair IDs: %s.",
        },
    "poolanddomain.domain.inconsistency":
        {
            "zh": u"\n硬盘域信息不一致的双活pair Id：%s。",
            "en": "\nDisk domain information corresponding to the following HyperMetro pair IDs is different: %s.",
        },
    "poolanddomain.prompt":
        {
            "zh": u"\n本端（SN：%s）与远端（SN：%s）检查的提示信息如下：",
            "en": "\nInformation displayed on the local end (SN: %s) and remote end (SN: %s) is as follows:",
        },
    "port.for.host.and.other.replication.link.port.occupied":
        {
            "zh": u"\n复制链路[ID:%s]对应的端口与主机端口[ID:%s]共用。",
            "en": "\nReplication link [ID:%s] and the host share the same port [ID:%s]."
        },
    "port.for.host.and.other.repAndQuorum.link.port.occupied":
        {
            "zh": u"\n复制链路[ID:%s]对应的端口与仲裁链路[ID:%s]的端口[ID:%s]共用。",
            "en": "\nReplication link [ID: %s] and quorum link [ID:%s] share the same port [ID:%s]."
        },
    "port.for.host.and.other.quorum.link.port.occupied":
        {
            "zh": u"\n仲裁链路[ID:%s]对应的端口与主机端口[ID:%s]共用。",
            "en": "\nQuorum link [ID:%s] and host share the same port [ID:%s]."
        },
    "failed.query.replication.link.ports":
        {
            "zh": u"\n查询复制链路[ID:%s]信息失败。",
            "en": "\nFailed to query the infomation of replication link[ID:%s]."
        },
    "failed.query.link.ports":
        {
            "zh": u"\n查询端口[ID:%s]信息失败。",
            "en": "\nFailed to query the infomation of port[ID:%s]."
        },

    "pair.inconsistent.work.controllers":
        {
            "zh": u"\n双活pair[%s]中主从端LUN的工作控制器不一致。",
            "en": "\nThe working controllers of the primary and secondary LUNs for HyperMetro pair [%s] are different."
        },
    "exist.Non-Huawei.vendor":
        {
            "zh": u"\n双活pair[%s]中主从端LUN均为外部LUN且至少一端存在异构阵列为非华为厂商设备。",
            "en": "\nIn HyperMetro pair [%s], both the primary and secondary LUNs are external LUNs, "
                  "and at least one end is a non-Huawei device."
        },
    "pair.inconsistent.dedupEnabled":
        {
            "zh": u"\n双活pair[%s]中主从端LUN的Dedup Enabled不一致。",
            "en": "\nThe Dedup Enabled of the primary and secondary LUNs for HyperMetro pair [%s] are different."
        },
    "pair.inconsistent.compressionEnabled":
        {
            "zh": u"\n双活pair[%s]中主从端LUN的Compression Enabled不一致。",
            "en": "\nThe Compression Enabled of the primary and secondary LUNs for HyperMetro pair [%s] are different."
        },
    "exist.external.array":
        {
            "zh": u"\n双活pair[%s]中至少有一端是外部LUN。",
            "en": "\nIn HyperMetro pair [%s], at least one end is external LUN."
        },
    "not.add.remote.device.again":
        {
            "zh": u"\n未添加远端设备(SN:%s)，请添加远端设备后再执行巡检。",
            "en": "\nRemote device (SN: %s) is not added. Add the remote device and perform the inspection again."
        },
    "hyMetro.consis.initiator.wwn.not.consistence":
        {
            "zh": u"\n双活Pair两端映射的主机启动器信息不一致%s，详细信息(远端设备SN:%s)：\n    本端LUN[ID：%s]映射给主机[ID：%s]，"
                  u"启动器为(WWN/IQN): %s；\n    远端LUN[ID：%s]映射给主机[ID：%s]，启动器(WWN/IQN)为:%s。",
            "en": "\nHost initiators mapped to both ends of a HyperMetro pair are different%s. "
                  "The details are as follows(The remote device is [SN: %s]):\n    "
                  "Local LUN [ID: %s] is mapped to host [ID: %s]. The initiator(WWN/IQN) is %s.\n    "
                  "Remote LUN [ID: %s] is mapped to host [ID: %s]. The initiator(WWN/IQN) is %s."
        },
    "hyMetro.consis.initiator.wwn.not.consistence.old.version":
        {
            "zh": u"\n双活Pair两端映射的主机启动器信息不一致，详细信息(远端设备SN:%s)：\n    "
                  u"本端LUN[ID：%s]映射给主机[ID：%s]，启动器为(WWN/IQN): %s；\n    远端LUN[ID：%s]映射给主机[ID：%s]，"
                  u"启动器(WWN/IQN)为:%s。",
            "en": "\nHost initiators mapped to both ends of a HyperMetro pair are different. "
                  "The details are as follows(The remote device is [SN: %s]):\n    "
                  "Local LUN [ID: %s] is mapped to host [ID: %s]. The initiator(WWN/IQN) is %s.\n    "
                  "Remote LUN [ID: %s] is mapped to host [ID: %s]. The initiator(WWN/IQN) is %s."
        },
    "hyMetro.consis.initiator.wwn.not.consistence.old.version.local.configed":
        {
            "zh": u"\n    远端LUN[ID：%s]映射的主机未在本端阵列上配置，主机信息(启动器WWN/IQN)：%s。本端LUN[ID：%s]。",
            "en": "\n    Hosts mapped by remote LUN [ID: %s] are not configured on the local storage array. "
                  "Host information(initiator WWN/IQN): %s. Local LUN [ID: %s]."
        },
    "hyMetro.consis.initiator.wwn.not.consistence.old.version.remote.configed":
        {
            "zh": u"\n    本端LUN[ID：%s]映射的主机未在远端阵列上配置，主机信息(启动器WWN/IQN)：%s。远端LUN[ID：%s]。",
            "en": "\n    Hosts mapped by local LUN [ID: %s] are not configured on the remote storage array. "
                  "Host information(initiator WWN/IQN):%s. Remote LUN [ID: %s]."
        },
    "hyMetro.consis.initiator.wwn.not.consistence.old.version.title":
        {
            "zh": u"\n双活Pair两端映射的主机启动器信息不一致%s，详细信息(远端设备SN:%s)：%s",
            "en": "\nHost initiators mapped to both ends of a HyperMetro pair are different%s. "
                  "The details are as follows(The remote device is [SN: %s]):%s"
        },
    "hyMetro.consis.hostOper":
        {
            "zh": u"\n双活Pair两端映射的主机操作系统类型不一致：本端主机[ID：%s]为%s，远端主机[ID：%s]为%s，远端设备[SN:%s]。",
            "en": "\nThe operating system types of hosts mapped to both ends of the HyperMetro pair are different. "
                  "The operating system type of local host [ID: %s] is %s, and that of remote host [ID: %s] is %s. "
                  "The remote device is [SN: %s]."
        },
    "hyMetro.consis.initiator.config":
        {
            "zh": u"\n双活Pair两端映射的主机启动器信息不一致(远端设备SN:%s)：%s",
            "en": "\nHost initiators mapped to both ends of "
                  "a HyperMetro pair are different(The remote device is [SN: %s]). %s"
        },
    "hyMetro.consis.hostlunid":
        {
            "zh": u"\n本地主机[ID:%s]与远端主机[ID:%s]属于同一Pair，但是Host LUN "
                  u"ID不一致（详见“原始信息”），请确认实际主机操作"
                  u"系统类型是否为VMware，如果是则按"
                  u"修复建议整改，否则请忽略 ，远端设备SN:%s。查询VMware主机版本"
                  u"信息的命令是：vmware -vl。",
            "en": "\nLocal host [ID: %s] and remote host [ID: %s] belong to the "
                  "same HyperMetro pair. However, the values of Host LUN ID are "
                  "different (For details in \"Original Information\"). Check "
                  "whether the host operating system type is VMware. "
                  "If yes, rectify the fault based on the "
                  "suggestions. Otherwise, ignore it. The remote device is "
                  "[SN: %s].The vmware -vl command is used to query the VMware "
                  "host version."
        },
    "hyMetro.consis.hostlunid.doradov6":
        {
            "zh": u"\n本地主机[ID:%s]与远端主机[ID:%s]"
                  u"属于同一Pair，但是Host LUN "
                  u"ID不一致（详见“原始信息”），请确认实际主机操作"
                  u"系统类型是否为VMware，如果是则按"
                  u"修复建议整改，否则请忽略 ，远端设备SN:%s。"
                  u"查询VMware主机版本"
                  u"信息的命令是：vmware -vl。",
            "en": "\nLocal host [ID: %s] and remote"
                  " host [ID: %s] belong to the "
                  "same HyperMetro pair. However, "
                  "the values of Host LUN ID are "
                  "different (For details in \"Original Information\")."
                  " Check whether the host operating system type is VMware."
                  " If yes, rectify the fault based on the "
                  "suggestions. Otherwise, ignore it. The remote device is "
                  "[SN: %s].The vmware -vl command is"
                  " used to query the VMware host version."
        },

    "hyMetro.consis.hostlunid.title":
        {
            "zh": u"\n本端存储(SN:%s),双活远端设备(SN:%s)\n本地主机与远端主机属于同一Pair，但是Host LUN ID不一致:%s",
            "en": "\nLocal storage (SN: %s), remote HyperMetro device(SN: %s)\nLocal host and remote"
                  " host belong to the same HyperMetro pair. However, the values of Host LUN ID "
                  "are different %s:"
        },

    "hyMetro.consis.hostlunid.brief":
        {
            "zh": u"\n本地主机[ID:%s]与远端主机[ID:%s]属于同一Pair，但是Host LUN "
                  u"ID不一致[本地LUN ID：%s，远端LUN ID：%s]。",
            "en": "\nLocal host [ID: %s] and remote host [ID: %s] belong to the "
                  "same HyperMetro pair. However, the values of Host LUN ID are "
                  "different [Local Host Lun ID:%s, Remote Host Lun ID:%s]."
        },

    "hyMetro.consis.unmapped.hypermetro.lun.local":
        {"zh": u"\n本端设备未映射给主机的双活LUN（LUN ID）如下：%s。",
         "en": "\nThe active-active LUNs on local device that are not mapped to the host are(LUN ID):%s."
         },
    "hyMetro.consis.unmapped.hypermetro.lun.remote":
        {"zh": u"\n远端设备[SN：%s]未映射给主机的双活LUN如下(LUN ID)：%s。",
         "en": "\nThe active-active LUNs on remote device[SN:%s] that are not mapped to the host are(LUN ID): %s."
         },
    "hyMetro.consis.initiator.offline.title":
        {
            "zh": u"\n双活两端映射的主机启动器均处于离线状态，请确认以下启动器是否正在使用：%s",
            "en": "\nHost initiators at both ends of the HyperMetro pair are Offline. "
                  "Check whether the following initiators are in use:%s"
        },
    "hyMetro.consis.initiator.offline":
        {
            "zh": u"\n    本端主机[ID：%s]，远端主机[ID：%s]，启动器[WWN/IQN:%s]，远端设备[SN:%s]。",
            "en": "\n    Local host [ID: %s], remote host [ID: %s], initiator[WWN/IQN: %s], remote device [SN: %s]."
        },
    "hyMetro.consis.initiator.config.hpux":
        {
            "zh": u"\n主机[ID:%s]操作系统为HP-UX，且在双活两端阵列上启动器的Running Status不一致，"
                  u"请手动确认是主机无IO导致还是主机到阵列的链路异常导致。其中对端设备SN:%s, 对端主机ID:%s。",
            "en": "\nFor host [ID: %s], the operating system is HP-UX, "
                  "and the values of Running Status for initiators on storage devices at the two HyperMetro ends "
                  "are inconsistent. Check whether the exception occurs due to the absence of host I/Os or a link "
                  "error between the host and storage device. The peer storage device is SN: %s, "
                  "and the peer host ID is %s."
        },
    "hyMetro.consis.acces.model.not.pass":
        {
            "zh": u"\n    本端主机(ID:%s)的Access Mode为[%s]，远端主机(ID:%s)Access Mode为[%s]",
            "en": "\n    The access mode of the local host (ID: %s) is [%s], and the access mode of "
                  "the remote host (ID: %s) is [%s]."
        },
    "hyMetro.consis.acces.model.not.pass.title":
        {
            "zh": u"\n本端存储(SN:%s)和双活远端设备(SN:%s)存在主机Access Mode配置不一致:",
            "en": "\nThe host access modes of the local storage (SN: %s) and remote HyperMetro device "
                  "(SN: %s) are inconsistent:"
        },
    "fileid.nodetree.overproof.threshold":
        {"zh": u"\n以下文件系统[ID:%s]分配树节点数已超过阈值。",
         "en": "\nOn the following file systems [ID: %s], "
               "the number of nodes allocated in the node tree exceeds the threshold."
         },
    "please.contact.engineers.to.confirm.risk":
        {"zh": u"，请联系技术工程师确认是否有风险",
         "en": ", contact technical support engineers to check whether risks exist"
         },
    "not.turned.fclink":
        {"zh": u"\n以下链路ID[%s]为8G带宽FC链路，且立即数开关未打开。",
         "en": "\nThe link ID[%s] is an 8 GB/s Fibre Channel link, and the Fast Write Enable function is disabled",
         },
    "cannot.get.info.gang":
        {
            "zh": u"\n无法获取GANG块详细信息。",
            "en": "\nFailed to obtain details about the GANG block."
        },
    "gang.check.not.pass":
        {
            "zh": u"\nGANG块检查不通过的文件系统ID:%s。",
            "en": "\nThe GANG block checks for the following file system IDs are not passed: %s."
        },
    "gang.disk_hot_patch_version": {
        "zh": u"\n热补丁版本{}可能有相关风险！",
        "en": "\nHot patch version {} may have related risks!",
    },
    "connect.controller.failed":
        {
            "zh": u"\n部分控制器连接失败，请手动检查。",
            "en": "\nSome controllers fail to be connected. Check the connection manually."
        },
    "not.add.remote.device.again.isInSvp":
        {
            "zh": u"\n当前在SVP设备内由于无法连接远端设备，会导致“双活一致性”相关巡检项的检查结果为“未完成检查”。请在SVP设备外使用工具单独执行“双活一致性”相关巡检项。",
            "en": '\nThe check results of the HyperMetro check items are Not completed because the remote device '
                  'fails be added to the SVP. Perform the check items '
                  'of "HyperMetro information consistency" outside the SVP.'
        },
    "arbitration.single.link":
        {
            "zh": u"\n设备SN（%s）未配置仲裁链路。",
            "en": '\nNo quorum server link is configured on device (SN: %s).'
        },
    "IP.network.error":
        {
            "zh": u"\n设备SN（%s）中端口[ID:%s]的有效IP网段相同。",
            "en": '\nOn device (SN: %s), ports [ID:%s] have the same valid IP network segment.'
        },
    "member.disk.list.only.one.controller":
        {
            "zh": u"\n引擎[%s]只有一个控制器。",
            "en": "\nEngine [%s] has only one controller."
        },
    "member.disk.list.engine.fault":
        {
            "zh": u"\n引擎[%s]的健康状态不为Normal。",
            "en": "\nThe health status of engine [%s] is not Normal."
        },
    "member.disk.list.engine.offine":
        {
            "zh": u"\n引擎[%s]的运行状态不为Online。",
            "en": "\nThe running status of engine [%s] is not Online."
        },
    "member.disk.list.controller.fault":
        {
            "zh": u"\n控制器[%s]的健康状态不为Normal。",
            "en": "\nThe health status of controller [%s] is not Normal."
        },
    "member.disk.list.controller.offine":
        {
            "zh": u"\n控制器[%s]的运行状态不为Online。",
            "en": "\nThe running status of controller [%s] is not Online."
        },
    "member.disk.list.domain.fault":
        {
            "zh": u"\nDisk domain[%s]的健康状态不为Normal。",
            "en": "\nThe health status of disk domain [%s] is not Normal."
        },
    "member.disk.list.domain.offine":
        {
            "zh": u"\nDisk domain[%s]的运行状态不为Online。",
            "en": "\nThe running status of disk domain [%s] is not Online."
        },
    "member.disk.list.controller.disk.num":
        {
            "zh": u"\n引擎[%s]中控制器[%s]与控制器[%s]的Config Disk Num值不同",
            "en": "\nIn engine [%s], controller [%s] and controller [%s] have different Config Disk Num values."
        },
    "member.disk.list.controller.disk.list":
        {
            "zh": u"\n引擎[%s]中控制器[%s]与控制器[%s]的Config Disk List值不同",
            "en": "\nIn engine [%s], controller [%s] and controller [%s] have different Config Disk List values."
        },
    "member.disk.list.controller.disk.list.and.num":
        {
            "zh": u"\n引擎[%s]中控制器[%s]的Config Disk List包含的盘数量和Config Disk Num值不同",
            "en": "\nThe number of disks included in Config Disk List of engine [%s] controller [%s] is different "
                  "from the value of Config Disk Num."
        },
    "dm.patch.too.old":
        {
            "zh": u"\n当前补丁版本（%s）不满足扩容要求。",
            "en": "\nThe current patch version (%s) does not meet the expansion requirements."
        },
    "ssd.not.support.sys.version":
        {
            "zh": u"\n当前系统软件版本（%s）不满足扩容要求。",
            "en": "\nThe current system version (%s) does not meet the expansion requirements."
        },
    "ssd.not.support.patch.version":
        {
            "zh": u"\n当前补丁版本（%s）不满足扩容要求。",
            "en": "\nThe current patch version (%s) does not meet the expansion requirements."
        },
    "expand.disk.number.not.pass":
        {
            "zh": u"\n引擎间扩容硬盘数量不一致。",
            "en": '\nThe number of the disks to be added are different on engine.'
        },
    "expand.disk.capacity.not.pass":
        {
            "zh": u"\n引擎间扩容硬盘容量不一致。",
            "en": '\nThe capacity values of the disks to be added are different On engine.'
        },
    "expand.disk.type.not.pass":
        {
            "zh": u"\n新扩容硬盘类型与扩容硬盘域中的硬盘类型不一致。",
            "en": '\nThe type of the disks to be added is different from the type '
                  'of the existing disks in the disk domain.'
        },
    "expand.disk.dualengine.not.pass":
        {
            "zh": u"\n硬盘域（ID：%s）内的相同容量类型盘个数在引擎间不相同。",
            "en": '\nThe number of disks of the same capacity in the disk '
                  'domain(ID: %s) is different among different engines.'
        },
    "expand.disk.capacity.scale1.not.pass":
        {
            "zh": u"\n新扩容硬盘容量(硬盘容量：%sGB)小于原系统硬盘容量（硬盘容量：%sGB）。",
            "en": '\nCapacity (disk capacity: %sGB) of the disks to be added is smaller than the capacity '
                  '(disk capacity: %sGB) of existing disks in the system.'
        },
    "expand.disk.capacity.scale2.not.pass":
        {
            "zh": u"\n新扩容硬盘容量(硬盘容量：%sGB)不等于原硬盘域中最大的硬盘容量（硬盘容量：%sGB）。",
            "en": '\nCapacity (disk capacity: %sGB) of the disks to be added does not equal the maximum capacity '
                  '(disk capacity: %sGB) of existing disks in the disk domain.'
        },
    "expand.disk.capacity.scale3.not.pass":
        {
            "zh": u"\n新扩容硬盘容量(硬盘容量：%sGB)不等于原硬盘域中的硬盘容量（硬盘容量：%sGB）。",
            "en": '\nCapacity (hard disk capacity: %sGB) of the disks to be added does not equal the capacity '
                  '(disk capacity: %sGB) of existing disks in the disk domain.'
        },
    "expand.disk.number.scale.not.pass":
        {
            "zh": u"\n引擎（引擎ID：CTE%s）上新扩硬盘数量（%s）超过了系统硬盘最大支持规格（%s）。",
            "en": '\nOn engine(engine ID:CTE%s), the number of disks to be added (%s) exceeds the threshold (%s).'
        },
    "expand.disk.number.scale.max.not.pass":
        {
            "zh": u"\n引擎（引擎ID：CTE%s）上新扩硬盘数量（%s）超过了系统可扩容硬盘的最大数量（%s）。",
            "en": "\nOn engine(engine ID:CTE%s), the number of disks (%s) to be added exceeds the "
                  "maximum number of disks (%s) that can be added to the system."
        },
    "device.no.normal.engines":
        {"zh": u"\n设备不存正常引擎，请联系技术工程师协助处理。",
         "en": "\nNo normal engine exists on the device. Contact technical support engineers.",
         },
    "device.no.normal.controller":
        {"zh": u"\n设备不存在正常硬盘域，请联系技术工程师协助处理。",
         "en": "\nNo normal disk domain exists on the device. Contact technical support engineers.",
         },
    "device.no.normal.error":
        {"zh": u"\n设备存在内部错误，请联系技术工程师协助处理。",
         "en": "\nInternal error exists on the device. Contact technical support engineers.",
         },
    "device.has.storagepool.error":
        {"zh": u"\n设备存在StoragePool容量未耗尽提前中断业务的风险。",
         "en": "\nServices may be interrupted before the storage pool capacity is exhausted.",
         },
    "device.has.possible.storagepool.error":
        {"zh": u"\n若设备不对硬盘域扩容，则无提前中断业务的风险；若设备对硬盘域扩容，则设备存在StoragePool容量未耗尽提前中断业务的风险。",
         "en": "\nIf the capacity of disk domains is not expanded, services will not be interrupted. "
               "If the capacity of disk domains is expanded, "
               "services may be interrupted before the storage pool capacity is exhausted.",
         },
    "check.expandbay.type.not.pass":
        {
            "zh": u"\n当前设备类型（%s）不支持（%s）控扩容至（%s）控。",
            "en": '\nThe current device type (%s) does not support '
                  'capacity expansion from %s controllers to %s controllers.'
        },
    "check.expand.single.engine.disk.number1.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：CTE%s）的新扩硬盘(硬盘类型：%s)数量小于4块（当前数量：%s）。",
            "en": '\nThe number of disks to be added on engine(disk domain ID:%s, '
                  'engine ID:CTE%s, disk type:%s) is less than 4(current disk number: %s).'
        },
    "storage.query.hyperMetro.mapped.lun.failed":
        {"zh": u"\n查询双活LUN配置信息失败。",
         "en": "\nFailed to query the HyperMetro LUN configuration information.",
         },
    "follow.aa.lun.not.discovered.on.hosts":
        {
            "zh": u"\n如下双活LUN（ID）未在添加的主机中匹配，"
                  u"无法查询ALUA配置正确性，1.请确认双活主机是否未使用Veritas "
                  u"DMP多路径接管LUN；2.请确认双活主机多路径配置是否正确；3."
                  u"若符合以上两点，请添加对应主机执行巡检操作： \n%s。"
                  u"\n修复建议：请参考《OceanStor Dorado 6.x & OceanStor 6.x（或华为SAN存储）在xx(主机类型)下的主机连通性指南》"
                  u"检查存储和多路径配置。若有任何疑问，请联系技术工程师处理。",
            "en": "\nThe following HyperMetro LUNs (IDs) are not detected on "
                  "the added hosts, and the ALUA configuration correctness "
                  "cannot be checked:1. Check whether the related hosts use "
                  "Veritas DMP to take over LUNs.2. Check whether the "
                  "multipathing software configurations of the related hosts "
                  "are correct.3. If any host does not use Veritas DMP to "
                  "take over LUNs or its multipathing software configuration "
                  "is incorrect, add the host and perform the inspection "
                  "again: \n%s.\nRecovery Suggestion:Check the storage and "
                  "multipathing configurations by referring to the OceanStor "
                  "Dorado 6.x & OceanStor 6.x or Huawei SAN storage Host Connectivity Guide for xx (Host Type)."
                  " If you have any questions, contact technical support.",
        },
    "3rdmutipath.hyper.metro.config.sugg":
        {
            "zh": u"\n修复建议：请参考《OceanStor Dorado 6.x & OceanStor 6.x在xx(主机类型)下的主机连通性指南》"
                  u"检查存储和多路径配置。若有任何疑问，请联系技术工程师处理。",
            "en": "\nRecovery Suggestion:Check the storage and "
                  "multipathing configurations by referring to the OceanStor "
                  "Dorado 6.x & OceanStor 6.x Host Connectivity Guide for xx (Host Type)."
                  " If you have any questions, contact technical support.",
        },
    "controller.num.warning.sugg":
        {
            "zh": u"\n修复建议：为保证性能建议扩控成一致后配置双活业务。",
            "en": "\nRecovery Suggestion:To ensure performance, you are advised "
                  "to configure active-active services after controller expansion.",
        },
    "fs.type.diff.sugg":
        {
            "zh": u"\n修复建议：双活文件系统的应用类型不一致，请调整为一致，建议联系技术支持工程师协助。",
            "en": "\nRecovery Suggestion:The application types of the HyperMetro "
                  "file systems are inconsistent. Change them to be consistent."
                  " Contact technical support for assistance.",
        },
    "check.expand.single.engine.disk.number2.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：CTE%s）的新扩硬盘(硬盘类型：%s)数量小于6块（当前数量：%s）且非SSD类型硬盘数量小于8块（当前数量：%s）。",
            "en": '\nThe number of ssd disks to be added on engine(disk domain ID:%s, engine ID:CTE%s, '
                  'disk type:%s) is less than 6(current disk number: %s) and '
                  'non-ssd disks(current disk number: %s) less than 8.'
        },
    "check.expand.sysversion.not.pass":
        {
            "zh": u"\n建议升级到%s或之后的系统版本（当前系统版本：%s）。",
            "en": "\nYou are advised to upgrade the system of %s or a later version(current system version: %s)."
        },
    "check.expand.hot.patch.not.pass":
        {
            "zh": u"\n建议安装%s或之后版本热补丁（当前补丁版本：%s）。",
            "en": "\nYou are advised to install the hot patch of %s or a later version(current patch version: %s)."
        },
    "expand.disk.capacity.exceed.specification":
        {
            "zh": u"\n原扩容引擎（引擎ID：CTE%s）的硬盘容量（%sTB）超过了最大规格（%sTB）。",
            "en": "\nThe Expand engine(engine ID:CTE%s)disk capacity(%sTB)exceed the max capacity(%sTB)."
        },
    "device.has.enclosureId.error":
        {
            "zh": u"\n该设备存在无效硬盘框号%s，请联系技术工程师协助处理。",
            "en": "\nInvalid disk enclosure ID %s exists on the device."
                  "Contact technical support engineers.",
        },
    "exp.diskdomain.check.fail":
        {
            "zh": u"\n引擎%s上的硬盘域（ID：%s）不支持同时扩容三种类型的硬盘。",
            "en": "\nOn engine %s, three types of disks in disk domain (ID: %s) cannot be added at the same time.",
        },
    "check.expand.engine.disk.capacity1.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同类型硬盘（硬盘类型：%s）容量超过2种。",
            "en": '\nThe capacity of disks to be added the same type on engine(disk domain ID:%s, '
                  'engine ID:%s, disk type:%s) exceed 2.'
        },
    "check.expand.engine.new.disk.capacity.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩硬盘（硬盘类型：%s）容量超过1种。",
            "en": '\nThe capacity of disks to be added on engine(disk domain ID:%s, engine ID:%s, '
                  'disk type:%s) exceed 1.'
        },
    "check.expand.engine.disk.number.less.threshold1.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同类型硬盘（硬盘类型：%s）数量（硬盘数量:%s）"
                  u"小于截断阈值（截断阈值：%s）。",
            "en": '\nThe number of disks to be added the same type on engine(disk domain ID:%s, engine ID:%s, '
                  'disk type:%s, disk quantity:%s) is less than truncation threshold(truncation threshold:%s).'
        },
    "check.expand.engine.disk.number.less.threshold2.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同"
                  u"类型硬盘（硬盘类型：%s）数量（硬盘数量:%s）小于截断阈"
                  u"值（截断阈值：%s）。",
            "en": '\nThe number of disks to be added on engine(disk domain '
                  'ID:%s, engine ID:%s, disk type:%s, disk quantity:%s) is '
                  'less than truncation threshold(truncation threshold:%s).'
        },
    "check.expand.disk.number.exceed.30":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）"
                  u"的新扩同类型硬盘（硬盘类型：%s）数量（硬盘数量:%s）"
                  u"大于等于30。",
            "en": '\nThe number of disks to be added on engine('
                  'disk domain ID:%s, engine ID:%s, disk type:%s, '
                  'disk quantity:%s) is is greater than or equal to 30.'
        },
    "check.expand.engine.disk.number.exceeded.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的已有硬盘（硬盘类型：%s，硬盘数量:%s）数量"
                  u"与同类型新扩硬盘数量（硬盘数量:%s）总和超过64块。",
            "en": '\nThe total number of current disks on engine(disk domain ID:%s, engine ID:%s, disk type:%s, '
                  'disk quantity:%s) and disks to be added(disk quantity:%s) exceed 64.'
        },
    "failed.to.get.disk.info":
        {
            "zh": u"\n无法获取硬盘信息（硬盘ID:%s），请确认硬盘是否正常。",
            "en": '\nCannot get information about disk (disk_id:%s),Check whether the diskt is normal.'
        },
    "failed.to.get.disk.electronic.label.info":
        {
            "zh": u"\n无法获取硬盘电子标签信息（硬盘ID:%s）。",
            "en": '\nCannot get information about disk electronic.label(disk_id:%s).'
        },
    "failed.to.get.encloure.cte0.info":
        {
            "zh": u"\n无法获取控制框信息（ID:CTE0），请确认控制框是否正常。",
            "en": '\nCannot get information about controller enclosure (id:CTE0),Check whether the enclosure is normal.'
        },
    "failed.to.get.encloure.cte0.electronic.label.info":
        {
            "zh": u"\n无法获取控制框电子标签信息（ID:CTE0）。",
            "en": '\nCannot get information about controller enclosure electronic label(id:CTE0).'
        },
    "check.dorado.expand.disk.orinsystem.capacity.not.mapping.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的硬盘（硬盘类型：%s）容量（硬盘容量:%s）不符合硬盘容量类型要求，"
                  u"满足条件的硬盘容量有:%s。",
            "en": '\nThe capacities of disks to be added on engine(disk domain ID:%s, engine ID:%s, disk type:%s, '
                  'disk capacity:%s) do not meet the capacity expansion requirements. '
                  'The required disk capacities are: %s.'
        },
    "check.dorado.expand.disk.capacity.not.mapping.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同类型硬盘（硬盘类型：%s）容量（硬盘容量:%s）"
                  u"不符合硬盘容量类型要求，满足条件的硬盘容量有:%s。",
            "en": '\nThe capacities of disks to be added on engine(disk domain ID:%s, engine ID:%s,'
                  ' disk type:%s, disk capacity:%s) do not meet the capacity expansion requirements. '
                  'The required disk capacities are: %s.'
        },
    "check.dorado.expand.disk.capacity.recomm.not.mapping.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同类型硬盘（硬盘类型：%s）容量（硬盘容量:%s）"
                  u"不符合硬盘容量类型要求",
            "en": '\nThe capacities of disks to be added on engine(disk domain ID:%s, engine ID:%s, '
                  'disk type:%s, disk capacity:%s) do not meet the capacity expansion requirements.'
        },
    "check.dorado.expand.disk.number.lessthan.configer.not.pass":
        {
            "zh": u"\n硬盘域（硬盘域ID：%s）所在引擎（引擎ID：%s）的新扩同类型硬盘（硬盘类型：%s）数量（硬盘数量:%s）"
                  u"不满足最小起扩盘数（最小起扩盘数：%s）。",
            "en": '\nThe number of disks to be added on engine(disk domain ID:%s, engine ID:%s, disk type:%s, '
                  'disk quantity:%s) is less than the Min expansion number(Min expansion number:%s).'
        },
    "contr.bois.memory.version.less":
        {
            "zh": u"\n设备型号为%s；BIOS版本为%s，小于10.01.07T36。",
            "en": "\nThe device model is %s. The BIOS version is %s, which is earlier than 10.01.07T36."
        },
    "no.quorum.link.configured":
        {
            "zh": u"\n设备（SN:%s）未配置仲裁链路。",
            "en": "\nNo quorum server link is configured on device (SN: %s)."
        },
    "ddr4.arm.board.bios.version":
        {
            "zh": u"\n当前系统为2600 V3 V300R005C00SPC300，控制器BIOS版本是10.01.01T58，控制器内存为DDR4。",
            "en": "\nThe current system is 2600 V3 V300R005C00SPC300. The controller BIOS version is 10.01.01T58, "
                  "and the controller memory is DDR4."
        },
    "alua.exist.alua.multipathType":
        {
            "zh": u"\n系统存在多路径类型为ALUA的启动器，不支持扩容操作。",
            "en": "\nThe system has an initiator that its multipath type is "
                  "ALUA who does not support capacity expansion."
        },
    "alua.host.error":
        {
            "zh": u"\n获取启动器信息失败。",
            "en": "\nFailed to obtain the initiator information."
        },
    "alua.host.error.config":
        {
            "zh": u"\n请按照检查方法检查以下主机配置是否正确，如果配置都正确请忽略该检查：",
            "en": "\nPlease perform the host check manually based on the check procedure. "
                  "If the configuration is correct, skip this check item:"
        },
    "alua.host.info":
        {
            "zh": u"\n主机ID：%s，操作系统：%s",
            "en": "\nHost ID: %s, Operating System: %s"
        },
    "enclosure.version.hds.ses.lower":
        {
            "zh": u"\n高密框[ID:%s]固件版本过低，请联系技术工程师协助处理。",
            "en": "\nThe firmware version of the high-density enclosure[ID:%s] "
                  "is too early and contact technical support engineers."
        },
    "raid.level.config.error":
        {
            "zh": u"\n以下存储池中的Nearline SAS盘或SATA盘的RAID级别 不为RAID6，存储池 ID列表为：%s。",
            "en": "\nThe RAID levels of near-line SAS or SATA disks in the following storage pools are not RAID6: %s."
        },
    "cannot.get.cascading.depth":
        {
            "zh": u"\n获取级联深度失败。",
            "en": "\nFailed to get cascading depth."
        },
    "cannot.get.disk.enclosure":
        {
            "zh": u"\n获取硬盘框失败。",
            "en": "\nFailed to get the disk enclosure."
        },
    "commom.high-density.enclosures.mixed":
        {
            "zh": u"\nSAS环路（%s）存在普通硬盘框与高密框混插。",
            "en": "\nBoth commom and high-density disk enclosures exist in SAS loops (%s)."
        },
    "cascading.depth.exceeding":
        {
            "zh": u"\nSAS环路（%s）级联深度为%i，超过最佳配置%i。",
            "en": "\nSAS Loop (%s) cascading depth is %i, exceeding best configuration (%i)."
        },
    "cascading.depth.exceeding.5x10":
        {
            "zh": u"\n框号（%s）所在sas环路级联深度为%i，超过最佳配置%i。",
            "en": "\nThe cascading depth of SAS loop where subrack (%s) resides is %i, "
                  "exceeding best configuration (%i)."
        },
    "cascading.depth.exceeding.warning.suggest":
        {
            "zh": u"\n修复建议：硬盘框级联深度非推荐配置，请联系技术工程师调整硬盘框级联深度。",
            "en": "\nRecovery Suggestion: The disk enclosure cascading depth is not recommended. "
                  "Contact technical support "
                  "to adjust the disk enclosure cascading depth."
        },
    "disk.bad.sector.record.suggest":
        {
            "zh": u"\n修复建议：使用硬盘健康分析工具检查硬盘健康度，如果有硬盘健康度较低，联系技术工程师进行处理；"
                  u"使用信息收集工具搜集阵列日志，联系技术工程师确认有无不可修复坏道等风险。",
            "en": "\nRecovery Suggestion: Use the hard disk health analysis tool to check the hard disk health"
                  " status. If the hard disk health status is low, contact technical support. Use the information"
                  " collection tool to collect disk array logs and contact technical support engineers to check "
                  "whether there are risks such as unrepairable bad sectors."
        },
    "multi.bond.check.sugg.install.patch":
        {
            "zh": u"\n修复建议：当前版本为：%s, 请安装补丁：%s。",
            "en": "\nRecovery Suggestion:The current version is %s. Install the patch %s."
        },
    "multi.bond.check.sugg.no.patch":
        {
            "zh": u"\n修复建议：请联系技术支持工程。",
            "en": "\nRecovery Suggestion: Contact technical support engineers."
        },
    "disk.domain.hotspare.strategy.warning.sugg":
        {
            "zh": u"\n修复建议：热备策略推荐值为High，请联系技术支持工程师进行处理。",
            "en": "\nRecovery Suggestion: The recommended value of hot spare policy is High. "
                  "Contact technical support."
        },
    "disk.domain.create.strategy.warning.sugg":
        {
            "zh": u"\n修复建议：硬盘域中所有的硬盘同引擎，且硬盘域中同类型硬盘的转速和容量相同（保险箱盘除外），"
                  u"请联系技术支持工程师进行处理",
            "en": "\nRecovery Suggestion:If all disks in the disk domain share the same engine, "
                  "and disks of the same type (except coffer disks) in the disk domain have the same "
                  "rotational speed and capacity, contact technical support.."
        },
    "lun.controller.owner.inconsistent":
        {
            "zh": u"\nLUN[%s]的工作控制器与归属控制器不一致。\n修复建议：归属控制器和工作控制器不一致，"
                  u"请联系技术支持工程师进行处理。",
            "en": "\nThe work controller of the LUN [%s] is inconsistent with the owner controller."
                  " \nRecovery Suggestion:If the home controller is inconsistent with the working controller, "
                  "contact technical support.",
        },
    "disk.domain.usage.warning.sugg":
        {
            "zh": u"\n修复建议：重新规划硬盘域和存储池（同一硬盘域下的业务类型相同）。",
            "en": "\nRecovery Suggestion: Replan the disk domain and storage pool (the service types "
                  "in the same disk domain are the same)."
        },
    "share.nfs.warning.sugg":
        {
            "zh": u"\n修复建议：推荐所有NFS共享的Lock Type配置为Mandatory。",
            "en": "\nRecovery Suggestion: You are advised to set Lock Type to Mandatory for all NFS shares."
        },
    "fs.snap.warning.sugg":
        {
            "zh": u"\n修复建议：如果确定不使用文件系统快照功能，可以执行如下命令:change file_system "
                  u"general file_system_id=ID snapshot_reserve=0（ID为不使用文件系统快照功能的文件系统的ID）"
                  u"，将文件系统的快照预留比例改成0，以提高文件系统的空间利用率。",
            "en": "\nRecovery Suggestion: If you do not want to use the file system snapshot function, "
                  "run the change file_system general file_system_id=ID snapshot_reserve=0 command. "
                  "(ID indicates the ID of the file system that does not use the file system snapshot "
                  "function.) Change the snapshot reservation ratio of the file system to 0 to improve"
                  " the space utilization of the file system."
        },
    "file.system.type.not.Thin":
        {
            "zh": u"\n以下文件系统类型不为Thin：\n%s\n修复建议：如果考虑空间利用率，并且文件系统尚未部署业务，"
                  u"建议删除对应的文件系统重建，并且将文件系统类型指定为Thin，以此来提高空间利用率。",
            "en": "\nThe types of the following file systems are not Thin:\n%s.\nRecovery Suggestion: If the "
                  "space usage is considered and services are not deployed in the file system, you are "
                  "advised to delete the file system and set the file system type to Thin to improve "
                  "the space usage."
        },
    "show.service.ndmp.ip.not.pass":
        {
            "zh": u"IP当前设置为%s，建议优化。\n修复建议：执行命令change service ndmp_config ip=0.0.0.0，"
                  u"修改IP为0.0.0.0。\n",
            "en": "The current value of IP is %s, and an optimization is recommended.\nRecovery Suggestion: "
                  "Run the change service ndmp_config ip=0.0.0.0 command to change the IP address to 0.0.0.0.\n"
        },
    "show.service.ndmp.isSnapShotSupport.not.pass":
        {
            "zh": u"Support Snapshot当前配置为%s，建议优化。\n修复建议：执行命令：change user_mode "
                  u"current_mode user_mode=developer, 进入developer模式;change service ndmp_config "
                  u"support_snapshot=yes, 修改Support Snapshot为yes。\n",
            "en": "The current value of Support Snapshot is %s, and an optimization is recommended."
                  "\nRecovery Suggestion: Run change user_mode current_mode user_mode=developer. "
                  "To change Support Snapshot to yes, run change service ndmp_config support_snapshot=yes.\n"
        },
    "show.service.ndmp.isCTimeIgnored.not.pass":
        {
            "zh": u"Ignore CTime当前配置为%s，建议优化。\n修复建议：执行命令：change service ndmp_config "
                  u"ignore_ctime=no,修改Ignore CTime为no。\n",
            "en": "The current value of Ignore CTime is %s, and an optimization is recommended. "
                  "\nRecovery Suggestion: Run the change service ndmp_config ignore_ctime=no command to "
                  "change Ignore CTime to no.\n"
        },
    "following.cifs.share.ids.need.to.be.optimized":
        {
            "zh": u"\n如下CIFS Share ID对应配置需要优化：\n%s。\n修复建议：执行命令：change share cifs "
                  u"share_id=[ID] notify_enabled=yes，修改Notify Enabled  为Enable。\n",
            "en": "\nConfigurations corresponding to the following CIFS share IDs need to be optimized:\n %s."
                  "\nRecovery Suggestion:Run the change share cifs share_id=[ID] notify_enabled=yes command to "
                  "change Notify Enabled to Enable.\n"
        },
    "show.service.cifs.isSigningRequired.not.pass":
        {
            "zh": u"Signing Required当前设置为%s，建议优化。\n修复建议：执行命令change service cifs "
                  u"signing_required_enabled=no ，修改Signing Required为No。\n",
            "en": "The current value of Signing Required is %s, and an optimization is recommended."
                  "\nRecovery Suggestion:Run the change service cifs signing_required_enabled=no command to "
                  "change Signing Required to No.\n"
        },
    "show.service.cifs.isSigningEnabled.not.pass":
        {
            "zh": u"Signing Enabled当前设置为%s，建议优化。\n修复建议：执行命令：change service cifs "
                  u"signing_enabled=no ，修改Signing Enabled为No。\n",
            "en": "The current value of Signing Enabled is %s, and an optimization is recommended.\n"
                  "Recovery Suggestion:Run the change service cifs signing_enabled=no command to "
                  "change Signing Enabled to No.\n"
        },
    "show.service.cifs.isNotifyEnabled.not.pass":
        {
            "zh": u"Notify Enabled当前设置为%s，建议优化。\n修复建议：执行命令：change service "
                  u"cifs notify_enabled=yes，修改Notify Enabled  为Yes。\n",
            "en": "The current value of Notify Enabled is %s, and an optimization is recommended.\n"
                  "Recovery Suggestion:Run the change service cifs notify_enabled=yes command to "
                  "set Notify Enabled to Yes.\n"
        },
    "following.host.alua.config.need.opimize":
        {
            "zh": u"如下hostID对应主机的ALUA配置建议优化：\n %s。\n修复建议：请参考《华为SAN存储在xxx下的主"
                  u"机连通性指南》进行检查存储和多路径配置。\n",
            "en": "You are advised to optimize the host ALUA configuration corresponding to the following values "
                  "of hostID:\n %s.\nRecovery Suggestion:Check the storage and multipathing configurations by "
                  "referring to the Huawei SAN Storage Host Connectivity Guide in xxx.\n"
        },
    "3rdmutipath.hyper.metro.config.sugg.oceanstor":
        {
            "zh": u"\n修复建议：请参考《华为SAN存储在在xxx下的主"
                  u"机连通性指南》进行检查存储和多路径配置。\n",
            "en": "\nRecovery Suggestion:Check the storage and multipathing configurations by "
                  "referring to the Huawei SAN Storage Host Connectivity Guide in xxx.\n"
        },
    "hypermetro.pair.preference.inconsistent":
        {
            "zh": u"\n如下双活pair ID对应Role字段配置为 Preferred：\n%s；\n如下双活pair ID对应Role字段配置为 "
                  u"Non-preferred：\n%s。\n修复建议：对不一致的双活pair需要用户确认对应是否存在数据依赖，"
                  u"如存在数据依赖，需要将Role修改为一致，具体修改方法为：1.1. SAN双活执行change "
                  u"hyper_metro_pair priority pair_id=[ID]命令切换优先站点；1.2. NAS双活执行"
                  u"change hyper_metro_vstore_pair general pair_id=[ID] preferred_mode=manual "
                  u"preferred_site=[SITE]命令切换优先站点。如果对数据一致性有要求，建议将对应双活pair添加到一致性组。",
            "en": "\nThe Role field corresponding to the following HyperMetro pair ID(s) is set to "
                  "Preferred:\n%s;\nThe Role field corresponding to the following HyperMetro pair ID(s) "
                  "is set to Non-preferred:\n%s.\nRecovery Suggestion:For inconsistent HyperMetro pairs,"
                  " you need to check whether data dependency exists. If data dependency exists, change"
                  " Role to the same value. The modification method is as follows: 1. Run the change "
                  "hyper_metro_pair priority pair_id=[ID] command to switch the preferred site. Run "
                  "the change hyper_metro_vstore_pair general pair_id=[ID] preferred_mode=manual "
                  "preferred_site=[SITE] command to switch the preferred site. If data consistency is "
                  "required, you are advised to add the corresponding HyperMetro pair to the consistency group."
        },
    "storage.pool.disk.num.check.suggestion":
        {
            "zh": u"\n存储池[ID:%s]成员盘数量大于或等于所在硬盘域的硬盘个数，请配置存储池RAID策略成员盘数"
                  u"量小于所在硬盘域的硬盘个数。\n修复建议：建议配置存储池RAID策略成员盘数量小于所在硬盘域的硬盘个数",
            "en": "\nThe number of member disks in storage pool [ID:%s] is greater than or equal to "
                  "the number of disks in its disk domain. Configure the number of member disks of "
                  "the RAID policy for the storage pool to a value that is smaller than the number of disks "
                  "in its disk domain.\nRecovery Suggestion:It is recommended that the number of "
                  "member disks in the RAID policy of the storage pool be less than the number of "
                  "disks in the disk domain."
        },
    "write.policy.suggestion":
        {
            "zh": u"\n下列异构LUN的写策略为%s，需要设置为%s。Lun ID：%s",
            "en": "\nFor heterogeneous LUN, the write policy is %, which needs to be set to %s.Lun ID: %s."
        },
    "write.policy.suggestion.write.through":
        {
            "zh": u"\n修复建议：执行命令change lun write_policy=write_through lun_id=%s\n",
            "en": "\nRecovery Suggestion:Run the change lun write_policy=write_through lun_id=%s command.\n"
        },
    "write.policy.suggestion.write.back":
        {
            "zh": u"\n修复建议：执行命令change lun write_policy=write_back lun_id=?。Lun Id:%s\n",
            "en": "\nRecovery Suggestion:Run the change lun write_policy=write_back lun_id=? command."
                  " Lun Id:%s\n"
        },
    "exit.risky.host":
        {
            "zh": u"\n风险主机[ID:%s]与主机[ID:%s]间共用端口[ID:%s]。\n修复建议：请参考《华为SAN存储"
                  u"在xxx下的主机连通性指南》进行检查存储和多路径配置。\n",
            "en": "\nRisky host [%s] and hosts [%s] share port [%s].\nRecovery Suggestion:Check the "
                  "storage and multipathing configurations by referring to the Huawei SAN Storage Host "
                  "Connectivity Guide in xxx.\n",
        },
    "disk.domain.pool.type.check.suggestion":
        {
            "zh": u"\n硬盘域[ID:%s]下创建了多种类型（块存储和文件存储）的存储池，"
                  u"建议使用不同硬盘域分别创建用于块存储业务或者文件存储业务的存储池。",
            "en": "\nIn disk domain [ID: %s], multiple types of storage pools (block storage and file storage) "
                  "are created. You are advised to create storage pools for block storage services or file "
                  "storage services using different disk domains."
        },
    "remote_lun_single_link.no.links":
        {
            "zh": u"\n远端LUN[WWN:%s]无异构链路，请参考《SmartVirtualization特性指南》确认组网是否正确，如果不正确请重新组网，"
                  u"否则请联系技术工程师协助处理。",
            "en": "\nRemote LUN [WWN: %s] has no heterogeneous links. Check whether the networking is correct "
                  "by referring to the SmartVirtualization Feature Guide. If the networking is incorrect, "
                  "configure networking again. If the networking is correct, contact technical support engineers."
        },
    "remote_lun_single_link.no.other.links":
        {
            "zh": u"\n远端LUN[%s]无冗余异构链路，请检查异构链路是否正常。",
            "en": "\nRemote LUN [%s] does not have redundant heterogeneous links."
                  " Check whether its heterogeneous links are all normal."
        },
    "fc.link.fast.write.error":
        {
            "zh": u"\n以下FC端口ID对应的FC链路Fast Write开关未打开，ID：%s。",
            "en": "\nThe Fast Write switches of the FC links corresponding "
                  "to the following FC port IDs are not enabled: %s."
        },
    "fc.link.fast.write.error.sugg":
        {
            "zh": u"\n修复建议："
                  u"存在相同端口ID，请确认存储阵列是否为拉远场景，"
                  u"若为拉远场景（10KM以上推荐打开，25KM以上强制要求打开），"
                  u"请以admin用户登录设备，执行命令：change port fc fc_port_id="
                  u"端口ID（步骤3与步骤5中相同的端口ID）fast_write_enable=yes"
                  u"打开立即数开关。",
            "en": "\nRecovery Suggestion:The same port ID exists"
                  ", check whether the storage array is deployed"
                  " remotely. If yes, check whether the storage array is "
                  "deployed remotely. (If the distance is greater than 10 km,"
                  " this function is recommended. If the distance is greater "
                  "than 25 km, this function is mandatory.), log in to the"
                  " device as the admin user and run the change port fc "
                  "fc_port_id=Port ID command. (The port ID in step 3 is "
                  "the same as that in step 5.) fast_write_enable=yes Enable"
                  " the immediate data function."
        },
    "iscsi.link.fast.write.error":
        {
            "zh": u"\n以下ISCSI链路ID的Fast Write开关未打开，ID：%s。",
            "en": "\n2.The Fast Write switches of the iSCSI links with the "
                  "following IDs are not enabled: %s."
        },
    "iscsi.link.fast.write.error.sugg":
        {
            "zh": u"\n修复建议：存在“Fast Write Enabled”字段值为“NO”的"
                  u"iSCSI链路，请确认存储阵列是否为拉远场景，若为拉远场景"
                  u"（10KM以上推荐打开，25KM以上强制要求打开），请以admin用户"
                  u"登录设备，执行命令：change remote_device link link_type=iSCSI"
                  u" link_id=ID（步骤6中记录 “ID”字段值） fast_write_enabled=yes"
                  u"打开立即数开关",
            "en": "\nRecovery Suggestion:"
                  "An iSCSI link whose Fast Write Enabled is NO"
                  ", check whether the storage array is remotely deployed. "
                  "If yes, check whether the storage array is remotely deployed. "
                  "(If the distance is greater than 10 km, this function is "
                  "recommended. If the distance is greater than 25 km, "
                  "this function is mandatory.), log in to the device as "
                  "the admin user and run the change remote_device link "
                  "link_type=iSCSI link_id=ID command. (Record the value of "
                  "the ID field in Step 6.) fast_write_enabled=yes Enable"
                  " the immediate data function."
        },
    "storage.pool.disk.num.check.connect.to.controller.failed":
        {
            "zh": u"\n连接控制器失败（若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的"
                  u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择存储池硬盘冗余数量检查进行巡检）。",
            "en": "\nFailed to connect to the controller. If the device model is any of 18000 series, "
                  "install SmartKit of the latest version on the SVP where the device is installed or install SmartKit "
                  "of the latest version and add the current device again by referring to the FAQ "
                  "\"Configuring the Access of Tools Outside the SVP of the High-End Storage System\", "
                  "and select Checking the Number of Redundant Disks in a Storage Pool for an inspection."
        },
    "exp.ctrl.patch.ver.error":
        {
            "zh": u"\n当前设备补丁版本（%s）不支持扩容。",
            "en": "\nThe current patch version (%s) does not support capacity expansion."
        },
    "exp.ctrl.sys.ver.error":
        {
            "zh": u"\n当前设备版本（%s）不支持扩容。",
            "en": "\nThe product version (%s) does not support capacity expansion."
        },
    "exp.ctrl.sys.ver.null":
        {
            "zh": u"\n当前设备未安装补丁，不支持扩容。",
            "en": "\nNo patch is installed on the device, and capacity expansion is not supported."
        },
    "hyMetro.consis.local.and.remote.value":
        {
            "zh": u"\n    %s的本地主机[ID：%s]值为%s，远端主机[ID：%s]值为%s。",
            "en": "\n    The value of %s for local host [ID: %s] is %s, and that for remote host [ID: %s] is %s."
        },
    "exp.lun.sys.ver.error":
        {
            "zh": u"\n当前设备版本（%s）不支持LUN扩容。",
            "en": "\nThe product version (%s) does not support capacity expansion of LUNs."
        },
    "check.expand.engine.disk.is.small":
        {
            "zh": u"\n新扩容硬盘（所在引擎：%s，所在硬盘域：%s，硬盘类型：%s）的容量（%s）小于设备已存在硬盘的最小容量（%s），不允许扩容。",
            "en": "\nFor new disk (engine: %s; disk domain: %s; disk type: %s), its capacity (%s) is smaller "
                  "than the minimum capacity (%s) of existing disks on the device. Capacity expansion is not allowed."
        },
    "controller.barcode.risk":
        {
            "zh": u"\n控制器[%s]固件版本过低，长期运行控制器故障概率增加，请联系技术支持工程师进行处理。",
            "en": "\nThe firmware version of controller [%s] is an early version, "
                  "which may increase the failure rate of the controller after running for a long time. "
                  "Please contact technical support engineers for help."
        },
    "exp.hotpatch.ver.error":
        {
            "zh": u"\n当前设备版本（%s）不满足扩容条件，请安装%s及以后的补丁。",
            "en": "\nThe product version (%s) does not meet the capacity expansion requirements. "
                  "Install %s or a later patch."
        },

    "exp.domain.disk.version.error":
        {
            "zh": u"\n当前设备版本（%s）或补丁版本（%s）不满足扩容条件。",
            "en": "\nThe current device version (%s) or patch version (%s) "
                  "does not meet the capacity expansion requirements. "
        },
    "exp.domain.disk.multi.capacity.error":
        {
            "zh": u"\n不支持同一个硬盘域（Disk Domain ID: %s）同时扩容多种容量的硬盘（Capacity(GB)：%s）。"
                  u"如有任何疑问，请联系技术支持工程师协助处理。",
            "en": "\nIn disk domain (Disk Domain ID: %s), "
                  "disks of different capacities (Capacity(GB): %s) cannot be added. "
                  "If you have any questions, contact technical support engineers."
        },
    "exp.domain.disk.capacity.error":
        {
            "zh": u"\n硬盘域（Disk Domain ID: %s）已经拥有如下容量的硬盘类型（Capacity(GB)：%s），"
                  u"不支持扩容新指定的硬盘（Capacity(GB)：%s）。",
            "en": "\nIn disk domain (Disk Domain ID: %s), disks of the following capacities (Capacity(GB): %s) exist. "
                  "You cannot add the specified disk (Capacity(GB): %s)."
        },
    "hypermetro.quorum.consistence.sn.diff":
        {
            "zh": u"\n双活域[ID:%s]使用的仲裁服务器不一致。本端仲裁服务器SN[%s], 远端仲裁服务器SN[%s]。",
            "en": "\nThe quorum servers used in the HyperMetro domain [ID: %s] are inconsistent. "
                  "The local quorum server SN is [%s], and the remote quorum server SN is [%s]."
        },
    "hypermetro.quorum.consistence.no.server":
        {
            "zh": u"\n双活域[ID:%s]未配置仲裁服务器。",
            "en": "\nNo quorum server is configured in HyperMetro domain [ID: %s]."
        },
    "hypermetro.quorum.consistence.static.mode":
        {
            "zh": u"\n双活域[ID:%s]配置了仲裁服务器，但仲裁模式为静态优先模式。",
            "en": "\nHyperMetro domain [ID: %s] is configured with a quorum server, "
                  "but the value of Quorum Mode is Static Priority."
        },
    "hypermetro.quorum.consistence.no.server.and.not.static":
        {
            "zh": u"\n双活域[ID:%s]未配置仲裁服务器，且仲裁模式不为静态优先模式。",
            "en": "\nHyperMetro domain [ID: %s] is not configured with a quorum server, "
                  "and the value of Quorum Mode is not Static Priority."
        },
    "hypermetro.quorum.consistence.name.local.null":
        {
            "zh": u"\n双活域[ID:%s]仲裁服务器名称对端不为空，本端为空。",
            "en": "\nIn HyperMetro domain [ID: %s], the remote quorum server name is not null, "
                  "while the local quorum server name is null."
        },
    "hypermetro.quorum.consistence.name.remote.null":
        {
            "zh": u"\n双活域[ID:%s]仲裁服务器名称本端不为空，对端为空。",
            "en": "\nIn HyperMetro domain [ID: %s], the local quorum server name is not null, "
                  "while the remote quorum server name is null."
        },
    "hypermetro.quorum.consistence.server.mode.diff":
        {
            "zh": u"\n双活域[ID:%s]两端仲裁服务器的仲裁模式不同。",
            "en": "\nThe two quorum servers used in HyperMetro domain [ID: %s] have different values of Quorum Mode."
        },
    'disk.model.firmware.risk':
        {
            'zh': u'\n硬盘[ID:%s]的Model字段值为%s，且Firmware Version字段值小于%s。',
            'en': '\nThe value of Model for disk [ID: %s] is %s, and the value of Firmware Version is smaller than %s.'
        },
    'disk.model.firmware.risk.new':
        {
            'zh': u'\n硬盘[ID:%s]的Model字段值为%s，且Firmware Version字段值等于%s。',
            'en': '\nThe value of Model for disk [ID: %s] is %s, and the value of Firmware Version is equal to %s.'
        },
    'disk.model.firmware.nas.risk':
        {
            'zh': u'\n硬盘[ID:%s]的Model字段值为%s，且Firmware Version字段值小于%s，且存在NAS文件系统。',
            'en': '\nThe value of Model for disk [ID: %s] is %s, the value of Firmware Version is smaller than %s, '
                  'and NAS file systems exist.'
        },
    'exit.risk.interface.modul':
        {
            'zh': u'\n当前系统软件版本为%s，且系统上存在以下类型的接口卡。请按修复建议处理。\n%s',
            'en': '\nThe current system software version is%s and the following types of interface cards exist '
                  'on the system. Please follow the repair recommendations.\n%s'
        },
    '8GFC.port.mor.abnormal':
        {
            'zh': u"\n系统当前存在如下8G FC做异构的端口FC MOR State"
                  u"状态为：Open。\n端口ID：%s。",
            'en': '\nFC MOR State of the following heterogeneous 8 '
                  'Gbit/s FC ports is Open.\nPort IDs:%s.'
        },
    '8GFC.port.mor.abnormal.no.open':
        {
            'zh': u"\n系统当前存在如下8G FC做异构的端口FC MOR State"
                  u"不存在。\n端口ID：%s。",
            'en': '\nFC MOR State does not exist for the following '
                  'heterogeneous 8 Gbit/s FC ports.\nPort IDs:%s.'
        },
    '8GFC.port.mor.err':
        {
            'zh': u"\n以下8G FC端口详细信息查询失败，请检查网络连接或稍后重试:\n%s",
            'en': "\nFailed to query the information of following 8G FC ports. "
                  "Check the network connection or try again later:\n%s"
        },
    "hypermetro.fs.cannot.get.filesystem.info":
        {
            "zh": u"\n无法获取下列文件系统信息[ID:%s],设备SN：%s",
            "en": "\nCannot get information about File System[ID:%s] on Device[SN:%s]",
        },
    "hypermetro.fs.some.info.consistency":
        {
            "zh": u"\n本端文件系统[ID:%s]和远端文件系统[ID:%s]的%s信息不一致，本端值：%s，远端值：%s。",
            "en": "\nFor local file system [ID: %s] and remote file system [ID: %s], "
                  "their %s values are different. Local: %s, remote: %s.",
        },
    'exp.tire.storage.pool.fail':
        {
            'zh': u"\n获取硬盘域（ID：%s）的存储池信息异常。",
            'en': '\nFailed to obtain information about storage pools in disk domain (ID: %s).'
        },
    'exp.tire.storage.pool.tier.fail':
        {
            'zh': u"\n获取硬盘域（ID：%s）的存储池层级信息异常。",
            'en': '\nFailed to obtain tier information about storage pools in disk domain (ID: %s).'
        },
    'exp.tire.hdd.disk.too.less':
        {
            'zh': u"\n在硬盘域%s上，新扩容的HDD（硬盘类型：%s）硬盘数量（数量：%s）不满足最小起扩盘数（数量：%s）。",
            'en': '\nIn disk domain %s, the number of HDDs (disk type: %s, quantity: %s) '
                  'to be added does not meet the minimum threshold (quantity: %s).'
        },
    'exp.tire.ssd.disk.too.less':
        {
            'zh': u"\n在硬盘域%s中，引擎%s上新扩容的SSD硬盘数量（数量：%s）不满足最小起扩盘数（数量：%s）。",
            'en': '\nIn disk domain %s, engine %s, the number of SSDs (quantity: %s) '
                  'to be added does not meet the minimum threshold (quantity: %s).'
        },
    'exp.tire.exp.disk.less':
        {
            'zh': u"\n在硬盘域%s中，引擎%s上新扩容的硬盘（类型：%s）数量（数量：%s）不满足最小起扩盘数（数量：%s）。",
            'en': '\nIn disk domain %s, engine %s, the number of disks (disk type: %s, quantity: %s) '
                  'to be added does not meet the minimum threshold (quantity: %s).'
        },
    'exp.tire.storage.pool.meta.tier.fail':
        {
            'zh': u"\n获取硬盘域（%s）最大RAID成员盘数异常。",
            'en': '\nFailed to obtain the maximum number of RAID member disks in disk domain (ID: %s).'
        },
    'domain.recommended.configuration.titile':
        {
            'zh': u"\n基于最佳实践，建议文件系统与LUN划分不同硬盘域。\n",
            'en': '\nBased on best practices, it is recommended that storage pools of the File System type '
                  'and the LUN type be divided into different disk domains.\n'
        },
    'pool.usage.type':
        {
            'zh': u"存储池[ID:%s]的Usage Type为%s。",
            'en': 'For storage pools [ID:%s], the Usage Type values are %s.'
        },
    'hypermetro.arbnetwork.config.link.not.up':
        {
            'zh': u"\n仲裁服务器[ID:%s]的仲裁链路[ID:%s]连接状态不为Link Up，设备[SN:%s]。",
            'en': '\nOn quorum server[ID:%s], the quorum link [ID: %s] connection status is not Link Up, device[SN:%s].'
        },
    'hypermetro.arbnetwork.config.link.not.up.sugg':
        {
            'zh': u"\n修复建议：请检查仲裁链路[ID:%s]连接是否正常。\n",
            'en': '\nRecovery Suggestion:Check whether the arbitration '
                  'link [ID: %s] is properly connected.\n'
        },
    'hypermetro.lun.configration.doradov6.diff.attr.sugg':
        {
            'zh': u"\n修复建议：建议将双活两端LUN的Dedup Enabled和Compression Enabled配置为一致，联系技术支持工程师协助。",
            'en': '\nRecovery Suggestion:You are advised to set the values of Dedup Enabled and Compression Enabled '
                  'for the LUNs at both ends of the HyperMetro pair to be the same. '
                  'Contact technical support for assistance.'
        },
    "hypermetro.arbnetwork.config.not.exit.quorum.server.link":
        {
            "zh": u"\n设备[SN:%s]的仲裁服务器[ID:%s]不存在仲裁链路。\n",
            "en": "\nOn device[SN:%s], the quorum server[ID:%s] has no quorum link exist.\n",
        },
    "hypermetro.arbnetwork.config.IP.network.error":
        {
            "zh": u"\n仲裁服务器[ID:%s]下所有仲裁链路的端口[ID:%s]的有效IP网段相同，设备[SN:%s]。",
            "en": '\nOn quorum server[ID:%s], ports [ID:%s] have the same valid IP network segment, device[SN:%s].'
        },
    "hypermetro.arbnetwork.config.IP.network.error.sugg":
        {
            "zh": u"\n修复建议：请重新配置IP网段后再添加仲裁链路。",
            "en": '\nRecovery Suggestion:Reconfigure the IP network segment and then add the arbitration link.'
        },
    "hypermetro.pool.health.status.abnorml":
        {
            "zh": u"\n设备（SN:%s）上的存储池（ID:%s）健康状态异常。",
            "en": "\nThe health status on the device (sn:%s) of storage pool (id:%s) is abnormal.",
        },
    "lun.edev.rmdev.info.faile":
        {"zh": u"\n获取远端设备（ID：%s）上的异构lun信息失败",
         "en": "\nThere is an error in getting information of heterogeneous LUN on the remote device(ID:%s)",
         },
    "lun.edev.wwn.info.faile":
        {"zh": u"\n获取异构lun（Lun WWN:%s）信息失败",
         "en": "\nThere is an error in getting information of heterogeneous LUN(Lun WWN:%s)",
         },
    "exp.hetero.lun.sys.patch.fail":
        {"zh": u"\n异构Lun数量和硬盘数量接近满规格，存在扩容失败风险，请升级到%s及以后的版本后再扩容，如有疑问请联系技术支持工程师协助处理。",
         "en": "\nIf the number of heterogeneous LUNs and the number of disks are close to the maximum specifications, "
               "capacity expansion may fail. Upgrade the system to %s or a later version and then expand the capacity. "
               "If you have any questions, contact technical support engineers.",
         },
    "exp.hetero.lun.sys.fail":
        {"zh": u"\n异构Lun数量和硬盘数量接近满规格，存在扩容失败风险，请升级到%s及以后的版本后再扩容，如有疑问请联系技术支持工程师协助处理。",
         "en": "\nIf the number of heterogeneous LUNs and the number of disks are close to the maximum specifications, "
               "capacity expansion may fail. Upgrade the system to %s or a later version and then expand the capacity. "
               "If you have any questions, contact technical support engineers.",
         },
    "exp.hetero.lun.patch.fail":
        {"zh": u"\n异构Lun数量和硬盘数量接近满规格，存在扩容失败风险，请安装%s及以后的补丁后再扩容，如有疑问请联系技术支持工程师协助处理。",
         "en": "\nIf the number of heterogeneous LUNs and the number of disks are close to the maximum specifications, "
               "capacity expansion may fail. Install the patch of %s or a later version and then expand the capacity. "
               "If you have any questions, contact technical support engineers.",
         },
    "check.disk.usage.warning":
        {
            "zh": u"\n控制器[%s]:平均磁盘利用率过高：%s%%。",
            "en": "\nAverage disk usage(%s%%) of controller [%s] is high.",
        },
    "check.disk.usage.no.check":
        {
            "zh": u"\n控制器[%s]:平均磁盘利用率查询失败。",
            "en": "\nFailed to query the average disk usage of controller [%s].",
        },
    "check.disk.userate.warning":
        {
            "zh": u"\n平均磁盘利用率过高：%s。",
            "en": "\nAverage disk usage(%s) is high.",
        },
    "check.disk.userate.warning.disktype":
        {
            "zh": u"\n%s盘平均磁盘利用率过高：%s。",
            "en": "\nAverage %s disk usage(%s) is high.",
        },
    "check.disk.userate.no.check":
        {
            "zh": u"\n平均磁盘利用率查询失败。",
            "en": "\nFailed to query the average disk usage.",
        },
    "cannot.get.disk.on.domain":
        {
            "zh": u"\n无法获取硬盘域（ID:%s）上的硬盘信息",
            "en": "\nCannot get disk information in disk domain(ID:%s)",
        },
    "unable.enter.debug.mode":
        {
            "zh": u"\n工具建立到控制器的SSH连接失败。你可按以下方式处理：\n1 请在SVP内运行工具，或安装最新工具箱后，参照工具箱的"
                  u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。\n2 若工具运行在SVP内，请恢复SVP到控制"
                  u"器的连接，然后重新检查。\n3 请联系技术工程师协助解决。",
            "en": "\nFailed to build SSH connections to controllers. You can perform the following operations: "
                  "\n1. Run "
                  "the tool on the SVP or install SmartKit of the latest version and add the current device again by "
                  "referring to the FAQ \"Configuring the Access of Tools Outside the SVP of the High-End Storage "
                  "System\", and select the current check item for an inspection again.\n2. Recover the connection "
                  "between the SVP and controllers, and perform a check again if the tool is running on the "
                  "SVP. \n3. Contact technical support engineers.",
        },
    "cannot.build.http.connections":
        {
            "zh": u"\n工具建立HTTP连接失败。你可按以下方式处理：\n1 请在SVP内运行工具，或安装最新工具箱后，参照工具箱的"
                  u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。\n2 请联系技术工程师协助解决。",
            "en": "\nFailed to build HTTP connections. You can perform the "
                  "following operations: \n1. Run the tool on the SVP or install SmartKit of the "
                  "latest version and add the current device again by referring to the FAQ \"Configuring"
                  " the Access of Tools Outside the SVP of the High-End Storage System\", and select "
                  "the current check item for an inspection again.\n"
                  "2. Contact technical support engineers.",
        },
    "cannot.build.http.connections.tlv":
        {
            "zh": u"\n工具建立HTTP连接失败。你可按以下方式处理：\n1 请在SVP内运行工具重新巡检。"
                  u"\n2 请联系技术工程师协助解决。",
            "en": "\nFailed to build HTTP connections. You can perform the "
                  "following operations: \n1. Run the tool in the SVP to perform the inspection again.\n"
                  "2. Contact technical support engineers.",
        },
    "cannot.get.hotpatch.xml":
        {
            "zh": u"\n无法找到热补丁文件productHotPatch.xml。",
            "en": "\nCan't find the file of hot-patch, productHotPatch.xml."
        },

    "expdd.errorcode.1073809960": {
        "zh": u"当前硬盘配置已经达到系统最大规格。单引擎硬盘可支持扩盘数（%s）。",
        "en": "The number of disks reaches the upper limit. The number of "
              "disks are allowed to be expanded on a single engine is (%s).",
    },
    "expdd.errorcode.1073809970": {
        "zh": u"即将扩入的硬盘加入硬盘域后，硬盘总个数与数据保护策略不匹配。",
        "en": "After the disks are added to the disk domain, the total number"
              " of disks does not match the data protection policy.",
    },
    "exp.storage.pool.error.code.1090587147": {
        "zh": u"License不存在,请购买并导入HyperEncryption软件许可。",
        "en": "The license does not exist. Purchase and import the HyperEncryption software license.",
    },
    "exp.storage.pool.error.code.1073810090": {
        "zh": u"控制框数量超过单个硬盘域支持的最大规格（%s个）。",
        "en": "The number of controller enclosures will exceed the upper limit (%s) supported by a disk domain.",
    },
    "exp.storage.pool.error.code.1073810165": {
        "zh": u"控制框数量超过单个性能层支持的最大规格（%s个）。",
        "en": "The number of controller enclosures has exceeded the upper limit (%s) supported by a "
              "single performance layer.",
    },
    "exp.storage.pool.error.code.1073810126": {
        "zh": u"硬盘域内某种类型硬盘的容量类型个数大于系统最高要求（类型：%s，数量：%s）。",
        "en": "The capacity type quantity of disks of a certain type (%s) in the disk domain has reached "
              "the upper limit (%s).",
    },
    "exp.storage.pool.error.code.1073797219": {
        "zh": u"硬盘的加密属性与所在性能层其他成员盘的加密属性不一致。",
        "en": "The encryption attribute of disks to be added is inconsistent with that of member disks in the "
              "performance layer.",
    },
    "exp.storage.pool.error.code.1073810154": {
        "zh": u"指定类型的硬盘不支持创建性能层或扩容。",
        "en": "Disks of the specified types do not support performance layer creation or capacity expansion.",
    },
    "exp.storage.pool.error.code.1073810155": {
        "zh": u"指定的盘列表包含异常盘。",
        "en": "The specified disk list contains abnormal disks.",
    },
    "exp.storage.pool.error.code.1073810156": {
        "zh": u"没有指定盘列表。",
        "en": "No disk list is specified.",
    },
    "exp.storage.pool.error.code.1073810158": {
        "zh": u"空闲盘数量不足。",
        "en": "The number of free disks is insufficient.",
    },
    "exp.storage.pool.error.code.1073810159": {
        "zh": u"指定的盘列表包含系统中不存在的硬盘。",
        "en": "The specified disk list contains disks that do not exist in the system.",
    },
    "exp.storage.pool.error.code.1073810160": {
        "zh": u"指定的盘列表包含非空闲盘。",
        "en": "The specified disk list contains non-free disks.",
    },
    "exp.storage.pool.error.code.1073810094": {
        "zh": u"该类型(%s)的硬盘数量达到单控制框所支持的最大个数(%s)。",
        "en": "The number of (%s) disks has reached the upper limit (%s) supported by a controller enclosure.",
    },
    "exp.storage.pool.error.code.1073810093": {
        "zh": u"SCM类型的硬盘不支持创建框级冗余的硬盘域。",
        "en": "SCM drives do not support disk domains with enclosure redundancy.",
    },
    "exp.storage.pool.error.code.1073810095": {
        "zh": u"硬盘域内每种类型的硬盘数不能小于系统规格(%s)。",
        "en": "The number of disks of each type in a disk domain cannot be less than the lower limit (%s).",
    },
    "exp.storage.pool.error.code.1073810114": {
        "zh": u"硬盘域内某种类型的硬盘数小于系统规格下限(类型：%s，数量：%s)。",
        "en": "The number of disks of a certain type in the disk domain is less than the lower "
              "limit (type: %s, quantity: %s).",
    },
    "exp.storage.pool.error.code.1073810118": {
        "zh": u"系统内成员盘总物理容量（%s）大于系统许可容量（%s）。",
        "en": "The total physical capacity (%s) of member disks in the system is greater than the licensed "
              "capacity (%s).",
    },
    "exp.storage.pool.error.code.1073810140": {
        "zh": u"创建或扩容成混闪硬盘域时，系统不支持打开重删开关。",
        "en": "The deduplication function cannot be enabled when you create or expand a disk domain into a hybrid "
              "flash disk domain.",
    },
    "exp.storage.pool.error.code.1073810143": {
        "zh": u"该控制框(名称：%s)上指定硬盘类型(%s)的硬盘数不足，无法创建指定热备硬盘数(%s)的性能层，还需要更多硬盘(数量：%s)才"
              u"能创建成功。",
        "en": "On this controller enclosure (name: %s),the number of disks of the specified type (%s) is "
              "insufficient.The performance tier of the specified number of hot spare disks (%s) cannot be created, "
              "More disks (number: %s) are required to create the performance tier.",
    },
    "exp.storage.pool.error.code.1077951772": {
        "zh": u"特性License开关关闭，请打开特性License开关。",
        "en": "The feature license is disabled. Enable the feature license and try again.",
    },
    "exp.storage.pool.error.code.1077951773": {
        "zh": u"License过期，请导入有效的License文件。",
        "en": "The license has expired. Import a valid license file and try again.",
    },
    "exp.storage.pool.error.code.1073810116": {
        "zh": u"创建或者扩容时指定了不支持混插的盘类型，只指定一种类型的盘或指定支持混插的盘类型。",
        "en": "A disk type that does not support mixed insertion is specified during "
              "creation or capacity expansion.Specify one or more types of disks that can be intermixed.",
    },
    "expdd.errorcode.1073809963": {
        "zh": u"对硬盘域执行扩容操作时，待扩容的盘扩入阵列后硬盘空间会被截断，"
              u"扩容操作失败。增加空闲盘数量，使得空闲盘数量不小于单引擎截断阈值"
              u"（%s），或是联系技术支持工程师。",
        "en": "A user fails to expand the capacity of a disk domain, when disk"
              " capacity truncation occurs after the disks to be added to the"
              " disk domain are connected to the storage array. Add free disks"
              " to ensure that the number of free disks is larger than or"
              " equal to the truncation threshold(truncation threshold:%s)"
              " on a single engine, or contact technical support engineers.",
    },
    "expdd.errorcode.50331651": {
        "zh": u"参数错误。请输入正确的参数。",
        "en": "The entered parameter is incorrect. Enter a correct parameter.",
    },
    "expdd.errorcode.1073797156": {
        "zh": u"\n扩盘的时候，待扩盘的型号与当前硬盘域中的盘不一致，导致扩硬盘失败。",
        "en": "\nA disk fails to be added to a disk domain, because the model"
              " of the disk is inconsistent with that of other disks in the"
              " disk domain.",
    },
    "expdd.errorcode.1077953176": {
        "zh": u"指定的硬盘域不存在。请指定有效的硬盘域ID。",
        "en": "The specified disk domain does not exist. Specify a valid"
              " disk domain ID.",
    },
    "expdd.errorcode.1077949019": {
        "zh": u"系统内部错误。请联系技术支持工程师。",
        "en": "The system has an internal error. Contact technical support"
              " engineers.",
    },
    "expdd.errorcode.1077949006": {
        "zh": u"系统繁忙。请稍后重试。",
        "en": "The system is busy. Try again later.",
    },
    "expdd.errorcode.1073809964": {
        "zh": u"大小盘混插时，待扩容的盘容量和硬盘域中相同类型硬盘的最大容量不一致。",
        "en": "When smaller-capacity disks intermix with larger-capacity disks"
              ", the capacity of the disks to be added to a disk domain is"
              " different from the maximum capacity of the disks of the same"
              " type in the disk domain. ",
    },
    "expdd.errorcode.1073809992": {
        "zh": u"硬盘域内的相同容量类型盘个数在引擎间不相同。执行硬盘域扩容命令时，"
              u"请确保硬盘域内的相同容量类型盘个数在引擎间相同。",
        "en": "The number of disks of the same capacity in the disk domain is"
              " different among different engines. When expanding the disk"
              " domain capacity, ensure that the number of disks of the same"
              " capacity in the disk domain is the same among different"
              " engines.",
    },
    "expdd.errorcode.1073809959": {
        "zh": u"硬盘域最多支持（%s）种不同硬盘容量类型。",
        "en": "The disk domain supports the maximum of (%s) disk"
              " capacity types.",
    },
    "expdd.errorcode.100990": {
        "zh": u"输入的盘容量不支持。",
        "en": "The entered capacities of disks are not allowed.",
    },
    "expdd.errorcode.100990.patch": {
        "zh": u"当前版本无法评估，请安装%s及以后的补丁后重新评估。",
        "en": "The current version can not be evaluated. Please install %s "
              "or a later patch and evaluate again.",
    },
    "expdd.errorcode.-1": {
        "zh": u"查询信息失败。请联系技术支持工程师。",
        "en": "Query information failed. Contact technical support engineers.",
    },
    "expdd.errorcode.1073810025": {
        "zh": u"根据当前引擎的数据缩减率和扩容后的硬盘域容量评估，扩容后的用户可写入"
              u"容量超系统有效容量规格（%s TB/双控）。",
        "en": "Based on the data reduction rate and disk domain capacity after"
              " capacity expansion on the engine, the amount of data written"
              " to the storage system exceeds the effective capacity of the"
              " storage system (%s TB per dual-controller).",
    },
    "exp.storage.pool.error.code.1077949099": {
        "zh": u"所指定的ID超过系统最大规格，重新指定一个规格范围内的ID。",
        "en": "The specified ID exceeds the upper limit of the system."
              "Specify another ID that does not exceed the upper limit.",
    },
    "exp.storage.pool.error.code.1073810148": {
        "zh": u"存储池性能层配额小于最小配额%s，修改指定配额值，推荐配额为%s。",
        "en": "The performance layer quota of the storage pool is less "
              "than the minimum quota %s.Change the value of the specified "
              "quota. The recommended quota is %s.",
    },
    "exp.storage.pool.error.code.1077953174": {
        "zh": u"指定类型的硬盘不支持创建硬盘域或扩容，在创建硬盘域或扩容时，请选择支持的硬盘类型。",
        "en": "The specified disk type does not support the disk domain "
              "creation or capacity expansion.Specify another disk type that "
              "supports the disk domain creation and capacity expansion.",
    },
    "exp.storage.pool.error.code.1073797227": {
        "zh": u"性能层分布硬盘框和容量层分布硬盘框重叠时，其中一层分布的硬盘框必须是另一层分布硬盘框的子集。",
        "en": "Disk enclosures where the performance or capacity layer resides "
              "must belong to that where the capacity or performance layer resides.",
    },
    "exp.storage.pool.error.code.-1": {
        "zh": u"查询信息失败。请联系技术支持工程师。",
        "en": "Query information failed. Contact technical support engineers.",
    },
    "exp.storage.pool.error.code.unknown": {
        "zh": u"扩容评估异常(错误码：%s)。请联系技术支持工程师。",
        "en": "Abnormal capacity expansion evaluation (error code: %s). "
              "Contact technical support engineers.",
    },
    "exp.storage.pool.error.code.50331651": {
        "zh": u"参数错误。",
        "en": "The entered parameter is incorrect.",
    },
    "exp.storage.pool.error.code.1073810069": {
        "zh": u"待扩容的硬盘数太少不满足系统性能要求。",
        "en": "The number of disks to be added is too small to meet the "
              "system performance requirements.",
    },
    "exp.storage.pool.error.code.1077948995": {
        "zh": u"系统繁忙。",
        "en": "The system is busy.",
    },
    "exp.storage.pool.error.code.1077949019": {
        "zh": u"系统内部错误。",
        "en": "The system has an internal error.",
    },
    "exp.storage.pool.error.code.1077953176": {
        "zh": u"指定的存储池(ID:%s)不存在。",
        "en": "The specified storage pool (ID:%s) does not exist.",
    },
    "exp.storage.pool.error.code.1073809960": {
        "zh": u"当前硬盘配置已经达到单引擎最大规格（%s）。",
        "en": "The current disk number reaches the maximum specifications(%s)"
              " of a single engine.",
    },
    "exp.storage.pool.error.code.1073810117": {
        "zh": u"当前存储池(ID:%s):硬盘(类型：%s)可用物理容量小于硬盘(类型：%s)可用物理容量的%s。",
        "en": "The disk number of storage pool (ID:%s):The available physical capacity of disk (type: %s) "
              "is less than %s "
              "of the available physical capacity of disk (type: %s).",
    },
    "exp.storage.pool.error.code.1073809970": {
        "zh": u"即将扩入的硬盘加入存储池(ID:%s)后，硬盘总个数与数据保护策略不匹配。",
        "en": "After the disks are added to the storage pool (ID:%s),"
              " the total number of disks does not match the data"
              " protection policy.",
    },
    "exp.storage.pool.error.code.1073809963": {
        "zh": u"对存储池(ID:%s)执行扩容操作时，待扩容的盘扩入阵列后硬盘空间会被"
              u"截断，扩容操作失败。",
        "en": "A user fails to expand the capacity of a storage pool (ID:%s),"
              " when disk capacity truncation occurs after the disks to be"
              " added to the storage pool are connected to the storage array.",
    },
    "exp.storage.pool.error.code.1073809964": {
        "zh": u"大小盘混插时，待扩容的盘容量和存储池(ID:%s)中相同类型硬盘的"
              u"最大容量不一致。",
        "en": "When smaller-capacity disks intermix with larger-capacity"
              " disks, the capacity of the disks to be added to a storage"
              " pool is different from the maximum capacity of the disks"
              " of the same type in the storage pool (ID:%s).",
    },
    "exp.storage.pool.error.code.1073809992": {
        "zh": u"存储池(ID:%s)内的相同容量类型盘个数在引擎间不相同。",
        "en": "The number of disks of the same capacity in the storage pool"
              " (ID:%s) is different among different engines.",
    },
    "exp.storage.pool.error.code.1073809959": {
        "zh": u"存储池(ID:%s)最多支持%s种不同硬盘容量类型。",
        "en": "The storage pool (ID:%s) supports the maximum of %s disk"
              " capacity types.",
    },
    "exp.storage.pool.error.code.1073797156": {
        "zh": u"扩盘的时候，待扩盘的型号与当前存储池(ID:%s)中的盘不一致，导致"
              u"扩硬盘失败。",
        "en": "A disk fails to be added to a storage pool, because the model"
              " of the disk is inconsistent with that of other disks in the"
              " storage pool (ID:%s).",
    },
    "exp.storage.pool.error.code.1073810027": {
        "zh": u"扩容后存储池(ID:%s)的总容量超过系统容量规格（%s），超过的容量"
              u"为（%s）。",
        "en": "The total capacity of storage pool (ID:%s) after expansion"
              " exceeds the system capacity specification (%s). The exceeded"
              " capacity is %s.",
    },
    "exp.storage.pool.error.code.1073810033": {
        "zh": u"扩容存储池(ID:%s)时，待扩硬盘所属的控制框上的存储池写入容量之和"
              u"已达到有效容量规格。",
        "en": "On the controller enclosure where a disk to be added belongs,"
              " the total amount of data written to storage pools (ID:%s) has"
              " reached the effective capacity specification.",
    },
    "exp.storage.pool.error.code.1073809993": {
        "zh": u"当前引擎上的硬盘域个数已达到最大规格%s个。",
        "en": "The number of disk domains on the current engine has reached the upper limit of %s.",
    },
    "exp.storage.pool.error.code.1073809929": {
        "zh": u"内双活扩容控制器新增引擎时，存储池(ID:%s)的成员盘数量不能小于16，"
              u"请先扩容存储池，再进行扩容控制器。",
        "en": "In scenarios where HyperMetro-Inner controllers are added,"
              " the number of member disks in storage pool (ID: %s) cannot"
              " be less than 16. Add controllers after expanding the capacity"
              " of the storage pool.",
    },
    "exp.storage.pool.error.code.1073810054": {
        "zh": u"对存储池(ID:%s)执行扩容操作时，待扩容的盘数太少不满足系统规格，"
              u"扩容评估失败。请增加空闲盘数量，使得空闲盘数量不小于eDesigner"
              u"扩容评估推荐页面上推荐的盘数，或是联系技术支持工程师。",
        "en": "When expanding the capacity of storage pool (ID: %s), capacity"
              " expansion evaluation fails because the number of disks to be"
              " added is too small, which does not meet the system"
              " specification. Add more idle disks to ensure that the number"
              " of idle disks in the storage pool is no less than that"
              " recommended on eDesigner, or, contact technical support"
              " engineers.",
    },
    "exp.storage.pool.error.code.1073810066": {
        "zh": u"存储池(ID:%s)扩容后将导致控制框（%s）上的存储池可用容量之和"
              u"超过可得容量规格。",
        "en": "After expanding the capacity of storage pool (ID: %s),"
              " the total available capacity of storage pools"
              " on the controller enclosure (%s) will exceed"
              " the effective capacity specification.",
    },
    "exp.storage.pool.error.code.1073810079": {
        "zh": u"扩容框级冗余存储池或性能层时，在硬盘框上选择的容量点的盘数小于系统规格。",
        "en": "When capacity expansion is performed for the enclosure "
              "redundancy storage pool or performance layer, the number of disks corresponding to "
              "the capacity value selected for the disk enclosure is less than"
              " the system specifications.",
    },
    "exp.storage.pool.error.code.1073810085": {
        "zh": u"扩容框级冗余存储池或性能层时，或者存储池扩盘时，选择不是第一级硬盘框。",
        "en": "When capacity expansion is performed for the enclosure "
              "redundancy storage pool or performance layer, or disks are added to the storage pool,"
              " a non-level-1 disk enclosure is selected.",
    },
    "exp.storage.pool.error.code.1073810083": {
        "zh": u"扩容框级冗余存储池或性能层时，选择的硬盘框不满足正反接组网。",
        "en": "When capacity expansion is performed for the enclosure "
              "redundancy storage pool or performance layer, the selected disk enclosure does not "
              "meet the forward and backward connection networking "
              "requirements.",
    },
    "exp.storage.pool.error.code.1073810081": {
        "zh": u"扩容框级冗余存储池或性能层时，硬盘框之间硬盘类型、个数、容量大小不一致。",
        "en": "When capacity expansion is performed for the enclosure "
              "redundancy storage pool or performance layer, disk types, quantity, and capacity of "
              "disk enclosures are different.",
    },
    "exp.storage.pool.error.code.1073810084": {
        "zh": u"扩容框级冗余存储池或性能层时，选择的硬盘框存在组网错误。",
        "en": "When capacity expansion is performed for the enclosure "
              "redundancy storage pool or performance layer, the networking of the selected disk "
              "enclosure is incorrect.",
    },
    "exp.storage.pool.error.code.1073810133": {
        "zh": u"性能层内的硬盘数不能小于最低规格（%s盘）",
        "en": "The number of disks in a performance layer cannot be less than the lower limit (%s).",
    },
    "exp.storage.pool.error.code.1077948996": {
        "zh": u"指定的对象不存在。",
        "en": "The specified object is unavailable.",
    },
    "exp.storage.pool.error.code.1073810164": {
        "zh": u"重删开关为打开状态。",
        "en": "The deduplication switch is enabled.",
    },
    "exp.storage.pool.error.code.1073797221": {
        "zh": u"硬盘域存在重删数据。",
        "en": "Deduplication data exists in the disk domain.",
    },
    "exp.storage.pool.error.code.1073810163": {
        "zh": u"硬盘域成员盘个数大于最大成员盘数（%s）。",
        "en": "The number of member disks in the disk domain exceeds the upper limit (%s)",
    },
    "exp.storage.pool.error.code.1073810124": {
        "zh": u"选取的硬盘(类型：%s)不支持在硬盘域内使用。",
        "en": "The selected disk (type: %s) cannot be used in the disk domain.",
    },
    "exp.storage.pool.error.code.1073810131": {
        "zh": u"创建或扩容硬盘域时，性能层部署节点没有包含硬盘域部署节点。",
        "en": "During disk domain creation or capacity expansion, the performance layer "
              "deployment node does not contain the disk domain deployment node.",
    },
    "exp.storage.pool.error.code.1073810138": {
        "zh": u"当前控制框上的性能层个数已达到最大规格（%s个）。",
        "en": "The number of performance layers on the current controller"
              " enclosure has reached the upper limit (%s).",
    },
    "exp.storage.pool.error.code.1073797213": {
        "zh": u"性能层最多支持%s种不同硬盘容量类型。",
        "en": "The performance layer supports a maximum of %s disk capacity types.",
    },
    "exp.storage.pool.error.code.1073797214": {
        "zh": u"相同容量类型的硬盘在引擎间个数不同。",
        "en": "The number of disks of the same capacity is different among engines.",
    },
    "exp.storage.pool.error.code.1073797210": {
        "zh": u"存在大小盘，发生容量截断。",
        "en": "Disks of different capacities are selected and capacity truncation occurs.",
    },
    "exp.storage.pool.error.code.1073810157": {
        "zh": u"大小盘混插时，待扩容的盘容量和性能层中相同类型硬盘的最大容量不一致。",
        "en": "The capacity of a disk to be added differs from the maximum "
              "capacity of the same type of disks in the performance layer when"
              " disks of different capacities are used.",
    },
    "expdd.storage.pool.error.code.100990": {
        "zh": u"输入的盘容量不支持。",
        "en": "The entered capacities of disks are not allowed.",
    },
    "expdd.storage.pool.error.code.100991": {
        "zh": u"不支持该种容量点的盘扩容。",
        "en": "Disk capacity expansion at this capacity point is not supported.",
    },
    "expdd.storage.pool.error.code.1073797220": {
        "zh": u"共享性能层需要部署在所有控制框上。",
        "en": "The shared performance layer must be deployed on all controller enclosures.",
    },
    "check.data.persistence.not.pass": {
        "zh": u"\n硬盘域（ID:%s）的Tier层级(%s)不满足数据持久度。",
        "en": "\nFor disk domain (ID: %s), its tier (%s) does not meet the"
              " data persistence requirement.",
    },
    "check.data.persistence.error":
        {
            "zh": u"\n检查数据持久度出错：硬盘域ID:%s，Tier层级：%s。",
            "en": "\nAn error occurred when data persistence is checked. The disk domain ID is %s, and the tier is %s.",
        },
    "check.utrapath.path.num.not.pass":
        {
            "zh": u"\n主机[ID:%s]到控制器[ID:%s]的路径数超过8条，路径数为[%s]。",
            "en": "\nThe number of paths from host [ID: %s] to controller [ID: %s] exceeds 8, "
                  "and the number of paths is [%s]."
        },
    'product.version.low':
        {
            'zh': u'\n当前存储版本号较低（版本号为：%s），请联系技术支持工程师，升级存储版本。',
            'en': '\nThe current storage version is too early (version: %s). '
                  'Contact technical support engineers to upgrade it.'
        },
    'cannot.get.hypervault .info':
        {
            'zh': u'\n无法获取一体化备份PAIR数量。',
            'en': '\nFailed to obtain the number of HyperVault pairs.'
        },
    'cannot.get.hyper.metro.pair .info':
        {
            'zh': u'\n无法获取双活PAIR数量。',
            'en': '\nFailed to obtain the number of file system remote replication pairs.'
        },
    'cannot.get.used.obj.info':
        {
            'zh': u'\n无法获取引擎[%s]中控制器[%s]的增值LOG分区使用数量。',
            'en': '\nIn engine [%s], the number of value-added LOG partitions used by controller [%s] '
                  'fails to be obtained.'
        },
    'exit.used.obj':
        {
            'zh': u'\n引擎[%s]中控制器[%s]的增值LOG分区使用数为%s，'
                  u'大于双活PAIR数加一体化备份PAIR数加文件远程复制PAIR数加128的值（%s）。',
            'en': '\nIn engine [%s], the number of value-added LOG partitions used by controller [%s] is %s, '
                  'which is larger than the value of HyperMetro pairs + HyperVault pairs + '
                  'File system remote replication pairs + 128 (%s).'
        },
    "connect.to.controller.failed.hypermetro":
        {"zh": u"\n连接控制器失败（若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的"
               u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择双活LOG分区资源检查进行巡检）。",
         "en": "\nFailed to connect to the controller. If the device model is any of 18000 series, "
               "install SmartKit of the "
               "latest version on the SVP where the device is installed or install "
               "SmartKit of the latest version and add "
               "the current device again by referring to the FAQ \"Configuring the Access of Tools Outside the SVP "
               "of the "
               "High-End Storage System\", and select Checking HyperMetro LOG Partition Resources for an inspection."
         },
    "ebk.log.level.risk":
        {
            "zh": u"\n控制器[%s]下的微服务%s日志级别不为Info。",
            "en": "\nOn controller [%s], the log level of the %s microservice is not Info."
        },
    "get.lun.copy.id.failed":
        {
            "zh": u"\n获取第%s个LUN拷贝ID失败。",
            "en": "\nFailed to obtain the ID of LUN copy %s."
        },
    "get.origin.lun.id.failed":
        {
            "zh": u"\n获取LUN拷贝[ID:%s]的源LUN ID失败，失败原因为：\n%s。",
            "en": "\nFailed to obtain the source LUN ID of LUN copy [ID: %s]. Cause:\n%s."
        },
    "origin.lun.id.not.exist":
        {
            "zh": u"\nLUN拷贝[ID:%s]的源LUN ID不存在。",
            "en": "\nThe source LUN ID of LUN copy [ID: %s] does not exist."
        },
    "get.work.controller.failed":
        {
            "zh": u"\n获取源LUN[ID:%s]的工作控制器字段值失败，失败原因为：\n%s。",
            "en": "\nFailed to obtain the value of Work Controller for source LUN [ID: %s]. Cause:\n%s."
        },
    "work.controller.not.exist":
        {
            "zh": u"\n源LUN[ID:%s]的工作控制器字段值不存在。",
            "en": "\nThe Work Controller field of source LUN [ID: %s] does not exist."
        },
    "exit.work.controller":
        {
            "zh": u"\n源LUN[ID:%s]的工作控制器为%s。",
            "en": "\nThe Work Controller of source LUN [ID: %s] is %s."
        },
    "storage.pool.disk.slot.check.connect.to.controller.failed":
        {
            "zh": u"\n连接控制器失败（若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的"
                  u"FAQ“高端存储SVP外工具接入配置指导”重新添加当前设备后选择硬盘槽位号一致性检查进行巡检）。",
            "en": "\nFailed to connect to the controller. If the device model is any of 18000 series, "
                  "install SmartKit of "
                  "the latest version on the SVP where the device "
                  "is installed or install SmartKit of the latest version "
                  "and add the current device again by referring to the FAQ "
                  "\"Configuring the Access of Tools Outside the"
                  " SVP of the High-End Storage System\", and select Checking the Consistency of Disk Slot IDs for "
                  "an inspection."
        },
    "software.disk.slot.consistency.not.pass":
        {
            "zh": u"\n控制器节点[%s]和控制器节点[%s]的硬盘[SN:%s]槽位号不一致，控制器节点[%s]槽位号为[%s],控制器节点[%s]槽位号为[%s]。",
            "en": "\nOn controller node [%s] and controller node [%s], the slot IDs of disk [SN: %s] are different. "
                  "The slot ID of controller node [%s] is [%s], and that of controller node [%s] is [%s]."
        },
    "meiguang.risk.sn.suggestion":
        {
            "zh": u"\n请升级至V300R006C10SPC100并安装V300R006C10SPH101及之后版本的补丁。",
            "en": "\nPlease upgrade the system to V300R006C10SPC100 "
                  "and install the patch of V300R006C10SPH101 or a later version."
        },
    "preinspect.cannot.execute.debug.cmd.errinfo":
        {
            "zh": u'\n若设备型号为18000系列高端存储，请在设备所在SVP上安装最新的巡检工具后或更新工具箱后参照工具箱的FAQ“高端存储'
                  u'SVP外工具接入配置指导”重新添加当前设备后选择当前检查项重新巡检。',
            "en": "\nIf the device model is any of 18000 series, install "
                  "SmartKit of the latest version on the SVP where "
                  "the device is installed or install SmartKit of the latest version "
                  "and add the current device again by "
                  "referring to the FAQ \"Configuring the Access of Tools Outside the SVP of the High-End Storage "
                  "System\", and select the current check item for an inspection again."
        },
    "get.external.lun.info.failed":
        {
            "zh": u"\n获取异构LUN[ID:%s]详细信息失败，失败原因为：\n%s。",
            "en": "\nFailed to obtain the info of external LUN [ID: %s]. Cause:\n%s."
        },
    "disk.num.low":
        {
            "zh": u"\n引擎[%s]下的硬盘数量为%s块，建议配置为大于或等于8块后再创建硬盘域。",
            "en": "\nThe number of disks in engine [%s] is %s. "
                  "You are advised to configure 8 or more disks before creating a disk domain."
        },
    "disk.num.zero":
        {
            "zh": u"\n硬盘数量为0，建议配置为大于或等于8块后再创建硬盘域。",
            "en": "\nThe number of disks is zero. "
                  "You are advised to configure 8 or more disks before creating a disk domain."
        },
    "software.arb.reserved.key.value.queryFailed":
        {
            "zh": u"\n查询硬盘仲裁预留key值失败。",
            "en": "\nFailed to query the reserved key value on the disk."
        },
    "software.arb.reserved.key.value.not.pass":
        {
            "zh": u"\n硬盘[ID:%s]预留key值[%s]与检查标准中对应槽位的仲裁预留key值不匹配。",
            "en": "\nThe reserved key value of disk [ID: %s] does not match the reserved key values[%s] "
                  "of those in the corresponding slots mentioned in the check criteria."
        },
    "software.arb.reserved.key.value.queryFailed.withDiskId":
        {
            "zh": u"\n查询硬盘[ID:%s]仲裁预留key值失败。",
            "en": "\nFailed to query the reserved key value on the disk[ID:%s]."
        },
    "expand.disk.move.sas.module.NVMe.morethanmax":
        {
            "zh": u"\nNVMe硬盘数量超过系统最大规格，请减少扩容的NVMe类型硬盘的数量再执行扩容操作。",
            "en": "\nThe number of NVMe disks exceeds the upper limit. "
                  "Reduce the number of added NVMe disks and then perform capacity expansion for the disk domain."
        },
    "expand.disk.move.sas.module.NVMe.morethanmax.result":
        {
            "zh": u"\n引擎（%s）原有NVMe硬盘数量总数（%s）加上新扩硬盘数量超过系统最大规格（%s）。",
            "en": "\nIn the engine (%s), there are %s existing NVMe disks.. "
                  "The number of existing NVMe disks and newly added disks in the engine exceeds the upper limit of %s."
        },
    "expand.disk.move.sas.module.NVMe.lessthanmin":
        {
            "zh": u"\n新建硬盘域NVMe硬盘数量低于系统最小规格，请增加扩容的NVMe类型硬盘的数量再执行扩容操作。",
            "en": "\nThe number of NVMe disks in the new disk domain is smaller than the lower limit. "
                  "Add NVMe disks and then perform capacity expansion for the disk domain."
        },
    "expand.disk.move.sas.module.NVMe.lessthanmin.result":
        {
            "zh": u"\n引擎（%s）原有NVMe硬盘数量总数（%s）加上新扩硬盘数量低于系统最小规格（%s）。",
            "en": "\nIn the engine (%s), there are %s existing NVMe disks.. "
                  "The number of existing NVMe disks and newly added disks "
                  "in the engine is smaller than the lower limit of %s."
        },
    "expand.disk.move.sas.module.needmove":
        {
            "zh": u"\n硬盘域所在的引擎1号槽位（%s）被4x12G SAS光电接口模块占用且有对称的空闲槽位,"
                  u"请使用最新工具进入扩容硬盘框流程，进行移动4x12G SAS光电接口模块操作后再执行扩容操作。"
                  u"请提前准备好PCIe Scale-up接口模块和一块4x12G SAS光电接口模块备件。",
            "en": "\nSlot 1 (%s) of the engine where the disk domain resides is occupied by the 4x12G SAS QSFP "
                  "interface module and has a symmetrical vacant slot. "
                  "You need to start the disk enclosure expansion procedure "
                  "(move the 4x12G SAS QSFP interface module and then add disk enclosures). "
                  "Prepare PCIe scale-up interface modules and one spare 4x12G SAS QSFP interface module."
        },
    "expand.disk.move.sas.module.needmove.result":
        {
            "zh": u"\n硬盘域所在的引擎1号槽位（%s）被4x12G SAS光电接口模块占用且有对称的空闲槽位,满足移卡条件",
            "en": "\nSlot 1 (%s) of the engine where the disk domain resides is occupied by the 4x12G SAS QSFP "
                  "interface module and has a symmetrical vacant slot, "
                  "meeting the conditions for moving the 4x12G SAS QSFP interface module."
        },
    "expand.disk.move.sas.module.slot.info.desc":
        {
            "zh": u"\n被4x12G SAS光电接口模块占用的槽位:%s\n被PCIe Scale-up接口模块占用的槽位:%s\n空闲槽位:%s",
            "en": "\nSlots occupied by 4x12G SAS QSFP interface module:%s\nSlots occupied "
                  "by PCIe scale-up interface modules:%s\nVacant slots:%s"
        },
    "expand.disk.move.sas.module.not.sas.result":
        {
            "zh": u"\n硬盘域所在的引擎（%s）1号槽位被除4x12G SAS光电接口模块和PCIe Scale-up接口模块外的其他模块占用，不满足移卡条件。",
            "en": "\nSlot 1 of engine (%s) where the disk domain resides is occupied by a module other than "
                  "the 4x12G SAS QSFP interface module or PCIe scale-up interface module, "
                  "which does not meet the conditions for moving the 4x12G SAS QSFP interface module."
        },
    "expand.disk.move.sas.module.not.sas":
        {
            "zh": u"\n硬盘域所在的引擎（%s）1号槽位被除4x12G SAS光电接口模块和PCIe Scale-up接口模块外的其他模块占用。"
                  u"请联系技术服务工程师支持。",
            "en": "\nSlot 1 of engine (%s) where the disk domain resides is occupied by a module other than "
                  "the 4x12G SAS QSFP interface module or PCIe scale-up interface module. "
                  "Contact technical support engineers."
        },
    "expand.disk.move.sas.module.not.free":
        {
            "zh": u"\n硬盘域所在的引擎（%s）1号槽位被4x12G SAS光电接口模块占用但无对称的空闲槽位，"
                  u"无法进行移动4x12G SAS光电接口模块操作。请联系技术服务工程师支持。",
            "en": "\nSlot 1 of engine (%s) where the disk domain resides is occupied by the 4x12G SAS QSFP interface "
                  "module but has no symmetrical vacant slot. Therefore, the 4x12G SAS QSFP interface module "
                  "cannot be moved. Contact technical support engineers."
        },
    "expand.disk.move.sas.module.not.free.result":
        {
            "zh": u"\n硬盘域所在的引擎（%s）1号槽位被4x12G SAS光电接口模块占用但无对称的空闲槽位，不满足移卡条件。",
            "en": "\nSlot 1 of engine (%s) where the disk domain resides is occupied by the 4x12G SAS QSFP "
                  "interface module and has no symmetrical vacant slot, which does not meet the conditions "
                  "for moving the 4x12G SAS QSFP interface module."
        },
    "expand.disk.move.sas.module.NVME.numCheck":
        {
            "zh": u"\nNVMe硬盘数量检查：",
            "en": "\nCheck the number of NVMe disks:"
        },
    "expand.disk.move.sas.module.needMove.check":
        {
            "zh": u"\n移卡检查：",
            "en": "\nCheck before interface module moving:"
        },
    "expand.disk.move.sas.module.slot.info":
        {
            "zh": u"\n接口卡槽位信息：",
            "en": "Slot information of interface modules:"
        },
    "get.remote.replication.id.failed":
        {
            "zh": u"\n获取部分同步远程复制ID失败。",
            "en": "\nFailed to obtain some synchronous remote replication IDs."
        },
    "get.remote.replication.info.failed":
        {
            "zh": u"\n获取同步远程复制配置[ID:%s]的详细信息失败。",
            "en": "\nFailed to obtain details about synchronous remote replication configuration (ID: %s)."
        },
    "get.local.lun.id.failed":
        {
            "zh": u"\n获取主LUN失败的同步远程复制配置如下：\nID：%s。",
            "en": "\nFailed to obtain the primary LUN of following synchronous "
                  "remote replication configuration:\nID:%s."
        },
    "get.lun.remote.replication.id.failed":
        {
            "zh": u"\n获取LUN[ID:%s]的远程复制配置ID失败。",
            "en": "\nFailed to obtain the remote replication configuration ID of LUN (ID: %s)."
        },
    "lun.remote.replication.id.num.fault":
        {
            "zh": u"\nLUN[ID:%s]上存在并联3DC业务。",
            "en": "\nA parallel 3DC service is configured on LUN [ID: %s]."
        },
    "protect.capacity.no.pass":
        {
            "zh": u"\n系统存在存储池中保护容量大于LUN已用容量。存储池ID如下：\nID：%s。",
            "en": "\nThe protection capacity of storage pools in the system is greater than the used capacity of LUNs. "
                  "The storage pool IDs are as follows: \nID: %s."
        },
    "cli_software_checkFailover.0.notpass":
        {
            "zh": u"目标端口不存在，请确认目标端口状态是否正常。",
            "en": "The target port does not exist. Check whether the target port is normal."
        },
    "cli_software_checkFailover.1.notpass":
        {
            "zh": u"源端口不支持NPIV，请更换为支持NPIV的接口卡。",
            "en": "The source port does not support NPIV. Replace an interface card that supports NPIV."
        },
    "cli_software_checkFailover.2.notpass":
        {
            "zh": u"源端口所接交换机不支持NPIV，请确认交换机NPIV功能是否打开。",
            "en": "The switch connected to the source port does not support NPIV. Check that the"
                  " switch NPIV function is enabled."
        },
    "cli_software_checkFailover.3.notpass":
        {
            "zh": u"目标端口不支持NPIV，请更换为支持NPIV的接口卡。",
            "en": "The target port does not support NPIV. Replace an interface card that supports NPIV."
        },
    "cli_software_checkFailover.4.notpass":
        {
            "zh": u"目标端口所接交换机不支持NPIV，请确认交换机NPIV功能是否打开。",
            "en": "The switch connected to the target port does not support NPIV. "
                  "Check that the switch NPIV function is enabled."
        },

    # 新增场景
    "cli_software_checkFailover.1.notcheck":
        {
            "zh": u"无法检查源端口是否支持NPIV，请确认目标端口状态正常。",
            "en": "The system cannot check whether the source port supports NPIV. Check that the port status is normal."
        },
    "cli_software_checkFailover.2.notcheck":
        {
            "zh": u"无法检查源端口所接交换机是否支持NPIV，请确认端口状态正常并已配置为“自适应”模式，并确认网络为交换机组网。",
            "en": "The system cannot check whether the switch connected to the source port supports NPIV. "
                  "Check that the port status is normal, the port is in 'Auto-Adapt' mode, "
                  "and the switch network is used."
        },
    "cli_software_checkFailover.3.notcheck":
        {
            "zh": u"无法检查目标端口是否支持NPIV，请确认端口状态正常。",
            "en": "The system cannot check whether the target port supports NPIV. Check that the port status is normal."
        },
    "cli_software_checkFailover.4.notcheck":
        {
            "zh": u"无法检查目标端口所接交换机是否支持NPIV，请确认端口状态正常并已配置为“自适应”模式，并确认网络为交换机组网。",
            "en": "The system cannot check whether the switch connected to the target port supports NPIV. "
                  "Check that the port status is normal, the port is in 'Auto-Adapt' mode, "
                  "and the switch network is used."
        },

    "cli_software_checkFailover.5.notpass":
        {
            "zh": u"目标端口剩余连接数小于源端口当前连接数，链路规格不足，请调整组网。",
            "en": "The number of remaining links on the target port is smaller than that "
                  "on the source port. Link requirements are not met.Adjust the network."
        },
    "cli_software_checkFailover.6.notpass":
        {
            "zh": u"目标端口链路不冗余（为直连主机组网，或与目标端口不在同一网络），请调整组网。",
            "en": "The target port has no redundant link (the port is directly connected to the host or the source "
                  "and target ports are not on the same network).Adjust the network."
        },
    "cli_software_checkFailover.7.notpass":
        {
            "zh": u"源端口正在接管其他端口，请在端口回漂后再进行操作。",
            "en": "The source port is taking over another port. "
                  "Check the port failover network after the port fails back."
        },
    "cli_software_checkFailover.8.notpass":
        {
            "zh": u"源端口已发生漂移，请在端口回漂后再进行操作。",
            "en": "The source port has failed over. Check the port failover network after the port fails back."
        },
    "cli_software_checkFailover.common":
        {
            "zh": u"组网检查结果如下：",
            "en": "Network check results are as follows:"
        },
    "cli_software_checkFailover.common.1":
        {
            "zh": u"%s至%s漂移路径检查失败。原因：",
            "en": "The failover path from %s to %s fails to be checked. Cause:"
        },
    "cli_software_checkFailover.step5.fail.oldver":
        {
            "zh": u"\n主机HBA卡和存储可能存在兼容性风险，请安装V500R007C00SPH102/V300R006C10SPH102/DoradoV300R001C21SPH101或之后补丁。",
            "en": "\nThe host HBA may be incompatible with the storage device. "
                  "Install patch V500R007C00SPH102/V300R006C10SPH102/DoradoV300R001C21SPH101 or a later version. "
        },
    "cli_software_checkFailover.step5.fail.newver":
        {
            "zh": u"\n主机HBA卡和存储可能存在兼容性风险，并建议关闭故障场景端口漂移"
                  u"(开发者视图下执行命令change logical_port failover_switch service_type=SAN switch=off)。",
            "en": "\nThe host HBA may be incompatible with the storage device. "
                  "You are advised to run the change logical_port failover_switch service_type=SAN switch=off "
                  "command in the developer view to disable the port failover function in the fault scenario."
        },
    "check.failover.notpass":
        {
            "zh": u"\n当前组网不满足逻辑端口漂移功能的要求，请参考检查项的修复建议进行处理。",
            "en": "\nThe current network does not meet the failover requirements on logical ports. "
                  "Refer to the suggestion of this check item to rectify faults.",
        },
    "ipscaleout.hotpatch.version.not.pass":
        {
            "zh": u"\n补丁版本[%s]小于既定补丁版本，请参考修复建议整改。",
            "en": "\nPatch version [%s] is earlier than the specified patch version. "
                  "Rectify the fault by referring to the suggestions. ",
        },
    "dirty.quota.patchver.less.required.patchver":
        {
            "zh": u"\n当前版本%s存在于以下版本%s中，并且补丁版本%s小于需要补丁版本%s，检查不通过。",
            "en": "\nVersion %s is in the following list: %s, and patch version %s is earlier "
                  "than %s that is required. The check result is Not passed."
        },
    "dirty.quota.patchver.greater.required.patchver":
        {
            "zh": u"\n当前版本%s存在于以下版本%s中，并且补丁版本%s大于需要补丁版本%s，检查通过。",
            "en": "\nVersion %s is in the following list: %s, and patch version %s is later than %s that is required. "
                  "The check result is Passed."
        },
    "dirty.quota.no.patch":
        {
            "zh": u"\n当前版本%s存在于以下版本%s中，检查不通过。",
            "en": "\nVersion %s is in the following list: %s. The check result is Not passed."
        },
    "dirty.quota.voldoirtyfs.less.0":
        {
            "zh": u"\n获取到的VOL_DIRTY_FS项used的数值小于0。",
            "en": "\nThe value of used in VOL_DIRTY_FS is smaller than 0."
        },
    "dirty.quota.voldoirtyfs.failed":
        {
            "zh": u"\n获取到的%s项used的数值失败。",
            "en": "\nFail to obtain the value of used in %s."
        },
    "dirty.quota.voldoirtyfs.some.key.less.0":
        {
            "zh": u"\n获取到的%s项used的数值小于0。",
            "en": "\nThe value of used in %s is smaller than 0."
        },
    "expctrl.2to.check.veritas":
        {
            "zh": u"\n当前控制器数量为2，且存在使用Veritas DMP多路径的主机。",
            "en": "\nThe number of controllers is 2, and one or multiple hosts that use Veritas DMP exist.",
        },
    "nasRedundantLink.logicport":
        {
            "zh": u"%s（漂移组ID：%s）\n",
            "en": "%s(Failover Group ID:%s)\n"
        },
    "nasRedundantLink.nopass":
        {
            "zh": u"\n不冗余的逻辑端口及对应的漂移组如下：\n%s",
            "en": "\nThe logical ports having no redundant ports "
                  "and the corresponding failover groups are as follows:\n%s"
        },
    "one.of.nas.businesses.not.check":
        {
            "zh": u"\n因以下命令：\n%s\n执行异常，导致以下NAS业务未完成检查：\n%s",
            "en": "\nDue to the following command: "
                  "\n%s \nperforms an exception that causes the following NAS business to not complete the check:\n%s"
        },
    "manually.troubnleshoot.nas.bussiness":
        {
            "zh": u"\n当前版本%s不支持工具检查，请手工排查NAS业务逻辑端口是否冗余。",
            "en": "\nCurrent version%s does not support tool checking, "
                  "please manually check whether the NAS business logic port is redundant."
        },
    "version.not.fit":
        {
            "zh": u"\n存在%s版本的设备，该检查项未在该版本适配，建议补充新增版本的软件兼容性列表。",
            "en": "\nThe device of the %s version is available. "
                  "This check item is not applicable to this version. "
                  "You are advised to add the software compatibility list of the new version."
        },
    "check.result.timeout":
        {
            "zh": u"\n控制器检查结果超时",
            "en": "\nThe controller check times out.",
        },
    "check.ISUserDelUrgAlarm.notpass":
        {
            "zh": u"\n存在告警被手动删除，请确认告警是否已修复。如果已经完成修复，则请忽略该检查项",
            "en": "\nSome alarms have been manually deleted. Check whether the alarms have been cleared. "
                  "If the fault has been rectified, ignore this check item.",
        },
    "check.lun.capacity.consistence.sectors.not.pass":
        {
            "zh": u"\n节点[%s]中下列LUN（ID）对应的内存容量异常:\n    %s",
            "en": "\nThe memory capacity of the following LUNs (ID) in node [%s] is abnormal:\n    %s.",
        },
    "check.lun.capacity.consistence.preuserluncapacity.not.pass":
        {
            "zh": u"\n节点[%s]中下列LUN(ID)对应的Lun:preUserLunCapacity容量异常：\n    %s。",
            "en": "\nThe capacity of Lun:"
                  "preUserLunCapacity corresponding to the following LUNs (ID) in node [%s] is abnormal:\n    %s.",
        },
    "check.lun.capacity.consistence.exceeds.400lun.suggession":
        {
            "zh": u"LUN数量较多（已超过400个），请导出配置数据后联系技术工程师协助处理。",
            "en": "\nThe number of LUNs exceeds 400. "
                  "Export the configuration data and contact technical support engineers.",
        },
    "check.anyItem.exception.common":
        {
            "zh": u"\n执行检查时出错，请检查网络连接是否断开，如果网络断开请连接好网络，重新检查；如果网络连接正常，"
                  u"请查看设备是否正常运行，如果设备运行异常，请修复设备后重新检查；如果设备运行正常，请联系技术支持工程师协助处理。",
            "en": "\nAn error occurred during the check.Check whether the network is disconnected. "
                  "If yes, connect the network, and check again; if the network connection is normal, "
                  "check whether the device works properly. If no, repair the device, and check again; "
                  "If yes, contact technical support engineers.",
        },
    "cannot.get.system.time.info":
        {
            "zh": u"\n无法获取系统时间。",
            "en": "\nCannot get system time.",
        },
    "get.CA.expire.time.failed":
        {
            "zh": u"\n获取CA证书过期时间失败。",
            "en": "\nFailed to get CA certificate expiration time.",
        },
    "check.cert.expire.no.pass":
        {
            "zh": u"\n证书场景[%s]存在过期风险，证书过期日期为[%s]，CA证书过期日期为[%s]。",
            "en": "\nCertificate scenario [%s] has an expiration risk. The expiration date of the certificate is [%s]. "
                  "The expiration date of the CA certificate is [%s].",
        },
    "check.cert.expire.no.pass.only.cert.expire":
        {
            "zh": u"\n证书场景[%s]存在过期风险，证书过期日期为[%s]。",
            "en": "\nCertificate scenario [%s] has an expiration risk. The expiration date of the certificate is [%s].",
        },
    "check.cert.expire.no.pass.only.ca.cert.expire":
        {
            "zh": u"\n证书场景[%s]存在过期风险，CA证书过期日期为[%s]。",
            "en": "\nCertificate scenario [%s] has an expiration risk. "
                  "The expiration date of the CA certificate is [%s].",
        },
    "check.item.perf.threshold.nopass":
        {
            "zh": u"\n性能阈值条数不标准。",
            "en": "\nThe number of performance thresholds is not standard.",
        },
    "check.item.upgrade.risk.check.for.nvme.nopass":
        {
            "zh": u"\n设备存在NVMe升级风险，请收集阵列日志，联系技术工程师协助处理。",
            "en": "\nThe device has an upgrade risk of NVMe. "
                  "Collect array logs and contact technical support engineers.",
        },
    "check.remain.obj.install.patch":
        {
            "zh": u"\n请安装%s及以后版本补丁后，再次执行巡检。",
            "en": "\nInstall a patch whose version is %s or later and perform the inspection again.",
        },
    "check.remain.obj.nopass":
        {
            "zh": u"\n请联系技术支持工程师进行处理。",
            "en": "\nContact technical support engineers.",
        },
    "get.cache.capacity.failed":
        {
            "zh": u"\n获取控制器内存失败。",
            "en": "\nThere is an error in getting controller memory.",
        },
    "check.nfsv4.state.id.nopass.need.install.patch":
        {
            "zh": u"\n当前系统中检查NFSV4服务存在风险，请安装%s或之后的热补丁或者升级存储版本到V300R006C10或之后的版本。",
            "en": "\nThere is a risk of checking the NFSV4 service in the current system. "
                  "Install hot patch %s or later or upgrade the storage version to V300R006C10 or later.",
        },
    "check.nfsv4.state.id.nopass":
        {
            "zh": u"\n当前系统中检查NFSV4服务存在风险，请升级存储版本到V300R006C10或之后的版本。",
            "en": "\nThere is a risk of checking the NFSV4 service in the current system. "
                  "Upgrade the storage version to V300R006C10 or later.",
        },
    "exit.vstore.mode.fail":
        {
            "zh": u"\n退出租户%s失败。",
            "en": "\nThe exit of a tenant with an name of %s failed.",
        },
    "enter.vstore.mode.fail":
        {
            "zh": u"\n进入ID为%s的租户失败。",
            "en": "\nThe entry to a tenant with an ID of %s failed.",
        },
    "get.vstore.name.fail":
        {
            "zh": u"\n获取ID为%s租户的名称失败。",
            "en": "\nGetting the name of a tenant with an ID of %s failed.",
        },
    "obtain.dd.info.failed":
        {
            "zh": u"\n无法获取硬盘域[ID:%s]的信息。",
            "en": "\nFailed to obtain the information of disk domain [ID:%s].",
        },
    "check.dd.member.disk.failed":
        {
            "zh": u"\n硬盘域[ID:%s]的成员盘数量是%s, 小于等于%s块。",
            "en": "\nThe number of disks in the disk domain [ID:%s] is %s, which is smaller than or equal to %s.",
        },
    "suggest.operation.key":
        {
            "zh": u"\n修复建议：",
            "en": "\nRecovery Suggestion:",
        },
    "disk.firmware.need.upg.time":
        {
            "zh": u"该设备存在%s块硬盘的固件版本过低，建议升级至合适版本，"
                  u"升级预计耗时%s。",
            "en": "The firmware version of %s disks on the device is too early. "
                  "You are advised to upgrade the firmware version to a proper version. "
                  "The upgrade takes about %s.",
        },
    "disk.firmware.not.pass.need.upg.time":
        {
            "zh": u"该设备存在%s块硬盘的固件版本小于推荐值，"
                  u"请升级至合适版本，升级预计耗时%s。",
            "en": "Firmware version of %s disks on the device is earlier than "
                  "recommended Value. Upgrade the disk firmware. The upgrade takes about %s.",
        },
    'install.fc.driver.risk.patch':
        {
            "zh": u"请安装%s或之后版本补丁后再进行运行数据收集，或联系技术工程师处理。",
            "en": "Install the patch[%s] or a later version and then collect running data, "
                  "or contact technical support engineers."
        },
    "check.iscsi.dorado.v3.exist.risk.install.hotpatch":
        {
            "zh": u"\n当前设备复制链路状态存在风险，请安装%s版本或之后版本热补丁，并且联系技术工程师协助解决。",
            "en": "\nThe replication link status of the current version is risky. "
                  "Install the hot patch of %s or later and contact technical support engineers.",
        },
    "check.iscsi.dorado.v3.exist.risk":
        {
            "zh": u"\n当前设备复制链路状态存在风险，请联系技术工程师协助解决。",
            "en": "\nThe replication link status of the current version is risky. Contact technical support engineers.",
        },
    "check.iscsi.dorado.v3.install.hotpatch":
        {
            "zh": u"\n当前版本复制链路状态存在风险，请安装%s版本或之后版本热补丁。",
            "en": "\nThe replication link status of the current version is risky. "
                  "Install the hot patch of %s or later.",
        },
    "check.capacity.too.high":
        {
            "zh": u"\n控制器%s所在引擎用户写入容量太高，用户需要尽快删除或迁移部分业务。",
            "en": "\nThe data written to the engine where controller %s resides is too large. "
                  "Users need to delete or migrate some services as soon as possible.",
        },
    "get.cps.or.ctrl.num.error":
        {
            "zh": u"\n获取仲裁服务器或控制器数量不一致。",
            "en": "\nThe obtained numbers of quorum servers or controllers are inconsistent.",
        },
    "check.arb.link.no.pass":
        {
            "zh": u"\n仲裁服务器[name:%s]liveLink数在所有控制器的Ctrl(%s)上存在不一致。",
            "en": "\nThe number of liveLinks of quorum server [name:%s] is "
                  "inconsistent on Ctrl(%s) of all controllers.",
        },
    "check.arb.link.warning":
        {
            "zh": u"\n仲裁服务器[name:%s]在所有控制器上仲裁链路数均为0。",
            "en": "\nThe number of quorum links of quorum server [name:%s] on all controllers is 0.",
        },
    "check.arb.link.no.config":
        {
            "zh": u"\n双活域未配置仲裁服务器，请配置仲裁服务器。",
            "en": "\nNo quorum server is configured for the HyperMetro domain. Configure a quorum server.",
        },
    "check.hyper.array.product.model.not.pass":
        {
            "zh": u"\n本端设备[SN:%s]与远端设备[%s]产品型号不一致。",
            "en": "\nThe product model of local device [SN:%s] is inconsistent with that of remote device [%s].",
        },
    "check.hyper.array.product.version.and.hot.patch.not.pass":
        {
            "zh": u"\n本端设备[SN:%s]与远端设备[%s]软件版本或补丁版本不一致。",
            "en": "\nThe software version or patch version of local device [SN:%s] is inconsistent "
                  "with that of remote device [%s].",
        },
    "check.hyper.array.controller.num.warning":
        {
            "zh": u"\n本端设备[SN:%s]与远端设备[%s]控制器数量不一致。",
            "en": "\nThe number of controllers of local device [SN:%s] "
                  "is inconsistent with that of remote device [%s].",
        },
    "cannot.get.dsm.info":
        {
            "zh": u"\n无法获取DSM分区状态信息",
            "en": "\nFailed to obtain the DSM partition status.",
        },
    "check.dsm.status.error":
        {
            "zh": u"\nDSM分区状态异常",
            "en": "\nThe DSM partition status is abnormal.",
        },
    "heart.beat.to.engine.failed":
        {"zh": u"\n通过心跳连接到引擎：%s 失败。",
         "en": "\nFailed to connect to engine %s based on the heartbeat."
         },
    "single.engine.exp.and.new.dd.member.disk.cnt.may.over.spec": {
        'zh': u'引擎：%s 支持成员盘最大个数：%s，当前已有成员盘个数：%s，计划扩容硬盘域新增成员盘总数为：%s, '
              u'计划新建硬盘域新增成员盘总数为：%s，超过单个引擎支持的最大成员盘个数。',
        'en': u'The maximum number of member disks supported by engine %s is %s. '
              u'The number of existing member disks is %s. %s member disks are planned to be '
              u'added to the existing disk domains on the engine, '
              u'and the total number of member disks planned to be added for creating new disk domains '
              u'on the engine is %s, it exceeds the maximum number of member disks supported by the engine',
    },
    "single.engine.exp.member.disk.cnt.over.spec": {
        'zh': u'引擎：%s 支持成员盘最大个数：%s，当前已有成员盘个数：%s, 计划扩容硬盘域新增成员盘总数为：%s，'
              u'超过单引擎支持的最大成员盘个数。',
        'en': u'The maximum number of member disks supported by engine %s is %s. '
              u'The number of existing member disks is %s and %s member disks are planned to be added to '
              u'the existing disk domains on the engine'
              u' which exceeds the maximum number of disks supported by the engine.',
    },
    "software.version.does.not.to.be.checked": {
        "zh": u"\n设备的软件版本不需要检查。",
        "en": "\nSoftware vesion does not to be checked."
    },
    "disks.over.limit.when.create.disk.domain": {
        "zh": u"\n新建硬盘域时，硬盘数量大于%s。",
        "en": "\nThe number of disks is larger than %s "
              "when create disk domain."
    },
    "disks.over.limit.when.expand.disk.domain": {
        "zh": u"\n在%s上扩容硬盘域(ID:%s)时，硬盘数量大于%s。",
        "en": "\nOn %s, after adding disks to disk domain (ID: %s), "
              "the number of disks is larger than %s."
    },
    "hypermetro.remote.replication.link.v5r7c60.nolink":
        {
            "zh": u"无正常的远程复制链路。",
            "en": "No normal remote replication link"
        },
    "hypermetro.remote.replication.link.v5r7c60.fclink.noredundantlink":
        {
            "zh": u"引擎[%s] 未绑定正常的远程复制链路。",
            "en": "Engine[%s] is not bound to a normal remote replication link."
        },
    "hypermetro.remote.replication.link.v5r7c60.fclink.missingredundantlink":
        {
            "zh": u"引擎[%s] 至少需要两条正常远程复制链路。",
            "en": "Engine[%s] requires at least two normal links."
        },
    "hypermetro.remote.replication.link.v5r7c60.fclink.missinginterfacecard":
        {
            "zh": u"引擎[%s] 绑定链路需要分布在至少两个接口卡上。",
            "en": "Engine[%s] bound links need to be distributed on at least two interface cards."
        },
    "hypermetro.remote.replication.link.v5r7c60.remotedevice.showlink.error":
        {
            "zh": u"获取远端设备[%s] 绑定链路失败。",
            "en": "Failed to obtain the link bound to the remote [%s]."
        },
    "hypermetro.remote.replication.link.v5r7c60.remotedevice.error":
        {
            "zh": u"\n远端设备ID[%s]链路存在如下问题：",
            "en": "\nThe remote device ID [%s] link has the following problems:"
        },
    "hypermetro.remote.replication.link.v5r7c60.remotedevice.linktype.error":
        {
            "zh": u"%s组网：",
            "en": "%s networking:"
        },
    "hypermetro.remote.replication.link.v5r7c60.remotedevice.linkport.error":
        {
            "zh": u"\n该共享卡设备端口ID非标准数据格式(CTEx.X.X.Px)",
            "en": "The shared card device port ID is not a standard data format (CTEx.X.X.Px)"
        },
    "disk.domain.format.mode.is.risk":
        {
            "zh": u"\n格式化类型不为混合格式化的硬盘域ID:%s",
            "en": "The format mode of disk domains (IDs:%s) "
                  "is not Disk Extent Mix Format."
        },
    "root.disk.check.mount.coffer.log.auth.error":
        {
            "zh": u"%s目录的权限不为rw",
            "en": "The permissions of the %s directory are not rw."
        },
    "root.disk.check.mount.error.nodirectory":
        {
            "zh": u"目录：%s未挂载",
            "en": "Directory: %s is not mounted."
        },
    "root.disk.check.mount.directory.empty":
        {
            "zh": u"目录：%s内容为空",
            "en": "Directory: %s is empty."
        },
    "root.disk.check.engine.controller.disk.error":
        {
            "zh": u"\n引擎ID：%s，控制器：%s系统盘检查存在如下异常：\n%s",
            "en": "\nEngine ID: %s, controller: %s system "
                  "disk check has the following exception: \n%s"
        },
    "ftp.arm.status.error":
        {
            "zh": u"\nftp服务运行状态为Running",
            "en": "\nFtp service running status is Running"
        },
    "disk.enclosure.number.error":
        {
            "zh": u"\n控制框[CTE%s]级联的硬盘框数量为%s。",
            "en": "\nThe number of disk enclosures in "
                  "the controller enclosure [CTE%s] is %s."
        },
    "disk.enclosure.number.with.errordisk.error":
        {
            "zh": u"\n控制框[CTE%s]级联的硬盘框数量为%s"
                  u"（其中异常硬盘框数量为%s）。",
            "en": "\nThe number of disk enclosures in "
                  "the controller enclosure [CTE%s] is %s"
                  "(The number of abnormal disk enclosures is %s.)."
        },
    "coffer.link.error.risk":
        {
            "zh": u"\n以下保险箱框存在连线错误的风险：%s",
            "en": "\nThe following disk enclosures with coffer disks have "
                  "risks of incorrect cable connections:%s"
        },
    "coffer.link.error.list1": {
        "zh": u"\nmac相同[mac: %s]，\"Is first\"字段不相同[Is first: %s]",
        "en": "\nMAC addresses are the same [mac: %s], but values of the "
              "Is first filed are different [Is first: %s]."
    },
    "coffer.link.error.list2": {
        "zh": u"\n引擎[ID：%s]，\"Is first\"字段等于1，mac不相同[mac：%s]",
        "en": "\nEngine ID [ID: %s]; Values of the Is first filed are the "
              "same (1), but MAC addresses are different [mac: %s]."
    },
    "coffer.link.error.list3": {
        "zh": u"\n引擎[ID：%s]，控制器对[%s]，\"Is first\"字段等于1，"
              u"mac不相同[mac：%s]",
        "en": "\nEngine ID [ID: %s]; Controller pair [%s]; Values of the "
              "Is first filed are the same (1), but MAC addresses are "
              "different [mac: %s]."
    },
    "hypermetro.remote.replication.link.doradov6.no.controller":
        {
            "zh": u"\n获取控制器信息失败",
            "en": "\nFailed to obtain the disk array "
                  "controller information."
        },
    "hypermetro.remote.replication.link.doradov6.remotedevice.error":
        {
            "zh": u"\n远端设备ID[%s]双活复制链路存在如下问题：",
            "en": "\nThe remote device ID [%s] HyperMetro replication "
                  "link has the following problems:"
        },
    "hypermetro.remote.replication.link.doradov6."
    "remotedevice.linktype.error":
        {
            "zh": u"%s链路：",
            "en": "%s link:"
        },
    "hypermetro.remote.replication.link.doradov6.engine.not.enough.link":
        {
            "zh": u"引擎[%s]在上下两个物理平面内均需要"
                  u"绑定至少两条状态正常的复制链路。",
            "en": "The engine [%s] is required on both the upper and lower "
                  "physical planes bind at least two "
                  "replication links in normal state."
        },
    "ctrl.not.enough.link.sugg":
        {
            "zh": u"\n修复建议：为保证复制链路"
                  u"冗余性及性能，请确保每个控制器均绑定了至少两条状态正常的"
                  u"复制链路到同一个远端设备。",
            "en": "\nRecovery Suggestion:"
                  "To ensure replication link redundancy and performance, "
                  "ensure that each controller is bound to at least two "
                  "normal replication links to the same remote device."
        },
    "hypermetro.remote.replication.link.doradov6.ctrl.not.enough.link":
        {
            "zh": u"控制器[%s]未绑定至少两条状态正常的复制链路。",
            "en": "The controller [%s] needs to bind "
                  "at least two replication links in normal status."
        },
    "engine.not.enough.link.sugg":
        {
            "zh": u"修复建议：中低端存储，本端每个控制器与对端存储每个控制器都"
                  u"有链接，全互联组网；高端存储，FC共享接口模块时，本端存储"
                  u"每个引擎的象限与对端存储相同引擎相同象限有链接，iSCSI接"
                  u"口模块时，本端存储每个象限与对端存储每个象限都有链接，全互联组网",
            "en": "\nRecovery Suggestion:For mid-range and low-end storage "
                  "devices, each controller at the local end is connected "
                  "to each controller at the peer end, and the network is "
                  "fully interconnected. For high-end storage devices, "
                  "if FC ports share interface modules, each quadrant of "
                  "the local storage device is connected to the same quadrant "
                  "of the peer storage device. If iSCSI ports are used, "
                  "each quadrant of the local storage device is connected to "
                  "each quadrant of the peer storage device. In full "
                  "interconnection networking, each quadrant of the local "
                  "storage device is connected to each quadrant of the peer "
                  "storage device."
        },
    "hypermetro.remote.replication.link.doradov6.mix.link.error":
        {
            "zh": u"双活复制链路中既存在FC链路又存在IP链路。",
            "en": "The HyperMetro replication link contains "
                  "FC links and IP links."
        },
    "hypermetro.remote.replication.link.doradov6."
    "remotedevice.showlink.error":
        {
            "zh": u"远端设备ID[%s]双活复制链路信息异常。",
            "en": "The remote device ID [%s] HyperMetro replication"
                  " link information is abnormal."
        },
    "infrastructure.check.risk":
        {
            "zh": u"补丁版本%s 小于既定补丁版本%s 且存在ODX使用记录，"
                  u"请参考修复建议处理。",
            "en": "\nPatch version %s is earlier than specified patch version"
                  " %s, and ODX usage records exist. Rectify the fault "
                  "according to the handling suggestions."
        },
    "mem.sys.95": {
        "zh": u"\n节点[node id: %s]，内存使用率超过95%%。",
        "en": "\nNodes[node id: %s],the memory usage exceeds 95%%."
    },
    "msg.not.risky.msg":
        {
            "zh": u"\n此设备不在风险版本和型号中。",
            "en": "This device is not a risky version or model."
        },
    "msg.dev.product.model":
        {
            "zh": u"\n当前设备型号为：",
            "en": "\nCurrent device model:"
        },
    "msg.current.version":
        {
            "zh": u"\n当前设备版本为：",
            "en": "\nCurrent device version:"
        },
    "msg.risk.model":
        {
            "zh": u"\n风险型号为：",
            "en": "\nRisky device model:"
        },
    "msg.risky.version":
        {
            "zh": u"\n风险版本为:",
            "en": "\nRisky device version:"
        },
    "msg.risky.version.and.later":
        {
            "zh": u"%s及之后版本",
            "en": "%s and later versions"
        },
    "msg.comma":
        {
            "zh": u"，",
            "en": ","
        },
    "msg.period":
        {
            "zh": u"。",
            "en": "."
        },
    "msg.more.than":
        {
            "zh": u"大于",
            "en": "Versions later than"
        },
    "msg.less.than":
        {
            "zh": u"小于",
            "en": "Versions earlier than"
        },
    "msg.less.than.or.equal":
        {
            "zh": u"小于或等于%s",
            "en": "%s and earlier versions"
        },
    "risk.disk.burst.suggestion":
        {
            "zh": u"\n存在model为[%s]的硬盘，系统版本为：%s, "
                  u"补丁版本为：%s",
            "en": "\nA disk whose model is [%s] exists. The system "
                  "version is %s, and patch version is %s."
        },
    "risk.controller.link.suggestion":
        {
            "zh": u"\n当前设备型号为：%s，系统软件版本为：%s，系统热补丁版本"
                  u"为：%s，建议升级系统软件或安装对应系统热补丁。",
            "en": "The current device model is: %s. The system software "
                  "version is: %s. The system hot patch version is: %s. "
                  "You are advised to upgrade the system software or install "
                  "the corresponding hot patch."
        },
    "ad.domain.ddns.not.pass":
        {
            "zh": u"\n租户[ID:%s]下列逻辑IP的DDNS状态是On:[%s]。",
            "en": "The DDNS status of the following logical IP"
                  " addresses of vStore [ID:%s] is On[%s]."
        },
    "get.hyper.data.failed":
        {
            "zh": u"命令执行失败，设备SN:%s, 命令:%s",
            "en": "Failed to run the command, sn:[%s], cmd:[%s]"
        },
    "wether.deleted.alarm.not.pass":
        {
            "zh": u"是否删除严重告警：是",
            "en": "Whether a major or critical alarm is "
                  "manually deleted:Yes."
        },
    "wether.deleted.alarm.pass":
        {
            "zh": u"是否删除严重告警：否",
            "en": "Whether a major or critical alarm is "
                  "manually deleted:No."
        },
    "query.result.port.error":
        {
            "zh": u"获取端口信息失败。",
            "en": "There is an error in getting port information."
        },
    "query.result.controller.error":
        {
            "zh": u"获取控制器信息失败。",
            "en": "There is an error in getting controller information."
        },
    "query.result.port.utilization.error":
        {
            "zh": u"获取端口%s的利用率失败。",
            "en": "Failed to obtain the usage of port %s."
        },
    "query.result.controller.cache.water.error":
        {
            "zh": u"获取控制器%s的cache水位失败。",
            "en": "Failed to obtain the cache watermark of controller %s."
        },
    "performance.switch.disabled":
        {
            "zh": u"性能统计开关已关闭，请在admin模式执行以下"
                  u"命令打开性能统计开关，再重新巡检："
                  u"change performance statistic_enabled enabled=yes",
            "en": "The performance statistics switch is disabled.Run "
                  "the following command in admin mode to enable "
                  "the performance statistic, then perform the "
                  "inspection again:"
                  "change performance statistic_enabled enabled=yes."
        },
    "third.paty.multipath.hyper.config.ignore.ini":
        {
            "zh": u"\n请重新人工确认下列主机的启动器配置"
                  u"是否正确(主机ID：启动器)：\n",
            "en": "\nManually check again whether the initiator "
                  "configuration of the following hosts is correct "
                  "(host ID: initiator):\n"
        },
    "third.paty.multipath.hyper.config.not.checked.ini":
        {
            "zh": u"\n请人工确认下列主机的启动器配置"
                  u"是否正确(主机ID：启动器)：\n",
            "en": "\nManually check whether the initiator configuration"
                  " of the following hosts is correct again"
                  "(host ID: initiator):\n"
        },
    "third.paty.multipath.array.not.support.3rd":
        {
            "zh": u"\n下列主机使用了不支持双活的第三方多路径，"
                  u"请参照修复建议进行处理(主机ID：启动器)：\n",
            "en": "\nThe following hosts use third-party multipathing"
                  " software that does not support HyperMetro."
                  " Rectify the fault by referring to the handling "
                  "suggestions (host ID: initiator):\n"

        },
    "third.paty.multipath.array.host.type.error":
        {
            "zh": u"\n请人工确认下列阵列配置的主机类型和物理主机"
                  u"类型是否一致(主机ID：启动器)：\n",
            "en": "\nManually check whether the host types "
                  "configured for the following arrays are "
                  "consistent with the physical host types "
                  "(host ID: initiator):\n"
        },
    "third.paty.multipath.array.host.type.man.error":
        {
            "zh": u"\n下列阵列配置的主机类型和物理主机类型不一致，"
                  u"未添加到巡检工具中巡检的主机使用双活人工确认项"
                  u"的结果(主机ID：启动器)：\n",
            "en": "\nThe host types configured for the following"
                  " arrays are inconsistent with the physical host"
                  " types. For hosts that are not added to the "
                  "inspection tool, the results of the HyperMetro "
                  "manual confirmation item are used"
                  " (host ID: initiator):\n"
        },
    "third.paty.multipath.array.no.support.3rd.host.oper":
        {
            "zh": u"\n下列主机使用了第三方多路径，但主机操作系统不支持"
                  u"第三方多路径做双活（主机ID：启动器）：\n",
            "en": "\nThe following hosts use third-party "
                  "multipathing software, but their operating "
                  "systems do not support third-party multipathing "
                  "software for HyperMetro (host ID: initiator):\n"
        },
    "third.paty.multipath.array.hw.cfg.error":
        {
            "zh": u"\n下列主机使用了华为多路径，但启动器Multipath "
                  u"Type未配置成Default（主机ID：启动器）\n",
            "en": "\nThe following hosts use Huawei UltraPath,"
                  " but Multipath Type of the initiator is not "
                  "set to Default (host ID: initiator):\n"
        },
    "third.paty.multipath.array.3rd.cfg.error":
        {
            "zh": u"\n下列主机使用了第三方多路径，但启动器Multipath"
                  u" Type配置成了Default（主机ID：启动器）\n",
            "en": "\nThe following hosts use third-party multipathing"
                  " software, but Multipath Type of the initiator"
                  " is set to Default (host ID: initiator):\n"
        },
    "check_snmp_protocol_result.not.pass":
        {
            "zh": u"当前系统开启了SNMPv1&SNMPv2c协议\n",
            "en": "SNMPv1 and SNMPv2c are enabled in the system.\n",
        },
    "check_snmp_usm_auth_result.not.pass":
        {
            "zh": u"USM用户%s使用了不安全的鉴权算法%s\n",
            "en": "The USM user %s uses the insecure authentication algorithm %s.\n",
        },
    "check_snmp_usm_priv_result.not.pass":
        {
            "zh": u"USM用户%s使用了不安全的加密算法%s\n",
            "en": "The USM user %s uses the insecure encryption algorithm %s.\n",
        },
    "check_snmp_usm_auth.not.pass":
        {
            "zh": u"USM用户%s未启用鉴权算法\n",
            "en": "The USM user %s does not enable the authentication algorithm.\n",
        },
    "check_snmp_usm_priv.not.pass":
        {
            "zh": u"USM用户%s未启用加密算法\n",
            "en": "The USM user %s does not enable the encryption algorithm.\n",
        },
    "check_rmtd_s3_https.warning":
        {
            "zh": u"smartmobility远端设备%s使用了S3协议，未选择HTTPS传输协议。\n",
            "en": "The remote smartmobility device %s uses the S3 protocol."
                  " The HTTPS communication protocol is not selected.\n",
        },
}

MESSAGES_DICT.update(RESOURCE_MESSAGES_DICT)
