# -*- coding: UTF-8 -*-

KUNPENG = "Kunpeng"

# 逻辑端口回漂时间检查风险版本
SHARE_CIFS_RISK_VERSION = [
    "V300R006C30",
    "V300R006C50SPC100",
    "V300R006C50SPC200",
    "V300R006C60",
    "V500R007C20",
    "V500R007C30SPC100",
    "V500R007C30SPC200",
    "V500R007C50",
]

SHARE_CIFS_RISK_VERSION_KUNPENG = "V500R007C60SPC100 Kunpeng"

# 逻辑端口回漂时间检查-已解决问题的补丁
SHARE_CIFS_RISK_VERSION_DICT = {
    "V300R006C60": "V300R006C60SPH001",
    "V500R007C30SPC100": "V500R007C30SPH107",
    "V500R007C50": "V500R007C50SPH001",
    "V300R006C50SPC100": "V300R006C50SPH107",
}

# 风险IP网段,用于检查业务IP是否存在于阵列内部使用IP网段
RISKY_IP_NETWORK_SEGMENT_LIST = ["10.0", "10.48",
                                 "10.96", "10.144",
                                 "10.213", "10.215",
                                 "10.216", "10.217",
                                 "10.218", "10.219",
                                 "10.220", "10.221"]

# Smart智能框扩容风险型号
EXP_RISK_V6_PRODUCT_MODE = ["OceanStor Dorado 6800 V6",
                            "OceanStor Dorado 8000 V6",
                            "OceanStor Dorado 18000 V6",
                            "OceanStor Dorado 18500 V6",
                            "OceanStor Dorado 18800 V6",
                            "OceanStor Dorado 18800K V6",
                            "OceanStor 6810",
                            "OceanStor 18510",
                            "OceanStor 18500K",
                            "OceanStor 18810",
                            "OceanProtect X9000",
                            "OceanProtect X9000K",
                            ]

# NFS共享风险版本
RISK_SHARE_NFS_VERSION_AND_PATCH = {
    "V500R007C60SPC300": "V500R007C60SPH301",
    "V500R007C60SPC300 Kunpeng": "V500R007C60SPH302"
}

# 硬盘recover状态风险版本
RISK_DISK_RECOVER_STATUS = ['V300R006C50SPC100',
                            'V500R007C30SPC100',
                            'V500R007C50',
                            'V500R007C60SPC100',
                            'V500R007C60SPC200',
                            'V500R007C60SPC300',
                            'V500R007C60SPC100 Kunpeng',
                            'V500R007C60SPC200 Kunpeng',
                            'V500R007C60SPC300 Kunpeng']

# 存储产品接入的AD域服务器安装Windows补丁导致AD域用户无法
RISK_AD_DOMAIN_ACCESS_CIFS_VERSION_AND_PATCH = {
    "V300R002C10SPC100": "V300R002C10SPH118",
    "V300R006C20": "V300R006C20SPH026",
    "V300R006C20SPC100": "V300R006C20SPH119",
    "V300R006C50SPC100": "V300R006C50SPH118",
    "V300R006C60": "V300R006C60SPH006",
    "V500R007C10SPC100": "V500R007C10SPH119",
    "V500R007C50": "V500R007C50SPH006",
    "V500R007C70SPC200": "V500R007C70SPH201",
    "V300R006C61": "V300R006C61SPH009",
    "V500R007C10": "V500R007C10SPH026",
    "V500R007C30SPC100": "V500R007C30SPH118",
    "V500R007C61": "V500R007C61SPH009",
    "V500R007C70SPC200 Kunpeng": "V500R007C70SPH201",
    "V500R007C60SPC300 Kunpeng": "V500R007C60SPH309",
}

# 使用ip：172.16.[0-3].[0-8]会产生风险的软件版本
RISK_IP_CONFLICT_WITH_SCALEOUT_VERSION = ('V500R007C60SPC200',
                                          'V500R007C60SPC300',
                                          'V500R007C70',
                                          '6.0.0',
                                          '6.0.1',
                                          '6.1.RC1')

# 检查存储上是否映射了磁带库设备的风险版本以及对应补丁
RISK_LIBRARY_DEVICE_MAP_TO_STORAGE_VERSION = {
    "V500R007C00": "",
    "V500R007C00SPC100": "V500R007C00SPH106",
    "V500R007C10": "",
    "V500R007C20": "",
    "V500R007C30": "",
    "V500R007C30SPC100": "V500R007C30SPH115",
    "V500R007C50": "",
    "V300R001C21SPC100": "",
    "V300R001C30SPC100": "",
    # NAS
    "V300R002C20SPC002": "",
    "V300R002C20SPC003": "",
    # X86
    "V500R007C60SPC300": "",
    "V500R007C61": "V500R007C61SPH008",
    "V300R006C60SPC100": "",
    "V300R006C60SPC102": "",
    "V300R006C60SPC103": "",
}
# LUN的卷ID检查,风险版本范围
RISK_SYSTEM_MAX_VOLUME_ID_MODEL = (
    "OceanStor Dorado 18800K V6",
    "OceanStor Dorado 18000 V6",
    "OceanStor Dorado 18500 V6",
    "OceanStor Dorado 18800 V6",
    "OceanStor Dorado 8000 V6",
    "OceanStor Dorado 6800 V6"
)

# 共享卡双活ALUA特殊模式0风险版本范围
RISK_SHARD_PORT_SWITCH_VERSION = {
    "V500R007C60SPC200": 999,
    "V500R007C60SPC300": 308,
    "V500R007C70": 999,
    "V500R007C70SPC100": 999
}

# 共享卡双活ALUA特殊模式0风险型号范围
RISK_SHARD_PORT_SWITCH_MODEL = (
    "6810 V5",
    "6800 V5",
    "6800K V5",
    "6810F V5",
    "6800F V5",
    "18510 V5",
    "18500 V5",
    "18500K V5",
    "18510F V5",
    "18500F V5",
    "18810 V5",
    "18800 V5",
    "18800K V5",
    "18810F V5",
    "18800F V5",
)

C_PLUS_AND_C_CONTROLLER_ITEM_CODE = [
    ["03059172", "03059095"],
    ["03059174", "03059097"],
    ["03059175", "03059098"],
    ["03059168", "03059044"],
    ["03059170", "03059046"],
    ["03059171", "03059047"],
    ["03050AEW", "03050AFD"],
    ["03050AFA", "03050AFG"],
    ["03050AFH", "03050AFH"],
    ["03050AFF", "03050AFF"],
    ["03050AFE", "03050AFE"],
    ["03050AFC", "03050AFC"],
]

# 元数据损坏风险检测
META_DATA_HAS_PATCH_VERSION = {
    "V100R001C30SPC300": "V100R001C30SPH305",
    "V100R001C30SPC200": "V100R001C30SPH215",
    "V500R007C10": "V500R007C10SPH030",
    "V300R006C20": "V300R006C20SPH030",
    "V500R007C30SPC100": "V500R007C30SPH120",
    "V300R006C50SPC100": "V300R006C50SPH120",
    "V500R007C50": "V500R007C50SPH006",
    "V300R006C60": "V300R006C60SPH006",
    "V500R007C61": "V500R007C61SPH013",
    "V500R007C60SPC300 Kunpeng": "V500R007C60SPH309",
    "V500R007C60SPC100 Kunpeng": "V500R007C60SPH105",
    "V500R007C70SPC200 Kunpeng": "V500R007C70SPH202",
}

# FC驱动系统版本及热补丁风险版本
FC_FAULT_RISK_VERSION_DICT = {
    'V300R006C20': 'V300R006C20SPH015',
    'V300R006C20SPC100': 'V300R006C20SPH115',
    'V500R007C10': 'V500R007C10SPH015',
    'V500R007C30SPC100': 'V500R007C30SPH105',
    'V300R001C21SPC100': 'V300R001C21SPH112',
    'V500R007C10SPC100': 'V500R007C10SPH115',
    'V300R002C10SPC100': 'V300R002C10SPH101',
    'V300R006C50SPC100': 'V300R006C50SPH105',
    'V300R001C30SPC100': 'V300R001C30SPH106'
}

# smart io 1.0 风险版本
SMART_IO_NO_RISK_VERSION = ('V300R002C10SPC200', 'V300R003C00SPC100',
                            'V300R003C10SPC100', 'V300R003C20',
                            'V300R003C20SPC200',
                            'V300R005C00SPC300', 'V300R006C00SPC100',
                            'V500R007C00SPC100', 'V300R006C10SPC100',
                            'V500R007C10',
                            'V300R006C20', 'V500R007C20', 'V300R006C30',
                            'V500R007C30SPC100', 'V300R006C50SPC100',
                            'V500R007C50',
                            'V300R006C60')

# HyperCDP保护容量风险版本
PROTECT_CAPACITY_RISK_VERSION = {
    "V300R002C10SPC100": "V300R002C10SPH117",
    "V300R002C00SPC100": "--",
    "V300R002C20": "--"
}

# 存储池参数检查 - 特定风险版本
STORAGE_POOL_PARAM_RISK_VERSION = {
    "6.0.RC1": "",
    "6.0.0": "SPH11",
    "6.0.1": "SPH8",
    "6.1.RC1": "",
    "6.1.RC2": "",
}
# 2600 V5/5110 V5 Enhanced/5110F V5 Enhanced/5210 V5 Enhanced/5210F V5 Enhanced
CPU_VOLTAGE_RISK_MODEL = [
    "2600 V5",
    "5110 V5 Enhanced",
    "5110F V5 Enhanced",
    "5210 V5 Enhanced",
    "5210F V5 Enhanced"
]

# IO时延问题补丁预警检查补丁
SOFTWARE_IO_DELAY_RISK_DICT = {
    "V300R006C50SPC100": "V300R006C50SPH116",
    "V300R006C60": "V300R006C60SPH006",
    "V300R006C61": "V300R006C61SPH008",
    "V500R007C30SPC100": "V500R007C30SPH116",
    "V500R007C50": "V500R007C50SPH006",
    "V500R007C61": "V500R007C61SPH008",
    "V300R002C10SPC100": "V300R002C10SPH118",
    "V300R002C20": "V300R002C20SPH006",
}

# 检查硬盘域硬盘总数 - 特定风险版本
DISK_DOMAIN_TOTAL_DISK_NUM_VERSION = {
    "6.0.0": "SPH3",
    "6.0.RC1": "",
    "V300R002C20": "",
    "V300R001C21SPC100": "V300R001C21SPH118",
    "V300R002C00SPC100": "V300R002C00SPH105",
    "V300R002C10SPC100": "V300R002C10SPH112",
    "V300R001C30SPC100": "",
}

# 控制器硬件版本检查中版本和补丁需求表
REQUIRE_VERSION_AND_PATCH = {
    "6.0.0": "",
    "6.0.1": "6.0.1.SPH15",
    "V500R007C60SPC100": "",
    "V500R007C60SPC300": "",
    "V500R007C70SPC200": "",
    "V500R007C71": "",
}
# 控制器硬件版本检查，V500R007C71升级到V500R007C71SPC100或之后版本
REQUIRE_VERSION_FOR_C71 = "V500R007C71SPC100 Kunpeng"

# 控制器硬件版本检查，0305编码清单
CTRL_BOM_LIST = ["03050CLW", "03050CMC", "03050CLV", "03050CLX", "03050CNQ",
                 "03050BBH", "03050BVH", "03050CCF", "03050CCG", "03050CCH",
                 "03050AMM", "03050APM", "03050AMP", "03050ABP", "03050ABW",
                 "03050ABQ", "03050ABG", "03050ABH", "03050ABF", "03050BAS",
                 "03050BAR", "03050BAJ", "03050BAK", "03059975", "03059962",
                 "03059969", "03059968", "03059963", "03050AYV", "03050AYU",
                 "03050AYN", "03050AYM", "03059970", "03050AFF", "03050AFA",
                 "03050AFH", "03050AFC", "03050AEW", "03050AFE", "03050AFG",
                 "03050AFD", "03050BBV", "03050BGN", "03050BBU", "03050BGM",
                 "03050CCL", "03050BVJ", "03050CCK", "03050CCJ"]

# 检查高空闲率盘数 风险版本
HIGH_IDLE_DISK_NUM_VERSION = {
    "6.0.0": "",
    "6.0.1": "6.0.1.SPH21",
    "6.1.0": "6.1.0.SPH11"
}

# 高端4P型号BOM
BOM_INFO_OF_INNTER_MODEL_4P = [
    '02352WKE', '02352WKF', '02352WKG', '02352TMA', '02352WJW', '02352WJX', '02352VQE',
    '02352WLL', '02352WLM', '02352VPN', '02352WLF', '02352WLG', '02352WKK', '02352WKM',
    '02352WKN', '02352WJY', '02352WKA', '02352WKB', '02352WLR', '02352WLS', '02352WLN',
    '02352WLH', '02352WLJ', '02352WLK', '02352WJT', '02352WJU', '02352WKL', '02352WKP',
    '02352WKR', '02352WKU', '02352WLC', '02352WLD', '02352WLE', '02352WLX', '02352WMC',
    '02352WME', '02352WMT', '02352WMU', '02352WMV', '02352WNC', '02352WND', '02352WNE',
    '02352WNF', '02352WNG', '02352WNH', '02352WNJ', '02352WNK', '02352WNL', '02352WMG',
    '02352WRW', '02352WRY', '02352WSE', '02352WSC', '02352WSB', '02352WSJ', '02352WSL',
    '02352WSP', '02352WSW', '02352WSU', '02352WSR', '02352WUJ', '02352WUK', '02352WUL',
    '02352WUQ', '02352WUN', '02352WUM', '02352WUS', '02352WUV', '02352WUX', '02352WVE',
    '02352WVC', '02352WVA', '02353ASU', '02353ASV', '02353ASW', '02353ASX', '02353ASY',
    '02353ATA', '02353ATB', '02353ATC', '02353ATD', '02353ATE', '02353ATF', '02353ATG',
    '02353ATH', '02353ATJ', '02353ATK', '02353ATL', '02352WPK', '02352WPM', '02352WPN',
    '02352WPT', '02352WPV', '02352WPX', '02352WPY', '02352WQB', '02352WQC', '02352WQE',
    '02352WQF', '02352WQH', '02352WSN', '02352WSM', '02352WSH', '02352WSF', '02352WSD',
    '02352WSA', '02352WRX', '02352WRV', '02352WRT', '02352WRS', '02352WRQ', '02352WRN',
    '02353ATR', '02353ATS', '02353ATT', '02353ATW', '02353AUA', '02353AUB', '02353AUE',
    '02353AUF', '02353ATU', '02353ATV', '02353ATX', '02353ATY', '02353AUC', '02353AUD',
    '02353AUG', '02353AUH', '02352XRF', '02352XRE', '02352XRD', '02352XPS', '02352XPN',
    '02352XPL', '02352XQX', '02352XRC', '02352XRG', '02352XPH', '02352XPK', '02352XPP',
    '02352XQH', '02352XQN', '02352XRB', '02352XNX', '02352XPF', '02352XPJ', '02352XQP',
    '02352XQS', '02352XQV', '02352XNV', '02352XPC', '02352XPE', '02352XRH', '02352XRR',
    '02352XRS', '02352XPU', '02352XPY', '02352XQF', '02352XRJ', '02352XRK', '02352XRL',
    '02352XPR', '02352XQJ', '02352XQL', '02352WYK', '02352WYJ', '02352WYH', '02352WYA',
    '02352WXY', '02352WXX', '02352WVT', '02352WVW', '02352WWA', '02352WVD', '02352WVF',
    '02352WVG', '02352WYE', '02352WYF', '02352WYG', '02352WXU', '02352WXV', '02352WXW',
    '02352WVM', '02352WVP', '02352WVR', '02352WUW', '02352WUY', '02352WVB', '02352WYL',
    '02352WYM', '02352WYN', '02352WYB', '02352WYC', '02352WYD', '02352WWD', '02352WWE',
    '02352WWG', '02352WVH', '02352WVJ', '02352WVL', '02353GVT', '02353GVU', '02353GVV',
    '02353GVW', '02353GVX', '02353GVY', '02353GVL', '02353GVM', '02353GVP', '02353GVQ',
    '02353GVR', '02353GVS', '02353GWT', '02353GWS', '02353GWR', '02353GXA', '02353GWY',
    '02353GWX', '02353GWW', '02353GWV', '02353GWU', '02353GXB', '02353GXC', '02353GXD',
    '02353GXK', '02353GXJ', '02353GXH', '02353GXG', '02353GXL', '02353GXM', '02353GXE',
    '02353GXF', '02353HGF', '02353HGG', '02353HGH', '02353HGJ', '02353HGL', '02353HGM',
    '02353HHJ', '02353HHK', '02353HHL', '02353HHM', '02353HHN', '02353HHP', '02353HHQ',
    '02353HHR', '02353HHS', '02353HHT', '02353GYP', '02353KQT', '02353KQU', '02353KQV',
    '02353KQW', '02353NDS', '02353NDT', '02353NDU', '02353NDV', '02353NDW', '02353NDX',
    '02353NDY', '02353NEA', '02353NDL', '02353NDN', '02353NDP', '02353NDR', '02353SAR',
    '02353SAT', '02354EJG', '02354EJE', '02353TQX', '02353TQY', '02353TRA', '02353TRB',
    '02353TRC', '02353TRD', '02353TRE', '02353TRF', '02353TRG', '02353TRH', '02353TRJ',
    '02353TRK', '02353RLW', '02353TUD', '02353TUE', '02353TUF', '02353TUG', '02353TUH',
    '02353TUJ', '02353TUL', '02353TSE', '02353TSF', '02353TSG', '02353TSH', '02353TSJ',
    '02353TSK', '02353TUM', '02353TUS', '02353TUT', '02353TUU', '02353TUV', '02353TUW',
    '02353UTY', '02353UUB', '02353UUE', '02353UUF', '02353TSL', '02353TSM', '02353TSN',
    '02353TSQ', '02353RSU', '02353RSV', '02353TAA', '02353TAG', '02353TAH', '02353TAJ',
    '02353TAQ', '02353TAR', '02353TAS', '02353TAT', '02353RSJ', '02353RSY', '02353SYX',
    '02353SYY', '02353TAE', '02353TAF', '02353TAB', '02353TAC', '02353TAD', '02353TAK',
    '02353TAL', '02353TAM', '02353TAU', '02353TAV', '02353TAW', '02353TAX', '02353TKU',
    '02353TKW', '02353TKY', '02353TLM', '02353TLP', '02353TLQ', '02353TLA', '02353TLF',
    '02353TLL', '02353TLR', '02353TLS', '02353TLT', '02353TLU', '02353TLV', '02353TLW',
    '02353TLX', '02353TLY', '02353TMA', '02353RVC', '02353RVD', '02353THM', '02353THN',
    '02353THV', '02353THW', '02353RVB', '02353THK', '02353THL', '02353THS', '02353THT',
    '02353THU', '02353THP', '02353THQ', '02353THR', '02353THX', '02353THY', '02353TJA',
    '02353TMB', '02353TMC', '02353TMD', '02353TMH', '02353TMJ', '02353TMK', '02353TME',
    '02353TMF', '02353TMG', '02353TML', '02353TMM', '02353TMN', '02353TMP', '02353TMQ',
    '02353TMR', '02353TMS', '02353TMT', '02353TMU', '02353TMV', '02353TMW', '02353TMX',
    '02353TMY', '02353TNA', '02353TNB', '02353TNC', '02353TND', '02353TNE', '02353TNF',
    '02353TNG', '02353TNH', '02353UMJ', '02353UMK', '02353UML', '02353UMM', '02353TRR',
    '02353TRS', '02353TRT', '02353TRU', '02353TRV', '02353TRW', '02353TRX', '02353TRY',
    '02353TTJ', '02353TTK', '02353TTL', '02353TTM', '02353TTN', '02353TTP', '02353TTQ',
    '02353TTR', '02353TTS', '02353TTT', '02353TTU', '02353TTV', '02353UEW', '02353UEX',
    '02353UEY', '02353UFA', '02353UFC', '02353UFD', '02353UFF', '02353UFH', '02353UFJ',
    '02353UFL', '02353UFN', '02353UFP', '02353UFR', '02353UFU', '02353UFV', '02353UFX',
    '02353UFY', '02353UGA', '02353UGC', '02353UGD', '02353UGF', '02353UGH', '02353UGJ',
    '02353UGL', '02353UGM', '02353UGN', '02353UGQ', '02353UGR', '02353UGT', '02353UGU',
    '02353UGV', '02353UGW', '02353TVH', '02353TVP', '02353TVS', '02353VGH', '02353RLY',
    '02353RLX', '02353RLU', '02353RLT', '02353RLS', '02353YEG', '02353YEH', '02353RLQ',
    '02353WRM', '02353WRN', '02353WRQ', '02353WRR', '02353WRS', '02353WRT', '02353WRC',
    '02353WRF', '02353WRG', '02353WRJ', '02353WRK', '02353WRL', '02353XLF', '02353XLG',
    '02353XLH', '02353XLJ', '02353XMN', '02353XMP', '02353XMQ', '02353XMR', '02353XMS',
    '02353XMT', '02353XMU', '02353XMV', '02353RVG', '02354DFD', '02354DFE', '02354JDW',
    '02354PBG', '02354PBH', '02354RMA', '02354SFU', '02354SFV', '02354SFW', '02354SFX',
    '02354SFY', '02354SGA', '02354SGB', '02354SGC', '02354RRC', '02354RRD', '02354RRE',
    '02354RRF', '02354RRG', '02354RRH', '02354RRJ', '02354RRK', '02354RJM', '02354RJN',
    '02354TKB', '02354TKC', '02354TKD', '02354TKE', '02354TKF', '02354TKG', '02354TKH',
    '02354TKJ', '02353VEK', '02355GVA', '02355GVE', '02355GVH', '02355GVJ', '02355GVK',
    '02355GVL', '02355GVM', '02355GVP', '02355GVQ', '02355GVR', '02355GVS', '02355GVU',
    '02355GVV', '02355GVW', '02355GVX', '02355GVY', '02355GWA', '02355GWB', '02355GWC',
    '02355GWD', '02355GWE', '02355GWF', '02355GWG', '02355GWH', '02355GWJ', '02355GWK',
    '02355GWL', '02355GWM', '02355GWN', '02355GWP', '02355GWQ', '02355GWR', '02355GWS',
    '02355GWT', '02352WWK', '02352WWM', '02352WYP', '02353RVQ', '02353SYT', '02352XRV',
    '02353RVH', '02352WYR', '02352XRU', '02353TJD', '02353TJE', '02353TAN', '02353TJB',
    '02353TJC', '02353TAP', '02353SYV', '02352XRT', '02352WWP', '02353UMQ', '02352XRN',
    '02352WYQ', '02353RUF', '02353SYU', '02352XRQ', '02352XRP'
]

# 二级存储3P型号BOM
BOM_INFO_OF_INNTER_MODEL_3P = [
    '02354DEX', '02354DEY', '02354DFA', '02354DFB', '02354JDV', '02354JDK', '02354KKK', '02354KKL', '02354PBA',
    '02354PBB', '02354PBC', '02354PBD', '02354PBE', '02354PBF', '02354RHP', '02354RJL', '02354PWS', '02354PWT',
    '02354PWV', '02354PWW', '02354PWY', '02354PXA', '02354PXC', '02354PXD', '02354PWR', '02354PWU', '02354PWX',
    '02354PXB', '02355AUP', '02355AUQ', '02355AYH', '02355AYJ', '02355AYK', '02355AYL', '02355AYM', '02355AYN',
    '02355GXM', '02355GYN', '02355GYP', '02355GUT', '02355LJC'
]
