#!/bin/sh


CMD_FILE=./cmd_tmp_file

PrintNotInstallUp()
{
   isPass=3
   errResult="UltraPath is not installed on this host, skip this item."  
        
   WRITE_XML_ERROR 0 ":${errResult}"
   WRITE_XML_JUDGE $isPass
   WRITE_XML_SUBCMD_TAIL
   return 1;
}


PrintUpadmFileNotExist()
{
   isPass=3
   errResult="#upadm show version
   upadm: command not found"  
        
   WRITE_XML_ERROR 0 ":${errResult}"
   WRITE_XML_JUDGE $isPass
   WRITE_XML_SUBCMD_TAIL
   return 1; 
}


HOST_01_ChkUltraPathVersion()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
   Version=`lslpp -l U*.*.rte|grep -E "COMMITTED"|awk -F. '{print $1}'`

   if [ ${Version} -eq 1 ]; then
        isPass=4
   elif [ ${Version} -eq 41 ]; then
        isPass=4
   else
      isPass=0
   fi
   
    UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
    WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
 
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_02_ChkUpServer()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi    
    
    if [ ${Version} -lt 6 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    elif [ ${Version} -eq 41 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    else
        
        isPass=0
        ps -ef|grep -v grep|grep alarm_server > /dev/null 2>&1
        if [ $? -ne 0 ]; then
            isPass=1
            errResult="INFO:The status of alarm_server is abnormal!"  
        fi
        UltraPath_VERSION=`echo "#ps -ef|grep -v grep|grep alarm_server";ps -ef|grep -v grep|grep alarm_server`
        WRITE_XML_COMMON 1 ":${UltraPath_VERSION}"
        
        if [ "$errResult" != "" ];then 
            WRITE_XML_ERROR 0 ":${errResult}"
        fi
    fi
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

HOST_ChkFileExist()
{
        if [ ! -f ${1} ]; then
            isPass=1
            errResult="INFO:Not found file:${1}"  
            WRITE_XML_ERROR 0 ":${errResult}"    
        fi
}

HOST_03_ChkUpFiles()
{
    errResult=""
    isPass=0
        
    DRV_DIR=/kernel/drv/sparcv9	

    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
        
        
    if [ ${Version} -lt 6 ]; then
        
        HOST_ChkFileExist /usr/sbin/autoSetPri
        
        HOST_ChkFileExist /usr/sbin/Inquiry
        
        HOST_ChkFileExist /opt/UltraPath/up.conf
        
        LS_STR=" /usr/sbin/autoSetPri /usr/sbin/Inquiry  /opt/UltraPath/up.conf"
        if [ ${isPass} -eq 0 ]; then
            FILE_STATUS=`echo "#ls -l ${LS_STR}";ls -l  ${LS_STR}`
            WRITE_XML_COMMON 0 ":${FILE_STATUS}"
        fi             


    elif [ ${Version} -eq 41 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    else
        
        LS_STR=" /usr/lib/methods/UltraPath_pcmrtl /usr/lib/drivers/UltraPath_pcmke /etc/up.conf /usr/sbin/upadm "

        HOST_ChkFileExist  /usr/lib/methods/UltraPath_pcmrtl
        
        HOST_ChkFileExist /usr/lib/drivers/UltraPath_pcmke
        
        HOST_ChkFileExist /etc/up.conf 
        
        HOST_ChkFileExist /usr/sbin/upadm         
        
           
        if [ ${isPass} -eq 0 ]; then
            FILE_STATUS=`echo "#ls -l ${LS_STR}";ls -l ${LS_STR}`
            WRITE_XML_COMMON 0 ":${FILE_STATUS}"
        fi  
    fi
    
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_04_ChkUpConfig()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    
    if [ ${Version} -lt 6 ]; then
        CHK_STR="autoSetPri"

    elif [ ${Version} -eq 41 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    else      
        CHK_STR="alarm_server" 
    fi
    
    cat /etc/inittab| grep ${CHK_STR} > ${CMD_FILE}
    if [ $? -ne 0 ]; then
        isPass=1
        errResult="INFO:Not found UltraPath config in /etc/inittab"  
        WRITE_XML_ERROR 0 ":${errResult}" 
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;   
    fi
        
    
    if [ ${isPass} -eq 0 ]; then
        CONFIG_STATUS=`echo "#cat /etc/inittab| grep ${CHK_STR} ";cat /etc/inittab| grep ${CHK_STR} `
        WRITE_XML_COMMON 0 ":${CONFIG_STATUS}"
    fi                
    
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_05_ChkUpLogSpace()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
     
    if [ ${Version} -lt 6 -o  ${Version} -eq 41 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
    
    if [ -d /opt/UltraPath/log/kernel_log ]; then
    
        LOG_SIZE=`du -sk /opt/UltraPath/log/kernel_log|awk '{print $1}'`
    
        if [ ${LOG_SIZE} -gt 204800 ]; then
            isPass=4
            errResult="INFO:UltraPath log dir larger than 200MB  "  
            WRITE_XML_ERROR 0 ":${errResult}"  
        fi
        
        LOG_SPACE=`echo "#du -sk /opt/UltraPath/log/kernel_log";du -sk /opt/UltraPath/log/kernel_log`
        WRITE_XML_COMMON 0 ":${LOG_SPACE}"
    else
        isPass=3
        WRITE_XML_COMMON 0 "No compress log directory"
    fi
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

DISK_CHK_STR="KB|MB|GB|TB"
VendorChk="huawei|huasy|symantec|hs|eisoo|udsafe|marstor|sanm|anystor|sugon|netposa" 
ProductChk="XSG1|S5300|S5500T|S5500|S5600T|S5600|VIS6000|S2600|S2300E|S2300|S6800T|S6800E|V1600N|S3900-M120|S3900-M240|S3900|S6900-M1200|S6900|S8000|S5900-M480|S5800T|S6900-M100|S3900-M300|S3900-M200|S5900-M100|Dorado2100|S2900|S2600T|S5900-M200|S8000-I|Dorado5100|S2200T|VIS6000|VIS6000T|HVS85T|HVS88T|AS5000"
abnormalStr="Unavailable|fault|degraded"
HOST_06_ChkUpDiskStatus()
{
    errResult=""
    isPass=0
    AppendStr=""
    diskFlag=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Version} -lt 6 -o ${Version} -eq 41 ]; then
        allDisk=`lsdev -Cc disk|grep FC|awk '{print $1}'`
        
        for i in ${allDisk}
        do
            DiskVendorFlag=0
            DiskProductFlag=0
            Manufacturer_Str=`lscfg -vpl $i|grep Manufacturer`
    
            DiskVendorFlag=`echo ${Manufacturer_Str}|grep -E -i "$VendorChk"|wc -l`                           
            if [ ${DiskVendorFlag} -gt 0 ]; then
                MachineType_Str=`lscfg -vpl $i|grep "Machine Type and Model"`
                DiskProductFlag=`echo ${MachineType_Str}|grep -E -i "$ProductChk"|wc -l`
                if [ ${DiskProductFlag} -gt 0 ]; then
                    #
                    diskFlag=1
                    FailedChk=`lspath -l $i |grep -i enable|wc -l`
                    if [ ${FailedChk} -eq 0 ]; then
                        isPass=1
                        DISK_INFO=`echo "#lspath -l ${i}";lspath -l ${i}`
                        WRITE_XML_ERROR 0 ":${DISK_INFO}"
                        WRITE_XML_JUDGE $isPass
                        WRITE_XML_SUBCMD_TAIL
                        return 0;
                    fi                    
                fi
            fi 
        done
        
        if [ ${diskFlag} -eq 0 ]; then
            isPass=3
            errResult="Warning: Can't find any vluns in UltraPath"  
            WRITE_XML_ERROR 0 ":${errResult}"   
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        CHK_FLAG=`echo "${allDisk}"|wc -l`
        
        DISK_INFO=`echo "#lsdev -Cc disk |head -n 10";lsdev -Cc disk|head -n 10`
        
        if [ ${CHK_FLAG} -gt 10 ]; then
                DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
        fi
        
        WRITE_XML_COMMON 0 ":${DISK_INFO}"         
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;        
        
    else
        if [ ${Upadm_Flag}  -eq 1 ]; then
            PrintUpadmFileNotExist
            return 1;
        fi
        
        UP_VER=`upadm show version|grep -i software|awk  '{print $4}'|awk -F. '{print $1 $2}'`
        if [ ${UP_VER} -ge 803 ]; then
            AppendStr=" type=all"
        fi
        upadm show vlun ${AppendStr}|${GREP} -E -i ${DISK_CHK_STR} > ${CMD_FILE}
    
        CHK_FLAG=`cat ${CMD_FILE}|wc -l`
        if [ ${CHK_FLAG} -eq 0 ]; then
            isPass=3
            errResult="Warning: Can't find any vluns in UltraPath"  
            WRITE_XML_ERROR 0 ":${errResult}"   
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi

        abnormal=`cat ${CMD_FILE}|${GREP} -E -i "${abnormalStr}"|wc -l`
    
        if [ ${abnormal} -ne 0 ]; then
            isPass=1
            errResult="Warning: Some disks status abnormal"  
            WRITE_XML_ERROR 0 ":${errResult}"     
            DISK_INFO=`echo "#upadm show vlun ${AppendStr} |${GREP} -E -i \"${abnormalStr}\"";cat ${CMD_FILE}|${GREP} -E -i "${abnormalStr}"|head -n 10`
            
            if [ ${abnormal} -gt 10 ]; then
                DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
            fi
            
            WRITE_XML_ERROR 0 ":${DISK_INFO}"
        else
            DISK_INFO=`echo "#upadm show vlun ${AppendStr} |head -n 10";upadm show vlun ${AppendStr}|head -n 10`
            
            if [ ${CHK_FLAG} -gt 8 ]; then
                DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
            fi
            
            WRITE_XML_COMMON 0 ":${DISK_INFO}"    
        fi
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

}


HOST_07_ChkUpPathStatus()
{
    errResult=""
    isPass=0   
    diskFlag=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Version} -lt 6 -o ${Version} -eq 41 ]; then
        allDisk=`lsdev -Cc disk|grep FC|awk '{print $1}'`
        
        for i in ${allDisk}
        do
            DiskVendorFlag=0
            DiskProductFlag=0
            Manufacturer_Str=`lscfg -vpl $i|grep Manufacturer`
    
            DiskVendorFlag=`echo ${Manufacturer_Str}|grep -E -i "$VendorChk"|wc -l`                           
            if [ ${DiskVendorFlag} -gt 0 ]; then
                MachineType_Str=`lscfg -vpl $i|grep "Machine Type and Model"`
                DiskProductFlag=`echo ${MachineType_Str}|grep -E -i "$ProductChk"|wc -l`
                if [ ${DiskProductFlag} -gt 0 ]; then
                    #
                    diskFlag=1
                    FailedChk=`lspath -l $i |grep -i fail|wc -l`
                    if [ ${FailedChk} -ne 0 ]; then
                        isPass=1
                        DISK_INFO=`echo "#lspath -l ${i}";lspath -l ${i}`
                        WRITE_XML_ERROR 0 ":${DISK_INFO}"
                        
                        errResult="Warning: Some paths status abnormal." 
                        WRITE_XML_ERROR 0 ":${errResult}"
        
                        WRITE_XML_JUDGE $isPass
                        WRITE_XML_SUBCMD_TAIL
                        return 0;
                    fi                    
                fi
            fi 
        done
        
        if [ ${diskFlag} -eq 0 ]; then
            isPass=3
            errResult="Warning: Can't find any vluns in UltraPath"  
            WRITE_XML_ERROR 0 ":${errResult}"   
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        DISK_INFO=`echo "#lspath -F\"name:parent:connection:path_id:status\"|head -n 10 ";lspath -F"name:parent:connection:path_id:status"|head -n 10`
        
        CHK_FLAG=`lspath -F"name:parent:connection:path_id:status"|wc -l`
        
        if [ ${CHK_FLAG} -gt 10 ]; then
            DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
        fi
        
        WRITE_XML_COMMON 0 ":${DISK_INFO}"         
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;        
        
    else
        if [ ${Upadm_Flag}  -eq 1 ]; then
            PrintUpadmFileNotExist
            return 1;
        fi
    
        upadm show path |${GREP} FC > ${CMD_FILE}
    
        CHK_FLAG=`cat ${CMD_FILE}|wc -l`
        
        if [ ${CHK_FLAG} -eq 0 ]; then
            isPass=3
            errResult="Warning: Can't find any paths in UltraPath"  
            WRITE_XML_ERROR 0 ":${errResult}"   
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
    
        PATH_CHK=`cat ${CMD_FILE}|${GREP} -E -i "fail|fault|degraded"|wc -l`
    
        if [ ${PATH_CHK} -ne 0 ]; then
            errResult="Warning: Some paths status abnormal." 
            WRITE_XML_ERROR 0 ":${errResult}"
        
            PATH_INFO=`echo "#upadm show path|${GREP} -E -i \"fail|fault|degraded\"|head -n 10";cat ${CMD_FILE}|${GREP} -E -i "fail|fault|degraded"|head -n 10`
            
            if [ ${PATH_CHK} -gt 10 ]; then
                PATH_INFO=`echo " ${PATH_INFO} \n ..........................."`
            fi
            
            WRITE_XML_ERROR 0 ":${PATH_INFO}"
        
            isPass=1
        else
            PATH_INFO=`echo "#upadm show path|head -n 10";upadm show path|head -n 10`
            
            if [ ${CHK_FLAG} -gt 10 ]; then
                PATH_INFO=`echo " ${PATH_INFO} \n ..........................."`
            fi
            
            WRITE_XML_COMMON 0 ":${PATH_INFO}"
        fi  
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi   

    
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_08_ChkUpRedundancyController()
{
    errResult=""
    isPass=0
       
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Version} -lt 6 -o ${Version} -eq 41 ]; then        
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;    
        
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi
    
    UP_VER=`upadm show version|grep -i software|awk  '{print $4}'|awk -F. '{print $1 $2}'`
    if [ ${UP_VER} -ge 803 ]; then
        AppendStr=" type=all"
    fi
    
    upadm show vlun ${AppendStr}|${GREP} -E -i ${DISK_CHK_STR} > ${CMD_FILE}
        
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Warning: Can't find any vluns in UltraPath"  
        WRITE_XML_ERROR 0 ":${errResult}"   
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
    
    upadm show array  > ${CMD_FILE}
        
    ARRAY_ID=`cat ${CMD_FILE}| ${GREP}  -E '^[[:blank:]]*[[:digit:]]' | awk '{print $1}'`
    
    ARRAY_NUM=`echo "${ARRAY_ID}" |wc -l`
    
    for i in ${ARRAY_ID}
    do
        upadm show array id=${i} > ${CMD_FILE}
                
        CTRL_STR=`cat ${CMD_FILE}|${GREP} -i "controller"|wc -l`
        
        if [ ${CTRL_STR} -eq 1 ]; then
            isPass=1
            errResult="Warning: Some arrays managed by UltraPath only connect single controller."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            VLUN_INFO=`echo "#upadm show array id=${i}";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        CTRL_STR=`cat ${CMD_FILE}|${GREP} -E -i "State|status"|${GREP} -E -i "normal|enable|degrad"|wc -l`
        
        if [ ${CTRL_STR} -lt 2 ]; then
            isPass=1
            errResult="Warning: Some controller status abnormal."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            VLUN_INFO=`echo "#upadm show array id=${i}";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        PhyPathId=`cat ${CMD_FILE}|${GREP} [Pp]ath|${GREP} -v -E -i "fail|fault|disable"  |awk -F: '{print $1}'|sed 's/[^0-9]//g'`
        
        if [ -z "${PhyPathId}" ]; then
            if [ ${ARRAY_NUM} -eq 1 ]; then
                isPass=3
            fi
            continue
        fi            
        
        CTRL_STR=""
                
        for i in ${PhyPathId}
        do
            CTRL=`upadm show phypath id=${i}|${GREP} [Cc]ontroller|awk -F: '{print $2}'`

            CTRL_STR=`/usr/bin/echo "${CTRL_STR} \n ${CTRL}" |sed 's/ //g'`

        done

        CTRL_Flag=`/usr/bin/echo "${CTRL_STR}"|sort|uniq|grep -v "^$"|wc -l `

        if [ ${CTRL_Flag} -lt 2 ]; then
            isPass=1
            errResult="Warning: Some controller status abnormal."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            VLUN_INFO=`echo "#upadm show array id=${i}";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
    done 
    
    
    if [ ${isPass} -eq 0 -o ${isPass} -eq 3  ]; then
        PATH_INFO=`echo "#upadm show phypath";upadm show phypath`
        WRITE_XML_COMMON 0 ":${PATH_INFO}"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
    
}



HOST_09_ChkThirdMP()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
        
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_10_ChkOsVersion()
{
    errResult=""
    isPass=0
    
    OS_VER=`uname -r`
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
           
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_11_ChkHcSingleDisk()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Version} -lt 6 -o ${Version} -eq 41 ]; then        
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;    
        
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi
    
    UP_VER=`upadm show version|grep -i software|awk  '{print $4}'|awk -F. '{print $1 $2}'`
    if [ ${UP_VER} -lt 803 ]; then
        isPass=3
        UltraPath_VERSION=`echo "#lslpp -l U*.*.rte";lslpp -l U*.*.rte`
    
        WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;   
    fi
          
    upadm show vlun type=hypermetro |${GREP} -E -i ${DISK_CHK_STR} 2> /dev/null > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then

        isPass=3
        errResult="Not found hypermetro disk in UltraPath"  
        WRITE_XML_COMMON 0 ":[hypermetro]:${errResult}"   
        
        VLUN_INFO=`echo "#upadm show vlun type=hypermetro";upadm show vlun type=hypermetro`
        WRITE_XML_COMMON 0 ":${VLUN_INFO}"  
        
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi  
    
    VLUN_ID=`cat ${CMD_FILE}|awk '{print $1}'|sort|uniq`
    
    for i in ${VLUN_ID}
    do
        upadm show vlun id=${i} type=hypermetro > ${CMD_FILE}
        
        LUN_WWN_NUM=`cat ${CMD_FILE}|${GREP} "LUN WWN"|wc -l`
        if [ ${LUN_WWN_NUM} -ne 2 ]; then
            isPass=1
            errResult="Warning: vlun_id:${i} only one storage system reports the LUN in a HyperMetro pair."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            
            VLUN_INFO=`echo "#upadm show vlun id=${i} type=hypermetro";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        Pri_Array=`cat ${CMD_FILE}|${GREP} "Primary Array SN"`
        
    done
    
    VLUN_INFO=`echo "#upadm show vlun type=hypermetro|head -n 10";upadm show vlun type=hypermetro|head -n 10`
    
    if [ ${CHK_FLAG} -gt 8 ]; then
        VLUN_INFO=`echo " ${VLUN_INFO} \n ..........................."`
    fi
    
    WRITE_XML_COMMON 0 ":${VLUN_INFO}"  
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_UltraPathChkItem()
{
  

    WRITE_XML_CMD_HEADER $1
    
    case $1 in
        100)
        HOST_00_ChkUltraPathExist "0"        
        ;;
        101)
        HOST_01_ChkUltraPathVersion "0"
        ;;
        102)
        HOST_02_ChkUpServer "0"
        ;;
        103)
        HOST_03_ChkUpFiles "0" 
        ;;
        104)
        HOST_04_ChkUpConfig "0" 
        ;;
        105)
        HOST_05_ChkUpLogSpace "0"
        ;;
        106)
        HOST_06_ChkUpDiskStatus "0"
        ;;
        107)
        HOST_07_ChkUpPathStatus "0"
        ;;
        108)
        HOST_08_ChkUpRedundancyController "0"
        ;;
        109)
        HOST_09_ChkThirdMP "0"
        ;;
        110)
        HOST_10_ChkOsVersion "0"
        ;;
        111)        
        HOST_11_ChkHcSingleDisk "0"
        ;;
        *)
        echo "No this type"
        ;;
    esac

    WRITE_XML_CMD_TAIL         
}
