INSTALL_PATH=/opt/BCManager
RUNTIME_PATH=$INSTALL_PATH/Runtime
BACK_USER=ICUser
TOMCAT_USER=Tomcat
tempFile="/tmp/inspectTempFile"
sudo /usr/bin/managedScript.sh getHaMode
HA_MODE=`cat $tempFile`
SOFT_NAME=BCManager
LOCAL_ROLE=""

#########checklog begin###########
writeResultOfLogCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "        <cmditem id=\""$1"\">"

    sudo /usr/bin/managedScript.sh checkLegoPath
    if [ `cat $tempFile` ]
    then
        echo "      <item id=\""$10"\">"
        checkDiskVolume
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    else
        echo "      <item id=\""$10"\">"
        echo "          <errorvalue type=\"0\">BCManager not installed</errorvalue>"
        echo "              <judge>"1"</judge>"
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    fi
}

checkDiskVolume()
{
    sudo /usr/bin/managedScript.sh getLegoSpace
    space=`cat $tempFile`
    freeCap=`echo "scale=2;$space / 1024" | bc`
    if echo $freeCap-1.0|bc|grep -E '^-' ; then
        echo "           <errorvalue type=\"0\">0"$freeCap"G</errorvalue>"
        echo "                  <judge>"1"</judge>"
    elif echo $freeCap-5.0|bc|grep -E '^-' ; then
        echo "           <errorvalue type=\"0\">"$freeCap"G</errorvalue>"
        echo "                  <judge>"1"</judge>"
    else
        echo "           <commonvalue type=\"0\">"$freeCap"G</commonvalue>"
        echo "                  <judge>"0"</judge>"
    fi
}

 #########checkResource begin###########
writeResultOfResourceCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"

    echo "        <item id=\""$10"\">"
    checkMemory
    echo "        </item>"
    echo "        <item id=\""$11"\">"
    checkCpu
    echo "        </item>"

    echo "      </cmditem>"
    echo "</device>"
}

checkMemory()
{
    memStr=`free | grep 'Mem: '`
    used=`echo $memStr | awk -F" " '{print $3}'`
    total=`echo $memStr | awk -F" " '{print $2}'`
    tmp=`expr $used \* 100`
    usage=`expr $tmp / $total`
    if [[ $usage -lt 80 ]];then
        echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

checkCpu()
{
    cpuGeneral=`vmstat | awk -F ' ' 'NR==3{print $15}'`
    cpuWa=`vmstat | awk -F ' ' 'NR==3{print $16}'`
    usage=`echo "100-$cpuGeneral-$cpuWa " |bc`
    if [[ $usage -lt 80 ]];then
        echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

writeResultOfServerCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"

    echo "        <item id=\""$10"\">"
    checkJVMRunning
    echo "        </item>"

    echo "        <item id=\""$14"\">"
    checkIsmHttpsPort
    echo "        </item>"

    echo "        <item id=\""$15"\">"
    checkJVMMemory
    echo "        </item>"

    echo "        <item id=\""$16"\">"
    checkHAStatus
    echo "        </item>"

    echo "        <item id=\""$17"\">"
    checkDBStatus
    echo "        </item>"

    echo "      </cmditem>"
    echo "</device>"
}

checkDBStatus()
{
    local dbPid=`sudo -u GaussDB ps -ux | grep gaussdb | grep ^GaussDB | grep "\-D" | awk '{print $2}'`
    if [ ! -z "$dbPid" ];then
        echo "           <commonvalue type=\"0\">PID $dbPid</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">GaussDB not running</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

isHARunning()
{
    HAPID=`sudo -u ICUser ps -ux | grep ha.bin | grep -v grep | grep "$SOFT_NAME" | awk '{print $2}'`
    if [ -z "$HAPID" ];then
        return 1
    fi
    return 0
}

checkHAStatus()
{
    isHARunning;
    local check_result=$?
    if [ $check_result -eq 0 ];then
        echo "           <commonvalue type=\"0\">PID $HAPID</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">HA not running</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

checkJVMMemory()
{
    javaId=`sudo -u ICUser ps -ux | grep java | grep equinox.jar | awk '{print $2}'`
    if (( ${#javaId} !=0 ));then
        temp1=`grep 'VmRSS:' /proc/$javaId/status`
        temp=`echo $temp1 |awk -F" " '{print $2}'`
        usage=`echo "scale=0; $temp / 1024" | bc`
        usedStr=''
        if (( $usage < 1024 ))
        then
            usedStr="$usage"M
        else
            usedStr=`echo "scale=2; $usage / 1024" | bc`G
        fi

        if (( $usage < 3072 ))
        then
            echo "           <commonvalue type=\"0\">"$usedStr"</commonvalue>"
            echo "                  <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\">"$usedStr"</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    else
        getLocalRole
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">BCManager not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

getLocalRole()
{
    if [ ! -z "$LOCAL_ROLE" ];then
        return
    fi
    isHARunning;
    local checkRes=$?
    if [ $checkRes -ne 0 ];then
        return
    fi

    if [ "$HA_MODE" == "single" ];then
        return
    fi

    sudo /usr/bin/managedScript.sh getCurrentRole
    local currentRole=`cat $tempFile`
    [ "$currentRole" == "1" ] && LOCAL_ROLE=active && return
    [ "$currentRole" == "2" ] && LOCAL_ROLE=standby && return
    LOCAL_ROLE=unknown
}

  #########checkJVMRunning begin###########
checkJVMRunning()
{
    javaId=`sudo -u ICUser ps -ux | grep java | grep $BACK_USER | grep equinox.jar | awk '{print $2}'`
    if (( ${#javaId} !=0 ));then
        echo "           <commonvalue type=\"0\">PID $javaId</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        getLocalRole
        echo "LOCAL_ROLE: $LOCAL_ROLE" >>/tmp/result.txt
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">BCManager not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

checkIsmHttpsPort()
{
    javaId=`sudo -u ICUser ps -ux | grep java |grep $TOMCAT_USER | grep "$SOFT_NAME" | awk '{print $2}'`
    sudo /usr/bin/managedScript.sh getHttpsPort
    if [ $? -ne 0 ];then
        exit 1
    fi
    httpsPort=`cat $tempFile`
    if (( ${#javaId} !=0 ));then
        local temp=`sudo lsof -i:$httpsPort`
        local result=`echo $temp | awk -F$javaId '{print $1}'`

        if (( ${#result} !=0 ));then
            echo "           <commonvalue type=\"0\">Https port $httpsPort</commonvalue>"
            echo "                   <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\"></errorvalue>"
            echo "                   <judge>"1"</judge>"
        fi
    else
        getLocalRole
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">Tomcat not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

 #########checkAlarm begin###########
writeResultOfAlarmCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    echo "        <item id=\""$10"\">"
    checkAlarm
    echo "        </item>"
    echo "      </cmditem>"
    echo "</device>"
}

checkAlarm()
{
    sudo -u ICUser -S $RUNTIME_PATH/bin/reportAlarm.sh --type 1 --severity 1 --alarmId 00000000 --createTime `date "+%s"`000 --param '127.0.0.1'
    getLocalRole
    if [ "$LOCAL_ROLE" == "standby" ];then
             echo "           <errorvalue type=\"0\">Run error</errorvalue>"
             echo "                   <judge>"2"</judge>"
             return
    fi
    sudo /usr/bin/managedScript.sh getAlarmInfo
    if [ $? -ne 0 ] || [ ! -s $tempFile ];then
             echo "           <errorvalue type=\"0\">Run error</errorvalue>"
             echo "                   <judge>"2"</judge>"
    elif [ `cat $tempFile |wc -l` -gt 2 ];then
             echo "           <commonvalue type=\"0\">`cat "$tempFile" | column -t -s","`</commonvalue>"
             echo "                   <judge>"1"</judge>"
    elif [ `cat $tempFile |wc -l` -le 2 ];then
             echo "           <commonvalue type=\"0\">No warning</commonvalue>"
             echo "                   <judge>"0"</judge>"
    fi
}

writeResultOfMachineAccount()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    echo "        <item id=\""$10"\">"
    checkRestMachineAccount
    echo "        </item>"

    echo "        <item id=\""$11"\">"
    checkDbManageAccount
    echo "        </item>"

    echo "        <item id=\""$12"\">"
    checkDbConnectAccount
    echo "        </item>"

    echo "      </cmditem>"
    echo "</device>"
}
checkRestMachineAccount()
{
        local result=`sudo /usr/bin/managedScript.sh getMachineAccountStatus checkRestMachineAccount`
        if [ "$result" == "true" ];then
            echo "           <commonvalue type=\"0\">The initial password of the account has been changed</commonvalue>"
            echo "                   <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\">The initial password of the account is not changed</errorvalue>"
            echo "                   <judge>"1"</judge>"
        fi

}

checkDbManageAccount()
{
        local result=`sudo /usr/bin/managedScript.sh getMachineAccountStatus checkDbManageAccount`

        if [ "$result" == "true" ];then
            echo "           <commonvalue type=\"0\">The initial password of the account has been changed</commonvalue>"
            echo "                   <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\">The initial password of the account is not changed</errorvalue>"
            echo "                   <judge>"1"</judge>"
        fi

}

checkDbConnectAccount() {
       local result=`sudo /usr/bin/managedScript.sh getMachineAccountStatus checkDbConnectAccount`
        if [ "$result" == "true" ];then
            echo "           <commonvalue type=\"0\">The initial password of the account has been changed</commonvalue>"
            echo "                   <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\">The initial password of the account is not changed</errorvalue>"
            echo "                   <judge>"1"</judge>"
        fi
}

if (($2 == 2));then
    writeResultOfLogCheck 2
elif (($2 == 3));then
    writeResultOfResourceCheck 3
elif (($2 == 4));then
    writeResultOfServerCheck 4
elif (($2 == 5));then
    writeResultOfAlarmCheck 5
elif (($2 == 6));then
    writeResultOfMachineAccount 6
fi
sudo /usr/bin/managedScript.sh removeTemp
