# !/usr/bin/env python
# -*- coding: utf-8 -*-
import json


class CheckBase:
    ssh = ""

    def __init__(self, ssh):
        self.ssh = ssh

    def execute(self, check_id):
        try:
            output = self.ssh.execCmd(
                "sh /opt/BCManager/Runtime/root_tools/inspect.sh -c " + check_id)
            output = output[output.find('{'):output.find('}') + 1]
            output_json = json.loads(output)
            commonvalue = '\n'.join(output_json.get("commonvalue").split('#'))
            status = output_json.get("status")
            flag = ""
            if status == "0":
                flag = "True"
            elif status == "1":
                flag = "False"
            elif status == "2":
                flag = "NOCHECK"
            elif status == "3":
                flag = "NOSUPPORT"
            return flag, commonvalue, ""
        except Exception as e:
            return "NOCHECK", "Execute error:" + str(e), ""
