
initEnvironment()
{
    source /etc/profile.d/lego.sh
    INSTALL_PATH=$LEGO_HOME
    LEGORUNTIME_PATH=$INSTALL_PATH/Runtime/LegoRuntime
    local startFile=$INSTALL_PATH/Runtime/bin/config/conf/startInfo.properties
    BACKUSER=`cat "$startFile" | grep custom.user.name | awk -F= '{print $2}'`
    BACKUSER=$(echo $BACKUSER | sed -e 's/\r//g')
    TOMCATUSER=`cat "$startFile" | grep tomcat.user.name | awk -F= '{print $2}'`
    TOMCATUSER=$(echo $TOMCATUSER | sed -e 's/\r//g')
    [ -z "$BACKUSER" ] && BACKUSER=ICUser
    [ -z "$TOMCATUSER" ] && TOMCATUSER=ICUser

    HAMODE=""
    local CONFIG_FILE="${INSTALL_PATH}/Runtime/ha/module/hacom/conf/hacom.xml"
    if [ -f "$CONFIG_FILE" ];then
        local ha_mode=`cat $CONFIG_FILE | grep "<hamode value=\"" | awk -F "\"" '{print $2}'`
        local cascade_mode=`cat $CONFIG_FILE | grep "<cascade value=\"" | awk -F "\"" '{print $2}'`
        if [ "$ha_mode" = "double" ]; then
            HAMODE="double"
        elif [ "$cascade_mode" != "disable" ];then
            HAMODE="double"
        else
            HAMODE="single"
        fi
    fi

    softName=`cat "$INSTALL_PATH/Runtime/bin/config/conf/config.properties" | grep software.install.name | awk -F= '{print $2}'`
    [ -z "$softName" ] && softName=BCManager

    LOCAL_ROLE=""
}

initEnvironment

#########checklog begin###########
writeResultOfLogCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\" 
    echo "<device>"
    echo "        <cmditem id=\""$1"\">"

    if [ -d "$LEGORUNTIME_PATH" ]
    then
        cd "$LEGORUNTIME_PATH"/logs/ISM/
        echo "      <item id=\""$10"\">"
        checkDiskVolume
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    else
        echo "      <item id=\""$10"\">"
        echo "          <errorvalue type=\"0\">BCManager not installed</errorvalue>"
        echo "              <judge>"1"</judge>"
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    fi
} 

checkDiskVolume()
{
    temp=`df -m "$LEGORUNTIME_PATH"| tail -n1|awk '{print $4}'`
    freeCap=`echo "scale=2;$temp / 1024" | bc`
    if echo $freeCap-1.0|bc|grep -E '^-' ; then
        echo "           <errorvalue type=\"0\">0"$freeCap"G</errorvalue>"
        echo "                  <judge>"1"</judge>"
    elif echo $freeCap-5.0|bc|grep -E '^-' ; then
        echo "           <errorvalue type=\"0\">"$freeCap"G</errorvalue>"
        echo "                  <judge>"1"</judge>"
    else
        echo "           <commonvalue type=\"0\">"$freeCap"G</commonvalue>"
        echo "                  <judge>"0"</judge>"
    fi
}
 
 #########checkResource begin###########
writeResultOfResourceCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    
    echo "        <item id=\""$10"\">"
    checkMemory
    echo "        </item>"
    echo "        <item id=\""$11"\">"
    checkCpu
    echo "        </item>"
  
    echo "      </cmditem>"
    echo "</device>"
}

checkMemory()
{
    memStr=`free | grep 'Mem: '`
    used=`echo $memStr | awk -F" " '{print $3}'`
    total=`echo $memStr | awk -F" " '{print $2}'`
    tmp=`expr $used \* 100`
    usage=`expr $tmp / $total`
    if [[ $usage -lt 80 ]];then
        echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

checkCpu()
{
    cpuGeneral=`vmstat | awk -F ' ' 'NR==3{print $15}'`
    cpuWa=`vmstat | awk -F ' ' 'NR==3{print $16}'` 
    usage=`echo "100-$cpuGeneral-$cpuWa " |bc`
    if [[ $usage -lt 80 ]];then
        echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

writeResultOfServerCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    
    echo "        <item id=\""$10"\">"
    checkJVMRunning
    echo "        </item>"
    
    echo "        <item id=\""$14"\">"
    checkIsmHttpsPort
    echo "        </item>"

    echo "        <item id=\""$15"\">"
    checkJVMMemory
    echo "        </item>"

    echo "        <item id=\""$16"\">"
    checkHAStatus
    echo "        </item>"

    echo "        <item id=\""$17"\">"
    checkDBStatus
    echo "        </item>"
    
    echo "      </cmditem>"
    echo "</device>"
}

checkDBStatus()
{
    local dbPid=`ps -ef | grep gaussdb | grep ^GaussDB | grep "\-D" | awk '{print $2}'`
    if [ ! -z "$dbPid" ];then
        echo "           <commonvalue type=\"0\">PID $dbPid</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">GaussDB not running</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

isHARunning()
{
    HAPID=`ps -ef | grep ha.bin | grep -v grep | grep "$softName" | awk '{print $2}'`
    if [ -z "$HAPID" ];then
        return 1
    fi
    return 0
}

checkHAStatus()
{
    isHARunning;local check_result=$?
    if [ $check_result -eq 0 ];then
        echo "           <commonvalue type=\"0\">PID $HAPID</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else
        echo "           <errorvalue type=\"0\">HA not running</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}

checkJVMMemory()
{
    javaId=`ps -efww | grep java | grep equinox.jar | awk '{print $2}'`
    if (( ${#javaId} !=0 ));then 
        temp1=`grep 'VmRSS:' /proc/$javaId/status`
        temp=`echo $temp1 |awk -F" " '{print $2}'`
        usage=`echo "scale=0; $temp / 1024" | bc`
        usedStr=''
        if (( $usage < 1024 ))
        then
            usedStr="$usage"M
        else
            usedStr=`echo "scale=2; $usage / 1024" | bc`G
        fi

        if (( $usage < 3072 ))
        then
            echo "           <commonvalue type=\"0\">"$usedStr"</commonvalue>"
            echo "                  <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\">"$usedStr"</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    else
        getLocalRole
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">BCManager not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

getLocalRole()
{
    if [ ! -z "$LOCAL_ROLE" ];then
        return
    fi
    isHARunning; local checkRes=$?
    if [ $checkRes -ne 0 ];then
        return
    fi

    if [ "$HAMODE" == "single" ];then
        return
    fi

    local haconfig=$INSTALL_PATH/Runtime/ha/local/haarb/conf/haarb_local.xml
    local current_role=`cat "$haconfig" | grep "harole value=" | awk -F 'harole value=\"' '{print $2}' | awk -F '\"' '{print $1}'`
    [ "$current_role" == "1" ] && LOCAL_ROLE=active && return
    [ "$current_role" == "2" ] && LOCAL_ROLE=standby && return
    LOCAL_ROLE=unknown
}

  #########checkJVMRunning begin###########
checkJVMRunning()
{
    javaId=`ps -efww | grep java | grep $BACKUSER | grep equinox.jar | awk '{print $2}'`
    if (( ${#javaId} !=0 ));then
        echo "           <commonvalue type=\"0\">PID $javaId</commonvalue>"
        echo "                  <judge>"0"</judge>"
    else 
        getLocalRole
        echo "LOCAL_ROLE: $LOCAL_ROLE" >>/tmp/result.txt
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">BCManager not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

checkIsmHttpsPort()
{
    javaId=`ps -efww | grep java |grep $TOMCATUSER | grep "$softName" | grep "bootstrap" | awk '{print $2}'`
    if (( ${#javaId} !=0 ));then
        local serverFile=${INSTALL_PATH}/Runtime/Tomcat6/conf/server.xml
        local httpsPort=`cat "$serverFile" | grep keystoreFile | grep port | awk -F 'port=\"' '{print $2}' | awk -F '\"' '{print $1}' | sed -n '1p'`
        local temp=`sudo lsof -i:$httpsPort`
        local result=`echo $temp | awk -F$javaId '{print $1}'`
        if (( ${#result} !=0 ));then
            echo "           <commonvalue type=\"0\">Https port $httpsPort</commonvalue>"
            echo "                   <judge>"0"</judge>"
        else
            echo "           <errorvalue type=\"0\"></errorvalue>"
            echo "                   <judge>"1"</judge>"
        fi
    else
        getLocalRole
        if [ "$LOCAL_ROLE" == "standby" ];then
            echo "           <commonvalue type=\"0\">Standby</commonvalue>"
            echo "                  <judge>"3"</judge>"
        elif [ "$LOCAL_ROLE" == "unknown" ];then
            echo "           <errorvalue type=\"0\">unknown</errorvalue>"
            echo "                  <judge>"2"</judge>"
        else
            echo "           <errorvalue type=\"0\">Tomcat not running</errorvalue>"
            echo "                  <judge>"1"</judge>"
        fi
    fi
}

 #########checkAlarm begin###########
writeResultOfAlarmCheck()
{
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    echo "        <item id=\""$10"\">"
    checkAlarm
    echo "        </item>"
    echo "      </cmditem>"
    echo "</device>"
}

checkAlarm()
{
   local alarmFile=$LEGORUNTIME_PATH/datastorage/currentAlarm/currentAlarm.csv
   cd $INSTALL_PATH/Runtime/bin
   sudo -u root -S ./reportAlarm.sh --type 1 --severity 1 --alarmId 00000000 --createTime `date "+%s"`000 --param '127.0.0.1'
   if [ $? -ne 0 ] || [ ! -s $alarmFile ];then
            echo "           <errorvalue type=\"0\">Run error</errorvalue>"
            echo "                   <judge>"2"</judge>"
   elif [ `cat $alarmFile |wc -l` -gt 2 ];then
            echo "           <commonvalue type=\"0\">`cat "$alarmFile" | column -t -s","`</commonvalue>"
            echo "                   <judge>"1"</judge>"
   elif [ `cat $alarmFile |wc -l` -le 2 ];then
            echo "           <commonvalue type=\"0\">No warning</commonvalue>"
            echo "                   <judge>"0"</judge>"
   fi
}

if (($2 == 2));then
    writeResultOfLogCheck 2
elif (($2 == 3));then
    writeResultOfResourceCheck 3
elif (($2 == 4));then
    writeResultOfServerCheck 4
elif (($2 == 5));then
    writeResultOfAlarmCheck 5
fi
