# -*- coding:utf-8 -*-
import cliUtil
import common
import re
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

NOR_POWERSTATUS = ["enabled", "vacant"]


def execute(cli):
    cliRetList = []
    resultDic = {}
    try:
        switchType, cliRet = common.getSwitchType(cli)
        cliRetList.append(cliRet)
        if not switchType:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))

        if switchType not in config.SWITCH_TYPE_HIGTH_TYPE:
            return True, "\n\n".join(cliRetList), ''

        cmd = "slotshow -m"
        (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetList.append(cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))

        isSucc, slotIdStatusDic = getStatusList(cliRet)
        if not slotIdStatusDic or not isSucc:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))

        for (key, value) in slotIdStatusDic.items():
            if value.lower() not in NOR_POWERSTATUS:
                resultDic[key] = value

        if not resultDic:
            return True, "\n\n".join(cliRetList), ''
        else:
            LOGGER.logInfo("checkResult:%s, the abnormal dict is:%s" % (False, resultDic))
            return (
                False, "\n\n".join(cliRetList),
                common.getMsg(LANG, "check.director.blade.status.no.pass",
                              ";".join(["Slot " + slot for slot in resultDic.keys()])))
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))


def getStatusList(cliRet):
    """
    @summary: 获取槽位与状态字典
    @param cliRet: 回文
    @return: 返回字典
    """
    hasStatus = False
    baldeStatusDict = {}
    for line in cliRet.encode("utf8").splitlines():
        if "status" in line.lower():
            hasStatus = True
            continue

        if not hasStatus:
            continue

        if '0' <= line.strip()[:1] <= '9':
            lineStr = re.split("\s\s+", line.strip())
            slotId = lineStr[0]
            status = lineStr[-1]
            baldeStatusDict[slotId] = status

    LOGGER.logInfo("the status list is:%s" % (baldeStatusDict))
    return hasStatus, baldeStatusDict
