# -*- coding:utf-8 -*-
import cliUtil
import common
import time
import re
import math
import traceback
from com.huawei.ism.tool.obase.exception import ToolException
PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

WAIT_TIME = 5 * 60
allCliRet = ""

checkIncrementFieldList = ["er_enc_in", "er_crc", "er_trunc", "er_toolong", "er_bad_eof", "er_enc_out", "er_bad_os", "er_rx_c3_timeout", "er_tx_c3_timeout", "er_other_discard", "er_type1_miss", "er_type2_miss", "er_type6_miss", "er_zone_miss", "er_lun_zone_miss", "er_crc_good_eof", "er_inv_arb"]
checktPercentageFieldList = ["tim_txcrd_z", "stat_ftx"]
needFieldList = checkIncrementFieldList + checktPercentageFieldList
def execute(cli):
    global allCliRet
    myPthread = common.AsynProgress(PY_JAVA_ENV, LOGGER, sleepTime = 0.4)
    myPthread.start()
    errMsg = ""
    try:
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if not isAdmin:
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "user.level.not.admin"))
        #获取虚拟交换机列表
        (flag, switchFidList, cliRet, errMsg) = common.getSwitchFidList(cli, LANG, LOGGER)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        #如果虚拟交换机列表为空，说明虚拟交换机未开启，不用遍历虚拟交换机
        if len(switchFidList) == 0:
            (checkFlag, checkResult, errMsg) = checkSwitchPortBufferZero(cli)
            if checkFlag != True:
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            if checkResult:
                errMsg = common.getMsg(LANG, "port.stats.show.no.pass.title", "\n".join(checkResult))
                return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
        else:
            (checkFlag, checkResult, errMsg) = checkSwitchPortBufferZeroTraveVF(cli, switchFidList)
            if checkFlag != True:
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            if checkResult:
                errMsg = ""
                for fid in checkResult.keys():
                    errMsg += common.getMsg(
                        LANG, "port.stats.show.no.pass.exit.VF.title",
                        (fid, "\n".join(checkResult.get(fid))))
                return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
        return (True, allCliRet, "")
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except:
            LOGGER.logError(str(traceback.format_exc()))
    
    
def getPortMaxIndex(cli):
    '''
           功能：查询关联的所有端口，获取最大端口
    '''
    global allCliRet
    cmd = "switchshow"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (False, "", errMsg)
    #如果没有记录标示没有端口关联，返回空字符串
    if "No ports found in the system" in cliRet:
        return (True, "", "")
    cliRetDict = cliUtil.getHorizontalCliRet(cliRet)
    LOGGER.logInfo("Get cliRetDict:[%s]"%cliRetDict)
    indexList = [int(dict.get("Index")) for dict in cliRetDict]
    indexMax = indexList[indexList.index(max(indexList))]
    return (True, indexMax, "")

def getPortStats(cli):
    '''
          功能：获取所有端口错误计数（stat_ftx、tim_txcrd_z、er_enc_in、er_crc、
          er_trunc、er_toolong、er_bad_eof、er_enc_out、er_bad_os、
          er_rx_c3_timeout、er_tx_c3_timeout、er_other_discard、
          er_type1_miss、er_type2_miss、er_type6_miss、er_zone_miss、
          er_lun_zone_miss、er_crc_good_eof、er_inv_arb）
         返回：端口ID与各项错误计数的映射字典{portid:{stat_ftx:value,tim_txcrd_z:value.....},.....}
    '''
    global allCliRet
    errMsg = ""
    portStatsDict = {}
    (flag, portMaxIndex, errMsg) = getPortMaxIndex(cli)
    if flag != True:
        return (False, portStatsDict, errMsg)
    #portMaxIndex返回空表示没有关联端口
    if not portMaxIndex:
        return (True, portStatsDict, "")
    cmd = "portstatsshow -i 0-%s -f" % portMaxIndex
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (False, portStatsDict, errMsg)
    LOGGER.logInfo("Start getting the port error value.")
    reg_port = "port:\s+[0-9]+"
    portTuple = re.findall(reg_port, cliRet)
    for num in range(0, len(portTuple)):
        portID = portTuple[num].split(":")[1].strip()
        statsDit = {}
        portInfoBeginIndex = cliRet.find(portTuple[num])
        if num >= len(portTuple) - 1:
            portInfo = cliRet[(portInfoBeginIndex):]
        else:
            portInfoEndIndex = cliRet.find(portTuple[num + 1])
            portInfo = cliRet[(portInfoBeginIndex):portInfoEndIndex]
        #解析PortInfo
        portInfoList = portInfo.encode("utf8").splitlines()
        for needField in needFieldList:
            regNeedField = re.compile("%s\s+([0-9]+)" % needField)
            for line in portInfoList:
                matchNeedField = regNeedField.search(line)
                if matchNeedField:
                    needFieldValue = matchNeedField.group().split()[1]
                    statsDit[needField] = needFieldValue
        portStatsDict[portID] = statsDit
    LOGGER.logInfo("Gets the end of the port error value, and the \
    resolution results are as follows:\n%s" % portStatsDict)
    return (True, portStatsDict, "")
    

def waitSomeTimeKeepCLI(cli, waitTime):
    '''
          功能：睡眠一定时间，期间每个30秒下发Version命令，保持CLI链接
    '''
    intervalTime = 30
    number = waitTime / intervalTime
    remainTime = waitTime % intervalTime
    cmd = "version"
    for num in range(0, number):
        cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
        time.sleep(intervalTime)
    time.sleep(remainTime)
    return

def checkNoPassPorts(portStatsDictEnd, portStatsDictBegin):
    '''
          功能：遍历所有端口,检查每个计数项的增量是否大于零并且tim_txcrd_z增量/stat_ftx增量的比率是否小于10%
        返回：不通过端口的列表
    '''
    err_info_list = []
    err_key = "port.stats.show.no.pass.port.content"
    err_key_tx = "port.stats.show.no.pass.port.content.txcrd"
    for portid in portStatsDictEnd.keys():
        portStatsEndField = portStatsDictEnd.get(portid)
        portStatsBeginField = portStatsDictBegin.get(portid)
        #遍历每个计数项的增量是否大于零
        for Field in checkIncrementFieldList:
            fieldStatsEnd = portStatsEndField.get(Field)
            fieldStatsBegin = portStatsBeginField.get(Field)
            if not fieldStatsEnd or not fieldStatsBegin:
                continue
            fieldIncrement = int(fieldStatsEnd) - int(fieldStatsBegin)
            #产品侧错误计数为32位无符号整形长时间可能出现反转的情况,如果为负或者，正数书都为有增量。
            if fieldIncrement != 0:
                err_info_list.append(common.getMsg(
                    LANG, err_key, (portid, Field, str(fieldIncrement))))
        #计算tim_txcrd_z增量/stat_ftx增量的比率是否小于10%
        timtxcrdzStatsEnd = portStatsEndField.get("tim_txcrd_z")
        timtxcrdzStatsBegin = portStatsBeginField.get("tim_txcrd_z")
        statftxStatsEnd = portStatsEndField.get("stat_ftx")
        statftxStatsBegin = portStatsBeginField.get("stat_ftx")
        
        if not timtxcrdzStatsEnd or \
        not timtxcrdzStatsBegin or \
        not statftxStatsEnd or \
        not statftxStatsBegin:
            continue
        timtxcrdzIncrement = int(timtxcrdzStatsEnd) - int(timtxcrdzStatsBegin) 
        statftxIncrement = int(statftxStatsEnd) - int(statftxStatsBegin)
        #产品侧错误计数为32位无符号整形长时间可能出现反转的情况，如果为负，认为出现反转，需要加上最大计数。
        if timtxcrdzIncrement < 0:
            timtxcrdzIncrement += 2 ** 32
        if statftxIncrement < 0:
            statftxIncrement += 2 ** 32
        if timtxcrdzIncrement == 0 or statftxIncrement == 0:
            continue

        ratio_value = int(timtxcrdzIncrement) * 100 / int(statftxIncrement)
        if ratio_value >= 10:
            err_info_list.append(common.getMsg(
                LANG, err_key_tx, (portid, str(ratio_value))))
    return list(set(err_info_list))


def checkSwitchPortBufferZero(cli):
    '''
          功能：检查各项计数值增量为0且tim_txcrd_z增量/stat_ftx增量的比率小于10%。
          返回：（检查是否成功，检查不通过交换机映射的端口列表）
          [portid1,portid2...]
    '''
    errMsg = ""
    noPassPortid = []
    (flag, portStatsDictBegin, errMsg) = getPortStats(cli)
    if flag != True:
        return (False, noPassPortid, errMsg)
    waitSomeTimeKeepCLI(cli, WAIT_TIME)
    (flag, portStatsDictEnd, errMsg) = getPortStats(cli)
    if flag != True:
        return (False, noPassPortid, errMsg)
    if not portStatsDictEnd:
        return (True, noPassPortid, "")
    LOGGER.logInfo("portStatsDictEnd:%s" % portStatsDictEnd)
    LOGGER.logInfo("portStatsDictBegin:%s" % portStatsDictBegin)
    noPassPortid = checkNoPassPorts(portStatsDictEnd, portStatsDictBegin)
    return (True, noPassPortid, "")

def checkSwitchPortBufferZeroTraveVF(cli, switchFidList):
    '''
          功能：遍历所有虚拟交换机，检查各项计数值增量为0且tim_txcrd_z增量/stat_ftx增量的比率小于10%。
          返回：（检查是否成功，检查不通过交换机映射的端口列表）
          {FID：[portid1,portid2...]}
    '''
    global allCliRet
    errMsg = ""
    checkResult = {}
    checkNoPassPortid = []
    fidPortStatsDictEnd = {}
    fidPortStatsDictBegin = {}
    for fid in switchFidList:
        LOGGER.logInfo("Start switching to Virtual Switch %s to get the first port error value." % fid)
        (flag, cliRet, errMsg) = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (False, checkResult, errMsg)
        (flag, portStatsDictBegin, errMsg) = getPortStats(cli)
        if flag != True:
            return (False, checkResult, errMsg)
        fidPortStatsDictBegin[fid] = portStatsDictBegin
    waitSomeTimeKeepCLI(cli, WAIT_TIME)
    for fid in switchFidList:
        LOGGER.logInfo("Start switching to Virtual Switch %s to get port error values after 5 minutes." % fid)
        (flag, cliRet, errMsg) = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (False, checkResult, errMsg)
        (flag, portStatsDictEnd, errMsg) = getPortStats(cli)
        if flag != True:
            return (False, checkResult, errMsg)
        fidPortStatsDictEnd[fid] = portStatsDictEnd
    LOGGER.logInfo("fidPortStatsDictEnd:%s" % fidPortStatsDictEnd)
    LOGGER.logInfo("fidPortStatsDictBegin:%s" % fidPortStatsDictBegin)
    for fid in switchFidList:
        portStatsDictEnd = fidPortStatsDictEnd.get(fid)
        portStatsDictBegin = fidPortStatsDictBegin.get(fid)
        checkNoPassPortid = checkNoPassPorts(portStatsDictEnd, portStatsDictBegin)
        if len(checkNoPassPortid) != 0:
            checkResult[fid] = checkNoPassPortid
    return (True, checkResult, "")

