# -*- coding:utf-8 -*-
import cliUtil
import common
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

NOR_POWERSTATUS = ["ok", "absent"]


def execute(cli):
    isPowerStatus = True
    abnormalList = []
    try:
        cmd = "psshow"
        (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, "", errMsg)
        powerSupplyPattern = re.compile(r'Power Supply.*#(\d+) is', re.I)

        if not powerSupplyPattern.search(cliRet):
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

        for line in cliRet.encode("utf8").splitlines():
            powerSupplyInfo = powerSupplyPattern.search(line)
            if powerSupplyInfo:
                powerStatus = line.split("is")[1].split()[0].strip()
                if powerStatus.lower() not in NOR_POWERSTATUS:
                    isPowerStatus = False
                    abnormalList.append(powerSupplyInfo.group(1))
        if isPowerStatus:
            return True, cliRet, ''
        else:
            LOGGER.logInfo("checkResult:%s, the abnormal list is:%s" % (isPowerStatus, abnormalList))
            return (
                False, cliRet,
                common.getMsg(LANG, "check.power.status.no.pass", ";".join(["ID " + id for id in abnormalList])))
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
