# -*- coding:utf-8 -*-
import cliUtil
import common
import re
import traceback
from com.huawei.ism.tool.obase.exception import ToolException


PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)
SFP_TX_POWER_THRESHOLD_VALUE = 350
SFP_RX_POWER_THRESHOLD_VALUE = 300

SWITCH_ONLINE_STATE_LIST = ["Online", "Online (Temporary)"]


def execute(cli):
    ret_list = []
    myPthread = common.AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start()
    try:
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        ret_list.append(cliRet)
        if not isAdmin:
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "user.level.not.admin"))
        #获取虚拟交换机列表
        (flag, switchFidList, cliRet, errMsg) = common.getSwitchFidList(cli, LANG, LOGGER)
        ret_list.append(cliRet)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, get_ret(ret_list), errMsg
        #如果虚拟交换机列表为空，说明虚拟交换机未开启，不用遍历虚拟交换机
        check_result = []
        if len(switchFidList) == 0:
            t_light_decay_sfp, r_light_decay_sfp, port_index_dict = check_all_ports(cli, ret_list)
            t_light_decay_sfp_final, r_light_decay_sfp_final = check_single_sfp_status_again(
                cli, ret_list, t_light_decay_sfp, r_light_decay_sfp)
            LOGGER.logInfo(
                "1 check_single_sfp_status_again t_light_decay_sfp_final:{}, \nr_light_decay_sfp_final:{}".format(
                    t_light_decay_sfp_final, r_light_decay_sfp_final))
            for key, value in t_light_decay_sfp_final.items():
                check_result.append(common.getMsg(
                    LANG, "check.sfp.status.tx.power", (key, get_port_index(key, port_index_dict), value)))
            for key, value in r_light_decay_sfp_final.items():
                check_result.append(common.getMsg(
                    LANG, "check.sfp.status.rx.power", (key, get_port_index(key, port_index_dict), value)))
        else:
            check_result = checkSFPstatusTraveVF(cli, switchFidList, ret_list)
        if check_result:
            return False, get_ret(ret_list), "".join(check_result)
        return True, get_ret(ret_list), ""
    except common.UnCheckException as e:
        return cliUtil.RESULT_NOCHECK, get_ret(ret_list), e.errorMsg
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, get_ret(ret_list),
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except:
            LOGGER.logError(str(traceback.format_exc()))


def get_port_index(port_id, port_index_dict):
    reg_legal_port = re.compile("(?:Slot\s*([0-9]+)/)?Port\s*([0-9]+)")
    match_res = reg_legal_port.match(port_id)
    if not match_res:
        return "--"
    return port_index_dict.get(match_res.groups(), "--")


def get_ret(ret_list):
    return "\n".join(ret_list)


def check_all_ports(cli, ret_list):
    """
    检查全部端口信息
    :param cli:
    :return:
    """
    (flag, switch_state, t_power_list, r_power_list, err_msg, port_index_dict) = getSwitchStateAndNoCheckPort(
        cli, ret_list)
    if flag is not True:
        raise common.UnCheckException(err_msg, '')
    LOGGER.logInfo("not check t_power_list: {}, \nr_power_list: {}, \n port_index_dict:{}".format(
        t_power_list, r_power_list, port_index_dict))
    # 如果交换机不是在线状态，不做检查。
    if switch_state not in SWITCH_ONLINE_STATE_LIST:
        return dict(), dict(), dict()
    cmd = "sfpshow -all"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
    ret_list.append(ret)

    # 检查tx power
    t_power_reg_str = re.compile("TX Power:.*[(](.*?)\s*uW[)]")
    t_light_decay_sfp = check_sfp_status(
        ret, t_power_list, t_power_reg_str, SFP_TX_POWER_THRESHOLD_VALUE)
    LOGGER.logInfo("check_sfp_status t_light_decay_sfp:{}".format(t_light_decay_sfp))
    # 检查rx power
    r_power_reg_str = re.compile("RX Power:.*[(](.*?)\s*uW[)]")
    r_light_decay_sfp = check_sfp_status(
        ret, r_power_list, r_power_reg_str, SFP_RX_POWER_THRESHOLD_VALUE)
    LOGGER.logInfo("check_sfp_status r_light_decay_sfp:{}".format(r_light_decay_sfp))
    return t_light_decay_sfp, r_light_decay_sfp, port_index_dict


def check_single_sfp_status_again(cli, ret_list, t_light_decay_sfp, r_light_decay_sfp):
    t_power_reg_str = re.compile("TX Power:.*[(](.*?)\s*uW[)]")
    r_power_reg_str = re.compile("RX Power:.*[(](.*?)\s*uW[)]")
    reg_legal_port = re.compile("(?:Slot\s*([0-9]+)/)?Port\s*([0-9]+)")
    t_light_decay_sfp_final, r_light_decay_sfp_final = {}, {}
    cmd = "sfpshow {} -f"
    all_ports = set(list(r_light_decay_sfp.keys()) + list(t_light_decay_sfp.keys()))
    for fp_port in all_ports:
        port_tuple = reg_legal_port.findall(fp_port)
        tmp_cmd_str = cmd.format("/".join(port_tuple[0]).lstrip("/"))
        flag, cli_ret, errMsg = cliUtil.excuteCmdInCliMode(cli, tmp_cmd_str, False, LANG)
        ret_list.append(cli_ret)
        if flag is not True:
            raise common.UnCheckException(errMsg, '')
        res, value = check_delay(cli_ret, t_power_reg_str, SFP_TX_POWER_THRESHOLD_VALUE)
        if not res and fp_port in t_light_decay_sfp:
            t_light_decay_sfp_final[fp_port] = value
        res, value = check_delay(cli_ret, r_power_reg_str, SFP_RX_POWER_THRESHOLD_VALUE)
        if not res and fp_port in r_light_decay_sfp:
            r_light_decay_sfp_final[fp_port] = value
    return t_light_decay_sfp_final, r_light_decay_sfp_final


def check_delay(ret, power_reg, power_value):
    match_power = power_reg.search(ret)
    if match_power:
        # 获取到功率值后取整进行比较
        match_value = match_power.group(1).strip()
        temp_power = int(match_value.split(".")[0])
        if temp_power < power_value:
            return False, match_value
        return True, None
    # TX Power字段不存在或者获取不到功率值，认为该端口异常，检查不通过。
    return False, None


def check_sfp_status(ret, not_check_port_list, power_reg_str, power_value):
    """
    功能：检查T/RX Power值是否满足阈值。
    返回：不满足阈值的光模块端口列表
    :param ret:
    :param not_check_port_list:
    :param power_reg_str:
    :param power_value:
    :return:
    """
    light_decay_sfp = dict()
    reg_allPort = re.compile("(?:\S+ *)?(?:Slot\s*[0-9]+/)?Port\s*[0-9]+:(?: *\S+)?")
    reg_legalPort = re.compile("(?:Slot\s*([0-9]+)/)?Port\s*([0-9]+):$")
    portTuple = reg_allPort.findall(ret)
    for num in range(0, len(portTuple)):
        portID = portTuple[num].strip()
        # 只检查ID为标准格式的光模块Slot  0/Port  0,过滤掉列如GE，XGE的光模块。
        match_legalPort = reg_legalPort.match(portID)
        if not match_legalPort:
            continue

        # 如果是不需要检查的端口（FC Disabled），直接跳过。
        if match_legalPort.groups() in not_check_port_list:
            continue
        portInfoBeginIndex = ret.find(portTuple[num])
        if num >= len(portTuple) - 1:
            portInfo = ret[(portInfoBeginIndex):]
        else:
            portInfoEndIndex = ret.find(portTuple[num + 1])
            portInfo = ret[(portInfoBeginIndex):portInfoEndIndex]
        # 解析PortInfo
        regIdentifier = re.compile("Identifier:\s*3\s+SFP")
        regTransceiver = re.compile("Transceiver:.*\D(?:4|8|16|32)_Gbps.*(?:sw|lw).+")
        if not regIdentifier.search(portInfo) or not regTransceiver.search(portInfo):
            continue
        match_power = power_reg_str.search(portInfo)
        port_id = portID.rstrip(":")
        if match_power:
            #获取到功率值后取整进行比较
            match_value = match_power.group(1).strip()
            temp_power = int(match_value.split(".")[0])
            if temp_power < power_value:
                light_decay_sfp[port_id] = match_value
        else:
            #TX Power字段不存在或者获取不到功率值，认为该端口异常，检查不通过。
            light_decay_sfp[port_id] = None
    return light_decay_sfp


def checkSFPstatusTraveVF(cli, switch_fid_list, ret_list):
    '''
          功能：遍历switchFidList查询端口光模块信息，筛选Identifier为3，最大速率为4Gbps、8Gbps、16Gbps或32Gbps，波长为sw的光模块信息，
                     判断TX Power值是否满足阈值。
         返回：FID与不满足阈值的光模块端口列表的映射字典。
         {FID:[PortID,..],...}
    '''
    check_result = []
    for fid in switch_fid_list:
        flag, ret, msg = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
        ret_list.append(ret)
        if flag is not True:
            raise common.UnCheckException(msg, ret)
        t_light_decay_sfp, r_light_decay_sfp, port_index_dict = check_all_ports(
            cli, ret_list)

        t_light_decay_sfp_final, r_light_decay_sfp_final = check_single_sfp_status_again(
            cli, ret_list, t_light_decay_sfp, r_light_decay_sfp)
        LOGGER.logInfo("check sfp again t_light_decay_sfp_final:{}, \nr_light_decay_sfp_final:{}".format(
            t_light_decay_sfp_final, r_light_decay_sfp_final))
        for key, value in t_light_decay_sfp_final.items():
            check_result.append(common.getMsg(
                LANG, "check.sfp.status.tx.power.vm", (fid, key, get_port_index(key, port_index_dict), value)))
        for key, value in r_light_decay_sfp_final.items():
            check_result.append(common.getMsg(
                LANG, "check.sfp.status.rx.power.vm",
                (fid, key, get_port_index(key, port_index_dict), value)))
    return check_result


def getSwitchStateAndNoCheckPort(cli, ret_list):
    '''
    功能：获取当前交换机状态和包含FC Disabled的端口ID(SlotID,PortID)/(None,PortID)
    返回：（是否成功，SwtichState， [(SlotID,PortID),(SlotID,PortID)], errMsg）
    '''
    errMsg = ""
    not_check_list = list()
    port_index_dict = {}
    r_power_list = list()
    cmd = "switchshow"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
    ret_list.append(cliRet)
    if flag is not True:
        return False, False, not_check_list, r_power_list, errMsg, port_index_dict
    allSfpInfoDictList, switchInfoDict = common.switchshowCliRetAnalysis(cliRet, LOGGER)
    switchState = switchInfoDict.get("switchState")
    if not switchState:
        errMsg = common.getMsg("query.result.abnormal")
        return False, False, not_check_list, r_power_list, errMsg, port_index_dict
    for allSfpInfoDict in allSfpInfoDictList:
        proto = allSfpInfoDict.get("Proto")
        otherInfo = allSfpInfoDict.get("otherInfo")
        slot = allSfpInfoDict.get("Slot")
        port = allSfpInfoDict.get("Port")
        port_state = allSfpInfoDict.get("State")
        temp_value = (None, port) if slot == "--" else (slot, port)
        index = allSfpInfoDict.get("Index")
        if proto == "FC" and "Disabled" in otherInfo:
            not_check_list.append(temp_value)
            r_power_list.append(temp_value)
        if port_state == "No_Light":
            r_power_list.append(temp_value)
        port_index_dict[temp_value] = index
        LOGGER.logInfo("getSwitchStateAndNoCheckPort allSfpInfoDict:{}, port_index_dict:{}".format(
            allSfpInfoDict, port_index_dict))
    return True, switchState, not_check_list, list(set(r_power_list)), errMsg, port_index_dict
