# -*- coding:utf-8 -*-
import cliUtil
import common
import time
import re
import math
import traceback
from com.huawei.ism.tool.obase.exception import ToolException

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

WAIT_TIME = 5 * 60
allCliRet = ""
G_PortErrorStates = ["Laser_Flt","Port_Flt","Diag_Flt","No_Sync", ""]

def execute(cli):
    global allCliRet
    myPthread = common.AsynProgress(PY_JAVA_ENV, LOGGER, sleepTime = 0.4)
    myPthread.start()

    try:
        flag = True
        errMsg = ""
        # 获取虚拟交换机列表
        (flag, switchFidList, cliRet, errMsg) = common.getSwitchFidList(cli, LANG, LOGGER)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        LOGGER.logInfo("switchFidList:%s" % (switchFidList))

        # 虚拟机列表为空，只需要查询当前主机
        if not switchFidList:
            return checkSingleSwitchState(cli, "")

        for switchFid in switchFidList:
            iRet = checkSingleSwitchState(cli, switchFid)
            if iRet[0] != True and flag != False:
                flag = iRet[0]
            if iRet[2]:
                errMsg += iRet[2] + "\n"

        return (flag, allCliRet, errMsg)
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except:
            LOGGER.logError(str(traceback.format_exc()))

def checkSingleSwitchState(cli, fid=""):
    '''
          功能：检查交换机的state信息：“switchState”、“zoning”和端口“state”
          返回：（检查是否成功，检查不通过交换机映射的端口列表）
          [portid1,portid2...]
    '''
    global allCliRet
    if fid:
        LOGGER.logInfo("Start switching to Virtual Switch %s to get the state information." % fid)
        #切换到对应的虚拟机
        (flag, cliRet, errMsg) = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

    cmd = "switchshow"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

    portInfoDictList, baseInfoDict = common.switchshowCliRetAnalysis(cliRet, LOGGER)
    LOGGER.logInfo("portInfoDictList:%s" % str(portInfoDictList))
    LOGGER.logInfo("baseInfoDict:%s" % str(baseInfoDict))

    #1、检查交换机状态
    switchState = baseInfoDict.get("switchState", "")
    if switchState.lower() != "online":
        flag = False
        if not fid:
            errMsg += common.getMsg(LANG, "switch.state.current.switchstate.error", (switchState))
        else:
            errMsg += common.getMsg(LANG, "switch.state.virtural.switchstate.error", (fid, switchState))
        return (flag, allCliRet, errMsg)

    #2、检查端口状态
    if "no ports found in the system" in cliRet.lower():
        return (flag, allCliRet, errMsg)
    for portDict in portInfoDictList:
        portState = portDict.get("State", "")
        if portState in G_PortErrorStates:
            flag = False
            if not fid:
                errMsg += common.getMsg(LANG, "switch.state.current.port.error", (portDict.get("Index", ""), portState))
            else:
                errMsg += common.getMsg(LANG, "switch.state.virtural.port.error", (fid, portDict.get("Index", ""), portState))

    return (flag, allCliRet, errMsg)