# -*- coding:utf-8 -*-
import cliUtil
import common
from frameone.ruleConfig import executeRule

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    checking temperature sensor readings
    :param cli:
    :return:
    """
    cliRet = ""
    try:
        cmd = "tempshow"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
        if flag != True:
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        lines = cliRet.splitlines()
        startToParsePoi = 0
        for line in lines:
            startToParsePoi += 1
            if "===" in line or "----" in line:
                break
        if startToParsePoi >= len(lines) - 1:
            raise Exception()
        abnormalSensors = []
        for line in lines[startToParsePoi: -1]:
            if "ok" in line.lower() or "absent" in line.lower():
                continue
            else:
                abnormalSensors.append(line.split()[0])
        if not abnormalSensors:
            return True, cliRet, ""
        else:
            return False, cliRet, common.getMsg(LANG,
                                                                 "the.following.sensor.reading.abnormal",
                                                                 ",".join(abnormalSensors))

    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal")
