# -*- coding:utf-8 -*-
import cliUtil
import common
import re
import traceback
from com.huawei.ism.tool.obase.exception import ToolException
PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

allCliRet = ""

def execute(cli):
    global allCliRet
    myPthread = common.AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start()
    errMsg = ""
    try:
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if not isAdmin:
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "user.level.not.admin"))
        #获取虚拟交换机列表
        (flag, switchFidList, cliRet, errMsg) = common.getSwitchFidList(cli, LANG, LOGGER)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        #如果虚拟交换机列表为空，说明虚拟交换机未开启，不用遍历虚拟交换机
        if len(switchFidList) == 0:
            (checkFlag, checkResult, errMsg) = checkCascadingLinkRedundancy(cli)
            if checkFlag != True:
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            if checkResult:
                errMsg = common.getMsg(LANG, "check.cascading.link.redundancy.no.pass", ",".join(checkResult))
                return (False, allCliRet, errMsg)
        else:
            (checkFlag, checkResult, errMsg) = checkCascadingLinkRedundancyTraveVF(cli, switchFidList)
            if checkFlag != True:
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            if checkResult:
                errMsg = ""
                for fid in checkResult.keys():
                    errMsg += common.getMsg(LANG, "check.cascading.link.redundancy.no.pass.exit.VF", (fid, ",".join(checkResult.get(fid))))
                return (False, allCliRet, errMsg)
        return (True, allCliRet, "")
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except:
            LOGGER.logError(str(traceback.format_exc()))

def getNumberLinks(cli, cmd):
    '''
           功能：查询创建的链路数
           返回：每个远端虚拟交换机与链路数映射的字典
        {WWN：链路数量，....}
    '''
    global allCliRet
    numberLinksDict = {}
    WWNList = []
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (False, numberLinksDict, errMsg)
    cliRetList = cliRet.encode("utf8").splitlines()
    regWWN = re.compile("(([a-fA-F0-9]{2}:){7}|([a-fA-F0-9]{2}:){5})[a-fA-F0-9]{2}")
    for line in cliRetList:
        matchWWN = regWWN.search(line)
        if matchWWN:
            WWNList.append(matchWWN.group())
    for WWN in WWNList:
        numberLinksDict[WWN] = WWNList.count(WWN)
    return (True, numberLinksDict, "")
                        
        
        
def checkCascadingLinkRedundancy(cli):
    '''
          功能：查询trunk和islshow的链路，检查每个WWN的条数，如果等于1则为不冗余
         返回：不冗余WWN列表。
    '''
    noRedundancyWwn = []
    (flag, numberTrunkLinksDict, errMsg) = getNumberLinks(cli, "trunkshow")
    LOGGER.logInfo("After obtaining link information parsing through the trunkshow command, the results are as follows:%s" % numberTrunkLinksDict)
    if flag != True:
        return (False, noRedundancyWwn, errMsg)
    (flag, numberLinksDict, errMsg) = getNumberLinks(cli, "islshow")
    LOGGER.logInfo("After obtaining link information parsing through the islshow command, the results are as follows:%s" % numberLinksDict)
    if flag != True:
        return (False, noRedundancyWwn, errMsg)
    for wwn in numberLinksDict:
        wwnLinkNum = numberLinksDict.get(wwn)
        wwnTrunkLinkNum = numberTrunkLinksDict.get(wwn, 0)
        if max(wwnLinkNum, wwnTrunkLinkNum) == 1:
            noRedundancyWwn.append(wwn)
    return (True, noRedundancyWwn, "")
     
    
    
def checkCascadingLinkRedundancyTraveVF(cli, switchFidList):
    '''
          功能：遍历switchFidList查询trunk和islshow的链路，检查每个WWN的条数，如果等于1则为不冗余
         返回：FID与不冗余WWN列表的映射字典。
         {FID:[WWN,..],...}
    '''
    global allCliRet
    checkResult = {}
    for fid in switchFidList:
        (flag, cliRet, errMsg) = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (False, checkResult, errMsg)
        (flag, noRedundancyWwn, errMsg) = checkCascadingLinkRedundancy(cli)
        if flag != True:
            return (False, checkResult, errMsg)
        if len(noRedundancyWwn) > 0:
            checkResult[fid] = noRedundancyWwn
    return (True, checkResult, "")
    
    

