# -*- coding:utf-8 -*-
import cliUtil
import common
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    cliRetList = []
    try:
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        cliRetList.append("Command:" + cliRet)
        if not isAdmin:
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "user.level.not.admin"))

        # 非虚拟交换机的命令
        switchType, cliRet = common.getSwitchType(cli)
        cliRetList.append(cliRet)
        if not switchType:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))
        
        if switchType in config.SWITCH_TYPE_HIGTH_TYPE:
            for cmdStr in config.COLLECT_CLI_RET_CMDS_HIGHT:
                cliRetList.append(cli.execCmdWithTimout(cmdStr, 300))
        else:
            for cmdStr in config.COLLECT_CLI_RET_CMDS_LOWER:
                cliRetList.append(cli.execCmdWithTimout(cmdStr, 300))

        for cmdStr in config.COLLECT_CLI_RET_CMDS_COMMON:
            cliRetList.append(cli.execCmdWithTimout(cmdStr, 300))

        # 虚拟交换机命令
        __, isVirtual, cliRet, errMsg = common.isVirtualSwitchesStarted(cli, LANG)
        cliRetList.append(cliRet)

        if isVirtual:
            __, isDefault, cliRet, __ = common.isDefaultSwitchLogin(cli, LANG)
            cliRetList.append(cliRet)
            LOGGER.logInfo("isDefault:%s" % str(isDefault))

            if not isDefault:
                __, cliRet, __ = common.switchToDefaultSwitch(cli, LANG)
                cliRetList.append(cliRet)

            # 获取默认的128回显
            getVirtualCliRet(cli, cliRetList)

            # 遍历其他虚拟交换机获取回显
            __, switchFidList, allCliRet, __ = common.getSwitchFidListsOneCommand(cli, LANG)
            LOGGER.logInfo("switchFidList:%s" % str(switchFidList))
            if '128' in switchFidList:
                switchFidList.remove('128')

            for fid in switchFidList:
                cliRetList.append("\n\n===========FID:%s==========" % fid)
                __, cliRet, __ = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
                LOGGER.logInfo("SwitchToSpecVirtualSwitch: success %s" % fid)
                cliRetList.append(cliRet)
                getVirtualCliRet(cli, cliRetList)
        else:
            getVirtualCliRet(cli, cliRetList)

        cliRet = "\n\nCommand:".join(cliRetList)
        return True, cliRet, ''
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n\n".join(cliRetList), common.getMsg(LANG, "query.result.abnormal"))
    finally:
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except Exception, exception:
            LOGGER.logException(exception)

def getVirtualCliRet(cli, cliRetList):
    """
    获取交换机命令回显
    :param cli:
    :param cliRetList:
    :return:
    """
    for cmdStr in config.COLLECT_CLI_RET_IN_VIRTUAL:
        try:
            cliRetList.append(cli.execCmdWithTimout(cmdStr, 300))
        except Exception, exception:
            LOGGER.logException(exception)