# -*- coding:utf-8 -*-
import cliUtil
import common
import re
from frameone.ruleConfig import executeRule

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

LICENSE_TTITLE = "extended fabric license"
LICENSE_EXPIRED = "expiry date"

def execute(cli):
    """
    开局场景	检查拉远license
    :param cli:
    :return:
    """
    cli_ret = ""
    try:
        # if current device is not cascadeing pull away:
        if not is_remote_switch_far_away():
            return cliUtil.RESULT_NOSUPPORT, "", ""
        cmd = "licenseshow"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)  # type: (str or bool, str, str)
        if flag != True:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        lines = cli_ret.lower().splitlines()
        lines = lines[1:-1]
        license_key = ""
        is_for_fabric_lic = False
        is_expired = False
        for line in lines:
            if re.match("^[\S]+", line, re.I):
                if is_for_fabric_lic:
                    if is_expired:
                        return False, cli_ret, common.getMsg(LANG, "current.device.extend.fabric.expired")
                    else:
                        # surly this scenario current device has license that is not expired.
                        return True, cli_ret, ""
                else:
                    license_key = line.strip()
                    is_for_fabric_lic = False
                    is_expired = False
                continue
            elif LICENSE_TTITLE in line:
                is_for_fabric_lic = True
                continue
            elif LICENSE_EXPIRED in line:
                is_expired = True
                continue
        if is_for_fabric_lic and not is_expired:
            return True, cli_ret, ""
        elif is_for_fabric_lic and is_expired:
            return False, cli_ret, common.getMsg(LANG, "current.device.extend.fabric.expired")
        else:
            return False, cli_ret, common.getMsg(LANG, "current.device.extend.fabric.lic.not.install")
    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")

def is_remote_switch_far_away():
    is_long_distance_cascade = py_java_env.get("switchIsLongRangeCascade")
    # None or False
    if not is_long_distance_cascade:
        return False
    return True