# -*- coding:utf-8 -*-
import cliUtil
import common
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    checking firmware sensor readings
    :param cli:
    :return:
    """
    cli_ret = ''
    try:
        cmd = "firmwareshow"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
        if flag != True:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        if "primary/secondary version" not in cli_ret.lower():
            LOGGER.logError("error: the echos of firmwareshow does not contain primary/secondary version key !")
            return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")
        lines = cli_ret.lower().splitlines()

        start_parse_line = 0
        for line in lines:
            start_parse_line += 1
            if "---" in line:
                break
        if start_parse_line >= len(lines) - 1:
            raise Exception()
        firmware_versions = []
        is_prim = False
        for line in lines[start_parse_line: -1]:
            vers = re.search(r'v[0-9]+(\.[0-9]+)+[\S]+', line, re.I)
            if "warning:" in line or line.startswith("*") or not line:
                break

            if vers:
                firmware_versions.append(vers.group())
            else:
                LOGGER.logInfo("there are lines do not contain key info.")
                return False, cli_ret, common.getMsg(LANG, "current.fw.version.pri-secnd.not.match")
            if not is_prim and len(line.split()) > 1:
                is_prim = True
                continue
            if is_prim and len(line.split()) == 1:
                is_prim = False
                continue
            if is_prim and len(line.split()) > 1:
                LOGGER.logInfo("current partion's pri/secondary version  is inconsist.")
                return False, cli_ret, common.getMsg(LANG, "current.fw.version.pri-secnd.not.match")

        if not firmware_versions or len(firmware_versions) <= 1:
            LOGGER.logError("error occured: the result echo is abnormal or" +
                            " the parsing stategy is not all-encopmpassing")
            raise Exception()

        firmware_versions = list(set(firmware_versions))
        if len(firmware_versions) > 1:
            return False, cli_ret, common.getMsg(LANG,
                                                 "current.slot.version.inconsist",
                                                 ",".join(firmware_versions))
        return True, cli_ret, ""
    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")
