# -*- coding:utf-8 -*-
import cliUtil
import common
import re
from frameone.ruleConfig import executeRule

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
VERSION_SPAN = 1000
VERSION_THRESHOLD = 7004
INT2 = 2

def execute(cli):
    """
    健康状态检查
    :param cli:
    :return:
    """
    cli_ret = ''
    try:
        version_cmd = "version"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, version_cmd, False,
                                                            LANG)  # type: (str or bool, str, str)
        if flag != True:
            LOGGER.logError("error occurred while excuting version command.")
            return flag, cli_ret, err_msg
        lines = cli_ret.lower().splitlines()
        current_version = ""
        for line in lines:
            if 'fabric os:' in line:
                line = line.split(":")[1]
                version_list = line.split(".")
                if len(version_list) < INT2:
                    # the version field is not valid
                    break
                current_version = int("".join(re.findall(r'\d', version_list[0]))) * VERSION_SPAN\
                    + int("".join(re.findall(r'\d', version_list[1])))
                LOGGER.logError("processing sns version to %s." % str(current_version))
        if not current_version:
            LOGGER.logError("error occurred while parsing version command.")
            raise Exception()
        if current_version >= VERSION_THRESHOLD:
            return check_by_mapdb(cli, cli_ret)
        else:
            return check_by_switchstatus(cli, cli_ret)

    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")


def check_by_mapdb(cli, cli_rets):
    """

    :param cli_rets:
    :param cli:
    :return:
    """
    cmd = 'mapsdb --show'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)  # type: (str or bool, str, str)
    cli_rets += "\n\n" + cli_ret
    if flag != True:
        LOGGER.logError("error occurred while excuting mapsdb --show command.")
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
    lines = cli_ret.lower().splitlines()
    key = 'current switch policy status'
    for line in lines:
        if key in line and ":" in line:
            if 'healthy' in line:
                return True, cli_rets, ""
            else:
                return False, cli_rets, common.getMsg(LANG, "switch.mapsdb.status.not.healthy")
    return cliUtil.RESULT_NOCHECK, cli_rets, common.getMsg(LANG, "mapsdb.result.abnormal")


def check_by_switchstatus(cli, cli_rets):
    """

    :param cli:
    :param cli_rets:
    :return:
    """
    cmd = 'switchstatusshow'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)  # type: (str or bool, str, str)
    cli_rets += "\n\n" + cli_ret
    if flag != True:
        LOGGER.logError("error occurred while excuting mapsdb --show command.")
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
    lines = cli_ret.lower().splitlines()
    key = 'switchstate'
    for line in lines:
        if key in line and ":" in line:
            if 'healthy' in line:
                return True, cli_rets, ""
            else:
                return False, cli_rets, common.getMsg(LANG, "switch.switchshow.status.not.healthy")
    return cliUtil.RESULT_NOCHECK, cli_rets, common.getMsg(LANG, "switchstatusshow.result.abnormal")
