# -*- coding:utf-8 -*-
import cliUtil
import common
import config
import cliResource
import re
import xlwt
import os
import sys
from com.huawei.ism.tool.obase.exception import ToolException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET_LIST = []
SWITCH_TYPE = ''
IS_HIGHEND_SWITCH = False
SWITCH_NAME = ''

try:
    reload(sys)
    sys.setdefaultencoding('utf8')
except Exception, exception:
    LOGGER.logException(exception)


def execute(cli):
    global SWITCH_TYPE, IS_HIGHEND_SWITCH
    myPthread = common.AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start()
    try:
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        if not isAdmin:
            return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "user.level.not.admin"))

        # 保存收集其他命令的信息文件。
        saveCollectCliRetToFile(cli)

        # 非虚拟交换机的命令
        SWITCH_TYPE, cliRet = common.getSwitchType(cli)
        IS_HIGHEND_SWITCH = SWITCH_TYPE in config.SWITCH_TYPE_HIGTH_TYPE

        ALL_CLI_RET_LIST.append(cliRet)
        if not SWITCH_TYPE:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG, "query.result.abnormal"))

        # 虚拟交换机命令
        flag, isVirtual, cliRet, errMsg = common.isVirtualSwitchesStarted(cli, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), errMsg)

        riskSfpDictList = []
        remoteReduntWWPN = {}
        if isVirtual:
            flag, isDefault, cliRet, errMsg = common.isDefaultSwitchLogin(cli, LANG)
            ALL_CLI_RET_LIST.append(cliRet)
            LOGGER.logInfo("isDefault:%s" % str(isDefault))
            if flag != True:
                return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), errMsg)

            if not isDefault:
                flag, cliRet, errMsg = common.switchToDefaultSwitch(cli, LANG)
                if flag != True:
                    return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), errMsg)
                ALL_CLI_RET_LIST.append(cliRet)

            # 获取默认的128回显
            defaultFid = "128"
            tmpList = getRiskSFPInfo(cli, defaultFid)
            if tmpList:
                # 每个虚拟交换机都需要获取自己的对端设备链路冗余信息
                tmpRemoteReduntWWPN = getRemoteReduntWWPN(cli, defaultFid)
                remoteReduntWWPN.update(tmpRemoteReduntWWPN)
            riskSfpDictList.extend(tmpList)
            LOGGER.logInfo("fid:%s, riskSfpDictList:%s" % ('128', str(tmpList)))
            # 遍历其他虚拟交换机获取回显
            flag, switchFidList, allCliRet, errMsg = common.getSwitchFidListsOneCommand(cli, LANG)
            if flag != True:
                return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), errMsg)

            LOGGER.logInfo("switchFidList:%s" % str(switchFidList))
            if '128' in switchFidList:
                switchFidList.remove('128')

            for fid in switchFidList:
                ALL_CLI_RET_LIST.append("\n\n===========FID:%s==========" % fid)
                flag, cliRet, errMsg = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
                if flag != True:
                    return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), errMsg)

                LOGGER.logInfo("SwitchToSpecVirtualSwitch: success %s" % fid)
                ALL_CLI_RET_LIST.append(cliRet)
                tmpList = getRiskSFPInfo(cli, fid)
                if tmpList:
                    # 每个虚拟交换机都需要获取自己的对端设备链路冗余信息
                    tmpRemoteReduntWWPN = getRemoteReduntWWPN(cli, fid)
                    remoteReduntWWPN.update(tmpRemoteReduntWWPN)
                riskSfpDictList.extend(tmpList)
                LOGGER.logInfo("fid:%s, riskSfpDictList:%s" % (fid, str(tmpList)))
        else:
            tmpList = getRiskSFPInfo(cli, "--")
            if tmpList:
                # 每个虚拟交换机都需要获取自己的对端设备链路冗余信息
                tmpRemoteReduntWWPN = getRemoteReduntWWPN(cli, "--")
                remoteReduntWWPN.update(tmpRemoteReduntWWPN)
            riskSfpDictList.extend(tmpList)
            LOGGER.logInfo("fid:%s, riskSfpDictList:%s" % ("--", str(tmpList)))

        # 如果不存在风险光模块，则通过。否则继续获取光模块详细信息
        if not riskSfpDictList:
            return True, "\n\n".join(ALL_CLI_RET_LIST), ''

        # 判断检查标准
        getSuggestionInfo(cli, riskSfpDictList, remoteReduntWWPN)
        LOGGER.logInfo(u"riskSfpDictList:%s" % str(riskSfpDictList))

        # 构造错误消息表格，写入文件
        showMsg = setShowInfo(riskSfpDictList)

        return False, "\n\n".join(ALL_CLI_RET_LIST), showMsg
    except common.UnCheckException, unCheckException:
        LOGGER.logException(unCheckException)
        return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), unCheckException.errorMsg)
    except ToolException, toolException:
        LOGGER.logException(toolException)
        raise
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, "\n\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except Exception, exception:
            LOGGER.logException(exception)


def getRiskSFPInfo(cli, fid):
    """
    获取风险光模块，
    3个命令的关联关系如下：sfpshow ->portId; switchshow->portId, portIndex; nsshow-> portIndex

    步骤8 执行命令switchshow，输出信息中获取交换机名称（switchName）、DID（switchDomain）、端口索引（Index）、槽位号（Slot）、
    端口号（Port）、端口状态（State）、端口类型、对端设备WWPN；
    步骤9 执行命令nsshow -t，输出信息中获取端口索引（Port Index）、设备类型（Device type）、设备信息（NodeSymb/FC4s）。
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST, SWITCH_NAME

    riskSfpDictList = []
    sfpInfoDictList = getAllSFPInfo(cli, LOGGER, LANG, IS_HIGHEND_SWITCH)
    LOGGER.logInfo("sfpInfoDictList : %s" % str(sfpInfoDictList))
    for sfpInfoDict in sfpInfoDictList:
        if sfpInfoDict.get("sn", "") in config.RISK_SFP_SN_LIST:
            riskSfpDictList.append(sfpInfoDict)

    if not riskSfpDictList:
        return riskSfpDictList

    # 获取其他详细信息
    allSfpInfoDictList, switchInfoDict, nsshowRetDictList = getDetailSfpInfo(cli)

    # 更新光模块信息
    for sfpInfoDict in riskSfpDictList:
        portId = sfpInfoDict.get("portId")
        slotId = sfpInfoDict.get("slot", "--")
        sfpInfoDict["virtualSwitchId"] = fid
        sfpInfoDict["switchName"] = switchInfoDict.get("switchName", "--")
        sfpInfoDict["switchDomain"] = switchInfoDict.get("switchDomain", "--")
        isGetInfo = False

        # 更新switchshow获取的端口信息和设备信息。
        for switchShowInfoDict in allSfpInfoDictList:
            if slotId == switchShowInfoDict.get("Slot", '') and switchShowInfoDict.get("Port", '') == portId:
                isGetInfo = True
                sfpInfoDict["State"] = switchShowInfoDict.get("State", "--")
                otherInfoStr = switchShowInfoDict.get("otherInfo", "")
                sfpInfoDict["portIndex"] = switchShowInfoDict.get("Index", "--")

                if not otherInfoStr:
                    sfpInfoDict["type"] = '--'
                    sfpInfoDict["remoteDeviceWWPN"] = '--'
                    break

                regx = re.compile(r"(([a-fA-F0-9]{2}:){7}|([a-fA-F0-9]{2}:){5})[a-fA-F0-9]{2}")
                wwpnMatchRet = regx.search(otherInfoStr)
                if wwpnMatchRet:
                    wwpn = wwpnMatchRet.group()
                else:
                    wwpn = "--"

                regx = re.compile(r"([F|E]-Port)")
                portTypeMatchRet = regx.search(otherInfoStr)
                if portTypeMatchRet:
                    portType = portTypeMatchRet.group()
                else:
                    portType = "--"

                sfpInfoDict["type"] = portType
                sfpInfoDict["remoteDeviceWWPN"] = wwpn

        # 如果都未从switch show 中获取到相同端口的信息，则全部设置为 --
        if not isGetInfo:
            sfpInfoDict["type"] = '--'
            sfpInfoDict["remoteDeviceWWPN"] = '--'
            sfpInfoDict["State"] = '--'

        LOGGER.logInfo("isGetInfo : %s, portId:%s, sfpInfoDict:%s" % (isGetInfo, portId, str(sfpInfoDict)))

        # 更新nsshow 获取的设备信息
        isGetInfo = False
        portIndex = sfpInfoDict.get("portIndex")
        for nsshowRetDict in nsshowRetDictList:
            if nsshowRetDict.get("Port Index", '') == portIndex:
                isGetInfo = True
                remoteDeviceInfo = nsshowRetDict.get("NodeSymb", "")
                sfpInfoDict["remoteDeviceType"] = nsshowRetDict.get("Device type", "--")
                if remoteDeviceInfo:
                    regx = re.compile(r"\"(.*)\"")
                    matchRes = regx.findall(remoteDeviceInfo)
                    if matchRes:
                        remoteDeviceInfo = matchRes[0]
                        sfpInfoDict["remoteDeviceInfo"] = remoteDeviceInfo
                        break
                    else:
                        remoteDeviceInfo = ""

                # 不用else是因为：匹配失败时使用FC4s的值。
                if not remoteDeviceInfo:
                    if nsshowRetDict.get("FC4s", ""):
                        sfpInfoDict["remoteDeviceInfo"] = nsshowRetDict.get("FC4s", "")
                    else:
                        sfpInfoDict["remoteDeviceInfo"] = "--"

        if not isGetInfo:
            sfpInfoDict["remoteDeviceType"] = '--'
            sfpInfoDict["remoteDeviceInfo"] = '--'

    return riskSfpDictList


def getAllSFPInfo(cli, LOGGER, LANG, isHighEnd):
    """
    获取交换机光模块信息
    :param cli:
    :param LOGGER:
    :param LANG:
    :param isHighEnd:
    :param ALL_CLI_RET_LIST:
    :return:
    """
    global ALL_CLI_RET_LIST
    import re
    riskSfpDictList = []
    cmd = "sfpshow"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n\n".join(ALL_CLI_RET_LIST))

    regx = ''
    if isHighEnd:
        regx = re.compile(r"Slot\s+(.*?)/Port\s+(\d+):.*?Serial No:(.*?)Speed:")
    else:
        regx = re.compile(r"Port\s+(\d+):.*?Serial No:(.*?)Speed:")

    retList = regx.findall(cliRet)
    LOGGER.logInfo("sfpshow retList is : %s" % str(retList))

    for res in retList:
        slot = ''
        portId = ''
        sn = ''
        if isHighEnd:
            if len(res) < 3:
                continue

            slot = res[0]
            portId = res[1]
            sn = res[2].strip()
        else:
            if len(res) < 2:
                continue
            slot = '--'
            portId = res[0]
            sn = res[1].strip()

        riskSfpDict = {
            'slot': slot,
            'portId': portId,
            'sn': sn
        }
        riskSfpDictList.append(riskSfpDict)

    LOGGER.logInfo("riskSfpDictList is : %s" % str(riskSfpDictList))
    return riskSfpDictList


def getDetailSfpInfo(cli):
    """
    执行命令switchshow，输出信息中获取
    交换机名称（switchName）、
    DID（switchDomain）、
    端口索引（Index）、
    槽位号（Slot）、
    端口号（Port）、
    端口状态（State）、
    端口类型、
    对端设备WWPN；

    执行命令nsshow -t，输出信息中获取端口索引（Port Index）、
    设备类型（Device type）、
    设备信息（NodeSymb/FC4s）。
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    cmd = "switchshow"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n\n".join(ALL_CLI_RET_LIST))

    allSfpInfoDictList, switchInfoDict = common.switchshowCliRetAnalysisMethod(cliRet, IS_HIGHEND_SWITCH, LOGGER)
    LOGGER.logInfo("allSfpInfoDictList:%s， switchInfoDict：%s" % (str(allSfpInfoDictList), str(switchInfoDict)))

    cmd = "nsshow -t"
    # 因有些正常回文中，无数据会带error字样，所以不能用公共方法
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n\n".join(ALL_CLI_RET_LIST))

    nsshowRetDictList = common.analysisNsshowTMethod(cliRet, LOGGER)
    LOGGER.logInfo("nsshowRetDictList:%s" % nsshowRetDictList)

    return allSfpInfoDictList, switchInfoDict, nsshowRetDictList


def getTrunkshowInfo(cli):
    """
    获取trunkshow 链路信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST

    trunkShowInfoDict = {}
    cmd = "trunkshow"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n\n".join(ALL_CLI_RET_LIST))

    regx = re.compile(r".*?(\d+)->\s*\w+\s+(.*?)\s+")
    matchResTuplList = regx.findall(cliRet)
    for matchResTup in matchResTuplList:
        if len(matchResTup) != 2:
            continue

        trunkShowInfoDict[matchResTup[0]] = matchResTup[1]

    return trunkShowInfoDict


def getIslshowInfo(cli):
    """
    获取islshow链路信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    islShowInfoDict = {}
    cmd = "islshow"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, "\n\n".join(ALL_CLI_RET_LIST))

    # 高端        1:215->  5 10:00:c4:f5:7c:9e:d9:7e   2 deskew 15 MASTER
    #              214->  4 10:00:c4:f5:7c:9e:d9:7e   2 deskew 15
    # 中低端的    4:  8-> 17 10:00:50:eb:1a:f9:19:0c   4 deskew 1 MASTER这种格式。
    #                4->214 10:00:00:27:f8:ef:96:40   1 deskew 3
    regx = re.compile(r".*?(\d+)->\s*\w+\s+(.*?)\s+")
    matchResTuplList = regx.findall(cliRet)
    for matchResTup in matchResTuplList:
        if len(matchResTup) != 2:
            continue

        islShowInfoDict[matchResTup[0]] = matchResTup[1]

    return islShowInfoDict


def getRemoteReduntWWPN(cli, fid):
    """
    每个虚拟交换机都需要获取自己的对端设备链路冗余信息
    :param cli:
    :param fid:
    :return:
    """
    remoteReduntWWPN = {}
    islShowInfoDict = getIslshowInfo(cli)
    trunkShowInfoDict = getTrunkshowInfo(cli)
    remoteReduntWWPN[fid] = {
        "islShowInfoDict": islShowInfoDict,
        "trunkShowInfoDict": trunkShowInfoDict
    }

    LOGGER.logInfo("fid:%s, remoteReduntWWPN:%s" % (fid, remoteReduntWWPN))
    return remoteReduntWWPN


def countSn(sn, infoDict):
    """
    计数端口是否冗余
    :param sn:
    :param infoDict:
    :return:
    """
    if infoDict and sn:
        valueList = infoDict.values()
        if valueList:
            return valueList.count(sn)
    return 0


def getSuggestionInfo(cli, riskSfpDictList, remoteReduntWWPN):
    """
    获取端口的修复建议
    :param cli:
    :param riskSfpDictList:
    :return:
    """
    for riskSfpDict in riskSfpDictList:
        sfpState = riskSfpDict.get("State", '--')
        sfpType = riskSfpDict.get("type", '--')
        sfpIndex = riskSfpDict.get("portIndex", '--')
        fid = riskSfpDict.get("virtualSwitchId", '--')
        # 如果步骤8中的端口状态显示为"No_Light"，表明该端口为"空闲端口"，建议修复
        if sfpState == 'No_Light':
            suggestionMsg = common.getMsg(LANG, "risk.sfp.state.no.ligth")

        # 如果步骤8中的端口状态显示为"Laser_Fault"，表明该端口为"故障端口"，建议修复
        elif sfpState == 'Laser_Flt':
            suggestionMsg = common.getMsg(LANG, "risk.sfp.state.laser.fault")

        # 如果步骤8中的端口状态显示为"Online"，且端口类型显示为E-Port，
        # 则执行步骤10-11，如果步骤10或者步骤11输出信息中，任何一个WWN数量大于1个，
        # 则表明该端口"E-Port端口冗余"，否则该端口"E-Port端口不冗余"，建议修复；
        # 如果步骤8中的端口状态显示为"Online"，且端口类型显示为F-Port，则表明该端口"F-Port端口"，建议修复；
        elif sfpState == 'Online':
            if sfpType == "E-Port":
                trunkShowInfoDict = remoteReduntWWPN.get(fid, {}).get("trunkShowInfoDict")
                islShowInfoDict = remoteReduntWWPN.get(fid, {}).get("islShowInfoDict")
                if countSn(trunkShowInfoDict.get(sfpIndex, ''), trunkShowInfoDict) > 1:
                    # E-Port端口冗余
                    suggestionMsg = common.getMsg(LANG, "risk.sfp.eport.redundent")
                elif countSn(islShowInfoDict.get(sfpIndex, ''), islShowInfoDict) > 1:
                    # E-Port端口冗余
                    suggestionMsg = common.getMsg(LANG, "risk.sfp.eport.redundent")
                else:
                    # E-Port端口不冗余
                    suggestionMsg = common.getMsg(LANG, "risk.sfp.eport.not.redundent")
            elif sfpType == "F-Port":
                # F-Port端口
                suggestionMsg = common.getMsg(LANG, "risk.sfp.fport")
            else:
                # 端口类型异常
                suggestionMsg = common.getMsg(LANG, "risk.sfp.state.other.port.type.except")

        # 如果步骤8中的端口状态显示为非"No_Light"或者非"Online"或者非"Laser_Fault"，表明该端口为"异常端口"，建议修复
        else:
            # 端口状态异常
            suggestionMsg = common.getMsg(LANG, "risk.sfp.state.except")

        riskSfpDict["suggestionMsg"] = suggestionMsg


def setShowInfo(riskSfpDictList):
    """
    构造回显
    :param riskSfpDictList:
    :return:
    """
    showMsg = ""
    ip = str(PY_JAVA_ENV.get("devInfo").getIp())
    devSN = str(PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber())
    # 找到每列最长的值作为列长度。
    # 1. 本身该key值的长度 2. 取中英文后title的长度做比较 3.空格右填充 4. 默认每列前增加一个空格作为列区分。
    maxKeyLen = {}
    index = 1
    for riskSfpDict in riskSfpDictList:
        riskSfpDict["ip"] = ip
        riskSfpDict["index"] = str(index)
        for head in cliResource.RISK_SFP_HEADER_LIST:
            key = head.get("valueKey")
            title = head.get("en")
            value = riskSfpDict.get(key, "--")
            maxLen = maxKeyLen.get(key, 0)
            maxKeyLen[key] = max([maxLen, len(value), len(title)])
        index += 1

    # 构造title
    nextLine = ''
    diffLine = '-'

    workbook = xlwt.Workbook(encoding='utf8')
    worksheet = workbook.add_sheet('%s' % devSN)

    index = 0
    for head in cliResource.RISK_SFP_HEADER_LIST:
        title = head.get("en")
        key = head.get("valueKey")
        showMsg += unicode(title).ljust(maxKeyLen.get(key) + 1, " ")
        nextLine += diffLine * (maxKeyLen.get(key)) + " "
        worksheet.write(0, index, label=head.get(LANG))
        index += 1

    showMsg = showMsg + "\n" + nextLine + "\n"

    # 构造value
    contentStr = ''
    index = 1
    for riskSfpDict in riskSfpDictList:
        vindex = 0
        for head in cliResource.RISK_SFP_HEADER_LIST:
            key = head.get("valueKey")
            value = riskSfpDict.get(key, "--")
            contentStr += unicode(value).ljust(maxKeyLen.get(key) + 1, " ")
            worksheet.write(index, vindex, label=value)
            vindex += 1
        contentStr += "\n"
        index += 1

    # 保存到excel文件中，IPV6替换:为.否则创建文件夹失败
    fileName = ""
    tmpFileName = "%s_%s_%s.xls" % (ip.replace(":", "_"), SWITCH_NAME, devSN)
    try:
        fileName = '%s{}%s'.format(os.sep) % (getSaveDir(), tmpFileName)
        workbook.save(fileName)
    except Exception, exception:
        fileName = ''
        LOGGER.logException(exception)

    errMsg = ''
    if fileName:
        # 请查看下列信息或查看巡检报告目录下：data\switch\%s。
        errMsg = common.getMsg(LANG, "risk.sfp.show.msg.save.succ", tmpFileName)
    else:
        # 保存信息到文件失败，请查看下列信息：
        errMsg = common.getMsg(LANG, "risk.sfp.show.msg.save.err")
    showMsg += contentStr

    return errMsg + "\n" + showMsg


def getSaveDir():
    """
    获取报告保存目录
    存放switch
    :return:
    """
    tmpDataDir = PY_JAVA_ENV.get("inspectTmpDataDir")
    if not tmpDataDir:
        # 写到当前工具目录下
        tmpDataDir = os.path.abspath(".")
    devIp = PY_JAVA_ENV.get("devInfo").getIp()

    localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "switch"
    if not os.path.exists(localFileDir):
        os.makedirs(localFileDir)

    return localFileDir


def saveCollectCliRetToFile(cli):
    """
    收集其他命令回文
    :param cli:
    :return:
    """
    global SWITCH_NAME
    fw = None
    try:
        cliRetList = []
        # 虚拟交换机命令
        SWITCH_NAME, __ = common.getSwitchName(cli)
        __, isVirtual, cliRet, errMsg = common.isVirtualSwitchesStarted(cli, LANG)
        if isVirtual:
            __, isDefault, cliRet, __ = common.isDefaultSwitchLogin(cli, LANG)

            if not isDefault:
                common.switchToDefaultSwitch(cli, LANG)

            for cmd in config.COLLECT_CLI_RET_TO_FILE_LIST:
                cliRetList.append(cli.execCmdWithTimout(cmd, 300))

            # 遍历其他虚拟交换机获取回显
            __, switchFidList, allCliRet, __ = common.getSwitchFidListsOneCommand(cli, LANG)
            LOGGER.logInfo("switchFidList:%s" % str(switchFidList))
            if '128' in switchFidList:
                switchFidList.remove('128')

            for fid in switchFidList:
                cliRetList.append("\n\n===========FID:%s==========" % fid)
                __, cliRet, __ = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
                LOGGER.logInfo("SwitchToSpecVirtualSwitch: success %s" % fid)
                cliRetList.append(cliRet)
                for cmd in config.COLLECT_CLI_RET_TO_FILE_LIST:
                    cliRetList.append(cli.execCmdWithTimout(cmd, 300))
        else:
            for cmd in config.COLLECT_CLI_RET_TO_FILE_LIST:
                cliRetList.append(cli.execCmdWithTimout(cmd, 300))

        ip = str(PY_JAVA_ENV.get("devInfo").getIp())
        devSN = str(PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber())
        fileName = '%s{}%s_%s_%s_SSHOW_SYS.txt'.format(os.sep) % (getSaveDir(), ip.replace(":", "_"), SWITCH_NAME, devSN)
        fw = open(fileName, "a")
        fw.write("\n\n\n".join(cliRetList))
        fw.close()
    except Exception, e:
        if fw:
            fw.close()
        LOGGER.logException(e)
    finally:
        try:
            common.switchToDefaultSwitch(cli, LANG)
        except Exception, exception:
            LOGGER.logException(exception)