# -*- coding:utf-8 -*-
import cliUtil
import common
import re
from frameone.ruleConfig import executeRule

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

VERSION_MIN_OF_EIGHT = 7003001
VERSION_MIN_OF_SEVEN = 7002000
VERSION_THRESHOLD = 8000000


def execute(cli):
    """
    开具场景	检查级联版本兼容性
    :param cli:
    :return:
    """
    cli_ret = ''
    try:
        cmd = "fabricshow -version"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)  # type: (str or bool, str, str)
        if flag != True:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        lines = cli_ret.splitlines()
        
        head_poi = -1
        if 'no fabric' in cli_ret.lower():
            cli_ret += "\n current switch has no fabric."
            return cliUtil.RESULT_NOSUPPORT, cli_ret, ""
        if "unrecognized option" in cli_ret.lower():
            LOGGER.logError("current switch's OS version is too low, the -version option is not supported.")
            cmd = "fabricshow"
            flag, cli_ret2, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)  # type: (str or bool, str, str)
            cli_ret += "\n\n" + cli_ret2
            return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "sns.fabricshow.version.option.not.support")
        for line in lines:
            if "---" in line:
                break
            head_poi += 1
        # no header line detected.
        if head_poi >= len(lines) - 1:
            raise Exception()
        version_poi = lines[head_poi].lower().find("version")
        switchs_versions = []
        for line in lines[head_poi + 2:]:
            if not line or "the fabric has" in line:
                break
            if len(line) > version_poi:
                switchs_versions.append(line[version_poi:].split()[0])
        LOGGER.logInfo("connected switchs os version are as follows:" + ",".join(switchs_versions))
        if len(switchs_versions) == 1:
            return cliUtil.RESULT_NOSUPPORT, cli_ret, ''
        if len(switchs_versions) < 1:
            return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.fabricshow.result.abnormal")
        switchs_versions = get_FIXED_versions(switchs_versions)
        max_version = max(switchs_versions)
        min_version = min(switchs_versions)
        # 8.X.X版本要求version必须全部大于731
        if max_version >= VERSION_THRESHOLD and min_version < VERSION_MIN_OF_EIGHT:
            return False, cli_ret, common.getMsg(LANG, "sns.os.version.min.lower.than731")
        if min_version < VERSION_MIN_OF_SEVEN:
            return False, cli_ret, common.getMsg(LANG, "sns.os.version.min.lower.than720")
        else:
            return True, cli_ret, ""
    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")

def get_FIXED_versions(switchs_versions):
    """

    :param switchs_versions:
    :return:
    """
    for poi in range(len(switchs_versions)):
        digits = switchs_versions[poi].split(".")
        header_ver = int("".join(re.findall("\d", digits[0]))) * 1000000
        mid_ver = int("".join(re.findall("\d", digits[1]))) * 1000
        last_ver = int("".join(re.findall("\d", digits[2]))) if len(digits) > 2 else 0
        switchs_versions[poi] = header_ver + mid_ver + last_ver
    LOGGER.logInfo("all versions:" + str(switchs_versions))
    return switchs_versions