# -*- coding:utf-8 -*-
import cliUtil
import common
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    cliRet = ""
    try:
        # 获取fids
        lsFlag, fids, ret, msg = common.getSwitchFidList(cli, LANG, LOGGER)
        cliRet = common.joinLines(cliRet, ret)
        if lsFlag is not True:
            return cliUtil.RESULT_NOCHECK, cliRet, msg

        # 未使用VF场景，检查默认交换机zone配置
        if not fids:
            eflag, ret, msg = checkEffectiveCfg(cli)
            cliRet = common.joinLines(cliRet, ret)
            return eflag, cliRet, msg

        # 使用VF场景，检查所有交换机是否配置zone
        errMsg = ""
        nocfgVfs = []
        result = True
        for fid in fids:
            sFlag, ret, msg = common.SwitchToSpecVirtualSwitch(cli, LANG, fid)
            cliRet = common.joinLines(cliRet, ret)
            if sFlag is not True:
                errMsg += msg
                result = common.getResult(result, cliUtil.RESULT_NOCHECK)
                continue

            eFlag, ret, __ = checkEffectiveCfg(cli)
            cliRet = common.joinLines(cliRet, ret)
            if eFlag is cliUtil.RESULT_WARNING:
                nocfgVfs.append(fid)

            if eFlag is cliUtil.RESULT_NOCHECK:
                msg = common.getMsg(LANG, "switch.vf.zone.cfg.error", fid)
                errMsg += msg

            result = common.getResult(result, eFlag)

        if nocfgVfs:
            msg = common.getMsg(LANG, "switch.vf.zone.no.cfg", " ,".join(nocfgVfs))
            errMsg += msg

        return result, cliRet, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkEffectiveCfg(cli):
    cmd = "cfgshow"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag != True:
        errMsg = common.getMsg(LANG, "switch.zone.cfg.error")
        return cliUtil.RESULT_NOCHECK, cliRet, errMsg

    effectiveCfgInfo= cliRet.split("Effective configuration")
    if len(effectiveCfgInfo) < 2:
        errMsg = common.getMsg(LANG, "switch.zone.cfg.error")
        return cliUtil.RESULT_NOCHECK, cliRet, errMsg

    if "no configuration in effect" in effectiveCfgInfo[-1].lower():
        msg = common.getMsg(LANG, "switch.zone.no.cfg")
        return cliUtil.RESULT_WARNING, cliRet, msg

    return True, cliRet, ""
