# -*- coding:utf-8 -*-
REG_USER_LOGIN_FLAG = ":.*>"

"""
版本范围    
机型    华为发布的版本号
SNS2124    7.1    7.2    7.3    7.4    NA    NA
SNS2248    7.1    7.2    7.3    7.4    8.1    8.2
SNS2224    7.1    7.2    7.3    7.4    8.1    8.2
SNS5384    7.1    7.2    7.3    7.4    8.1    8.2
SNS5192    7.1    7.2    7.3    7.4    8.1    8.2
SNS3096    7.1    7.2    7.3    7.4    8.1    8.2
SNS3664    NA      NA    NA     NA     8.1    8.2
SNS5604    NA      NA    NA     NA     8.1    8.2
SNS5608    NA      NA    NA     NA     8.1    8.2
SNS2624    NA      NA    NA     NA     8.1    8.2
SNS3696E   NA      NA    NA     NA     8.1    8.2
版本号最后两位的小数及字母不需要关注
产品型号    
机型  switchType
SNS2124    71.y
SNS2248    109.y
SNS2224    118.y
SNS5384    120.y
SNS5192    121.y
SNS3096    133.y
SNS3664    162.y
SNS5604    165.y
SNS5608    166.y
SNS2624    170.y
SNS3696E 173.y
y为硬件子版本号，不需要关注
"""

SNS_TO_TYPE_MAPPING = {
    "SNS2124": "71",
    "SNS2248": "109",
    "SNS2224": "118",
    "SNS5384": "120",
    "SNS5192": "121",
    "SNS3096": "133",
    "SNS3664": "162",
    "SNS5604": "165",
    "SNS5608": "166",
    "SNS2624": "170",
    "SNS3696E": "173",
    "SNS3764": "181",
    "SNS5704": "179",
    "SNS5708": "180"
}

TYPE_TO_SNS_MAPPING = {
    "71": "SNS2124",
    "109": "SNS2248",
    "118": "SNS2224",
    "120": "SNS5384",
    "121": "SNS5192",
    "133": "SNS3096",
    "162": "SNS3664",
    "165": "SNS5604",
    "166": "SNS5608",
    "170": "SNS2624",
    "173": "SNS3696E",
    "184": "SNS3696E",
    "181": "SNS3764",
    "179": "SNS5704",
    "180": "SNS5708"
}

# 新增 高端交换机的 5704， 5708 的枚举。SNS5704  179, SNS5708  180
SWITCH_TYPE_HIGTH_TYPE = ["121", "120", "165", "166", "179", "180"]

COLLECT_CLI_RET_CMDS_HIGHT = ['hashow',
                              'slotshow -m']

COLLECT_CLI_RET_CMDS_LOWER = []

COLLECT_CLI_RET_CMDS_COMMON = [
    'date',
    'tempshow',
    'psshow',
    'chassisshow',
    'licenseshow',
    'license --show',
]

COLLECT_CLI_RET_IN_VIRTUAL = [
    'switchshow',
    'fabricshow',
    'fabricshow -version',
    'porterrshow',
    'nsshow -t -r',
    'errdump -a',
    'trunkshow',
    'portbuffershow',
    'cfgtransshow',
    'fabriclog --show',
    'nscamshow -t',
    'mapsdb --show',
    'mapsdb --show all',
    'portlogdump'
]


COLLECT_CLI_RET_TO_FILE_LIST = ["cfgshow",
                                "switchshow",
                                "sfpshow -all",
                                "nsshow -t"
                                ]


RISK_SFP_SN_LIST = ['HAF618200000E26', 'HAF618200000F0T', 'HAF618200000F8K', 'HAF618200000F8P', 'HAF618200000F8Z',
                    'HAF618200000FB9', 'HAF618200000FGK', 'HAF618200000FGP', 'HAF618200000FGR', 'HAF618200000FGS',
                    'HAF618200000FHZ', 'HAF618200000FJ4', 'HAF618200000FJ7', 'HAF618200000FJ9', 'HAF618200000FNR',
                    'HAF618200000FNU', 'HAF618200000FP1', 'HAF618200000GG0', 'HAF618200000GG2', 'HAF618200000GG5',
                    'HAF618200000GG8', 'HAF618200000HMT', 'HAF618200000HY0', 'HAF618200000HYK', 'HAF618200000JJP',
                    'HAF618200000REG', 'HAF618200000RET', 'HAF618200000REZ', 'HAF618200000RFF', 'HAF618200000RFN',
                    'HAF6182000010BS', 'HAF6182000014C3', 'HAF61820000170N', 'HAF618210000027', 'HAF61821000019R',
                    'HAF6182100001C9', 'HAF6182100001P3', 'HAF61821000068S', 'HAF6182100008GJ', 'HAF6182300003SW',
                    'HAF6182300003YD', 'HAF6182300003YF', 'HAF6182300003YH', 'HAF6182300003YJ', 'HAF6182300003YK',
                    'HAF6182300003YL', 'HAF6182300003YM', 'HAF6182300003ZN', 'HAF6182300003ZP', 'HAF6182300003ZR',
                    'HAF6182300003ZS', 'HAF6182300003ZT', 'HAF61823000041F', 'HAF61823000043U', 'HAF61823000043V',
                    'HAF61823000043W', 'HAF61823000043Y', 'HAF61823000043Z', 'HAF61823000044F', 'HAF61823000044G',
                    'HAF61823000044J', 'HAF61823000044K', 'HAF61823000044M', 'HAF6182300004BZ', 'HAF6182300004DJ',
                    'HAF6182300004DS', 'HAF6182300004DU', 'HAF6182300004E0', 'HAF6182300004E4', 'HAF6182300004E8',
                    'HAF6182300004G5', 'HAF6182300004G8', 'HAF6182300004H1', 'HAF6182300004H4', 'HAF6182300004H7',
                    'HAF6182300004HA', 'HAF6182300004HD', 'HAF6182300004HH', 'HAF6182300004KC', 'HAF6182300004KJ',
                    'HAF6182300004KM', 'HAF6182300004MA', 'HAF6182300004PW', 'HAF6182300004PZ', 'HAF6182300004TM',
                    'HAF6182300004UU', 'HAF6182300004WD', 'HAF6182300004WG', 'HAF6182300004WK', 'HAF6182300004ZB',
                    'HAF6182300004ZE', 'HAF6182300004ZK', 'HAF6182300004ZL', 'HAF618230000502', 'HAF618230000507',
                    'HAF61823000050U', 'HAF61823000050V', 'HAF61823000050W', 'HAF61823000050Y', 'HAF61823000052J',
                    'HAF61823000052M', 'HAF61823000052P', 'HAF61823000052T', 'HAF618230000530', 'HAF61823000056A',
                    'HAF61823000056J', 'HAF618230000583', 'HAF618230000586', 'HAF618230000588', 'HAF61823000058K',
                    'HAF61823000058Y', 'HAF61823000059G', 'HAF61823000059J', 'HAF61823000059N', 'HAF61823000059R',
                    'HAF6182300005D0', 'HAF6182300005D4', 'HAF6182300005GK', 'HAF6182300005GL', 'HAF6182300005GN',
                    'HAF6182300005H0', 'HAF6182300005H3', 'HAF6182300005JR', 'HAF6182300005JV', 'HAF6182300005K1',
                    'HAF6182300005K3', 'HAF6182300005K9', 'HAF6182300005LV', 'HAF6182300005LW', 'HAF6182300005M0',
                    'HAF6182300005M3', 'HAF6182300005M4', 'HAF6182300005M8', 'HAF6182300005M9', 'HAF6182300005MA',
                    'HAF6182300005MC', 'HAF6182300005MF', 'HAF6182300005MH', 'HAF6182300005ML', 'HAF6182300005MN',
                    'HAF6182300005MS', 'HAF6182300005MV', 'HAF6182300005N0', 'HAF6182300005R7', 'HAF6182300005SG',
                    'HAF6182300005SL', 'HAF6182300005SP', 'HAF6182300005SR', 'HAF6182300005T0', 'HAF6182300005T5',
                    'HAF6182300005TE', 'HAF6182300005U4', 'HAF6182300005U8', 'HAF6182300005UH', 'HAF6182300005UJ',
                    'HAF6182300005UM', 'HAF6182300005US', 'HAF6182300005UT', 'HAF6182300005UY', 'HAF6182300005V0',
                    'HAF6182300005V2', 'HAF6182300005V5', 'HAF6182300005V6', 'HAF6182300005VA', 'HAF6182300005VD',
                    'HAF6182300005VV', 'HAF6182300005VY', 'HAF6182300005W2', 'HAF6182300005W5', 'HAF6182300005W7',
                    'HAF6182300005W9', 'HAF6182300005WD', 'HAF6182300005WF', 'HAF6182300005WG', 'HAF6182300005WJ',
                    'HAF6182300005WL', 'HAF6182300005WR', 'HAF6182300005WS', 'HAF6182300005WW', 'HAF6182300005Y2',
                    'HAF6182300005Y5', 'HAF6182300005Y9', 'HAF6182300005YA', 'HAF6182300005YD', 'HAF6182300005YE',
                    'HAF6182300005YF', 'HAF6182300005YK', 'HAF6182300005YM', 'HAF618230000601', 'HAF618230000606',
                    'HAF618230000609', 'HAF61823000060V', 'HAF61823000060W', 'HAF618230000610', 'HAF618230000611',
                    'HAF618230000613', 'HAF618230000615', 'HAF618230000617', 'HAF61823000061B', 'HAF61823000061F',
                    'HAF61823000061J', 'HAF61823000061M', 'HAF61823000061Y', 'HAF61823000064F', 'HAF61823000064H',
                    'HAF61823000064L', 'HAF61823000064M', 'HAF61823000064R', 'HAF61823000064S', 'HAF61823000064V',
                    'HAF61823000064Z', 'HAF618230000650', 'HAF618230000653', 'HAF618230000656', 'HAF618230000657',
                    'HAF618230000659', 'HAF61823000065A', 'HAF61823000065D', 'HAF61823000065H', 'HAF61823000065L',
                    'HAF61823000065T', 'HAF61823000065Z', 'HAF61823000066H', 'HAF61823000066T', 'HAF618230000672',
                    'HAF618230000673', 'HAF618230000674', 'HAF618230000676', 'HAF618230000677', 'HAF618230000678',
                    'HAF618230000687', 'HAF61823000068A', 'HAF61823000068C', 'HAF61823000068E', 'HAF61823000068H',
                    'HAF61823000068L', 'HAF61823000068M', 'HAF61823000068N', 'HAF61823000068R', 'HAF61823000068U',
                    'HAF6182300006B8', 'HAF6182300006CG', 'HAF6182300006D2', 'HAF6182300006DF', 'HAF6182300006FJ',
                    'HAF6182300006FP', 'HAF6182300006FV', 'HAF6182300006FZ', 'HAF6182300006G1', 'HAF6182300006G2',
                    'HAF6182300006G7', 'HAF6182300006GG', 'HAF6182300006HT', 'HAF6182300006HV', 'HAF6182300006HZ',
                    'HAF6182300006J5', 'HAF6182300006JB', 'HAF6182300006JG', 'HAF6182300006JT', 'HAF6182300006JU',
                    'HAF6182300006KM', 'HAF6182300006KR', 'HAF6182300006KS', 'HAF6182300006KU', 'HAF6182300006L0',
                    'HAF6182300006L5', 'HAF6182300006L8', 'HAF6182300006LF', 'HAF6182300006LL', 'HAF6182300006NG',
                    'HAF6182300006PC', 'HAF6182300006PJ', 'HAF6182300006PN', 'HAF6182300006PT', 'HAF6182300006R0',
                    'HAF6182300006R5', 'HAF6182300006SV', 'HAF6182300006T7', 'HAF6182300006TA', 'HAF6182300006TB',
                    'HAF6182300006TH', 'HAF6182300006TK', 'HAF6182300006TS', 'HAF6182300006TV', 'HAF6182300006TZ',
                    'HAF6182300006U2', 'HAF6182300006U5', 'HAF6182300006U6', 'HAF6182300006U9', 'HAF6182300006UB',
                    'HAF6182300006UE', 'HAF6182300006UK', 'HAF6182300006UP', 'HAF6182300006UU', 'HAF6182300006V9',
                    'HAF6182300006VF', 'HAF6182300006Z6', 'HAF6182300006ZK', 'HAF6182300006ZP', 'HAF6182300006ZY',
                    'HAF618230000700', 'HAF61823000070A', 'HAF61823000070N', 'HAF61823000071E', 'HAF61823000071K',
                    'HAF61823000071U', 'HAF61823000072E', 'HAF61823000072R', 'HAF61823000072Z', 'HAF618230000732',
                    'HAF618230000736', 'HAF618230000738', 'HAF61823000073B', 'HAF61823000073E', 'HAF61823000074P',
                    'HAF61823000075L', 'HAF61823000075T', 'HAF61823000076G', 'HAF61823000076L', 'HAF61823000076N',
                    'HAF61823000076P', 'HAF61823000076T', 'HAF61823000076W', 'HAF618230000771', 'HAF618230000772',
                    'HAF618230000776', 'HAF618230000777', 'HAF61823000077B', 'HAF61823000077G', 'HAF61823000077K',
                    'HAF61823000077L', 'HAF61823000077R', 'HAF61823000077U', 'HAF61823000077Y', 'HAF618230000781',
                    'HAF618230000784', 'HAF618230000786', 'HAF618230000787', 'HAF61823000079F', 'HAF61823000079H',
                    'HAF61823000079T', 'HAF61823000079V', 'HAF6182300007A0', 'HAF6182300007A3', 'HAF6182300007A7',
                    'HAF6182300007A8', 'HAF6182300007AD', 'HAF6182300007AE', 'HAF6182300007AK', 'HAF6182300007AP',
                    'HAF6182300007AU', 'HAF6182300007AZ', 'HAF6182300007B0', 'HAF6182300007B7', 'HAF6182300007B8',
                    'HAF6182300007BD', 'HAF6182300007BM', 'HAF6182300007BY', 'HAF6182300007C0', 'HAF6182300007C3',
                    'HAF6182300007C9', 'HAF6182300007CB', 'HAF6182300007CC', 'HAF6182300007CD', 'HAF6182300007CF',
                    'HAF6182300007CG', 'HAF6182300007CJ', 'HAF6182300007CK', 'HAF6182300007CM', 'HAF6182300007CP',
                    'HAF6182300007D4', 'HAF6182300007D8', 'HAF6182300007DA', 'HAF6182300007DC', 'HAF6182300007DG',
                    'HAF6182300007DL', 'HAF6182300007DM', 'HAF6182300007DR', 'HAF6182300007DS', 'HAF6182300007DT',
                    'HAF6182300007DU', 'HAF6182300007DZ', 'HAF6182300007E0', 'HAF6182300007E2', 'HAF6182300007E6',
                    'HAF6182300007EB', 'HAF6182300007ED', 'HAF6182300007EG', 'HAF6182300007EJ', 'HAF6182300007EL',
                    'HAF6182300007EN', 'HAF6182300007ES', 'HAF6182300007EU', 'HAF6182300007EZ', 'HAF6182300007F3',
                    'HAF6182300007F8', 'HAF6182300007FD', 'HAF6182300007FE', 'HAF6182300007FH', 'HAF6182300007FN',
                    'HAF6182300007FV', 'HAF6182300007G0', 'HAF6182300007G9', 'HAF6182300007GD', 'HAF6182300007GN',
                    'HAF6182300007GT', 'HAF6182300007H0', 'HAF6182300007H6', 'HAF6182300007HB', 'HAF6182300007HF',
                    'HAF6182300007HL', 'HAF6182300007HN', 'HAF6182300007HZ', 'HAF6182300007JG', 'HAF6182300007KA',
                    'HAF6182300007KG', 'HAF6182300007KN', 'HAF6182300007KR', 'HAF6182300007KW', 'HAF6182300007KZ',
                    'HAF6182300007L2', 'HAF6182300007L4', 'HAF6182300007LA', 'HAF6182300007LB', 'HAF6182300007LD',
                    'HAF6182300007LH', 'HAF6182300007LK', 'HAF6182300007LL', 'HAF6182300007LM', 'HAF6182300007LR',
                    'HAF6182300007LS', 'HAF6182300007LT', 'HAF6182300007LV', 'HAF6182300007LW', 'HAF6182300007LY',
                    'HAF6182300007M2', 'HAF6182300007M3', 'HAF6182300007MK', 'HAF6182300007NH', 'HAF6182300007NN',
                    'HAF6182300007NT', 'HAF6182300007NW', 'HAF6182300007NY', 'HAF6182300007NZ', 'HAF6182300007P0',
                    'HAF6182300007P3', 'HAF6182300007P4', 'HAF6182300007P6', 'HAF6182300007P9', 'HAF6182300007PA',
                    'HAF6182300007PE', 'HAF6182300007PJ', 'HAF6182300007PK', 'HAF6182300007PN', 'HAF6182300007PP',
                    'HAF6182300007PT', 'HAF6182300007PV', 'HAF6182300007R1', 'HAF6182300007R4', 'HAF6182300007R7',
                    'HAF6182300007R8', 'HAF6182300007RC', 'HAF6182300007RD', 'HAF6182300007RG', 'HAF6182300007RJ',
                    'HAF6182300007RK', 'HAF6182300007RM', 'HAF6182300007RN', 'HAF6182300007RP', 'HAF6182300007RS',
                    'HAF6182300007RT', 'HAF6182300007RV', 'HAF6182300007RW', 'HAF6182300007RZ', 'HAF6182300007S0',
                    'HAF6182300007S2', 'HAF6182300007S5', 'HAF6182300007S6', 'HAF6182300007S8', 'HAF6182300007SK',
                    'HAF6182300007SV', 'HAF6182300007T2', 'HAF6182300007T6', 'HAF6182300007T9', 'HAF6182300007TG',
                    'HAF6182300007TL', 'HAF6182300007TU', 'HAF6182300007TV', 'HAF6182300007TW', 'HAF6182300007TZ',
                    'HAF6182300007U1', 'HAF6182300007U2', 'HAF6182300007U4', 'HAF6182300007U7', 'HAF6182300007U8',
                    'HAF6182300007UB', 'HAF6182300007UD', 'HAF6182300007WB', 'HAF6182300007WG', 'HAF6182300007WJ',
                    'HAF6182300007WL', 'HAF6182300007WN', 'HAF6182300007WR', 'HAF6182300007WT', 'HAF6182300007WU',
                    'HAF6182300007WW', 'HAF6182300007WY', 'HAF6182300007Y1', 'HAF6182300007Y2', 'HAF6182300007Y4',
                    'HAF6182300007Y5', 'HAF6182300007Y6', 'HAF6182300007Y7', 'HAF6182300007YB', 'HAF6182300007YE',
                    'HAF6182300007YF', 'HAF6182300007YG', 'HAF6182300007YJ', 'HAF6182300007YL', 'HAF6182300007YU',
                    'HAF6182300007YY', 'HAF6182300007Z2', 'HAF6182300007Z3', 'HAF6182300007Z5', 'HAF6182300007ZM',
                    'HAF6182300007ZS', 'HAF6182300007ZV', 'HAF6182300007ZY', 'HAF618230000802', 'HAF618230000809',
                    'HAF61823000080C', 'HAF61823000080F', 'HAF61823000080Y', 'HAF618230000817', 'HAF61823000081E',
                    'HAF61823000081G', 'HAF61823000081J', 'HAF61823000081K', 'HAF61823000081L', 'HAF61823000081P',
                    'HAF61823000081R', 'HAF61823000081T', 'HAF61823000081U', 'HAF61823000081V', 'HAF618230000820',
                    'HAF618230000821', 'HAF618230000822', 'HAF618230000824', 'HAF618230000829', 'HAF61823000082A',
                    'HAF61823000082G', 'HAF61823000082H', 'HAF61823000082M', 'HAF61823000082N', 'HAF61823000082R',
                    'HAF61823000082V', 'HAF61823000083H', 'HAF61823000083S', 'HAF61823000083Y', 'HAF618230000843',
                    'HAF618230000844', 'HAF618230000845', 'HAF618230000847', 'HAF618230000848', 'HAF618230000849',
                    'HAF61823000084B', 'HAF61823000084C', 'HAF61823000084E', 'HAF61823000084H', 'HAF61823000084K',
                    'HAF61823000084L', 'HAF61823000084R', 'HAF61823000084S', 'HAF61823000084T', 'HAF61823000084V',
                    'HAF61823000085M', 'HAF61823000085P', 'HAF61823000085T', 'HAF61823000085W', 'HAF61823000085Z',
                    'HAF618230000862', 'HAF618230000863', 'HAF618230000865', 'HAF618230000866', 'HAF61823000086A',
                    'HAF61823000086J', 'HAF61823000086N', 'HAF61823000086Y', 'HAF618230000872', 'HAF618230000874',
                    'HAF618230000876', 'HAF618230000877', 'HAF618230000878', 'HAF61823000087A', 'HAF61823000087D',
                    'HAF61823000087E', 'HAF61823000087H', 'HAF61823000087J', 'HAF61823000087K', 'HAF61823000087N',
                    'HAF61823000087S', 'HAF61823000087T', 'HAF61823000087U', 'HAF61823000087Y', 'HAF61823000087Z',
                    'HAF618230000881', 'HAF618230000883', 'HAF618230000886', 'HAF618230000887', 'HAF61823000088A',
                    'HAF61823000088D', 'HAF61823000088G', 'HAF61823000088L', 'HAF61823000088P', 'HAF61823000088U',
                    'HAF6182300008AW', 'HAF6182300008B1', 'HAF6182300008B4', 'HAF6182300008B7', 'HAF6182300008B9',
                    'HAF6182300008BB', 'HAF6182300008BK', 'HAF6182300008BT', 'HAF6182300008BW', 'HAF6182300008BZ',
                    'HAF6182300008C0', 'HAF6182300008C1', 'HAF6182300008C3', 'HAF6182300008C4', 'HAF6182300008C5',
                    'HAF6182300008C7', 'HAF6182300008C9', 'HAF6182300008CB', 'HAF6182300008CD', 'HAF6182300008CE',
                    'HAF6182300008CF', 'HAF6182300008CG', 'HAF6182300008CH', 'HAF6182300008CJ', 'HAF6182300008CK',
                    'HAF6182300008CM', 'HAF6182300008CN', 'HAF6182300008CR', 'HAF6182300008CS', 'HAF6182300008CT',
                    'HAF6182300008CV', 'HAF6182300008CY', 'HAF6182300008D0', 'HAF6182300008D3', 'HAF6182300008D4',
                    'HAF6182300008D5', 'HAF6182300008D6', 'HAF6182300008D7', 'HAF6182300008D8', 'HAF6182300008DA',
                    'HAF6182300008DB', 'HAF6182300008DG', 'HAF6182300008E0', 'HAF6182300008E3', 'HAF6182300008E4',
                    'HAF6182300008E5', 'HAF6182300008E7', 'HAF6182300008EC', 'HAF6182300008EN', 'HAF6182300008EU',
                    'HAF6182300008EW', 'HAF6182300008EZ', 'HAF6182300008F2', 'HAF6182300008F5', 'HAF6182300008F7',
                    'HAF6182300008F9', 'HAF6182300008FD', 'HAF6182300008FE', 'HAF6182300008FG', 'HAF6182300008FH',
                    'HAF6182300008FJ', 'HAF6182300008FK', 'HAF6182300008FL', 'HAF6182300008FM', 'HAF6182300008FN',
                    'HAF6182300008FP', 'HAF6182300008FS', 'HAF6182300008FT', 'HAF6182300008FU', 'HAF6182300008FV',
                    'HAF6182300008GV', 'HAF6182300008H0', 'HAF6182300008HY', 'HAF6182300008HZ', 'HAF6182300008J0',
                    'HAF6182300008J1', 'HAF6182300008J3', 'HAF6182300008J5', 'HAF6182300008J6', 'HAF6182300008JU',
                    'HAF6182300008K8', 'HAF6182300008LZ', 'HAF6182300008M1', 'HAF6182300008M4', 'HAF6182300008M6',
                    'HAF6182300008M8', 'HAF6182300008MA', 'HAF6182300008MB', 'HAF6182300008MF', 'HAF6182300008MH',
                    'HAF6182300008MK', 'HAF6182300008ML', 'HAF6182300008MP', 'HAF6182300008MS', 'HAF6182300008N8',
                    'HAF6182300008NC', 'HAF6182300008NR', 'HAF6182300008NV', 'HAF6182300008P4', 'HAF6182300008P6',
                    'HAF6182300008P8', 'HAF6182300008R3', 'HAF6182300008SD', 'HAF6182300008T9', 'HAF6182300008TC',
                    'HAF6182300008TE', 'HAF6182300008TG', 'HAF6182300008TH', 'HAF6182300008TJ', 'HAF6182300008TK',
                    'HAF6182300008TL', 'HAF6182300008TM', 'HAF6182300008TN', 'HAF6182300008TP', 'HAF6182300008TS',
                    'HAF6182300008TT', 'HAF6182300008TW', 'HAF6182300008U0', 'HAF6182300008U1', 'HAF6182300008U2',
                    'HAF6182300008U4', 'HAF6182300008U5', 'HAF6182300008U7', 'HAF6182300008U9', 'HAF6182300008UB',
                    'HAF6182300008UP', 'HAF6182300008UU', 'HAF6182300008VK', 'HAF6182300008WJ', 'HAF6182300008YH',
                    'HAF6182300008YJ', 'HAF6182300008YK', 'HAF6182300008YL', 'HAF6182300008YM', 'HAF6182300008YN',
                    'HAF6182300008YP', 'HAF6182300008YU', 'HAF6182300008YV', 'HAF6182300008YY', 'HAF6182300008YZ',
                    'HAF6182300008Z0', 'HAF6182300008Z1', 'HAF6182300008Z3', 'HAF6182300008Z4', 'HAF6182300008ZM',
                    'HAF61823000090E', 'HAF61823000090G', 'HAF61823000090H', 'HAF61823000098G', 'HAF61823000098R',
                    'HAF61823000098Y', 'HAF61823000099R', 'HAF6182300009AS', 'HAF6182300009AT', 'HAF6182300009AU',
                    'HAF6182300009AZ', 'HAF6182300009B9', 'HAF6182300009BB', 'HAF6182300009BS', 'HAF6182300009DM',
                    'HAF6182300009DP', 'HAF6182300009DT', 'HAF6182300009DU', 'HAF6182300009E4', 'HAF6182300009G8',
                    'HAF6182300009GT', 'HAF6182300009GW', 'HAF6182300009HR', 'HAF6182300009HV', 'HAF6182300009JJ',
                    'HAF6182300009JN', 'HAF6182300009JR', 'HAF6182300009JS', 'HAF6182300009JW', 'HAF6182300009K0',
                    'HAF6182300009KH', 'HAF6182300009KJ', 'HAF6182300009KK', 'HAF6182300009KL', 'HAF6182300009KM',
                    'HAF6182300009KP', 'HAF6182300009KT', 'HAF6182300009KU', 'HAF6182300009KW', 'HAF6182300009KY',
                    'HAF6182300009L0', 'HAF6182300009LB', 'HAF6182300009LE', 'HAF6182300009LJ', 'HAF6182300009LT',
                    'HAF6182300009MC', 'HAF6182300009MP', 'HAF6182300009MS', 'HAF6182300009MV', 'HAF6182300009MY',
                    'HAF6182300009N1', 'HAF6182300009NN', 'HAF6182300009PD', 'HAF6182300009PP', 'HAF6182300009R0',
                    'HAF6182300009R4', 'HAF6182300009RA', 'HAF6182300009RL', 'HAF6182300009RZ', 'HAF6182300009SF',
                    'HAF6182300009T6', 'HAF6182300009T7', 'HAF6182300009TH', 'HAF6182300009TM', 'HAF6182300009TT',
                    'HAF6182300009U1', 'HAF6182300009VR', 'HAF6182300009W4', 'HAF6182300009W6', 'HAF6182300009WC',
                    'HAF6182300009WD', 'HAF6182300009WE', 'HAF6182300009WH', 'HAF6182300009WJ', 'HAF6182300009WK',
                    'HAF6182300009WM', 'HAF6182300009WN', 'HAF6182300009WR', 'HAF6182300009WS', 'HAF6182300009WU',
                    'HAF6182300009WY', 'HAF6182300009Y6', 'HAF6182300009YC', 'HAF6182300009Z5', 'HAF6182300009ZV',
                    'HAF618230000A1V', 'HAF618230000A2C', 'HAF618230000A2J', 'HAF618230000A2M', 'HAF618230000A2R',
                    'HAF618230000A2T', 'HAF618230000A2U', 'HAF618230000A2Y', 'HAF618230000A2Z', 'HAF618230000A30',
                    'HAF618230000A33', 'HAF618230000A34', 'HAF618230000A35', 'HAF618230000A36', 'HAF618230000A38',
                    'HAF618230000A39', 'HAF618230000A3B', 'HAF618230000A3C', 'HAF618230000A3D', 'HAF618230000A3H',
                    'HAF618230000A3J', 'HAF618230000A44', 'HAF618230000A45', 'HAF618230000A4F', 'HAF618230000A4J',
                    'HAF618230000A4R', 'HAF618230000A7Z', 'HAF618230000A9L', 'HAF618230000A9U', 'HAF618230000AA0',
                    'HAF618230000AA4', 'HAF618230000AAB', 'HAF618230000AB9', 'HAF618230000ABY', 'HAF618230000AC4',
                    'HAF618230000AC7', 'HAF618230000AC9', 'HAF618230000ACA', 'HAF618230000ACD', 'HAF618230000ACE',
                    'HAF618230000ACF', 'HAF618230000ACJ', 'HAF618230000ACK', 'HAF618230000ACV', 'HAF618230000AD3',
                    'HAF618230000AEM', 'HAF618230000AEZ', 'HAF618230000AF3', 'HAF618230000AFC', 'HAF618230000AMH',
                    'HAF618230000AMN', 'HAF618230000AMV', 'HAF618230000AN0', 'HAF618230000AN2', 'HAF618230000AN6',
                    'HAF618230000ANB', 'HAF618230000APE', 'HAF618230000APK', 'HAF618230000APW', 'HAF618230000AR1',
                    'HAF618230000AR6', 'HAF618230000AR9', 'HAF618230000ARD', 'HAF618230000ARF', 'HAF618230000ARG',
                    'HAF618230000ARM', 'HAF618230000ARN', 'HAF618230000ARS', 'HAF618230000ARW', 'HAF618230000AS0',
                    'HAF618230000AS3', 'HAF618230000AS7', 'HAF618230000ASA', 'HAF618230000ASE', 'HAF618230000ASH',
                    'HAF618230000ASL', 'HAF618230000ASN', 'HAF618230000ASS', 'HAF618230000ASU', 'HAF618230000ASV',
                    'HAF618230000ATT', 'HAF618230000AUV', 'HAF618230000AVH', 'HAF618230000AW7', 'HAF618230000AWE',
                    'HAF618230000AWM', 'HAF618230000AWS', 'HAF618230000AY3', 'HAF618230000AY4', 'HAF618230000AY8',
                    'HAF618230000AY9', 'HAF618230000AYC', 'HAF618230000AYD', 'HAF618230000AYG', 'HAF618230000AYJ',
                    'HAF618230000AYL', 'HAF618230000AYP', 'HAF618230000AYS', 'HAF618230000AYW', 'HAF618230000AYY',
                    'HAF618230000AZ2', 'HAF618230000AZ7', 'HAF618230000AZC', 'HAF618230000AZE', 'HAF618230000AZK',
                    'HAF618230000AZS', 'HAF618230000AZU', 'HAF618230000AZZ', 'HAF618230000B00', 'HAF618230000B01',
                    'HAF618230000B05', 'HAF618230000B07', 'HAF618230000B0A', 'HAF618230000B0C', 'HAF618230000B0F',
                    'HAF618230000B0M', 'HAF618230000B0N', 'HAF618230000B0R', 'HAF618230000B0Z', 'HAF618230000B35',
                    'HAF618230000B4L', 'HAF618230000B6P', 'HAF618230000B6U', 'HAF618230000B6W', 'HAF618230000B70',
                    'HAF618230000B73', 'HAF618230000B7B', 'HAF618230000B7H', 'HAF618230000B7M', 'HAF618230000B85',
                    'HAF618230000BB5', 'HAF618230000BBA', 'HAF618230000BBP', 'HAF618230000BBU', 'HAF618230000BBW',
                    'HAF618230000BC0', 'HAF618230000BC3', 'HAF618230000BDA', 'HAF618230000BFR', 'HAF618230000BFS',
                    'HAF618230000BFV', 'HAF618230000BFW', 'HAF618230000BFZ', 'HAF618230000BHU', 'HAF618230000BJ9',
                    'HAF618230000BJD', 'HAF618230000BK4', 'HAF618230000BK8', 'HAF618230000BKF', 'HAF618230000BKH',
                    'HAF618230000BKR', 'HAF618230000BKW', 'HAF618230000BRZ', 'HAF618230000BS3', 'HAF618230000C4D',
                    'HAF618230000C4H', 'HAF618230000C79', 'HAF618230000C8R', 'HAF618230000C9G', 'HAF618230000C9L',
                    'HAF618230000C9P', 'HAF618230000C9Y', 'HAF618230000CA1', 'HAF618230000CA8', 'HAF618230000CAC',
                    'HAF618230000CAH', 'HAF618230000CAR', 'HAF618230000CL0', 'HAF618230000CM7', 'HAF618230000CML',
                    'HAF618230000CPB', 'HAF618230000CPZ', 'HAF618230000CT9', 'HAF618230000CTC', 'HAF618230000CTF',
                    'HAF618230000CTJ', 'HAF618230000CTS', 'HAF618230000CTV', 'HAF618230000CTY', 'HAF618230000CV1',
                    'HAF618230000CW7', 'HAF618230000CW8', 'HAF618230000CWA', 'HAF618230000CWC', 'HAF618230000CWD',
                    'HAF618230000CWF', 'HAF618230000CZ1', 'HAF618230000CZC', 'HAF618230000D0P', 'HAF618230000D1F',
                    'HAF618230000D57', 'HAF618230000D5Z', 'HAF618230000D6A', 'HAF618230000D74', 'HAF618230000D7F',
                    'HAF618230000D7K', 'HAF618230000D7L', 'HAF618230000D7P', 'HAF618230000D7S', 'HAF618230000D7Z',
                    'HAF618230000D84', 'HAF618230000D87', 'HAF618230000D8C', 'HAF618230000D8H', 'HAF618230000D8P',
                    'HAF618230000DA9', 'HAF618230000DAY', 'HAF618230000DCM', 'HAF618230000DD1', 'HAF618230000DD7',
                    'HAF618230000DDD', 'HAF618230000DKD', 'HAF618230000DKG', 'HAF618230000DKM', 'HAF618230000DKR',
                    'HAF618230000DLF', 'HAF618230000DLR', 'HAF618230000DLZ', 'HAF618230000DM3', 'HAF618230000DM5',
                    'HAF618230000DM9', 'HAF618230000DMJ', 'HAF618230000DMK', 'HAF618230000DMW', 'HAF618230000DMY',
                    'HAF618230000DN4', 'HAF618230000DN9', 'HAF618230000DNR', 'HAF618230000DNV', 'HAF618230000DP4',
                    'HAF618230000DP8', 'HAF618230000DPD', 'HAF618230000DPK', 'HAF618230000DPM', 'HAF618230000DPP',
                    'HAF618230000DR1', 'HAF618230000DSE', 'HAF618230000DSL', 'HAF618230000DSS', 'HAF618230000DSZ',
                    'HAF618230000DT4', 'HAF618230000DT9', 'HAF618230000DTC', 'HAF618230000DUK', 'HAF618230000DWW',
                    'HAF618230000DYV', 'HAF618230000DZ0', 'HAF618230000DZ3', 'HAF618230000DZ5', 'HAF618230000DZ7',
                    'HAF618230000DZC', 'HAF618230000E0R', 'HAF618230000E33', 'HAF618230000E3J', 'HAF618230000E3S',
                    'HAF618230000E43', 'HAF618230000E49', 'HAF618230000E4J', 'HAF618230000E4S', 'HAF618230000E57',
                    'HAF618230000E5B', 'HAF618230000E5H', 'HAF618230000E5N', 'HAF618230000E5S', 'HAF618230000E5Z',
                    'HAF618230000E64', 'HAF618230000E6A', 'HAF618230000E6D', 'HAF618230000E6U', 'HAF618230000E74',
                    'HAF618230000E7D', 'HAF618230000E7E', 'HAF618230000E7M', 'HAF618230000E7V', 'HAF618230000E7Y',
                    'HAF618230000E86', 'HAF618230000E8U', 'HAF618230000E95', 'HAF618230000EEC', 'HAF618230000EFD',
                    'HAF618230000EG0', 'HAF618230000EG2', 'HAF618230000EHY', 'HAF618230000EJU', 'HAF618230000EKU',
                    'HAF618230000EKV', 'HAF618230000EL7', 'HAF618230000ELD', 'HAF618230000ELJ', 'HAF618230000ELN',
                    'HAF618230000ELT', 'HAF618230000EM3', 'HAF618230000ESL', 'HAF618230000EUP', 'HAF618230000EUW',
                    'HAF618230000EV2', 'HAF618230000EVA', 'HAF618230000EVN', 'HAF618230000EVU', 'HAF618230000EYC',
                    'HAF618230000EYH', 'HAF618230000EYR', 'HAF618230000EYY', 'HAF618230000EZ4', 'HAF618230000EZA',
                    'HAF618230000EZB', 'HAF618230000EZC', 'HAF618230000EZG', 'HAF618230000EZN', 'HAF618230000EZT',
                    'HAF618230000EZZ', 'HAF618230000F06', 'HAF618230000F0C', 'HAF618230000F0G', 'HAF618230000F0N',
                    'HAF618230000F0U', 'HAF618230000F2S', 'HAF618230000F2Z', 'HAF618230000F3A', 'HAF618230000F3L',
                    'HAF618230000F3Y', 'HAF618230000F44', 'HAF618230000F4H', 'HAF618230000FBJ', 'HAF618230000FC5',
                    'HAF618230000FEB', 'HAF618230000FEW', 'HAF618230000FF2', 'HAF618230000FF5', 'HAF618230000FFB',
                    'HAF618230000FFG', 'HAF618230000FFK', 'HAF618230000FFU', 'HAF618230000FKW', 'HAF618230000FLZ',
                    'HAF618230000FMW', 'HAF618230000FNC', 'HAF618230000FNK', 'HAF618230000FNR', 'HAF618230000FNZ',
                    'HAF618230000FP5', 'HAF618230000FPC', 'HAF618230000FS4', 'HAF618230000FS9', 'HAF618230000FT5',
                    'HAF618230000FUA', 'HAF618230000FY4', 'HAF618230000FY7', 'HAF618230000FYF', 'HAF618230000FYN',
                    'HAF618230000FZ0', 'HAF618230000FZ4', 'HAF618230000G0T', 'HAF618230000G0Y', 'HAF618230000G13',
                    'HAF618230000G1A', 'HAF618230000G1H', 'HAF618230000G1L', 'HAF618230000G1S', 'HAF618230000G1Y',
                    'HAF618230000G25', 'HAF618230000G2F', 'HAF618230000G2Y', 'HAF618230000G3P', 'HAF618230000G3U',
                    'HAF618230000G4A', 'HAF618230000G4E', 'HAF618230000G4H', 'HAF618230000G4N', 'HAF618230000G4T',
                    'HAF618230000G60', 'HAF618230000G64', 'HAF618230000G67', 'HAF618230000G6C', 'HAF618230000G6J',
                    'HAF618230000G6N', 'HAF618230000G6T', 'HAF618230000G72', 'HAF618230000G7E', 'HAF618230000G8Z',
                    'HAF618230000G96', 'HAF618230000G9A', 'HAF618230000G9C', 'HAF618230000G9W', 'HAF618230000GA1',
                    'HAF618230000GA6', 'HAF618230000GAB', 'HAF618230000GAH', 'HAF618230000GAT', 'HAF618230000GB0',
                    'HAF618230000GB5', 'HAF618230000GBA', 'HAF618230000GBF', 'HAF618230000GBJ', 'HAF618230000GBN',
                    'HAF618230000GBT', 'HAF618230000GC1', 'HAF618230000GCC', 'HAF618230000GDE', 'HAF618230000GDJ',
                    'HAF618230000GDP', 'HAF618230000GDU', 'HAF618230000GDZ', 'HAF618230000GE8', 'HAF618230000GEB',
                    'HAF618230000GJJ', 'HAF618230000GKT', 'HAF618230000GL0', 'HAF618230000HEH', 'HAF618230000HEK',
                    'HAF618230000HEL', 'HAF618230000HEN', 'HAF618230000HER', 'HAF618230000HES', 'HAF618230000HEU',
                    'HAF618230000HEW', 'HAF618230000HGM', 'HAF618230000HGP', 'HAF618230000HGR', 'HAF618230000HGU',
                    'HAF618230000HGV', 'HAF618230000HGZ', 'HAF618230000HH2', 'HAF618230000HH3', 'HAF618230000HH5',
                    'HAF618230000HMB', 'HAF618230000HMF', 'HAF618230000HMH', 'HAF618230000HMK', 'HAF618230000HML',
                    'HAF618230000HMM', 'HAF618230000HMN', 'HAF618230000HMP', 'HAF618230000HNE', 'HAF618230000HNG',
                    'HAF618230000HNH', 'HAF618230000HNM', 'HAF618230000HNR', 'HAF618230000HNU', 'HAF618230000HNW',
                    'HAF618230000HNY', 'HAF618230000HPF', 'HAF618230000HPG', 'HAF618230000K1K', 'HAF618230000K1N',
                    'HAF618230000K1R', 'HAF618230000K1T', 'HAF618230000K1V', 'HAF618230000K54', 'HAF618230000K56',
                    'HAF618230000K57', 'HAF618230000K58', 'HAF618230000K59', 'HAF618230000K5A', 'HAF618230000K5C',
                    'HAF618230000K5D', 'HAF618230000K5E', 'HAF618230000K5F', 'HAF618230000K5K', 'HAF618230000K5M',
                    'HAF618230000K5N', 'HAF618230000K5P', 'HAF618230000K5R', 'HAF618230000K69', 'HAF618230000K6C',
                    'HAF618230000K6D', 'HAF618230000K6G', 'HAF618230000K6M', 'HAF618230000K6S', 'HAF618230000K6U',
                    'HAF618230000K6W', 'HAF618230000K70', 'HAF618230000K71', 'HAF618230000K75', 'HAF618230000K77',
                    'HAF618230000K7A', 'HAF618230000K7B', 'HAF618230000K7D', 'HAF618230000K85', 'HAF618230000K8H',
                    'HAF618230000K8K', 'HAF618230000K8N', 'HAF618230000K8R', 'HAF618230000K8U', 'HAF618230000K8V',
                    'HAF618230000K8Y', 'HAF618230000K90', 'HAF618230000K93', 'HAF618230000K94', 'HAF618230000KBK',
                    'HAF618230000KBP', 'HAF618230000KBR', 'HAF618230000KBV', 'HAF618230000KBY', 'HAF618230000L3Y',
                    'HAF618230000L41', 'HAF618230000L42', 'HAF618230000L43', 'HAF618230000L45', 'HAF618230000L46',
                    'HAF618230000L47', 'HAF618230000L5H', 'HAF618230000L6L', 'HAF618230000L6N', 'HAF618230000L6R',
                    'HAF618230000L6S', 'HAF618230000L6V', 'HAF618230000L6W', 'HAF618230000RGC', 'HAF618230000RGU',
                    'HAF618230000RGV', 'HAF618230000RGY', 'HAF618230000RGZ', 'HAF618230000RH0', 'HAF618230000RH1',
                    'HAF618230000RH2', 'HAF618230000RH4', 'HAF618230000RHG', 'HAF618230000RJU', 'HAF618230000RKR',
                    'HAF618230000RKY', 'HAF618230000RL4', 'HAF618230000RL7', 'HAF618230000RLA', 'HAF618230000RLD',
                    'HAF618230000RLJ', 'HAF618230000RLL', 'HAF618230000RLS', 'HAF618230000RLV', 'HAF618230000RLY',
                    'HAF618230000RMA', 'HAF618230000RMC', 'HAF618230000RMD', 'HAF618230000RME', 'HAF618230000RMF',
                    'HAF618230000RMG', 'HAF618230000RMT', 'HAF618230000RMW', 'HAF618230000RMZ', 'HAF618230000RN2',
                    'HAF618230000RNF', 'HAF618230000RNH', 'HAF618230000RNK', 'HAF618230000RNN', 'HAF618230000RNT',
                    'HAF618230000RNV', 'HAF618230000RNZ', 'HAF618230000RP1', 'HAF618230000RP8', 'HAF618230000RPE',
                    'HAF618230000RPH', 'HAF618230000RPK', 'HAF618230000RPS', 'HAF618230000RPU', 'HAF618230000RR1',
                    'HAF618230000RR7', 'HAF618230000RRA', 'HAF618230000RRD', 'HAF618230000RRG', 'HAF618230000RRJ',
                    'HAF618230000RRL', 'HAF618230000RRP', 'HAF618230000RRS', 'HAF618230000RRV', 'HAF618230000RRY',
                    'HAF618230000RS6', 'HAF618230000RS9', 'HAF618230000RSM', 'HAF618230000RSP', 'HAF618230000RSV',
                    'HAF618230000RT4', 'HAF618230000RT9', 'HAF618230000RTB', 'HAF618230000RTC', 'HAF618230000RTD',
                    'HAF618230000RTE', 'HAF618230000RTF', 'HAF618230000RTY', 'HAF618230000RU4', 'HAF618230000RU6',
                    'HAF618230000RU9', 'HAF618230000RUE', 'HAF618230000RUG', 'HAF618230000RUH', 'HAF618230000RUK',
                    'HAF618230000RUR', 'HAF618230000RUV', 'HAF618230000RUY', 'HAF618230000RV1', 'HAF618230000RV3',
                    'HAF618230000RV4', 'HAF618230000RV6', 'HAF618230000RV9', 'HAF618230000RVC', 'HAF618230000RVF',
                    'HAF618230000RVU', 'HAF618230000RWA', 'HAF618230000RWC', 'HAF618230000RWF', 'HAF618230000RWP',
                    'HAF618230000RWS', 'HAF618230000RWT', 'HAF618230000RWV', 'HAF618230000RWY', 'HAF618230000RWZ',
                    'HAF618230000RY2', 'HAF618230000RY4', 'HAF618230000RY6', 'HAF618230000RY8', 'HAF618230000RY9',
                    'HAF618230000RYB', 'HAF618230000RYD', 'HAF618230000RYF', 'HAF618230000RYG', 'HAF618230000RYK',
                    'HAF618230000RYN', 'HAF618230000RZB', 'HAF618230000RZC', 'HAF618230000RZD', 'HAF618230000S06',
                    'HAF618230000S09', 'HAF618230000S0E', 'HAF618230000S0H', 'HAF618230000S0J', 'HAF618230000S0K',
                    'HAF618230000S0P', 'HAF618230000S0T', 'HAF618230000S27', 'HAF618230000S2Y', 'HAF618230000S33',
                    'HAF618230000S3C', 'HAF618230000S3E', 'HAF618230000S3G', 'HAF618230000S48', 'HAF618230000S4B',
                    'HAF618230000S4C', 'HAF618230000S4E', 'HAF618230000S4H', 'HAF618230000S4K', 'HAF618230000S57',
                    'HAF618230000S5C', 'HAF618230000S5E', 'HAF618230000S5L', 'HAF618230000S5P', 'HAF618230000S5T',
                    'HAF618230000S61', 'HAF618230000S67', 'HAF618230000S69', 'HAF618230000S6A', 'HAF618230000S6D',
                    'HAF618230000S6E', 'HAF618230000S6F', 'HAF618230000S6K', 'HAF618230000S6L', 'HAF618230000S6N',
                    'HAF618230000S6R', 'HAF618230000S6U', 'HAF618230000S6Y', 'HAF618230000S70', 'HAF618230000S71',
                    'HAF618230000S74', 'HAF618230000S75', 'HAF618230000S77', 'HAF618230000S78', 'HAF618230000S7B',
                    'HAF618230000S7C', 'HAF618230000S7E', 'HAF618230000S7H', 'HAF618230000S7J', 'HAF618230000S99',
                    'HAF618230000S9C', 'HAF618230000S9F', 'HAF618230000S9K', 'HAF618230000S9N', 'HAF618230000S9V',
                    'HAF618230000SA3', 'HAF618230000SBJ', 'HAF618230000SC4', 'HAF618230000SCC', 'HAF618230000SCF',
                    'HAF618230000SCH', 'HAF618230000SCL', 'HAF618230000SCP', 'HAF618230000SCR', 'HAF618230000SCW',
                    'HAF618230000SCZ', 'HAF618230000SD2', 'HAF618230000SD4', 'HAF618230000SD7', 'HAF618230000SDC',
                    'HAF618230000SDG', 'HAF618230000SDM', 'HAF618230000SDU', 'HAF618230000SDV', 'HAF618230000SDZ',
                    'HAF618230000SF4', 'HAF618230000SFK', 'HAF618230000SHY', 'HAF618230000SJ3', 'HAF618230000SJ5',
                    'HAF618230000SJ9', 'HAF618230000SJC', 'HAF618230000SJF', 'HAF618230000SJJ', 'HAF618230000SJL',
                    'HAF618230000SJP', 'HAF618230000SLA', 'HAF618230000SLE', 'HAF618230000SLN', 'HAF618230000SLS',
                    'HAF618230000SLY', 'HAF618230000SM4', 'HAF618230000SM7', 'HAF618230000SMA', 'HAF618230000SMF',
                    'HAF618230000SML', 'HAF618230000SMR', 'HAF618230000SMV', 'HAF618230000SN2', 'HAF618230000SN9',
                    'HAF618230000SNC', 'HAF618230000SNM', 'HAF618230000SNS', 'HAF618230000SNZ', 'HAF618230000SP4',
                    'HAF618230000SUV', 'HAF618230000SV5', 'HAF618230000SV7', 'HAF618230000SVB', 'HAF618230000SVJ',
                    'HAF618230000SVU', 'HAF618230000SW2', 'HAF618230000SW6', 'HAF618230000SW9', 'HAF618230000SZE',
                    'HAF618230000SZT', 'HAF618230000T57', 'HAF618230000T86', 'HAF618230000T8B', 'HAF618230000T8P',
                    'HAF618230000T8V', 'HAF618230000T90', 'HAF618230000T92', 'HAF618230000T98', 'HAF618230000T9C',
                    'HAF618230000T9L', 'HAF618230000T9P', 'HAF618230000T9T', 'HAF618230000T9Y', 'HAF618230000TA0',
                    'HAF618230000TFF', 'HAF618230000TGN', 'HAF618230000TH2', 'HAF618230000TH4', 'HAF618230000TH7',
                    'HAF618230000THA', 'HAF618230000THE', 'HAF618230000THH', 'HAF618230000THK', 'HAF618230000THR',
                    'HAF618230000THU', 'HAF618230000THY', 'HAF618230000TNR', 'HAF618230000TP0', 'HAF618230000TPT',
                    'HAF618230000TPZ', 'HAF618230000TR2', 'HAF618230000TR5', 'HAF618230000TRE', 'HAF618230000TRJ',
                    'HAF618230000TRL', 'HAF618230000TSN', 'HAF618230000TSU', 'HAF618230000TW9', 'HAF618230000TWC',
                    'HAF618230000TWF', 'HAF618230000TWK', 'HAF618230000TWT', 'HAF618230000TY4', 'HAF618230000TY9',
                    'HAF618230000TYD', 'HAF618230000TYG', 'HAF618230000TYT', 'HAF618230000TZF', 'HAF618230000TZR',
                    'HAF618230000TZW', 'HAF618230000U07', 'HAF618230000U08', 'HAF618230000U09', 'HAF618230000U0A',
                    'HAF618230000U0E', 'HAF618230000U0G', 'HAF618230000U0Z', 'HAF618230000U13', 'HAF618230000U1M',
                    'HAF618230000U3B', 'HAF618230000U3D', 'HAF618230000U3H', 'HAF618230000U3K', 'HAF618230000U3U',
                    'HAF618230000U41', 'HAF618230000U47', 'HAF618230000U4B', 'HAF618230000U4F', 'HAF618230000U4H',
                    'HAF618230000U4M', 'HAF618230000U6S', 'HAF618230000U6Y', 'HAF618230000U6Z', 'HAF618230000U71',
                    'HAF618230000U73', 'HAF618230000U74', 'HAF618230000U76', 'HAF618230000U78', 'HAF618230000U7A',
                    'HAF618230000U7B', 'HAF618230000U7F', 'HAF618230000U7H', 'HAF618230000U7K', 'HAF618230000U7M',
                    'HAF618230000U7P', 'HAF618230000U7S', 'HAF618230000U7T', 'HAF618230000U7Z', 'HAF618230000U82',
                    'HAF618230000U87', 'HAF618230000U8A', 'HAF618230000U8D', 'HAF618230000U8Y', 'HAF618230000U91',
                    'HAF618230000U9B', 'HAF618230000U9D', 'HAF618230000U9J', 'HAF618230000U9M', 'HAF618230000U9S',
                    'HAF618230000UAE', 'HAF618230000UAH', 'HAF618230000UAK', 'HAF618230000UAS', 'HAF618230000UAZ',
                    'HAF618230000UB2', 'HAF618230000UBD', 'HAF618230000UBG', 'HAF618230000UBK', 'HAF618230000UBR',
                    'HAF618230000UBV', 'HAF618230000UC1', 'HAF618230000UC4', 'HAF618230000UD9', 'HAF618230000UDD',
                    'HAF618230000UDF', 'HAF618230000UDH', 'HAF618230000UDL', 'HAF618230000UDN', 'HAF618230000UDW',
                    'HAF618230000UF2', 'HAF618230000UF7', 'HAF618230000UFC', 'HAF618230000UFJ', 'HAF618230000UFY',
                    'HAF618230000UG7', 'HAF618230000UGC', 'HAF618230000UGD', 'HAF618230000UGU', 'HAF618230000ULE',
                    'HAF618230000ULH', 'HAF618230000ULT', 'HAF618230000UM1', 'HAF618230000UM7', 'HAF618230000UMG',
                    'HAF618230000UMR', 'HAF618230000UMU', 'HAF618230000UMZ', 'HAF618230000UN4', 'HAF618230000UNA',
                    'HAF618230000UNG', 'HAF618230000UNP', 'HAF618230000UNV', 'HAF618230000UP9', 'HAF618230000UPN',
                    'HAF618230000UPS', 'HAF618230000UPY', 'HAF618230000UR9', 'HAF618230000URE', 'HAF618230000URG',
                    'HAF618230000URK', 'HAF618230000UU1', 'HAF618230000UU5', 'HAF618230000UUB', 'HAF618230000UUL',
                    'HAF618230000UUM', 'HAF618230000UUR', 'HAF618230000UUS', 'HAF618230000UUT', 'HAF618230000UUU',
                    'HAF618230000UUW', 'HAF618230000UV1', 'HAF618230000UV2', 'HAF618230000UV4', 'HAF618230000UV8',
                    'HAF618230000UV9', 'HAF618230000UVE', 'HAF618230000UVF', 'HAF618230000UVH', 'HAF618230000UVJ',
                    'HAF618230000UVK', 'HAF618230000UVP', 'HAF618230000UVR', 'HAF618230000UVS', 'HAF618230000UVU',
                    'HAF618230000UVW', 'HAF618230000UW0', 'HAF618230000UW1', 'HAF618230000UW4', 'HAF618230000UW7',
                    'HAF618230000UW9', 'HAF618230000UWC', 'HAF618230000UWE', 'HAF618230000UWH', 'HAF618230000UWJ',
                    'HAF618230000UWK', 'HAF618230000UWP', 'HAF618230000UWS', 'HAF618230000UWT', 'HAF618230000UWU',
                    'HAF618230000UWW', 'HAF618230000UWY', 'HAF618230000UY0', 'HAF618230000UY1', 'HAF618230000UY3',
                    'HAF618230000UY5', 'HAF618230000UY7', 'HAF618230000UY9', 'HAF618230000UYB', 'HAF618230000UYC',
                    'HAF618230000UYE', 'HAF618230000UYH', 'HAF618230000UYJ', 'HAF618230000UYK', 'HAF618230000UYM',
                    'HAF618230000UYN', 'HAF618230000UYR', 'HAF618230000UYS', 'HAF618230000UYU', 'HAF618230000UYV',
                    'HAF618230000UYW', 'HAF618230000UYZ', 'HAF618230000UZ0', 'HAF618230000UZ2', 'HAF618230000UZ3',
                    'HAF618230000UZ4', 'HAF618230000UZ6', 'HAF618230000UZ8', 'HAF618230000UZ9', 'HAF618230000UZB',
                    'HAF618230000UZD', 'HAF618230000UZE', 'HAF618230000UZF', 'HAF618230000UZG', 'HAF618230000UZK',
                    'HAF618230000UZL', 'HAF618230000UZM', 'HAF618230000UZP', 'HAF618230000UZR', 'HAF618230000UZW',
                    'HAF618230000V02', 'HAF618230000V05', 'HAF618230000V07', 'HAF618230000V0A', 'HAF618230000V0D',
                    'HAF618230000V0G', 'HAF618230000V1C', 'HAF618230000V1E', 'HAF618230000V1S', 'HAF618230000V26',
                    'HAF618230000V28', 'HAF618230000V2A', 'HAF618230000V2C', 'HAF618230000V77', 'HAF618230000V7B',
                    'HAF618230000VBU', 'HAF618230000VC0', 'HAF618230000VC4', 'HAF618230000VC8', 'HAF618230000VCA',
                    'HAF618230000VCC', 'HAF618230000VCF', 'HAF618230000VCY', 'HAF618230000VD2', 'HAF618230000VDM',
                    'HAF618230000VHA', 'HAF618230000VHG', 'HAF618230000VHK', 'HAF618230000VHS', 'HAF618230000VJ8',
                    'HAF618230000VJD', 'HAF618230000VJG', 'HAF618230000VJL', 'HAF618230000VJP', 'HAF618230000VJV',
                    'HAF618230000VJZ', 'HAF618230000VK2', 'HAF618230000VL3', 'HAF618230000VL6', 'HAF618230000VLB',
                    'HAF618230000VLE', 'HAF618230000VLF', 'HAF618230000VLJ', 'HAF618230000VRJ', 'HAF618230000VRY',
                    'HAF618230000VSP', 'HAF618230000VSR', 'HAF618230000VSV', 'HAF618230000VT5', 'HAF618230000VT7',
                    'HAF618230000VTB', 'HAF618230000VTD', 'HAF618230000VTG', 'HAF618230000VTJ', 'HAF618230000VTM',
                    'HAF618230000VTP', 'HAF618230000VTR', 'HAF618230000VTU', 'HAF618230000VTY', 'HAF618230000VTZ',
                    'HAF618230000VU2', 'HAF618230000VU4', 'HAF618230000VUA', 'HAF618230000VWZ', 'HAF618230000VYM',
                    'HAF618230000W05', 'HAF618230000W08', 'HAF618230000W0A', 'HAF618230000W0D', 'HAF618230000W0F',
                    'HAF618230000W0H', 'HAF618230000W0K', 'HAF618230000W0N', 'HAF618230000W18', 'HAF618230000W1B',
                    'HAF618230000W1D', 'HAF618230000W1J', 'HAF618230000W1M', 'HAF618230000W1P', 'HAF618230000W1T',
                    'HAF618230000W3M', 'HAF618230000W3N', 'HAF618230000W3R', 'HAF618230000W3U', 'HAF618230000W3V',
                    'HAF618230000W3W', 'HAF618230000W7F', 'HAF618230000W7H', 'HAF618230000W7K', 'HAF618240000000',
                    'HAF61824000000C', 'HAF61824000002C', 'HAF61824000002R', 'HAF61824000002Z', 'HAF618240000034',
                    'HAF618240000037', 'HAF61824000003D', 'HAF61824000004M', 'HAF61824000004P', 'HAF61824000005G',
                    'HAF61824000005H', 'HAF61824000005V', 'HAF61824000005W', 'HAF618240000066', 'HAF618240000075',
                    'HAF618240000077', 'HAF61824000007A', 'HAF61824000007F', 'HAF61824000007K', 'HAF61824000007M',
                    'HAF61824000007R', 'HAF6182400000DT', 'HAF6182400000DY', 'HAF6182400000E1', 'HAF6182400000E2',
                    'HAF6182400000E5', 'HAF6182400000EB', 'HAF6182400000J3', 'HAF6182400000KM', 'HAF6182400000KN',
                    'HAF6182400000L2', 'HAF6182400000L4', 'HAF6182400000NJ', 'HAF6182400000NN', 'HAF6182400000NW',
                    'HAF6182400000PW', 'HAF6182400000R2', 'HAF6182400000R4', 'HAF6182400000RY', 'HAF6182400000SG',
                    'HAF6182400000SM', 'HAF6182400000SN', 'HAF6182400000SV', 'HAF6182400000UN', 'HAF6182400000UZ',
                    'HAF6182400000W3', 'HAF6182400000W8', 'HAF6182400000Y7', 'HAF61824000015B', 'HAF618240000176',
                    'HAF61824000022C', 'HAF61824000028A', 'HAF6182400002AZ', 'HAF6182400002B1', 'HAF6182400002B4',
                    'HAF6182400002B9', 'HAF6182400002FB', 'HAF6182400002FE', 'HAF6182400002FJ', 'HAF6182400002G3',
                    'HAF6182400002GB', 'HAF61824000038A', 'HAF6182400003GJ', 'HAF61824000043A', 'HAF61824000045N',
                    'HAF61824000046T', 'HAF618240000470', 'HAF618240000476', 'HAF61824000047P', 'HAF61824000047Y',
                    'HAF61824000048R', 'HAF61824000048S', 'HAF61824000048U', 'HAF61824000048Z', 'HAF618240000492',
                    'HAF618240000497', 'HAF618240000499', 'HAF6182400004CB', 'HAF6182400004CK', 'HAF6182400004CN',
                    'HAF6182400004CR', 'HAF6182400004CT', 'HAF6182400004CU', 'HAF6182400004CW', 'HAF6182400004D6',
                    'HAF6182400004DD', 'HAF6182400004DM', 'HAF61824000052D', 'HAF61824000052J', 'HAF61824000052R',
                    'HAF61824000052V', 'HAF618240000530', 'HAF61824000055F', 'HAF6182400005DU', 'HAF6182400005DW',
                    'HAF6182400005DY', 'HAF6182400005E0', 'HAF6182400005E6', 'HAF6182400005E9', 'HAF6182400005FL',
                    'HAF6182400005FN', 'HAF6182400005FR', 'HAF6182400005FT', 'HAF6182400005FU', 'HAF6182400005FY',
                    'HAF6182400005G0', 'HAF6182400005G1', 'HAF6182400005G3', 'HAF6182400005G5', 'HAF6182400005GB',
                    'HAF6182400005GC', 'HAF6182400005GD', 'HAF6182400005GF', 'HAF6182400005J5', 'HAF6182400005J9',
                    'HAF6182400005LC', 'HAF6182400005N1', 'HAF6182400005N2', 'HAF6182400005N5', 'HAF6182400005N9',
                    'HAF6182400005NH', 'HAF6182400005RG', 'HAF6182400005RK', 'HAF6182400005UZ', 'HAF6182400005V3',
                    'HAF6182400005V4', 'HAF6182400005VL', 'HAF61824000063N', 'HAF61824000066G', 'HAF61824000068G',
                    'HAF6182400006B2', 'HAF6182400006BB', 'HAF6182400006BF', 'HAF6182400006BH', 'HAF6182400006BL',
                    'HAF6182400006BS', 'HAF6182400006DY', 'HAF6182400006E1', 'HAF6182400006E4', 'HAF6182400006EA',
                    'HAF6182400006EC', 'HAF6182400006EE', 'HAF6182400006EG', 'HAF6182400006GY', 'HAF6182400006H2',
                    'HAF6182400006H5', 'HAF6182400006H9', 'HAF6182400006HF', 'HAF6182400006HP', 'HAF6182400006HV',
                    'HAF6182400006ND', 'HAF6182400006NJ', 'HAF6182400006NM', 'HAF6182400006NS', 'HAF6182400006WY',
                    'HAF6182400006YZ', 'HAF6182400006Z0', 'HAF6182400006Z2', 'HAF6182400006Z4', 'HAF6182400006Z6',
                    'HAF6182400006ZB', 'HAF6182400006ZD', 'HAF6182400006ZH', 'HAF6182400006ZL', 'HAF6182400006ZN',
                    'HAF6182400006ZU', 'HAF6182400006ZW', 'HAF61824000070K', 'HAF61824000073Y', 'HAF618240000740',
                    'HAF618240000744', 'HAF61824000076K', 'HAF6182400007DK', 'HAF6182400007F4', 'HAF6182400007FM',
                    'HAF6182400007FY', 'HAF6182400007HR', 'HAF6182400007HZ', 'HAF6182400007J3', 'HAF6182400007JY',
                    'HAF6182400007NU', 'HAF6182400007SC', 'HAF6182400007T8', 'HAF6182400007TB', 'HAF6182400007TF',
                    'HAF6182400007TJ', 'HAF6182400007TM', 'HAF6182400007TP', 'HAF6182400007TT', 'HAF6182400007Z3',
                    'HAF6182400007Z7', 'HAF6182400007ZB', 'HAF6182400007ZD', 'HAF61824000080C', 'HAF61824000081C',
                    'HAF61824000081F', 'HAF61824000081H', 'HAF61824000081K', 'HAF61824000081L', 'HAF61824000081N',
                    'HAF61824000081P', 'HAF61824000085V', 'HAF618240000860', 'HAF618240000863', 'HAF618240000866',
                    'HAF618240000868', 'HAF6182400008C9', 'HAF6182400008CB', 'HAF6182400008CD', 'HAF6182400008CF',
                    'HAF6182400008CL', 'HAF6182400008CR', 'HAF6182400008CT', 'HAF6182400008EW', 'HAF6182400008EY',
                    'HAF6182400008F0', 'HAF6182400008F1', 'HAF6182400008F3', 'HAF6182400008F4', 'HAF6182400008MD',
                    'HAF6182400008MF', 'HAF6182400008PA', 'HAF6182400008PC', 'HAF6182400008PF', 'HAF6182400008PH',
                    'HAF6182400008PJ', 'HAF6182400008PL', 'HAF6182400008PU', 'HAF6182400008PW', 'HAF6182400009F9',
                    'HAF6182400009FN', 'HAF6182400009LG', 'HAF6182400009LJ', 'HAF6182400009YF', 'HAF6182400009Z9',
                    'HAF6182400009ZE', 'HAF6182400009ZG', 'HAF6182400009ZJ', 'HAF6182400009ZL', 'HAF6182400009ZN',
                    'HAF618240000A0J', 'HAF618240000A0L', 'HAF618240000A2B', 'HAF618240000A2S', 'HAF618240000A39',
                    'HAF618240000A3C', 'HAF618240000A3W', 'HAF618240000A45', 'HAF618240000A4C', 'HAF618240000A4E',
                    'HAF618240000A4H', 'HAF618240000A4J', 'HAF618240000A4P', 'HAF618240000A4R', 'HAF618240000A6E',
                    'HAF618240000A7M', 'HAF618240000AAM', 'HAF618240000AB0', 'HAF618240000AB2', 'HAF618240000AB4',
                    'HAF618240000ABF', 'HAF618240000ABM', 'HAF618240000ABR', 'HAF618240000AC0', 'HAF618240000AE0',
                    'HAF618240000AHW', 'HAF618240000AUJ', 'HAF618240000AYE', 'HAF618240000AZJ', 'HAF618240000B08',
                    'HAF618240000B53', 'HAF618240000B6R', 'HAF618240000B7A', 'HAF618240000B7G', 'HAF618240000B7M',
                    'HAF618240000B7T', 'HAF618240000B7Z', 'HAF618240000BA6', 'HAF618240000BDL', 'HAF618240000BGJ',
                    'HAF618240000BHV', 'HAF618240000BJB', 'HAF618240000BJH', 'HAF618240000BJN', 'HAF618240000BKP',
                    'HAF618240000BKU', 'HAF618240000BKZ', 'HAF618240000BL1', 'HAF618240000BL5', 'HAF618240000BL8',
                    'HAF618240000BLZ', 'HAF618240000BM3', 'HAF618240000BMB', 'HAF618240000BMW', 'HAF618240000BN3',
                    'HAF618240000BNC', 'HAF618240000BNJ', 'HAF618240000BPP', 'HAF618240000BPU', 'HAF618240000BR8',
                    'HAF618240000BRG', 'HAF618240000BTL', 'HAF618240000BTT', 'HAF618240000BU2', 'HAF618240000BUZ',
                    'HAF618240000BV3', 'HAF618240000BV6', 'HAF618240000BVF', 'HAF618240000BVJ', 'HAF618240000BVN',
                    'HAF618240000BWZ', 'HAF618240000BZ1', 'HAF618240000C0G', 'HAF618240000C22', 'HAF618240000C3K',
                    'HAF618240000C3T', 'HAF618240000C7W', 'HAF618240000C8K', 'HAF618240000C8R', 'HAF618240000CGE',
                    'HAF618240000CGZ', 'HAF618240000CH9', 'HAF618240000CHM', 'HAF618240000CHR', 'HAF618240000CJ2',
                    'HAF618240000CJC', 'HAF618240000CSJ', 'HAF618240000CSZ', 'HAF618240000CUF', 'HAF618240000CUS',
                    'HAF618240000CV0', 'HAF618240000CVF', 'HAF618240000CVV', 'HAF618240000CWD', 'HAF618240000CWM',
                    'HAF618240000CYU', 'HAF618240000CZ3', 'HAF618240000CZE', 'HAF618240000CZH', 'HAF618240000D04',
                    'HAF618240000D0G', 'HAF618240000D0P', 'HAF618240000D14', 'HAF618240000D19', 'HAF618240000D1A',
                    'HAF618240000D1K', 'HAF618240000D1L', 'HAF618240000D1S', 'HAF618240000D1W', 'HAF618240000D20',
                    'HAF618240000D23', 'HAF618240000D2J', 'HAF618240000D2T', 'HAF618240000D31', 'HAF618240000D32',
                    'HAF618240000D3B', 'HAF618240000D3J', 'HAF618240000D3T', 'HAF618240000D41', 'HAF618240000D44',
                    'HAF618240000D4L', 'HAF618240000D69', 'HAF618240000D6F', 'HAF618240000D6N', 'HAF618240000D7M',
                    'HAF618240000D7Z', 'HAF618240000DLZ', 'HAF618240000DSW', 'HAF618240000DT0', 'HAF618240000DT3',
                    'HAF618240000DWP', 'HAF618240000DY9', 'HAF618240000DZF', 'HAF618240000DZH', 'HAF618240000E6S',
                    'HAF618240000E6Y', 'HAF618240000E7A', 'HAF618240000E7C', 'HAF618240000EB2', 'HAF618240000EB4',
                    'HAF618240000EB6', 'HAF618240000EB8', 'HAF618240000EBA', 'HAF618240000EBD', 'HAF618240000EBF',
                    'HAF618240000EGB', 'HAF618240000EGW', 'HAF618240000EGZ', 'HAF618240000EH2', 'HAF618240000EH4',
                    'HAF618240000EH7', 'HAF618240000EHB', 'HAF618240000EMU', 'HAF618240000ESM', 'HAF618240000ESR',
                    'HAF618240000ESS', 'HAF618240000EST', 'HAF618240000ESU', 'HAF618240000ESW', 'HAF618240000ETP',
                    'HAF618240000ETT', 'HAF618240000ETU', 'HAF618240000ETW', 'HAF618240000ETY', 'HAF618240000EV8',
                    'HAF618240000F18', 'HAF618240000F23', 'HAF618240000F40', 'HAF618240000F44', 'HAF618240000F48',
                    'HAF618240000F49', 'HAF618240000F4C', 'HAF618240000F4D', 'HAF618240000F4F', 'HAF618240000F4K',
                    'HAF618240000F4N', 'HAF618240000F5M', 'HAF618240000F5P', 'HAF618240000F5T', 'HAF618240000F5W',
                    'HAF618240000FFN', 'HAF618240000FFU', 'HAF618240000FFY', 'HAF618240000FG2', 'HAF618240000FG4',
                    'HAF618240000FG7', 'HAF618240000FG9', 'HAF618240000FP6', 'HAF618240000FP9', 'HAF618240000FPK',
                    'HAF618240000FPM', 'HAF618240000FPR', 'HAF618240000FPU', 'HAF618240000FR0', 'HAF618240000FW2',
                    'HAF618240000FW6', 'HAF618240000FW9', 'HAF618240000FWD', 'HAF618240000FWH', 'HAF618240000FWL',
                    'HAF618240000FWR', 'HAF618240000FWU', 'HAF618240000FYH', 'HAF618240000FYM', 'HAF618240000G1W',
                    'HAF618240000G1Y', 'HAF618240000G1Z', 'HAF618240000G21', 'HAF618240000G22', 'HAF618240000G23',
                    'HAF618240000G24', 'HAF618240000G26', 'HAF618240000G51', 'HAF618240000G53', 'HAF618240000G56',
                    'HAF618240000G57', 'HAF618240000G58', 'HAF618240000G59', 'HAF618240000G5A', 'HAF618240000G5B',
                    'HAF618240000G5C', 'HAF618240000G5G', 'HAF618240000G5J', 'HAF618240000G5L', 'HAF618240000GBP',
                    'HAF618240000GBW', 'HAF618240000GC6', 'HAF618240000GC8', 'HAF618240000GCA', 'HAF618240000GCK',
                    'HAF618240000GED', 'HAF618240000GF6', 'HAF618240000GL4', 'HAF618240000GLC', 'HAF618240000GLH',
                    'HAF618240000GLY', 'HAF618240000GMK', 'HAF618240000GMU', 'HAF618240000GN0', 'HAF618240000GN1',
                    'HAF618240000GN8', 'HAF618240000GR9', 'HAF618240000GRC', 'HAF618240000GTE', 'HAF618240000GTL',
                    'HAF618240000GTN', 'HAF618240000GTP', 'HAF618240000GTW', 'HAF618240000GU0', 'HAF618240000GU4',
                    'HAF618240000GU8', 'HAF618240000GVC', 'HAF618240000GVE', 'HAF618240000GVH', 'HAF618240000GVK',
                    'HAF618240000GVM', 'HAF618240000GVN', 'HAF618240000GVR', 'HAF618240000GVV', 'HAF618240000GVY',
                    'HAF618240000GVZ', 'HAF618240000GW0', 'HAF618240000GW1', 'HAF618240000GW4', 'HAF618240000GW5',
                    'HAF618240000GW9', 'HAF618240000GWH', 'HAF618240000GY2', 'HAF618240000GYG', 'HAF618240000GYJ',
                    'HAF618240000GYL', 'HAF618240000GYM', 'HAF618240000GYR', 'HAF618240000GYU', 'HAF618240000GYV',
                    'HAF618240000GYY', 'HAF618240000GZ1', 'HAF618240000H2B', 'HAF618240000H2D', 'HAF618240000H2F',
                    'HAF618240000H2H', 'HAF618240000H2L', 'HAF618240000H2R', 'HAF618240000H2T', 'HAF618240000H2W',
                    'HAF618240000H4E', 'HAF618240000H7R', 'HAF618240000H7Y', 'HAF618240000H8F', 'HAF618240000HA1',
                    'HAF618240000HA2', 'HAF618240000HA5', 'HAF618240000HA7', 'HAF618240000HAB', 'HAF618240000HAE',
                    'HAF618240000HAG', 'HAF618240000HAK', 'HAF618240000HAL', 'HAF618240000HAU', 'HAF618240000HAV',
                    'HAF618240000HB5', 'HAF618240000HB7', 'HAF618240000HBA', 'HAF618240000HBB', 'HAF618240000HBD',
                    'HAF618240000HBE', 'HAF618240000HBF', 'HAF618240000HBG', 'HAF618240000HBJ', 'HAF618240000HBK',
                    'HAF618240000HBM', 'HAF618240000HBN', 'HAF618240000HBT', 'HAF618240000HBY', 'HAF618240000HC3',
                    'HAF618240000HC7', 'HAF618240000HC9', 'HAF618240000HCC', 'HAF618240000HCF', 'HAF618240000HCK',
                    'HAF618240000HCN', 'HAF618240000HCS', 'HAF618240000HD4', 'HAF618240000HDS', 'HAF618240000HDZ',
                    'HAF618240000HF3', 'HAF618240000HF9', 'HAF618240000HFG', 'HAF618240000HFK', 'HAF618240000HFM',
                    'HAF618240000HFS', 'HAF618240000HFV', 'HAF618240000HFY', 'HAF618240000HG0', 'HAF618240000HGW',
                    'HAF618240000HH0', 'HAF618240000HH3', 'HAF618240000HH6', 'HAF618240000HHA', 'HAF618240000HHE',
                    'HAF618240000HHK', 'HAF618240000HHN', 'HAF618240000HHP', 'HAF618240000HHU', 'HAF618240000HJ1',
                    'HAF618240000HJ4', 'HAF618240000HN8', 'HAF618240000HNE', 'HAF618240000HNM', 'HAF618240000HNY',
                    'HAF618240000HP2', 'HAF618240000HP7', 'HAF618240000HPA', 'HAF618240000HPD', 'HAF618240000HPF',
                    'HAF618240000HPL', 'HAF618240000HPP', 'HAF618240000HPT', 'HAF618240000HPY', 'HAF618240000HR7',
                    'HAF618240000HRE', 'HAF618240000HRJ', 'HAF618240000HS4', 'HAF618240000HS8', 'HAF618240000HSB',
                    'HAF618240000HSF', 'HAF618240000HSK', 'HAF618240000HSR', 'HAF618240000HT4', 'HAF618240000HT9',
                    'HAF618240000HTE', 'HAF618240000HTH', 'HAF618240000HTK', 'HAF618240000HTP', 'HAF618240000HTY',
                    'HAF618240000HU3', 'HAF618240000HU4', 'HAF618240000HU7', 'HAF618240000HUB', 'HAF618240000HUJ',
                    'HAF618240000HUN', 'HAF618240000HUT', 'HAF618240000HUW', 'HAF618240000HV0', 'HAF618240000HVZ',
                    'HAF618240000HW5', 'HAF618240000HWA', 'HAF618240000HWE', 'HAF618240000HWG', 'HAF618240000HWK',
                    'HAF618240000HWN', 'HAF618240000HWR', 'HAF618240000HWT', 'HAF618240000HWY', 'HAF618240000HY0',
                    'HAF618240000HY5', 'HAF618240000HY9', 'HAF618240000HYG', 'HAF618240000HYM', 'HAF618240000HYT',
                    'HAF618240000HYZ', 'HAF618240000HZ2', 'HAF618240000HZ4', 'HAF618240000HZ7', 'HAF618240000HZ8',
                    'HAF618240000HZC', 'HAF618240000HZP', 'HAF618240000HZV', 'HAF618240000J0K', 'HAF618240000J0R',
                    'HAF618240000J0U', 'HAF618240000J0Z', 'HAF618240000J13', 'HAF618240000J18', 'HAF618240000J1B',
                    'HAF618240000J1C', 'HAF618240000J1G', 'HAF618240000J2C', 'HAF618240000J2L', 'HAF618240000J2P',
                    'HAF618240000J2T', 'HAF618240000J2V', 'HAF618240000J30', 'HAF618240000J3H', 'HAF618240000J3L',
                    'HAF618240000J3P', 'HAF618240000J3T', 'HAF618240000J3W', 'HAF618240000J3Z', 'HAF618240000J4C',
                    'HAF618240000J4H', 'HAF618240000J4L', 'HAF618240000J4N', 'HAF618240000J4T', 'HAF618240000J4U',
                    'HAF618240000J4Y', 'HAF618240000J50', 'HAF618240000J52', 'HAF618240000J55', 'HAF618240000J56',
                    'HAF618240000J58', 'HAF618240000J5A', 'HAF618240000J5B', 'HAF618240000J5C', 'HAF618240000J5E',
                    'HAF618240000J5F', 'HAF618240000J5K', 'HAF618240000J5R', 'HAF618240000J5W', 'HAF618240000J60',
                    'HAF618240000J61', 'HAF618240000J64', 'HAF618240000J6H', 'HAF618240000J6K', 'HAF618240000J86',
                    'HAF618240000J8B', 'HAF618240000J8F', 'HAF618240000J8L', 'HAF618240000J8S', 'HAF618240000J8T',
                    'HAF618240000J8V', 'HAF618240000J8W', 'HAF618240000J8Z', 'HAF618240000J93', 'HAF618240000J97',
                    'HAF618240000J9C', 'HAF618240000J9Y', 'HAF618240000JA3', 'HAF618240000JA8', 'HAF618240000JAJ',
                    'HAF618240000JAP', 'HAF618240000JAV', 'HAF618240000JAZ', 'HAF618240000JB3', 'HAF618240000JB5',
                    'HAF618240000JB6', 'HAF618240000JBA', 'HAF618240000JBB', 'HAF618240000JBM', 'HAF618240000JBU',
                    'HAF618240000JBW', 'HAF618240000JCK', 'HAF618240000JCU', 'HAF618240000JU6', 'HAF618240000JUA',
                    'HAF618240000JUJ', 'HAF618240000JUL', 'HAF618240000JUU', 'HAF618240000JVC', 'HAF618240000JVZ',
                    'HAF618240000JY4', 'HAF618240000JZY', 'HAF618240000K0A', 'HAF618240000K0Z', 'HAF618240000K15',
                    'HAF618240000K1A', 'HAF618240000K1F', 'HAF618240000K1H', 'HAF618240000K1M', 'HAF618240000K1R',
                    'HAF618240000K1U', 'HAF618240000K1W', 'HAF618240000K38', 'HAF618240000K3B', 'HAF618240000K3E',
                    'HAF618240000K3H', 'HAF618240000K3M', 'HAF618240000K3S', 'HAF618240000K3W', 'HAF618240000K5J',
                    'HAF618240000K5L', 'HAF618240000K5S', 'HAF618240000K5W', 'HAF618240000K61', 'HAF618240000K62',
                    'HAF618240000KAL', 'HAF618240000KAP', 'HAF618240000KAT', 'HAF618240000KAZ', 'HAF618240000KB2',
                    'HAF618240000KB6', 'HAF618240000KBB', 'HAF618240000KBE', 'HAF618240000KG5', 'HAF618240000KG6',
                    'HAF618240000KG9', 'HAF618240000KGB', 'HAF618240000KGD', 'HAF618240000KGF', 'HAF618240000KGH',
                    'HAF618240000KGK', 'HAF618240000KSL', 'HAF618240000LNU', 'HAF618240000LNV', 'HAF618240000LP0',
                    'HAF618240000LP1', 'HAF618240000LP2', 'HAF618240000LP4', 'HAF618240000LV1', 'HAF618240000LV3',
                    'HAF618240000LV5', 'HAF618240000LV7', 'HAF618240000LVC', 'HAF618240000LVE', 'HAF618240000M20',
                    'HAF618240000M22', 'HAF618240000M37', 'HAF618240000M3E', 'HAF618240000M3G', 'HAF618240000M43',
                    'HAF618240000M5G', 'HAF618240000M5J', 'HAF618240000M5P', 'HAF618240000M5T', 'HAF618240000M5U',
                    'HAF618240000M5V', 'HAF618240000M5Y', 'HAF618240000M63', 'HAF618240000M65', 'HAF618240000M70',
                    'HAF618240000M72', 'HAF618240000M7A', 'HAF618240000M7D', 'HAF618240000M7E', 'HAF618240000M7K',
                    'HAF618240000M7U', 'HAF618240000ML4', 'HAF618240000ML6', 'HAF618240000ML7', 'HAF618240000ML9',
                    'HAF618240000MLC', 'HAF618240000MLG', 'HAF61825000001C', 'HAF61825000005L', 'HAF61825000005N',
                    'HAF61825000005R', 'HAF61825000005S', 'HAF6182500000H8', 'HAF6182500000HA', 'HAF6182500000HE',
                    'HAF6182500000HH', 'HAF6182500000HL', 'HAF6182500000HP', 'HAF6182500000HZ', 'HAF6182500000J2',
                    'HAF6182500000J5', 'HAF6182500000J9', 'HAF6182500000JC', 'HAF6182500000JH', 'HAF6182500000JP',
                    'HAF6182500000JS', 'HAF6182500000JT', 'HAF6182500000JW', 'HAF6182500000K1', 'HAF6182500000K9',
                    'HAF6182500000KD', 'HAF6182500000KE', 'HAF6182500000KF', 'HAF6182500000KK', 'HAF6182500000KL',
                    'HAF6182500000KP', 'HAF6182500000KS', 'HAF6182500000KV', 'HAF6182500000KY', 'HAF6182500000L1',
                    'HAF6182500000L3', 'HAF6182500000L6', 'HAF6182500000L8', 'HAF6182500000L9', 'HAF6182500000LC',
                    'HAF6182500000LD', 'HAF6182500000LP', 'HAF6182500000LY', 'HAF6182500000MA', 'HAF6182500000MH',
                    'HAF6182500000MZ', 'HAF6182500000N5', 'HAF6182500000N7', 'HAF6182500000NG', 'HAF6182500000P1',
                    'HAF6182500000P3', 'HAF6182500000P4', 'HAF6182500000P9', 'HAF6182500000PE', 'HAF6182500000PF',
                    'HAF6182500000PH', 'HAF6182500000PK', 'HAF6182500000PM', 'HAF6182500000PR', 'HAF6182500000PT',
                    'HAF6182500000PU', 'HAF6182500000SC', 'HAF6182500000SE', 'HAF6182500000SK', 'HAF6182500000SL',
                    'HAF6182500000SR', 'HAF6182500000ST', 'HAF6182500000SY', 'HAF6182500000TZ', 'HAF6182500000ZB',
                    'HAF6182500000ZV', 'HAF61825000011Y', 'HAF618250000120', 'HAF61825000012P', 'HAF61825000012V',
                    'HAF61825000012Y', 'HAF618250000131', 'HAF61825000013A', 'HAF61825000013E', 'HAF61825000013G',
                    'HAF61825000019R', 'HAF61825000019T', 'HAF61825000019U', 'HAF6182500001A1', 'HAF6182500001A7',
                    'HAF6182500001AB', 'HAF6182500001AF', 'HAF6182500001AL', 'HAF6182500001AR', 'HAF6182500001B0',
                    'HAF6182500001B3', 'HAF6182500001B5', 'HAF6182500001B9', 'HAF6182500001BB', 'HAF6182500001BG',
                    'HAF6182500001BH', 'HAF6182500001EZ', 'HAF6182500001F8', 'HAF6182500001FA', 'HAF6182500001FF',
                    'HAF6182500001FL', 'HAF6182500001FR', 'HAF6182500001FS', 'HAF6182500001FZ', 'HAF6182500001G3',
                    'HAF6182500001MK', 'HAF6182500001NK', 'HAF6182500001NR', 'HAF6182500001NU', 'HAF6182500001NW',
                    'HAF6182500001P1', 'HAF6182500001P2', 'HAF6182500001R3', 'HAF6182500001R8', 'HAF6182500001RC',
                    'HAF6182500001RG', 'HAF6182500001RM', 'HAF6182500001RS', 'HAF6182500001RZ', 'HAF6182500001S1',
                    'HAF6182500001S6', 'HAF6182500001S9', 'HAF6182500001WW', 'HAF6182500001WY', 'HAF6182500001Y2',
                    'HAF6182500001Y9', 'HAF6182500001YJ', 'HAF6182500001YP', 'HAF6182500001YT', 'HAF6182500001YY',
                    'HAF61825000020B', 'HAF61825000020K', 'HAF61825000020M', 'HAF618250000237', 'HAF61825000023B',
                    'HAF61825000023F', 'HAF61825000023M', 'HAF61825000023U', 'HAF618250000240', 'HAF618250000245',
                    'HAF61825000024A', 'HAF61825000024H', 'HAF618250000256', 'HAF61825000025B', 'HAF61825000025G',
                    'HAF61825000025L', 'HAF61825000025P', 'HAF61825000025U', 'HAF618250000260', 'HAF618250000261',
                    'HAF618250000269', 'HAF61825000026B', 'HAF61825000026U', 'HAF618250000271', 'HAF618250000275',
                    'HAF618250000276', 'HAF61825000027D', 'HAF618250000280', 'HAF61825000028U', 'HAF6182500002BC',
                    'HAF6182500002BJ', 'HAF6182500002BU', 'HAF6182500002C1', 'HAF6182500002C6', 'HAF6182500002CA',
                    'HAF6182500002CF', 'HAF6182500002CL', 'HAF6182500002DL', 'HAF6182500002DM', 'HAF6182500002DS',
                    'HAF6182500002GY', 'HAF6182500002H2', 'HAF6182500002H8', 'HAF6182500002HC', 'HAF6182500002KB',
                    'HAF6182500002KL', 'HAF6182500002KW', 'HAF6182500002LL', 'HAF6182500002MN', 'HAF6182500002P5',
                    'HAF6182500002PH', 'HAF6182500002R6', 'HAF6182500002WD', 'HAF6182500002WT', 'HAF6182500002WZ',
                    'HAF6182500002Y5', 'HAF6182500002YE', 'HAF618250000352', 'HAF618250000353', 'HAF618250000355',
                    'HAF618250000357', 'HAF61825000035B', 'HAF61825000035D', 'HAF61825000035E', 'HAF618250000360',
                    'HAF618250000368', 'HAF61825000036H', 'HAF61825000036N', 'HAF61825000036V', 'HAF618250000373',
                    'HAF61825000038N', 'HAF6182500003A7', 'HAF6182500003AC', 'HAF6182500003AH', 'HAF6182500003AM',
                    'HAF6182500003AT', 'HAF6182500003AZ', 'HAF6182500003B4', 'HAF6182500003B9', 'HAF6182500003BB',
                    'HAF6182500003BN', 'HAF6182500003BT', 'HAF6182500003BV', 'HAF6182500003C1', 'HAF6182500003C3',
                    'HAF6182500003CA', 'HAF6182500003CB', 'HAF6182500003CF', 'HAF6182500003CH', 'HAF6182500003CL',
                    'HAF6182500003CP', 'HAF6182500003CZ', 'HAF6182500003D9', 'HAF6182500003ET', 'HAF6182500003F0',
                    'HAF6182500003F8', 'HAF6182500003FC', 'HAF6182500003FJ', 'HAF6182500003FN', 'HAF6182500003FU',
                    'HAF6182500003GN', 'HAF6182500003HR', 'HAF6182500003KR', 'HAF6182500003L0', 'HAF6182500003L5',
                    'HAF6182500003LA', 'HAF6182500003LD', 'HAF6182500003LK', 'HAF6182500003LR', 'HAF6182500003LT',
                    'HAF6182500003LU', 'HAF6182500003LW', 'HAF6182500003LY', 'HAF6182500003M2', 'HAF6182500003M5',
                    'HAF6182500003M7', 'HAF6182500003MA', 'HAF6182500003MC', 'HAF6182500003NF', 'HAF6182500003NL',
                    'HAF6182500003NR', 'HAF6182500003NW', 'HAF6182500003NZ', 'HAF6182500003P3', 'HAF6182500003TD',
                    'HAF6182500003TM', 'HAF6182500003U2', 'HAF6182500003UC', 'HAF6182500003UK', 'HAF6182500003UU',
                    'HAF6182500003WB', 'HAF6182500003WK', 'HAF6182500003WR', 'HAF6182500003WS', 'HAF6182500003WW',
                    'HAF6182500003Y1', 'HAF6182500003Y3', 'HAF6182500003YP', 'HAF6182500003YW', 'HAF6182500003Z4',
                    'HAF6182500003ZE', 'HAF6182500003ZF', 'HAF6182500003ZP', 'HAF6182500003ZY', 'HAF61825000041U',
                    'HAF618250000423', 'HAF61825000042B', 'HAF618250000435', 'HAF618250000436', 'HAF61825000043J',
                    'HAF61825000043P', 'HAF618250000441', 'HAF618250000447', 'HAF61825000044L', 'HAF61825000044M',
                    'HAF61825000044R', 'HAF61825000044U', 'HAF61825000044Y', 'HAF618250000457', 'HAF61825000045A',
                    'HAF618250000461', 'HAF618250000464', 'HAF61825000046K', 'HAF618250000471', 'HAF618250000479',
                    'HAF61825000047K', 'HAF618250000490', 'HAF61825000049C', 'HAF61825000049K', 'HAF61825000049T',
                    'HAF6182500004A8', 'HAF6182500004AS', 'HAF6182500004AT', 'HAF6182500004B0', 'HAF6182500004B7',
                    'HAF6182500004B8', 'HAF6182500004BD', 'HAF6182500004BH', 'HAF6182500004BN', 'HAF6182500004BP',
                    'HAF6182500004BY', 'HAF6182500004BZ', 'HAF6182500004CF', 'HAF6182500004DS', 'HAF6182500004E2',
                    'HAF6182500004EC', 'HAF6182500004EF', 'HAF6182500004EM', 'HAF6182500004EU', 'HAF6182500004EY',
                    'HAF6182500004FB', 'HAF6182500004FH', 'HAF6182500004FM', 'HAF6182500004FT', 'HAF6182500004G0',
                    'HAF6182500004G6', 'HAF6182500004GC', 'HAF6182500004GF', 'HAF6182500004JJ', 'HAF6182500004JU',
                    'HAF6182500004JV', 'HAF6182500004KA', 'HAF6182500004KB', 'HAF6182500004KJ', 'HAF6182500004KS',
                    'HAF6182500004L1', 'HAF6182500004LA', 'HAF6182500004LW', 'HAF6182500004M4', 'HAF6182500004N0',
                    'HAF6182500004NL', 'HAF6182500004NP', 'HAF6182500004NS', 'HAF6182500004P0', 'HAF6182500004P5',
                    'HAF6182500004PU', 'HAF6182500004PW', 'HAF6182500004PZ', 'HAF6182500004R0', 'HAF6182500004R2',
                    'HAF6182500004R9', 'HAF6182500004RE', 'HAF6182500004RJ', 'HAF6182500004RN', 'HAF6182500004RT',
                    'HAF6182500004RY', 'HAF6182500004S5', 'HAF6182500004S6', 'HAF6182500004SF', 'HAF6182500004SJ',
                    'HAF6182500004SN', 'HAF6182500004ST', 'HAF6182500004SV', 'HAF6182500004T0', 'HAF6182500004T1',
                    'HAF6182500004T2', 'HAF6182500004T7', 'HAF6182500004T8', 'HAF6182500004T9', 'HAF6182500004TE',
                    'HAF6182500004TH', 'HAF6182500004TU', 'HAF6182500004TZ', 'HAF6182500004U2', 'HAF6182500004U4',
                    'HAF6182500004U5', 'HAF6182500004UB', 'HAF6182500004UG', 'HAF6182500004UP', 'HAF6182500004UU',
                    'HAF6182500004UY', 'HAF6182500004V2', 'HAF6182500004V4', 'HAF6182500004VM', 'HAF6182500004VS',
                    'HAF6182500004W2', 'HAF6182500004W7', 'HAF6182500004WF', 'HAF6182500004WK', 'HAF6182500004WN',
                    'HAF6182500004WS', 'HAF6182500004Y5', 'HAF61825000050R', 'HAF61825000051G', 'HAF61825000051K',
                    'HAF618250000528', 'HAF618250000529', 'HAF61825000053U', 'HAF618250000543', 'HAF618250000547',
                    'HAF61825000054A', 'HAF61825000054Y', 'HAF618250000551', 'HAF618250000557', 'HAF618250000559',
                    'HAF61825000055B', 'HAF61825000055E', 'HAF61825000056S', 'HAF61825000056V', 'HAF61825000057V',
                    'HAF618250000586', 'HAF61825000058C', 'HAF61825000058H', 'HAF61825000058S', 'HAF61825000058Y',
                    'HAF618250000595', 'HAF61825000059A', 'HAF61825000059F', 'HAF61825000059R', 'HAF61825000059W',
                    'HAF6182500005A2', 'HAF6182500005A9', 'HAF6182500005AE', 'HAF6182500005AM', 'HAF6182500005AT',
                    'HAF6182500005B0', 'HAF6182500005B4', 'HAF6182500005BM', 'HAF6182500005BP', 'HAF6182500005C1',
                    'HAF6182500005C5', 'HAF6182500005CG', 'HAF6182500005CN', 'HAF6182500005CV', 'HAF6182500005D2',
                    'HAF6182500005ED', 'HAF6182500005H0', 'HAF6182500005H8', 'HAF6182500005HK', 'HAF6182500005HN',
                    'HAF6182500005HS', 'HAF6182500005HY', 'HAF6182500005J0', 'HAF6182500005N5', 'HAF6182500005P5',
                    'HAF6182500005P8', 'HAF6182500005PC', 'HAF6182500005PF', 'HAF6182500005PJ', 'HAF6182500005PP',
                    'HAF6182500005PU', 'HAF6182500005PZ', 'HAF6182500005R7', 'HAF6182500005RG', 'HAF6182500005RS',
                    'HAF6182500005RY', 'HAF6182500005SB', 'HAF6182500005SG', 'HAF6182500005SL', 'HAF6182500005SR',
                    'HAF6182500005SY', 'HAF6182500005T4', 'HAF6182500005TA', 'HAF6182500005TK', 'HAF6182500005TN',
                    'HAF6182500005U3', 'HAF6182500005UG', 'HAF6182500005UH', 'HAF6182500005UM', 'HAF6182500005UP',
                    'HAF6182500005UW', 'HAF6182500005VY', 'HAF6182500005W3', 'HAF6182500005W6', 'HAF6182500005WB',
                    'HAF6182500005WE', 'HAF6182500005WK', 'HAF6182500005WM', 'HAF6182500005Y9', 'HAF6182500005YF',
                    'HAF6182500005YK', 'HAF6182500005YS', 'HAF6182500005YW', 'HAF6182500005Z4', 'HAF6182500005Z7',
                    'HAF6182500005ZF', 'HAF6182500005ZM', 'HAF61825000060L', 'HAF61825000062Z', 'HAF618250000632',
                    'HAF618250000635', 'HAF61825000063P', 'HAF61825000063W', 'HAF618250000671', 'HAF618250000675',
                    'HAF618250000679', 'HAF61825000067B', 'HAF61825000067G', 'HAF61825000067H', 'HAF6182500006EF',
                    'HAF6182500006EN', 'HAF6182500006F6', 'HAF6182500006FC', 'HAF6182500006FJ', 'HAF6182500006FP',
                    'HAF6182500006FS', 'HAF6182500006G0', 'HAF6182500006G9', 'HAF6182500006GG', 'HAF6182500006GK',
                    'HAF6182500006GP', 'HAF6182500006GS', 'HAF6182500006HK', 'HAF6182500006HM', 'HAF6182500006HN',
                    'HAF6182500006HP', 'HAF6182500006HS', 'HAF6182500006HV', 'HAF6182500006HY', 'HAF6182500006J2',
                    'HAF6182500006J4', 'HAF6182500006JA', 'HAF6182500006JK', 'HAF6182500006JW', 'HAF6182500006KB',
                    'HAF6182500006MZ', 'HAF6182500006N1', 'HAF6182500006N4', 'HAF6182500006N6', 'HAF6182500006N9',
                    'HAF6182500006NC', 'HAF6182500006T6', 'HAF6182500006TP', 'HAF6182500006TS', 'HAF6182500006TW',
                    'HAF6182500006U3', 'HAF6182500006U8', 'HAF6182500006UA', 'HAF6182500006UC', 'HAF6182500006V4',
                    'HAF61825000073M', 'HAF61825000073V', 'HAF6182500007CP', 'HAF6182500007CW', 'HAF6182500007D9',
                    'HAF6182500007DF', 'HAF6182500007DN', 'HAF6182500007DU', 'HAF6182500007E1', 'HAF6182500007MW',
                    'HAF6182500007N1', 'HAF6182500007N6', 'HAF6182500007N9', 'HAF6182500007NF', 'HAF6182500007NL',
                    'HAF6182500007R9', 'HAF6182500007UD', 'HAF6182500007UL', 'HAF6182500007UP', 'HAF6182500007UR',
                    'HAF6182500007UU', 'HAF6182500007UZ', 'HAF6182500007VC', 'HAF6182500007WT', 'HAF6182500007WZ',
                    'HAF6182500007Y5', 'HAF6182500007YA', 'HAF6182500007YD', 'HAF6182500007YH', 'HAF6182500007YP',
                    'HAF6182500007YU', 'HAF618250000809', 'HAF61825000080G', 'HAF61825000080L', 'HAF61825000080S',
                    'HAF61825000080W', 'HAF618250000814', 'HAF618250000816', 'HAF61825000081A', 'HAF6182500008A5',
                    'HAF6182500008AE', 'HAF6182500008AK', 'HAF6182500008AS', 'HAF6182500008CY', 'HAF6182500008D3',
                    'HAF6182500008RA', 'HAF61825000097L', 'HAF61825000097N', 'HAF61825000097P', 'HAF61825000097T',
                    'HAF61825000097V', 'HAF61825000097W', 'HAF618250000980', 'HAF618250000985', 'HAF618250000987',
                    'HAF6182500009AE', 'HAF6182500009J8', 'HAF6182500009KN', 'HAF6182500009KS', 'HAF6182500009KY',
                    'HAF6182500009L1', 'HAF6182500009L3', 'HAF6182500009L5', 'HAF6182500009L8', 'HAF6182500009MH',
                    'HAF6182500009MJ', 'HAF6182500009MK', 'HAF6182500009MM', 'HAF6182500009MN', 'HAF6182500009MP',
                    'HAF6182500009MS', 'HAF6182500009PG', 'HAF6182500009U7', 'HAF6182500009U9', 'HAF6182500009UD',
                    'HAF6182500009UF', 'HAF6182500009UH', 'HAF6182500009UP', 'HAF6182500009WE', 'HAF6182500009YW',
                    'HAF6182500009Z2', 'HAF6182500009ZL', 'HAF6182500009ZT', 'HAF618250000A08', 'HAF618250000A0E',
                    'HAF618250000A0H', 'HAF618250000A2J', 'HAF618250000A2N', 'HAF618250000A2T', 'HAF618250000A30',
                    'HAF618250000A33', 'HAF618250000A3A', 'HAF618250000A3D', 'HAF618250000AWJ', 'HAF618250000AY3',
                    'HAF618250000AY8', 'HAF618250000AYD', 'HAF618250000AYJ', 'HAF618250000AYM', 'HAF618250000B00',
                    'HAF618250000B1S', 'HAF618250000B35', 'HAF618250000B3D', 'HAF618250000B3M', 'HAF618250000B3U',
                    'HAF618250000B41', 'HAF618250000B48', 'HAF618250000B9U', 'HAF618250000BA2', 'HAF618250000BAM',
                    'HAF618250000BB1', 'HAF618250000BB7', 'HAF618250000BD3', 'HAF618250000BD7', 'HAF618250000BDB',
                    'HAF618250000BGD', 'HAF618250000BGM', 'HAF618250000BJ5', 'HAF618250000BJ9', 'HAF618250000BJE',
                    'HAF618250000BJJ', 'HAF618250000BJR', 'HAF618250000BJV', 'HAF618250000BP4', 'HAF618250000BP7',
                    'HAF618250000CC0', 'HAF618250000CC9', 'HAF618250000CCF', 'HAF618250000CCM', 'HAF618250000CCS',
                    'HAF618250000CCT', 'HAF618250000CD0', 'HAF618250000CD6', 'HAF618250000CD7', 'HAF618250000CDC',
                    'HAF618250000CEC', 'HAF618250000CEP', 'HAF618250000CER', 'HAF618250000CEU', 'HAF618250000CF2',
                    'HAF618250000CF3', 'HAF618250000CF9', 'HAF618250000CFA', 'HAF618250000CFD', 'HAF618250000CFK',
                    'HAF618250000CFP', 'HAF618250000CFT', 'HAF618250000CL3', 'HAF618250000CWV', 'HAF618250000CY4',
                    'HAF618250000CYC', 'HAF618250000D57', 'HAF618250000D5U', 'HAF618250000D6D', 'HAF618250000D6N',
                    'HAF618250000D6W', 'HAF618250000DAY', 'HAF618250000DAZ', 'HAF618250000DB1', 'HAF618250000DB2',
                    'HAF618250000DB6', 'HAF618250000DB8', 'HAF618250000DBA', 'HAF618250000DBF', 'HAF618250000DEV',
                    'HAF618250000DF3', 'HAF618250000DF9', 'HAF618250000DFH', 'HAF618250000DFS', 'HAF618250000DFZ',
                    'HAF618250000DG2', 'HAF618250000DGC', 'HAF618250000DSA', 'HAF618250000DSL', 'HAF618250000DSS',
                    'HAF618250000DSY', 'HAF618250000DT2', 'HAF618250000DT7', 'HAF618250000DZ8', 'HAF618250000DZB',
                    'HAF618250000DZE', 'HAF618250000DZJ', 'HAF618250000DZM', 'HAF618250000DZS', 'HAF618250000DZV',
                    'HAF618250000E00', 'HAF618250000E1A', 'HAF618250000E1D', 'HAF618250000E1F', 'HAF618250000E1L',
                    'HAF618250000E1R', 'HAF618250000E1U', 'HAF618250000E20', 'HAF618250000E7F', 'HAF618250000E7H',
                    'HAF618250000E7P', 'HAF618250000E7S', 'HAF618250000E7W', 'HAF618250000E7Z', 'HAF618250000E80',
                    'HAF618250000E93', 'HAF618250000E98', 'HAF618250000EA0', 'HAF618250000EA3', 'HAF618250000EA8',
                    'HAF618250000EAA', 'HAF618250000EAD', 'HAF618250000EAG', 'HAF618250000EAJ', 'HAF618250000EAL',
                    'HAF618250000EB7', 'HAF618250000EBJ', 'HAF618250000EBN', 'HAF618250000EBR', 'HAF618250000EC7',
                    'HAF618250000ECC', 'HAF618250000ECR', 'HAF618250000EDD', 'HAF618250000EDH', 'HAF618250000EJK',
                    'HAF618250000EJP', 'HAF618250000ERA', 'HAF618250000ERR', 'HAF618250000ES0', 'HAF618250000ESN',
                    'HAF618250000EYG', 'HAF618250000EZ8', 'HAF618250000F1S', 'HAF618250000F24', 'HAF618250000F2J',
                    'HAF618250000F2T', 'HAF618250000F2W', 'HAF618250000F33', 'HAF618250000F36', 'HAF618250000F38',
                    'HAF618250000F3A', 'HAF618250000F3C', 'HAF618250000F3E', 'HAF618250000F3H', 'HAF618250000F3J',
                    'HAF618250000F3L', 'HAF618250000F3M', 'HAF618250000F3N', 'HAF618250000F3S', 'HAF618250000F3V',
                    'HAF618250000F42', 'HAF618250000F47', 'HAF618250000F4N', 'HAF618250000F5E', 'HAF618250000F5K',
                    'HAF618250000F94', 'HAF618250000FGU', 'HAF618250000FGZ', 'HAF618250000FH2', 'HAF618250000FJ8',
                    'HAF618250000FJH', 'HAF618250000FJL', 'HAF618250000FJS', 'HAF618250000FKL', 'HAF618250000FKS',
                    'HAF618250000FL1', 'HAF618250000FMK', 'HAF618250000FN1', 'HAF618250000FR3', 'HAF618250000FRA',
                    'HAF618250000FRN', 'HAF618250000FRR', 'HAF618250000FS5', 'HAF618250000FSC', 'HAF618250000FSH',
                    'HAF618250000FUK', 'HAF618250000FWG', 'HAF618250000FWL', 'HAF618250000FWV', 'HAF618250000FY1',
                    'HAF618250000FY7', 'HAF618250000FYA', 'HAF618250000FYC', 'HAF618250000FYL', 'HAF618250000FYT',
                    'HAF618250000FZ3', 'HAF618250000FZB', 'HAF618250000FZH', 'HAF618250000FZJ', 'HAF618250000FZL',
                    'HAF618250000G1Y', 'HAF618250000G25', 'HAF618250000GDT', 'HAF618250000GDV', 'HAF618250000GDY',
                    'HAF618250000GE1', 'HAF618250000GE2', 'HAF618250000GE6', 'HAF618250000GT3', 'HAF618250000GTA',
                    'HAF618250000GTE', 'HAF618250000GTF', 'HAF618250000GTJ', 'HAF618250000GTM', 'HAF618250000GTP',
                    'HAF618250000GTT', 'HAF618250000GVH', 'HAF618250000GVL', 'HAF618250000GVN', 'HAF618250000GVS',
                    'HAF618250000GVU', 'HAF618250000GVY', 'HAF618250000GVZ', 'HAF618250000GW1', 'HAF618250000GYZ',
                    'HAF618250000GZ2', 'HAF618250000GZ3', 'HAF618250000GZ6', 'HAF618250000GZH', 'HAF618250000GZN',
                    'HAF618250000GZT', 'HAF618250000H0G', 'HAF618250000H0N', 'HAF618250000H0R', 'HAF618250000H0S',
                    'HAF618250000H0U', 'HAF618250000H0V', 'HAF618250000H0Y', 'HAF618250000H0Z', 'HAF618250000H10',
                    'HAF618250000H12', 'HAF618250000H13', 'HAF618250000H14', 'HAF618250000H17', 'HAF618250000H18',
                    'HAF618250000H1A', 'HAF618250000H1B', 'HAF618250000H1E', 'HAF618250000H2R', 'HAF618250000H2T',
                    'HAF618250000H2V', 'HAF618250000H2W', 'HAF618250000H2Y', 'HAF618250000H30', 'HAF618250000H31',
                    'HAF618250000H32', 'HAF618250000HLG', 'HAF618250000HLJ', 'HAF618250000HLN', 'HAF618250000HLS',
                    'HAF618250000HLV', 'HAF618250000HLY', 'HAF618250000HM1', 'HAF618250000HM4', 'HAF618250000HM5',
                    'HAF618250000HM9', 'HAF618250000HMC', 'HAF618250000HME', 'HAF618250000HMH', 'HAF618250000HML',
                    'HAF618250000HMP', 'HAF618250000HMU', 'HAF618250000HUJ', 'HAF618250000HUM', 'HAF618250000HV8',
                    'HAF618250000HVB', 'HAF618250000HVF', 'HAF618250000HVK', 'HAF618250000HVN', 'HAF618250000HVS',
                    'HAF618250000HYJ', 'HAF618250000J6Y', 'HAF618250000J71', 'HAF618250000J75', 'HAF618250000J78',
                    'HAF618250000J79', 'HAF618250000J7C', 'HAF618250000J7F', 'HAF618250000J8T', 'HAF618250000J97',
                    'HAF618250000J99', 'HAF618250000J9A', 'HAF618250000J9D', 'HAF618250000J9K', 'HAF618250000J9R',
                    'HAF618250000J9V', 'HAF618250000J9Y', 'HAF618250000J9Z', 'HAF618250000JA4', 'HAF618250000JA5',
                    'HAF618250000JA9', 'HAF618250000JAD', 'HAF618250000JAK', 'HAF618250000JAT', 'HAF618250000JAY',
                    'HAF618250000JBH', 'HAF618250000JBL', 'HAF618250000JBR', 'HAF618250000JBV', 'HAF618250000JC0',
                    'HAF618250000JC4', 'HAF618250000JCB', 'HAF618250000JCG', 'HAF618250000JCN', 'HAF618250000JCS',
                    'HAF618250000JD0', 'HAF618250000JD4', 'HAF618250000JDC', 'HAF618250000JDF', 'HAF618250000JDM',
                    'HAF618250000JDT', 'HAF618250000JDW', 'HAF618250000JEG', 'HAF618250000JEV', 'HAF618250000JHK',
                    'HAF618250000JJ7', 'HAF618250000JP1', 'HAF618250000JPT', 'HAF618250000K0B', 'HAF618250000K0F',
                    'HAF618250000K0N', 'HAF618250000K0V', 'HAF618250000K0Z', 'HAF618250000K16', 'HAF618250000K19',
                    'HAF618250000K1H', 'HAF618250000K3N', 'HAF618250000K4K', 'HAF618250000K4S', 'HAF618250000K4W',
                    'HAF618250000K50', 'HAF618250000K7G', 'HAF618250000K7K', 'HAF618250000K7L', 'HAF618250000K7P',
                    'HAF618250000K7R', 'HAF618250000K7U', 'HAF618250000K7V', 'HAF618250000K7Z', 'HAF618250000K81',
                    'HAF618250000K83', 'HAF618250000K85', 'HAF618250000K87', 'HAF618250000K8A', 'HAF618250000K8B',
                    'HAF618250000K8C', 'HAF618250000K8D', 'HAF618250000K8E', 'HAF618250000K8H', 'HAF618250000K8K',
                    'HAF618250000K8P', 'HAF618250000K8V', 'HAF618250000K8Y', 'HAF618250000K90', 'HAF618250000K92',
                    'HAF618250000K94', 'HAF618250000K99', 'HAF618250000K9Y', 'HAF618250000KA2', 'HAF618250000KA6',
                    'HAF618250000KA8', 'HAF618250000KAD', 'HAF618250000KAL', 'HAF618250000KAV', 'HAF618250000KAZ',
                    'HAF618250000KB5', 'HAF618250000KHZ', 'HAF618250000KJ3', 'HAF618250000KJ8', 'HAF618250000KJ9',
                    'HAF618250000KVC', 'HAF618250000KY1', 'HAF618250000L0U', 'HAF618250000L0Y', 'HAF618250000L10',
                    'HAF618250000L12', 'HAF618250000L13', 'HAF618250000L17', 'HAF618250000L1B', 'HAF618250000L1C',
                    'HAF618250000L1G', 'HAF618250000L1H', 'HAF618250000L1M', 'HAF618250000L1N', 'HAF618250000L1R',
                    'HAF618250000L1S', 'HAF618250000L1U', 'HAF618250000L1Y', 'HAF618250000L1Z', 'HAF618250000L20',
                    'HAF618250000L23', 'HAF618250000L24', 'HAF618250000L28', 'HAF618250000L29', 'HAF618250000L2B',
                    'HAF618250000L2J', 'HAF618250000L2Y', 'HAF618250000L37', 'HAF618250000L3D', 'HAF618250000L84',
                    'HAF618250000L8A', 'HAF618250000L94', 'HAF618250000L9J', 'HAF618250000LA1', 'HAF618250000LAD',
                    'HAF618250000LAV', 'HAF618250000LB8', 'HAF618250000LBH', 'HAF618250000LBL', 'HAF618250000LBP',
                    'HAF618250000LBT', 'HAF618250000LBZ', 'HAF618250000LC1', 'HAF618250000LC7', 'HAF618250000LE5',
                    'HAF618250000LWL', 'HAF618250000LWS', 'HAF618250000LY1', 'HAF618250000M2F', 'HAF618250000M45',
                    'HAF618250000M4A', 'HAF618250000M4D', 'HAF618250000M4G', 'HAF618250000M4J', 'HAF618250000M4U',
                    'HAF618250000M4V', 'HAF618250000M4W', 'HAF618250000M6M', 'HAF618250000M6Z', 'HAF618250000M8T',
                    'HAF618250000M91', 'HAF618250000MA1', 'HAF618250000MAG', 'HAF618250000MAJ', 'HAF618250000MAK',
                    'HAF618250000MAL', 'HAF618250000MAN', 'HAF618250000MAP', 'HAF618250000MAV', 'HAF618250000MBF',
                    'HAF618250000MBM', 'HAF618250000MBP', 'HAF618250000MBU', 'HAF618250000MBY', 'HAF618250000MC2',
                    'HAF618250000MC9', 'HAF618250000MEA', 'HAF618250000MEE', 'HAF618250000MER', 'HAF618250000MMU',
                    'HAF618250000MZJ', 'HAF618250000MZU', 'HAF618250000MZV', 'HAF618250000N00', 'HAF618250000N04',
                    'HAF618250000N0A', 'HAF618250000N0E', 'HAF618250000N0J', 'HAF618250000N1U', 'HAF618250000NCF',
                    'HAF618250000NUT', 'HAF618250000P65', 'HAF618250000P6F', 'HAF618250000P6H', 'HAF618250000P6M',
                    'HAF618250000P6S', 'HAF618250000P6U', 'HAF618250000P70', 'HAF618250000P74', 'HAF618250000PHE',
                    'HAF618250000PHL', 'HAF618250000PHR', 'HAF618250000PHW', 'HAF618250000PHZ', 'HAF618250000PJ8',
                    'HAF618250000PJ9', 'HAF618250000PJE', 'HAF618250000PJK', 'HAF618250000PJN', 'HAF618250000PJU',
                    'HAF618250000PK3', 'HAF618250000PK9', 'HAF618250000PKC', 'HAF618250000PL5', 'HAF618250000PW4',
                    'HAF618250000PW8', 'HAF618250000PWD', 'HAF618250000PWF', 'HAF618250000PWL', 'HAF618250000PWU',
                    'HAF618250000PWY', 'HAF618250000PY0', 'HAF618250000PY1', 'HAF618250000PY3', 'HAF618250000PY5',
                    'HAF618250000PY7', 'HAF618250000PY9', 'HAF618250000PYU', 'HAF618250000PYV', 'HAF618250000PYW',
                    'HAF618250000PZ3', 'HAF618250000PZ5', 'HAF618250000PZ8', 'HAF618250000PZA', 'HAF618250000PZC',
                    'HAF618250000PZF', 'HAF618250000PZK', 'HAF618250000R08', 'HAF618250000R0B', 'HAF618250000R0G',
                    'HAF618250000R0K', 'HAF618250000R0M', 'HAF618250000R0Y', 'HAF618250000R4F', 'HAF618250000R4R',
                    'HAF618250000R4V', 'HAF618250000R4Z', 'HAF618250000R53', 'HAF618250000RNT', 'HAF618250000RNY',
                    'HAF618250000RU1', 'HAF618250000RU5', 'HAF618250000RU8', 'HAF618250000RUB', 'HAF618250000RUF',
                    'HAF618250000RUU', 'HAF618250000S4C', 'HAF618250000S4F', 'HAF618250000S4J', 'HAF618250000S4M',
                    'HAF618250000S4S', 'HAF618250000S4V', 'HAF618250000S4Y', 'HAF618250000S53', 'HAF618250000S56',
                    'HAF618250000S59', 'HAF618250000S5C', 'HAF618250000S5F', 'HAF618250000S5J', 'HAF618250000S5R',
                    'HAF618250000S5T', 'HAF618250000S91', 'HAF618250000SEN', 'HAF618250000SEP', 'HAF618250000SF0',
                    'HAF618250000SF2', 'HAF618250000SF5', 'HAF618250000SF7', 'HAF618250000SFB', 'HAF618250000SFD',
                    'HAF618250000SFJ', 'HAF618250000SFP', 'HAF618250000SFV', 'HAF618250000SJ7', 'HAF618250000SJE',
                    'HAF618250000SJL', 'HAF618250000SJR', 'HAF618250000SJV', 'HAF618250000SJY', 'HAF618250000SK3',
                    'HAF618250000SK6', 'HAF618250000SKD', 'HAF618250000SKH', 'HAF618250000SKM', 'HAF618250000SKU',
                    'HAF618250000SP7', 'HAF618250000SR8', 'HAF618250000SRC', 'HAF618250000SRU', 'HAF618250000SRZ',
                    'HAF618250000SSA', 'HAF618250000ST0', 'HAF618250000ST4', 'HAF618250000STT', 'HAF618250000SW6',
                    'HAF618250000T06', 'HAF618250000T6J', 'HAF6182600000D1', 'HAF6182600000TE', 'HAF6182600001MU',
                    'HAF6182600001MY', 'HAF6182600001MZ', 'HAF6182600001N1', 'HAF6182600001N2', 'HAF6182600001NT',
                    'HAF6182600001NV', 'HAF6182600001RP', 'HAF6182600001RV', 'HAF6182600001RZ', 'HAF6182600001S5',
                    'HAF6182600001SD', 'HAF6182600001SL', 'HAF6182600001SP', 'HAF6182600001T3', 'HAF6182600001WS',
                    'HAF6182600001WW', 'HAF6182600001Y1', 'HAF6182600001Y4', 'HAF6182600001YH', 'HAF6182600001Z0',
                    'HAF6182600001ZL', 'HAF6182600001ZS', 'HAF6182600001ZU', 'HAF6182600001ZW', 'HAF6182600001ZZ',
                    'HAF618260000201', 'HAF618260000205', 'HAF618260000206', 'HAF618260000208', 'HAF618260000209',
                    'HAF61826000020D', 'HAF61826000020E', 'HAF61826000020F', 'HAF61826000020G', 'HAF61826000020M',
                    'HAF61826000020P', 'HAF618260000211', 'HAF618260000214', 'HAF618260000215', 'HAF618260000219',
                    'HAF61826000021C', 'HAF61826000021G', 'HAF61826000021L', 'HAF618260000220', 'HAF618260000226',
                    'HAF61826000022A', 'HAF61826000022D', 'HAF61826000022F', 'HAF61826000022H', 'HAF61826000022M',
                    'HAF61826000022P', 'HAF61826000025M', 'HAF61826000025S', 'HAF618260000269', 'HAF61826000027H',
                    'HAF61826000027N', 'HAF61826000027T', 'HAF618260000282', 'HAF618260000285', 'HAF618260000287',
                    'HAF61826000028C', 'HAF61826000029M', 'HAF61826000029P', 'HAF61826000029V', 'HAF61826000029Z',
                    'HAF6182600002A2', 'HAF6182600002A6', 'HAF6182600002A9', 'HAF6182600002B4', 'HAF6182600002BA',
                    'HAF6182600002BD', 'HAF6182600002EP', 'HAF6182600002F0', 'HAF6182600002F8', 'HAF6182600002FB',
                    'HAF6182600002FE', 'HAF6182600002FJ', 'HAF6182600002GJ', 'HAF618260000307', 'HAF618260000338',
                    'HAF61826000033F', 'HAF61826000033H', 'HAF61826000033K', 'HAF61826000033M', 'HAF61826000033V',
                    'HAF61826000033Y', 'HAF618260000344', 'HAF618260000346', 'HAF61826000034G', 'HAF61826000034K',
                    'HAF61826000035M', 'HAF618260000366', 'HAF618260000367', 'HAF61826000036A', 'HAF61826000037B',
                    'HAF61826000037F', 'HAF61826000037G', 'HAF61826000037M', 'HAF61826000037N', 'HAF61826000037P',
                    'HAF61826000037W', 'HAF618260000381', 'HAF61826000038F', 'HAF61826000038R', 'HAF61826000038T',
                    'HAF61826000038U', 'HAF61826000038Y', 'HAF61826000038Z', 'HAF618260000394', 'HAF61826000039B',
                    'HAF61826000039F', 'HAF61826000039G', 'HAF61826000039K', 'HAF61826000039P', 'HAF61826000039V',
                    'HAF61826000039W', 'HAF61826000039Z', 'HAF6182600003A2', 'HAF6182600003A8', 'HAF6182600003AD',
                    'HAF6182600003AH', 'HAF6182600003AL', 'HAF6182600003AN', 'HAF6182600003AS', 'HAF6182600003BC',
                    'HAF6182600003BJ', 'HAF6182600003BY', 'HAF6182600003C9', 'HAF6182600003CL', 'HAF6182600003CM',
                    'HAF6182600003CV', 'HAF6182600003CZ', 'HAF6182600003D3', 'HAF6182600003DA', 'HAF6182600003DB',
                    'HAF6182600003DF', 'HAF6182600003DG', 'HAF6182600003DJ', 'HAF6182600003DL', 'HAF6182600003DT',
                    'HAF6182600003DY', 'HAF6182600003E0', 'HAF6182600003E4', 'HAF6182600003E9', 'HAF6182600003EB',
                    'HAF6182600003EH', 'HAF6182600003EN', 'HAF6182600003EP', 'HAF6182600003ES', 'HAF6182600003EU',
                    'HAF6182600003EZ', 'HAF6182600003FF', 'HAF6182600003H0', 'HAF6182600003H4', 'HAF6182600003HB',
                    'HAF6182600003HC', 'HAF6182600003KK', 'HAF6182600003KW', 'HAF6182600003M0', 'HAF6182600003MD',
                    'HAF6182600003MK', 'HAF6182600003MR', 'HAF6182600003MU', 'HAF6182600003N3', 'HAF6182600003NA',
                    'HAF6182600003NY', 'HAF6182600003PN', 'HAF6182600003RZ', 'HAF6182600003SE', 'HAF6182600003SW',
                    'HAF6182600003SZ', 'HAF6182600003T3', 'HAF6182600003T8', 'HAF6182600003T9', 'HAF6182600003TA',
                    'HAF6182600003TD', 'HAF6182600003TH', 'HAF6182600003TR', 'HAF6182600003TS', 'HAF6182600003TV',
                    'HAF6182600003U2', 'HAF6182600003U6', 'HAF6182600003UA', 'HAF6182600003UD', 'HAF6182600003UG',
                    'HAF6182600003UH', 'HAF6182600003UP', 'HAF6182600003UT', 'HAF6182600003UU', 'HAF6182600003V1',
                    'HAF6182600003V7', 'HAF6182600003VC', 'HAF6182600003W0', 'HAF6182600003WP', 'HAF6182600003ZL',
                    'HAF6182600003ZZ', 'HAF618260000402', 'HAF618260000406', 'HAF618260000407', 'HAF618260000408',
                    'HAF61826000040A', 'HAF61826000040E', 'HAF61826000040F', 'HAF61826000040H', 'HAF61826000040J',
                    'HAF61826000040M', 'HAF61826000040S', 'HAF61826000040V', 'HAF618260000421', 'HAF618260000424',
                    'HAF61826000042C', 'HAF618260000431', 'HAF618260000435', 'HAF61826000043D', 'HAF61826000043T',
                    'HAF61826000043Y', 'HAF618260000443', 'HAF61826000044E', 'HAF618260000457', 'HAF618260000458',
                    'HAF61826000045F', 'HAF61826000045R', 'HAF61826000045V', 'HAF61826000047N', 'HAF61826000047S',
                    'HAF61826000047Y', 'HAF618260000486', 'HAF61826000048S', 'HAF618260000498', 'HAF6182600004CC',
                    'HAF6182600004CW', 'HAF6182600004D2', 'HAF6182600004DD', 'HAF6182600004DG', 'HAF6182600004DJ',
                    'HAF6182600004DW', 'HAF6182600004E0', 'HAF6182600004EE', 'HAF6182600004ER', 'HAF6182600004EU',
                    'HAF6182600004HP', 'HAF6182600004HS', 'HAF6182600004JB', 'HAF6182600004JH', 'HAF6182600004JK',
                    'HAF6182600004RM', 'HAF6182600004U9', 'HAF6182600004UB', 'HAF6182600004UD', 'HAF6182600004UG',
                    'HAF6182600004UM', 'HAF6182600004UN', 'HAF6182600004V3', 'HAF6182600004WF', 'HAF61826000052Y',
                    'HAF618260000531', 'HAF61826000053B', 'HAF61826000053M', 'HAF61826000053S', 'HAF61826000053V',
                    'HAF61826000054Z', 'HAF618260000559', 'HAF61826000055R', 'HAF61826000055U', 'HAF61826000055Z',
                    'HAF618260000564', 'HAF618260000566', 'HAF618260000569', 'HAF61826000056D', 'HAF61826000057M',
                    'HAF61826000057T', 'HAF618260000580', 'HAF6182600005GH', 'HAF6182600005GJ', 'HAF6182600005GM',
                    'HAF6182600005GS', 'HAF6182600005GT', 'HAF6182600005GY', 'HAF6182600005JZ', 'HAF6182600005K3',
                    'HAF6182600005K5', 'HAF6182600005K8', 'HAF6182600005KB', 'HAF6182600005KD', 'HAF6182600005KL',
                    'HAF6182600005TL', 'HAF6182600005TR', 'HAF6182600005TS', 'HAF6182600005TU', 'HAF6182600005TV',
                    'HAF6182600005UR', 'HAF6182600005US', 'HAF6182600005UU', 'HAF6182600005V0', 'HAF6182600005V1',
                    'HAF6182600005V3', 'HAF6182600005V6', 'HAF6182600005YE', 'HAF6182600005YN', 'HAF6182600005YU',
                    'HAF6182600005YZ', 'HAF6182600005Z1', 'HAF6182600005Z6', 'HAF6182600005Z8', 'HAF6182600006GT',
                    'HAF6182600006GW', 'HAF6182600006H1', 'HAF6182600006H3', 'HAF6182600006H6', 'HAF6182600006H8',
                    'HAF6182600006HA', 'HAF6182600006HC', 'HAF61826000074B', 'HAF61826000074H', 'HAF6182600007AA',
                    'HAF6182600007AE', 'HAF6182600007AJ', 'HAF6182600007AR', 'HAF6182600007AU', 'HAF6182600007AY',
                    'HAF6182600007B1', 'HAF6182600007BM', 'HAF6182600007C5', 'HAF6182600007CC', 'HAF6182600007CP',
                    'HAF6182600007CT', 'HAF6182600007CW', 'HAF6182600007FY', 'HAF6182600007HP', 'HAF6182600007HT',
                    'HAF6182600007HW', 'HAF6182600007JE', 'HAF6182600007JM', 'HAF6182600007KF', 'HAF6182600007KN',
                    'HAF6182600007VP', 'HAF6182600007W2', 'HAF6182600007W8', 'HAF6182600007WB', 'HAF61826000080U',
                    'HAF61826000080Z', 'HAF618260000812', 'HAF618260000814', 'HAF61826000081A', 'HAF61826000081N',
                    'HAF61826000081R', 'HAF61826000081U', 'HAF61826000082G', 'HAF61826000082M', 'HAF61826000082R',
                    'HAF61826000082S', 'HAF61826000082V', 'HAF61826000082W', 'HAF61826000082Z', 'HAF618260000833',
                    'HAF6182600008AD', 'HAF6182600008AH', 'HAF6182600008AN', 'HAF6182600008BN', 'HAF6182600008BR',
                    'HAF6182600008CT', 'HAF6182600008DF', 'HAF6182600008DN', 'HAF6182600008E3', 'HAF6182600008E6',
                    'HAF6182600008E8', 'HAF6182600008EA', 'HAF6182600008EG', 'HAF6182600008EK', 'HAF6182600008EL',
                    'HAF6182600008EU', 'HAF6182600008EZ', 'HAF6182600008F3', 'HAF6182600008FE', 'HAF6182600008FH',
                    'HAF6182600008FV', 'HAF6182600008G2', 'HAF6182600008G5', 'HAF6182600008G9', 'HAF6182600008GB',
                    'HAF6182600008GE', 'HAF6182600008GH', 'HAF6182600008GM', 'HAF6182600008GR', 'HAF6182600008H3',
                    'HAF6182600008HN', 'HAF6182600008HR', 'HAF6182600008HU', 'HAF6182600008HY', 'HAF6182600008J4',
                    'HAF6182600008J5', 'HAF6182600008JC', 'HAF6182600008JE', 'HAF6182600008JG', 'HAF6182600008JN',
                    'HAF6182600008JV', 'HAF6182600008K0', 'HAF6182600008K3', 'HAF6182600008LT', 'HAF6182600008M9',
                    'HAF6182600008MV', 'HAF6182600008MZ', 'HAF6182600008N1', 'HAF6182600008N4', 'HAF6182600008NF',
                    'HAF6182600008NR', 'HAF6182600008NV', 'HAF6182600008P0', 'HAF6182600008P5', 'HAF6182600008PA',
                    'HAF6182600008PF', 'HAF6182600008S2', 'HAF6182600008S5', 'HAF6182600008S9', 'HAF6182600008SH',
                    'HAF6182600008SN', 'HAF6182600008SY', 'HAF61826000091P', 'HAF61826000091V', 'HAF61826000092C',
                    'HAF61826000092S', 'HAF6182600009PY', 'HAF6182600009V4', 'HAF6182600009V6', 'HAF6182600009VE',
                    'HAF6182600009W7', 'HAF618260000A07', 'HAF618260000A0G', 'HAF618260000A1G', 'HAF618260000A2S',
                    'HAF618260000A2T', 'HAF618260000A2Y', 'HAF618260000A39', 'HAF618260000A3C', 'HAF618260000A3H',
                    'HAF618260000A3J', 'HAF618260000A3L', 'HAF618260000A3T', 'HAF618260000A41', 'HAF618260000A48',
                    'HAF618260000A8H', 'HAF618260000A8L', 'HAF618260000A8P', 'HAF618260000A8V', 'HAF618260000AFJ',
                    'HAF618260000AM2', 'HAF618260000AN9', 'HAF618260000ANE', 'HAF618260000B9P', 'HAF618260000BGL',
                    'HAF618260000BH6', 'HAF618260000BLN', 'HAF618260000BLY', 'HAF618260000BM4', 'HAF618260000C4F',
                    'HAF618260000C4L', 'HAF618260000C4P', 'HAF618260000C4T', 'HAF618260000C4V', 'HAF618260000EDH',
                    'HAF618260000EDR', 'HAF618260000EHP', 'HAF618260000EHR', 'HAF618260000EHT', 'HAF618260000EHU',
                    'HAF618260000EHZ', 'HAF618260000EJ2', 'HAF618260000EPH', 'HAF618260000EPL', 'HAF618260000EPM',
                    'HAF618260000EPP', 'HAF618260000F1D', 'HAF618260000F1F', 'HAF618260000F1H', 'HAF618260000F1L',
                    'HAF618260000F2A', 'HAF618260000F2B', 'HAF618260000FKP', 'HAF618260000FKS', 'HAF618260000FKU',
                    'HAF618260000FKV', 'HAF618260000FVW', 'HAF618260000FW0', 'HAF618260000FW4', 'HAF618260000FW7',
                    'HAF618260000FWD', 'HAF618260000FWH', 'HAF618260000G3U', 'HAF618260000G51', 'HAF618260000G56',
                    'HAF618260000G5C', 'HAF618260000GDK', 'HAF618260000GDT', 'HAF618260000GDW', 'HAF618260000GE3',
                    'HAF618260000GE8', 'HAF618260000GH1', 'HAF618260000GH6', 'HAF618260000GHE', 'HAF618260000GHF',
                    'HAF618260000GHJ', 'HAF618260000GHM', 'HAF618260000GN5', 'HAF618260000GZG', 'HAF618260000GZP',
                    'HAF618260000H5W', 'HAF618260000H5Y', 'HAF618260000H60', 'HAF618260000H61', 'HAF618260000H65',
                    'HAF618260000H69', 'HAF618260000H9V', 'HAF618260000HAD', 'HAF618260000HAJ', 'HAF618260000HAL',
                    'HAF618260000HDR', 'HAF618260000HEV', 'HAF618260000HF1', 'HAF618260000HF3', 'HAF618260000HG4',
                    'HAF618260000HGK', 'HAF618260000JBZ', 'HAF618260000JC2', 'HAF618260000JHD', 'HAF618260000JHF',
                    'HAF618260000JLT', 'HAF618260000JM0', 'HAF618260000JM4', 'HAF618260000JM7', 'HAF618260000JMB',
                    'HAF618260000JMG', 'HAF618260000JMK', 'HAF618260000JMN', 'HAF618260000K4F', 'HAF618260000K4G',
                    'HAF618260000K4H', 'HAF618260000K4J', 'HAF618260000K4K', 'HAF618260000K4L', 'HAF618260000K4M',
                    'HAF618260000K4N', 'HAF618260000KBD', 'HAF618260000KBG', 'HAF618260000KBL', 'HAF618260000KBR',
                    'HAF618260000KBU', 'HAF618260000KBZ', 'HAF618260000KC3', 'HAF618260000KC9', 'HAF618260000KGZ',
                    'HAF618260000KH2', 'HAF618260000KH7', 'HAF618260000KHB', 'HAF618260000KHG', 'HAF618260000KHL',
                    'HAF618260000KHS', 'HAF618260000KHU', 'HAF618260000KJ4', 'HAF618260000KJC', 'HAF618260000KJJ',
                    'HAF618260000KK9', 'HAF618260000KKH', 'HAF618260000KKS', 'HAF618260000KKY', 'HAF618260000KL1',
                    'HAF618260000KS1', 'HAF618260000KS9', 'HAF618260000KSC', 'HAF618260000KSJ', 'HAF618260000KSM',
                    'HAF618260000KST', 'HAF618260000KSY', 'HAF618260000KSZ', 'HAF618260000KT3', 'HAF618260000KT6',
                    'HAF618260000KU2', 'HAF618260000KU8', 'HAF618260000KUB', 'HAF618260000KUG', 'HAF618260000KUT',
                    'HAF618260000L0B', 'HAF618260000L0R', 'HAF618260000L0Z', 'HAF618260000L13', 'HAF618260000L18',
                    'HAF618260000L1B', 'HAF618260000L1E', 'HAF618260000L2F', 'HAF618260000LAJ', 'HAF618260000LD1',
                    'HAF618260000LDP', 'HAF618260000LDU', 'HAF618260000LE1', 'HAF618260000LE3', 'HAF618260000LE9',
                    'HAF618260000LEB', 'HAF618260000LEF', 'HAF618260000LEJ', 'HAF618260000LES', 'HAF618260000LEV',
                    'HAF618260000LF0', 'HAF618260000LF4', 'HAF618260000LF6', 'HAF618260000LF7', 'HAF618260000LFC',
                    'HAF618260000LFG', 'HAF618260000LFJ', 'HAF618260000LFM', 'HAF618260000LFR', 'HAF618260000LFS',
                    'HAF618260000LFV', 'HAF618260000LFZ', 'HAF618260000LG1', 'HAF618260000LGY', 'HAF618260000LH5',
                    'HAF618260000LHG', 'HAF618260000LHN', 'HAF618260000LHZ', 'HAF618260000LJ7', 'HAF618260000LJE',
                    'HAF618260000LJJ', 'HAF618260000LJP', 'HAF618260000LJV', 'HAF618260000LK2', 'HAF618260000LK3',
                    'HAF618260000LK5', 'HAF618260000LKA', 'HAF618260000LKF', 'HAF618260000LR1', 'HAF618260000LR6',
                    'HAF618260000LRA', 'HAF618260000LRE', 'HAF618260000LRK', 'HAF618260000LRP', 'HAF618260000LRV',
                    'HAF618260000LRY', 'HAF618260000LS2', 'HAF618260000LS6', 'HAF618260000LS8', 'HAF618260000LSE',
                    'HAF618260000LSJ', 'HAF618260000LSW', 'HAF618260000LSZ', 'HAF618260000LT5', 'HAF618260000LT9',
                    'HAF618260000LTG', 'HAF618260000LTK', 'HAF618260000LTP', 'HAF618260000LTU', 'HAF618260000LTW',
                    'HAF618260000LU1', 'HAF618260000LU5', 'HAF618260000N5G', 'HAF618260000N5K', 'HAF618260000N5N',
                    'HAF618260000N5P', 'HAF618260000N5S', 'HAF618260000N5V', 'HAF618260000N63', 'HAF618260000N66',
                    'HAF618260000NTP', 'HAF618260000NTU', 'HAF618260000NU2', 'HAF618260000NU8', 'HAF618260000NUP',
                    'HAF618260000NUT', 'HAF618260000NV0', 'HAF618260000NV9', 'HAF618260000NZ5', 'HAF618260000NZF',
                    'HAF618260000NZJ', 'HAF618260000NZM', 'HAF618260000NZN', 'HAF618260000NZT', 'HAF618260000NZU',
                    'HAF618260000NZY', 'HAF618260000RE0', 'HAF618260000REZ', 'HAF618260000RF3', 'HAF618260000RF6',
                    'HAF618260000RF8', 'HAF618260000RFA', 'HAF618260000RFC', 'HAF618260000RFE', 'HAF618260000RH9',
                    'HAF618260000RRY', 'HAF618260000RU9', 'HAF618260000RUE', 'HAF618260000S0F', 'HAF618260000S1J',
                    'HAF618260000S1V', 'HAF618260000S1Z', 'HAF618260000S21', 'HAF618260000S23', 'HAF618260000S5F',
                    'HAF618260000S76', 'HAF618260000S79', 'HAF618260000S7D', 'HAF618260000S7H', 'HAF618260000S7M',
                    'HAF618260000S7T', 'HAF618260000S7W', 'HAF618260000S82', 'HAF618260000SEC', 'HAF618260000SEJ',
                    'HAF618260000SEP', 'HAF618260000SEU', 'HAF618260000SEW', 'HAF618260000SF1', 'HAF618260000SF5',
                    'HAF618260000SF8', 'HAF618260000SF9', 'HAF618260000SFC', 'HAF618260000SFF', 'HAF618260000SFK',
                    'HAF618260000SFP', 'HAF618260000SFU', 'HAF618260000SFY', 'HAF618260000SG2', 'HAF618260000SNZ',
                    'HAF618260000SP0', 'HAF618260000SP6', 'HAF618260000SP9', 'HAF618260000SPD', 'HAF618260000SPP',
                    'HAF618260000SS6', 'HAF618260000SSE', 'HAF618260000SSR', 'HAF618260000STB', 'HAF618260000STP',
                    'HAF618260000SU9', 'HAF618260000SUR', 'HAF618260000SUW', 'HAF618260000T1Z', 'HAF618260000T27',
                    'HAF618260000T2A', 'HAF618260000T2G', 'HAF618260000T2U', 'HAF618260000T2Z', 'HAF618260000T33',
                    'HAF618260000T3E', 'HAF618260000T50', 'HAF618260000T56', 'HAF618260000T5F', 'HAF618260000T5S',
                    'HAF618260000T5U', 'HAF618260000T5W', 'HAF618260000T5Y', 'HAF618260000T6E', 'HAF618260000TBA',
                    'HAF618260000TC8', 'HAF618260000TCM', 'HAF618260000TCW', 'HAF618260000TD0', 'HAF618260000TD1',
                    'HAF618260000TD4', 'HAF618260000UAL', 'HAF618260000UDR', 'HAF618260000V19', 'HAF618260000V1B',
                    'HAF618260000VB4', 'HAF618260000VLY', 'HAF618260000VLZ', 'HAF618260000VM0', 'HAF618260000VM2',
                    'HAF618260000VM3', 'HAF618260000VM4', 'HAF618260000VM5', 'HAF618260000VM8', 'HAF618260000VMM',
                    'HAF618260000VMN', 'HAF618260000VN2', 'HAF618260000VN3', 'HAF618260000VNA', 'HAF618260000VPL',
                    'HAF618260000VPR', 'HAF618260000VR4', 'HAF618260000VR5', 'HAF618260000VRY', 'HAF618260000VS3',
                    'HAF618260000VS5', 'HAF618260000VS7', 'HAF618260000VS9', 'HAF618260000VSL', 'HAF618260000VSN',
                    'HAF618260000VSP', 'HAF618260000VSR', 'HAF618260000VST', 'HAF618260000VSU', 'HAF618260000VSV',
                    'HAF618260000VSW', 'HAF618260000VT9', 'HAF618260000VTH', 'HAF618260000VTM', 'HAF618260000VTR',
                    'HAF618260000VTU', 'HAF618260000VVH', 'HAF618260000VVK', 'HAF618260000VVN', 'HAF618260000VWF',
                    'HAF618260000VWH', 'HAF618260000VWL', 'HAF618260000VWN', 'HAF618260000VWS', 'HAF618260000VWU',
                    'HAF618260000VWW', 'HAF618260000VWZ', 'HAF618260000VZW', 'HAF618260000VZY', 'HAF618260000VZZ',
                    'HAF618260000W00', 'HAF618260000W01', 'HAF618260000W02', 'HAF618260000W03', 'HAF618260000W04',
                    'HAF618260000W10', 'HAF618260000W14', 'HAF618260000W15', 'HAF618260000W28', 'HAF618260000W2F',
                    'HAF618260000W2M', 'HAF618260000W2W', 'HAF618260000W2Z', 'HAF618260000W31', 'HAF618260000W4P',
                    'HAF618260000W4W', 'HAF618260000W57', 'HAF618260000W5A', 'HAF618260000W5D', 'HAF618260000W5V',
                    'HAF618260000W5Y', 'HAF618260000W5Z', 'HAF618260000W63', 'HAF618260000W65', 'HAF618260000W66',
                    'HAF618260000W68', 'HAF618260000W6D', 'HAF618260000W6F', 'HAF618260000W6H', 'HAF618260000W79',
                    'HAF618260000W7L', 'HAF618260000W7T', 'HAF618260000W7V', 'HAF618260000W7W', 'HAF618260000W81',
                    'HAF618260000W84', 'HAF618260000W89', 'HAF618260000W8D', 'HAF618260000WA6', 'HAF618260000WAA',
                    'HAF618260000WAK', 'HAF618260000WAT', 'HAF618260000WCU', 'HAF618260000WDD', 'HAF618260000WDH',
                    'HAF618260000WDL', 'HAF618260000WDM', 'HAF618260000WDP', 'HAF618260000WDZ', 'HAF618260000WE3',
                    'HAF618260000WEB', 'HAF618260000WEP', 'HAF618260000WF0', 'HAF618260000WF3', 'HAF618260000WF8',
                    'HAF618260000WFA', 'HAF618260000WFB', 'HAF618260000WFD', 'HAF618260000WFJ', 'HAF618260000WFK',
                    'HAF618260000WFM', 'HAF618260000WFS', 'HAF618260000WFZ', 'HAF618260000WHE', 'HAF618260000WHW',
                    'HAF618260000WJ0', 'HAF618260000WJ9', 'HAF618260000WKE', 'HAF618260000WKH', 'HAF618260000WKT',
                    'HAF618260000WKU', 'HAF618260000WL1', 'HAF618260000WL3', 'HAF618260000WL4', 'HAF618260000WL8',
                    'HAF618260000WLF', 'HAF618260000WMK', 'HAF618260000WMM', 'HAF618260000WMS', 'HAF618260000WNW',
                    'HAF618260000WPE', 'HAF618260000WPJ', 'HAF618260000WPW', 'HAF618260000WR1', 'HAF618260000WR3',
                    'HAF618260000WR6', 'HAF618260000WR9', 'HAF618260000WRC', 'HAF618260000WSP', 'HAF618260000WSR',
                    'HAF618260000WSU', 'HAF618260000WSZ', 'HAF618260000WT0', 'HAF618260000WT1', 'HAF618260000WT7',
                    'HAF618260000WTC', 'HAF618260000WTF', 'HAF618260000WTH', 'HAF618260000WTV', 'HAF618260000WU3',
                    'HAF618260000WUA', 'HAF618260000WW3', 'HAF618260000WW6', 'HAF618260000WW9', 'HAF618260000WWL',
                    'HAF618260000WWS', 'HAF618260000WWY', 'HAF618260000WY0', 'HAF618260000WY2', 'HAF618260000WY8',
                    'HAF618260000WYA', 'HAF618260000WYG', 'HAF618260000WYR', 'HAF618260000WYZ', 'HAF618260000WZ4',
                    'HAF618260000WZB', 'HAF618260000WZR', 'HAF618260000Y02', 'HAF618260000Y0H', 'HAF618260000Y0L',
                    'HAF618260000Y0R', 'HAF618260000Y0S', 'HAF618260000Y10', 'HAF618260000Y12', 'HAF618260000Y18',
                    'HAF618260000Y1A', 'HAF618260000Y1C', 'HAF618260000Y1D', 'HAF618260000Y1J', 'HAF618260000Y1N',
                    'HAF618260000Y1R', 'HAF618260000Y1W', 'HAF618260000Y2W', 'HAF618260000Y34', 'HAF618260000Y38',
                    'HAF618260000Y3A', 'HAF618260000Y3D', 'HAF618260000Y3E', 'HAF618260000Y3G', 'HAF618260000Y3H',
                    'HAF618260000Y3J', 'HAF618260000Y3R', 'HAF618260000Y3W', 'HAF618260000Y45', 'HAF618260000Y5R',
                    'HAF618260000Y5T', 'HAF618260000Y5Z', 'HAF618260000Y66', 'HAF618260000Y6B', 'HAF618260000Y6C',
                    'HAF618260000Y6E', 'HAF618260000Y6K', 'HAF618260000Y6L', 'HAF618260000Y6N', 'HAF618260000Y6W',
                    'HAF618260000Y70', 'HAF618260000Y73', 'HAF618260000Y76', 'HAF618260000Y78', 'HAF618260000Y7C',
                    'HAF618260000Y7K', 'HAF618260000Y7P', 'HAF618260000Y7R', 'HAF618260000Y7S', 'HAF618260000Y7T',
                    'HAF618260000Y7V', 'HAF618260000Y7Z', 'HAF618260000Y80', 'HAF618260000Y83', 'HAF618260000Y86',
                    'HAF618260000Y88', 'HAF618260000Y8B', 'HAF618260000Y8D', 'HAF618260000Y8F', 'HAF618260000Y8H',
                    'HAF618260000Y8M', 'HAF618260000Y8N', 'HAF618260000Y8R', 'HAF618260000Y8S', 'HAF618260000Y8T',
                    'HAF618260000Y90', 'HAF618260000Y9A', 'HAF618260000Y9B', 'HAF618260000Y9F', 'HAF618260000Y9M',
                    'HAF618260000Y9P', 'HAF618260000Y9R', 'HAF618260000Y9T', 'HAF618260000Y9W', 'HAF618260000Y9Z',
                    'HAF618260000YA1', 'HAF618260000YA9', 'HAF618260000YAC', 'HAF618260000YAF', 'HAF618260000YAJ',
                    'HAF618260000YAK', 'HAF618260000YAN', 'HAF618260000YAT', 'HAF618260000YAV', 'HAF618260000YAW',
                    'HAF618260000YB0', 'HAF618260000YBK', 'HAF618260000YBM', 'HAF618260000YBN', 'HAF618260000YBP',
                    'HAF618260000YBR', 'HAF618260000YBT', 'HAF618260000YBU', 'HAF618260000YBV', 'HAF618260000YBW',
                    'HAF618260000YBY', 'HAF618260000YBZ', 'HAF618260000YC2', 'HAF618260000YC4', 'HAF618260000YC5',
                    'HAF618260000YC6', 'HAF618260000YC7', 'HAF618260000YCA', 'HAF618260000YCB', 'HAF618260000YCE',
                    'HAF618260000YCJ', 'HAF618260000YCM', 'HAF618260000YCP', 'HAF618260000YD2', 'HAF618260000YD4',
                    'HAF618260000YD6', 'HAF618260000YD8', 'HAF618260000YDA', 'HAF618260000YDB', 'HAF618260000YDD',
                    'HAF618260000YDE', 'HAF618260000YDF', 'HAF618260000YDK', 'HAF618260000YDP', 'HAF618260000YDT',
                    'HAF618260000YDU', 'HAF618260000YDV', 'HAF618260000YDW', 'HAF618260000YDZ', 'HAF618260000YE0',
                    'HAF618260000YE3', 'HAF618260000YE6', 'HAF618260000YE7', 'HAF618260000YE9', 'HAF618260000YEA',
                    'HAF618260000YEB', 'HAF618260000YEC', 'HAF618260000YEG', 'HAF618260000YEM', 'HAF618260000YEV',
                    'HAF618260000YF0', 'HAF618260000YF3', 'HAF618260000YF4', 'HAF618260000YF7', 'HAF618260000YFB',
                    'HAF618260000YFS', 'HAF618260000YFV', 'HAF618260000YFY', 'HAF618260000YG1', 'HAF618260000YG2',
                    'HAF618260000YG5', 'HAF618260000YG8', 'HAF618260000YGA', 'HAF618260000YGC', 'HAF618260000YGE',
                    'HAF618260000YGG', 'HAF618260000YGM', 'HAF618260000YGR', 'HAF618260000YGS', 'HAF618260000YHW',
                    'HAF618260000YJ1', 'HAF618260000YJ3', 'HAF618260000YJ6', 'HAF618260000YJ8', 'HAF618260000YJD',
                    'HAF618260000YJF', 'HAF618260000YJG', 'HAF618260000YK7', 'HAF618260000YK9', 'HAF618260000YKN',
                    'HAF618260000YKS', 'HAF618260000YKV', 'HAF618260000YP3', 'HAF618260000YP8', 'HAF618260000YPB',
                    'HAF618260000YPG', 'HAF618260000YPJ', 'HAF618260000YPK', 'HAF618260000YPM', 'HAF618260000YPT',
                    'HAF618260000YPV', 'HAF618260000YR2', 'HAF618260000YR5', 'HAF618260000YR9', 'HAF618260000YRD',
                    'HAF618260000YRE', 'HAF618260000YRH', 'HAF618260000YRJ', 'HAF618260000YRR', 'HAF618260000YRT',
                    'HAF618260000YRU', 'HAF618260000YRW', 'HAF618260000YS4', 'HAF618260000YS6', 'HAF618260000YSR',
                    'HAF618260000YSW', 'HAF618260000YT0', 'HAF618260000YT9', 'HAF618260000YTE', 'HAF618260000YTF',
                    'HAF618260000YTG', 'HAF618260000YTH', 'HAF618260000YTK', 'HAF618260000YTN', 'HAF618260000YTV',
                    'HAF618260000YW0', 'HAF618260000YW9', 'HAF618260000YYL', 'HAF618260000YZR', 'HAF618260000YZZ',
                    'HAF618260000Z07', 'HAF618260000Z0G', 'HAF618260000Z0L', 'HAF618260000Z0N', 'HAF618260000Z0W',
                    'HAF618260000Z10', 'HAF618260000Z13', 'HAF618260000Z18', 'HAF618260000Z1F', 'HAF618260000Z1J',
                    'HAF618260000Z1M', 'HAF618260000Z1V', 'HAF618260000Z1W', 'HAF618260000Z1Y', 'HAF618260000Z2S',
                    'HAF618260000Z2V', 'HAF618260000Z2Z', 'HAF618260000Z34', 'HAF618260000Z37', 'HAF618260000Z39',
                    'HAF618260000Z3A', 'HAF618260000Z3C', 'HAF618260000Z4U', 'HAF618260000Z4W', 'HAF618260000Z4Z',
                    'HAF618260000Z52', 'HAF618260000Z5S', 'HAF618260000Z5W', 'HAF618260000Z60', 'HAF618260000Z63',
                    'HAF618260000Z6K', 'HAF618260000Z6Z', 'HAF618260000Z71', 'HAF618260000Z72', 'HAF618260000Z73',
                    'HAF618260000Z74', 'HAF618260000Z75', 'HAF618260000Z7J', 'HAF618260000Z7L', 'HAF618260000Z7S',
                    'HAF618260000Z83', 'HAF618260000ZDP', 'HAF618260000ZHC', 'HAF618260000ZJD', 'HAF618260000ZJF',
                    'HAF618260000ZJK', 'HAF618260000ZJL', 'HAF618260000ZJR', 'HAF618260000ZK5', 'HAF618260000ZR8',
                    'HAF618260000ZRA', 'HAF618260000ZRD', 'HAF618260000ZRJ', 'HAF618260000ZRM', 'HAF618260000ZRS',
                    'HAF618260000ZSP', 'HAF618260000ZTA', 'HAF618260000ZTE', 'HAF618260000ZTU', 'HAF618260000ZU3',
                    'HAF618260000ZU7', 'HAF618260000ZZ4', 'HAF618260000ZZC', 'HAF61826000100Y', 'HAF618260001015',
                    'HAF61826000104H', 'HAF61826000104M', 'HAF61826000104T', 'HAF61826000104Z', 'HAF618260001056',
                    'HAF61826000105G', 'HAF618260001092', 'HAF618260001095', 'HAF618260001098', 'HAF61826000109P',
                    'HAF6182600010A0', 'HAF6182600010A2', 'HAF6182600010A6', 'HAF6182600010AB', 'HAF6182600010AD',
                    'HAF6182600010AE', 'HAF6182600010BD', 'HAF6182600010BY', 'HAF6182600010C9', 'HAF6182600010CJ',
                    'HAF6182600010E2', 'HAF6182600010E7', 'HAF6182600010EH', 'HAF6182600010EN', 'HAF6182600010FM',
                    'HAF6182600010GD', 'HAF6182600010GH', 'HAF6182600010GM', 'HAF6182600010PE', 'HAF618280000VRK',
                    'HAF618280000WG9', 'HAF618280000WGD', 'HAF618280000WGK', 'HAF618280000WGS', 'HAF618280000WGZ',
                    'HAF618280000WH5', 'HAF618280000WHB', 'HAF618280000WLV', 'HAF618280000YMF', 'HAF618280000YWS',
                    'HAF618280000Z2A', 'HAF618280000Z48', 'HAF618280000Z6C', 'HAF618280000Z6G', 'HAF618280000Z6W',
                    'HAF618280000Z72', 'HAF618280000Z78', 'HAF618280000Z7E', 'HAF618280000ZCB', 'HAF618280000ZS8',
                    'HAF618280000ZS9', 'HAF618280000ZSA', 'HAF618280000ZSB', 'HAF618280000ZSC', 'HAF618280000ZSD',
                    'HAF618280000ZSE', 'HAF618280000ZSF', 'HAF618280001086', 'HAF618280001088', 'HAF61828000108B',
                    'HAF61828000108D', 'HAF61828000108F', 'HAF61828000108G', 'HAF61828000108J', 'HAF61828000108N',
                    'HAF6182800010A5', 'HAF6182800010A7', 'HAF6182800010AF', 'HAF6182800010AH', 'HAF6182800010AL',
                    'HAF6182800010AN', 'HAF6182800010AS', 'HAF6182800010AT', 'HAF6182800010B8', 'HAF6182800010BC',
                    'HAF6182800010BF', 'HAF6182800010BG', 'HAF6182800010BK', 'HAF6182800010BM', 'HAF6182800010BR',
                    'HAF6182800010BT', 'HAF6182800010H2', 'HAF6182800010NB', 'HAF6182800010UA', 'HAF6182800010UD',
                    'HAF6182800010UH', 'HAF6182800010UN', 'HAF6182800010UU', 'HAF6182800010V0', 'HAF6182800010V4',
                    'HAF61828000112E', 'HAF61828000112J', 'HAF61828000112M', 'HAF61828000112P', 'HAF61828000112Z',
                    'HAF618280001131', 'HAF618280001134', 'HAF618280001135', 'HAF6182800011AN', 'HAF6182800011HC',
                    'HAF6182800011VS', 'HAF6182800011VU', 'HAF6182800011VY', 'HAF6182800011W0', 'HAF6182800011W3',
                    'HAF6182800011W7', 'HAF6182800011WA', 'HAF6182800011WD', 'HAF61828000120E', 'HAF61828000127U',
                    'HAF61828000128W', 'HAF618280001292', 'HAF618280001296', 'HAF61828000129A', 'HAF61828000129G',
                    'HAF61828000129K', 'HAF6182800012A5', 'HAF6182800012AG', 'HAF6182800012BZ', 'HAF6182800012C2',
                    'HAF6182800012DW', 'HAF6182800012E2', 'HAF6182800012E5', 'HAF6182800012EB', 'HAF6182800012EE',
                    'HAF6182800012EJ', 'HAF6182800012ES', 'HAF6182800012EW', 'HAF6182800012F0', 'HAF6182800012F3',
                    'HAF6182800012F7', 'HAF6182800012FA', 'HAF6182800012FE', 'HAF6182800012FF', 'HAF6182800012FJ',
                    'HAF6182800012FL', 'HAF6182800012GD', 'HAF6182800012GJ', 'HAF6182800012GP', 'HAF6182800012GT',
                    'HAF6182800012GV', 'HAF6182800012GZ', 'HAF6182800012WA', 'HAF61828000131R', 'HAF618280001321',
                    'HAF61828000133E', 'HAF61828000133T', 'HAF61828000137Y', 'HAF61828000139G', 'HAF61828000139P',
                    'HAF61828000139T', 'HAF61828000139Z', 'HAF6182800013A5', 'HAF6182800013AA', 'HAF6182800013FH',
                    'HAF6182800013FV', 'HAF6182800013GS', 'HAF6182800013JM', 'HAF6182800013K0', 'HAF6182800013K3',
                    'HAF6182800013M1', 'HAF6182800013MS', 'HAF6182800013MU', 'HAF6182800013MZ', 'HAF6182800013N1',
                    'HAF6182800013N4', 'HAF6182800013NC', 'HAF6182800013NG', 'HAF6182800013PL', 'HAF6182800013PR',
                    'HAF6182800013PU', 'HAF6182800013PY', 'HAF6182800013R1', 'HAF6182800013R3', 'HAF6182800013R5',
                    'HAF6182800013R8', 'HAF6182800013SC', 'HAF6182800013SE', 'HAF6182800013VF', 'HAF6182800013VH',
                    'HAF6182800013VN', 'HAF6182800013VU', 'HAF6182800013VW', 'HAF6182800013W0', 'HAF6182800013W3',
                    'HAF618280001440', 'HAF61828000145H', 'HAF6182800014CJ', 'HAF6182800014CS', 'HAF6182800014CW',
                    'HAF6182800014D1', 'HAF6182800014D5', 'HAF6182800014DJ', 'HAF6182800014EE', 'HAF6182800014FH',
                    'HAF6182800014FK', 'HAF6182800014G1', 'HAF6182800014G6', 'HAF6182800014GB', 'HAF6182800014GK',
                    'HAF6182800014JC', 'HAF6182800014JH', 'HAF6182800014LW', 'HAF6182800014M9', 'HAF6182800014MD',
                    'HAF6182800014MG', 'HAF6182800014MK', 'HAF6182800014MP', 'HAF6182800014MV', 'HAF6182800014N3',
                    'HAF6182800014WU', 'HAF6182800014WZ', 'HAF6182800014Y4', 'HAF6182800014Y7', 'HAF6182800014Y9',
                    'HAF6182800014YC', 'HAF61828000154F', 'HAF61828000154J', 'HAF61828000154L', 'HAF61828000154P',
                    'HAF61828000154S', 'HAF61828000154V', 'HAF61828000154Z', 'HAF618280001551', 'HAF61828000155Y',
                    'HAF618280001562', 'HAF618280001566', 'HAF61828000156A', 'HAF61828000156D', 'HAF61828000156F',
                    'HAF61828000156J', 'HAF61828000156M', 'HAF61828000158A', 'HAF61828000158D', 'HAF61828000158L',
                    'HAF61828000158P', 'HAF61828000158R', 'HAF61828000158U', 'HAF61828000158W', 'HAF6182800015F3',
                    'HAF6182800015HL', 'HAF6182800015YS', 'HAF6182800015YU', 'HAF6182800015Z0', 'HAF6182800015Z2',
                    'HAF6182800015Z6', 'HAF6182800015Z8', 'HAF6182800015ZB', 'HAF6182800015ZF', 'HAF61828000165F',
                    'HAF61828000165L', 'HAF61828000165R', 'HAF61828000165Y', 'HAF61828000165Z', 'HAF618280001661',
                    'HAF618280001664', 'HAF618280001666', 'HAF61828000168Z', 'HAF618280001694', 'HAF6182800016N0',
                    'HAF6182800016N7', 'HAF6182800016NK', 'HAF6182800016NP', 'HAF6182800016NY', 'HAF6182800016P4',
                    'HAF6182800016P5', 'HAF6182800016P7', 'HAF6182800016P8', 'HAF6182800016P9', 'HAF6182800016PB',
                    'HAF6182800016PC', 'HAF6182800016PD', 'HAF6182800016PH', 'HAF6182800016SU', 'HAF61828000176E',
                    'HAF61828000176Z', 'HAF6182800017A1', 'HAF6182800017A3', 'HAF6182800017A8', 'HAF6182800017AA',
                    'HAF6182800017AC', 'HAF6182800017EP', 'HAF6182800017EU', 'HAF6182800017EY', 'HAF6182800017FG',
                    'HAF6182800017FH', 'HAF6182800017FK', 'HAF6182800017FL', 'HAF6182800017FN', 'HAF6182800017KE',
                    'HAF6182800017KH', 'HAF6182800017KK', 'HAF6182800017KP', 'HAF6182800017KR', 'HAF6182800017KV',
                    'HAF6182800017L3', 'HAF6182800017L6', 'HAF6182800017L9', 'HAF6182800017LC', 'HAF6182800017LE',
                    'HAF6182800017LH', 'HAF6182800017SC', 'HAF6182800017VK', 'HAF61828000180E', 'HAF61828000181C',
                    'HAF61828000181F', 'HAF61828000181K', 'HAF61828000182B', 'HAF61828000182C', 'HAF61828000182F',
                    'HAF61828000182J', 'HAF6182800018G5', 'HAF6182800018LH', 'HAF6182800018M8', 'HAF6182800018ML',
                    'HAF6182800018MT', 'HAF6182800018MV', 'HAF6182800018MY', 'HAF6182800018N0', 'HAF6182800018N2',
                    'HAF6182800018N3', 'HAF6182800018N6', 'HAF6182800018UH', 'HAF6182800019DE', 'HAF618290000013',
                    'HAF61829000001G', 'HAF61829000001K', 'HAF61829000001L', 'HAF61829000001M', 'HAF61829000001S',
                    'HAF61829000001U', 'HAF61829000001Y', 'HAF618290000021', 'HAF618290000023', 'HAF618290000025',
                    'HAF618290000026', 'HAF61829000002C', 'HAF61829000002J', 'HAF61829000002L', 'HAF61829000002R',
                    'HAF61829000002V', 'HAF61829000003B', 'HAF61829000003G', 'HAF61829000003T', 'HAF61829000003W',
                    'HAF61829000005D', 'HAF61829000005F', 'HAF61829000005H', 'HAF61829000005K', 'HAF61829000005P',
                    'HAF61829000005S', 'HAF61829000005U', 'HAF61829000005V', 'HAF61829000006C', 'HAF61829000006F',
                    'HAF61829000006V', 'HAF61829000006Z', 'HAF618290000071', 'HAF618290000072', 'HAF618290000075',
                    'HAF618290000076', 'HAF618290000078', 'HAF61829000007A', 'HAF61829000007J', 'HAF61829000007N',
                    'HAF61829000007S', 'HAF618290000085', 'HAF618290000089', 'HAF61829000008E', 'HAF61829000008F',
                    'HAF61829000008G', 'HAF61829000008J', 'HAF61829000008M', 'HAF61829000008T', 'HAF61829000008Y',
                    'HAF618290000093', 'HAF618290000094', 'HAF618290000096', 'HAF61829000009E', 'HAF6182900000A8',
                    'HAF6182900000C5', 'HAF6182900000CL', 'HAF6182900000CW', 'HAF6182900000CZ', 'HAF6182900000D3',
                    'HAF6182900000D4', 'HAF6182900000D6', 'HAF6182900000DA', 'HAF6182900000DB', 'HAF6182900000DF',
                    'HAF6182900000DJ', 'HAF6182900000DM', 'HAF6182900000DU', 'HAF6182900000DW', 'HAF6182900000E0',
                    'HAF6182900000E1', 'HAF6182900000EE', 'HAF6182900000EH', 'HAF6182900000EK', 'HAF6182900000EL',
                    'HAF6182900000EP', 'HAF6182900000ER', 'HAF6182900000ET', 'HAF6182900000EV', 'HAF6182900000EW',
                    'HAF6182900000EY', 'HAF6182900000EZ', 'HAF6182900000F1', 'HAF6182900000F3', 'HAF6182900000F8',
                    'HAF6182900000J8', 'HAF6182900000JV', 'HAF6182900000K1', 'HAF6182900000K2', 'HAF6182900000K8',
                    'HAF6182900000KD', 'HAF6182900000KG', 'HAF6182900000KM', 'HAF6182900000KR', 'HAF6182900000L0',
                    'HAF6182900000L8', 'HAF6182900000LC', 'HAF6182900000LH', 'HAF6182900000LM', 'HAF6182900000LS',
                    'HAF6182900000LW', 'HAF6182900000NC', 'HAF6182900000NG', 'HAF6182900000NJ', 'HAF6182900000NS',
                    'HAF6182900000R3', 'HAF6182900000R8', 'HAF6182900000RA', 'HAF6182900000UV', 'HAF6182900000V0',
                    'HAF6182900000VL', 'HAF6182900000W2', 'HAF6182900000W8', 'HAF6182900000WG', 'HAF6182900000YA',
                    'HAF6182900000YD', 'HAF61829000010H', 'HAF61829000011S', 'HAF61829000011U', 'HAF61829000011Y',
                    'HAF618290000120', 'HAF618290000122', 'HAF61829000012A', 'HAF61829000012B', 'HAF61829000012D',
                    'HAF61829000013F', 'HAF61829000013K', 'HAF61829000013R', 'HAF61829000013Z', 'HAF618290000141',
                    'HAF618290000146', 'HAF61829000014A', 'HAF618290000163', 'HAF618290000168', 'HAF61829000016J',
                    'HAF61829000016M', 'HAF61829000016T', 'HAF61829000016Z', 'HAF618290000170', 'HAF618290000172',
                    'HAF618290000176', 'HAF61829000017E', 'HAF6182900001AY', 'HAF6182900001B3', 'HAF6182900001B6',
                    'HAF6182900001B7', 'HAF6182900001CE', 'HAF6182900001CN', 'HAF6182900001CR', 'HAF6182900001CS',
                    'HAF6182900001CV', 'HAF6182900001D0', 'HAF6182900001D3', 'HAF6182900001D8', 'HAF6182900001DA',
                    'HAF6182900001DC', 'HAF6182900001DD', 'HAF6182900001DK', 'HAF6182900001DR', 'HAF6182900001DS',
                    'HAF6182900001DV', 'HAF6182900001DY', 'HAF6182900001E2', 'HAF6182900001E5', 'HAF6182900001E7',
                    'HAF6182900001E9', 'HAF6182900001EB', 'HAF6182900001ED', 'HAF6182900001EH', 'HAF6182900001EM',
                    'HAF6182900001ET', 'HAF6182900001EW', 'HAF6182900001F4', 'HAF6182900001F7', 'HAF6182900001FP',
                    'HAF6182900001FZ', 'HAF6182900001GF', 'HAF6182900001GV', 'HAF6182900001GW', 'HAF6182900001H0',
                    'HAF6182900001H3', 'HAF6182900001H5', 'HAF6182900001H8', 'HAF6182900001H9', 'HAF6182900001HC',
                    'HAF6182900001HE', 'HAF6182900001J4', 'HAF6182900001J6', 'HAF6182900001JF', 'HAF6182900001JJ',
                    'HAF6182900001K2', 'HAF6182900001K4', 'HAF6182900001K5', 'HAF6182900001K8', 'HAF6182900001KB',
                    'HAF6182900001KE', 'HAF6182900001KG', 'HAF6182900001KH', 'HAF6182900001KJ', 'HAF6182900001KK',
                    'HAF6182900001KN', 'HAF6182900001KW', 'HAF6182900001KY', 'HAF6182900001L2', 'HAF6182900001L3',
                    'HAF6182900001L4', 'HAF6182900001L6', 'HAF6182900001L8', 'HAF6182900001L9', 'HAF6182900001LH',
                    'HAF6182900001LJ', 'HAF6182900001LL', 'HAF6182900001LS', 'HAF6182900001M0', 'HAF6182900001M3',
                    'HAF6182900001M4', 'HAF6182900001MM', 'HAF6182900001MP', 'HAF6182900001N0', 'HAF6182900001N2',
                    'HAF6182900001N4', 'HAF6182900001N5', 'HAF6182900001NA', 'HAF6182900001PW', 'HAF6182900001PZ',
                    'HAF6182900001R4', 'HAF6182900001RV', 'HAF6182900001RY', 'HAF6182900001S0', 'HAF6182900001S1',
                    'HAF6182900001S2', 'HAF6182900001S6', 'HAF6182900001S8', 'HAF6182900001SA', 'HAF6182900001UV',
                    'HAF6182900001UY', 'HAF6182900001V2', 'HAF6182900001V4', 'HAF6182900001V7', 'HAF6182900001V9',
                    'HAF6182900001VB', 'HAF6182900001VF', 'HAF6182900001VL', 'HAF6182900001VR', 'HAF6182900001VT',
                    'HAF6182900001VW', 'HAF61829000026S', 'HAF61829000026Y', 'HAF618290000270', 'HAF6182900002BJ',
                    'HAF6182900002BN', 'HAF6182900002BT', 'HAF6182900003UT', 'HAF618290000422', 'HAF618290000428',
                    'HAF61829000042D', 'HAF61829000042F', 'HAF61829000042J', 'HAF61829000042L', 'HAF61829000042P',
                    'HAF618290000461', 'HAF618290000464', 'HAF618290000469', 'HAF61829000046B', 'HAF61829000046E',
                    'HAF61829000046G', 'HAF61829000046K', 'HAF6182900004AZ', 'HAF6182900004B1', 'HAF6182900004B3',
                    'HAF6182900004B5', 'HAF6182900004B7', 'HAF6182900004B9', 'HAF6182900004BE', 'HAF6182900004BH',
                    'HAF6182900004TK', 'HAF6182900004TL', 'HAF6182900004TM', 'HAF6182900004TN', 'HAF6182900004TP',
                    'HAF6182900004TR', 'HAF6182900004TS', 'HAF6182900004TT', 'HAF6182900004TU', 'HAF6182900004TV',
                    'HAF6182900004TW', 'HAF6182900004TZ', 'HAF6182900004U0', 'HAF6182900004U1', 'HAF6182900004U3',
                    'HAF6182900004U5', 'HAF6182900004U6', 'HAF6182900004U7', 'HAF6182900004U8', 'HAF6182900004U9',
                    'HAF6182900004UA', 'HAF61829000054D', 'HAF61829000054E', 'HAF61829000054G', 'HAF61829000054H',
                    'HAF61829000054J', 'HAF61829000054K', 'HAF61829000054L', 'HAF6182900005T3', 'HAF6182900005T5',
                    'HAF6182900005TJ', 'HAF6182900006N6', 'HAF6182900006P2', 'HAF6182900006RC', 'HAF6182900006RZ',
                    'HAF6182900006S3', 'HAF6182900006S5', 'HAF6182900006S8', 'HAF6182900006SB', 'HAF6182900006SE',
                    'HAF6182900006T8', 'HAF6182900006U7', 'HAF6182900006UP', 'HAF6182900006UR', 'HAF6182900006WB',
                    'HAF6182900006WL', 'HAF6182900006WR', 'HAF61829000070D', 'HAF61829000070J', 'HAF61829000070M',
                    'HAF61829000070S', 'HAF61829000070Y', 'HAF618290000710', 'HAF618290000711', 'HAF618290000712',
                    'HAF618290000713', 'HAF618290000714', 'HAF618290000715', 'HAF618290000721', 'HAF61829000072H',
                    'HAF61829000072K', 'HAF61829000072S', 'HAF618290000731', 'HAF61829000074R', 'HAF61829000074Z',
                    'HAF61829000075W', 'HAF61829000075Z', 'HAF618290000762', 'HAF618290000766', 'HAF61829000077A',
                    'HAF61829000077E', 'HAF61829000077T', 'HAF61829000077W', 'HAF618290000784', 'HAF6182900007A6',
                    'HAF6182900007A7', 'HAF6182900007A9', 'HAF6182900007AB', 'HAF6182900007AD', 'HAF6182900007AG',
                    'HAF6182900007AJ', 'HAF6182900007AM', 'HAF6182900007PJ', 'HAF6182900007PL', 'HAF6182900007PS',
                    'HAF6182900007PY', 'HAF6182900007R2', 'HAF6182900007R7', 'HAF6182900007R8', 'HAF61829000082C',
                    'HAF61829000082E', 'HAF61829000082G', 'HAF61829000082M', 'HAF61829000082S', 'HAF61829000082V',
                    'HAF61829000082Y', 'HAF618290000831', 'HAF618290000882', 'HAF618290000884', 'HAF6182900008A7',
                    'HAF6182900008AA', 'HAF6182900008AB', 'HAF6182900008AD', 'HAF6182900008AE', 'HAF6182900008AF',
                    'HAF6182900008AH', 'HAF6182900008AK', 'HAF6182900008AL', 'HAF6182900008AN', 'HAF6182900008AP',
                    'HAF6182900008AR', 'HAF6182900008AT', 'HAF6182900008AU', 'HAF6182900008AV', 'HAF6182900008AY',
                    'HAF618290000B48', 'HAF618290000B4A', 'HAF618290000B4D', 'HAF618290000B4F', 'HAF618290000B4H',
                    'HAF618290000B4J', 'HAF618290000B4M', 'HAF618290000B4N', 'HAF618290000CYC', 'HAF618290000CYF',
                    'HAF618290000CYK', 'HAF618290000CYM', 'HAF618290000CYN', 'HAF618290000CYS', 'HAF618290000CYT',
                    'HAF618290000CYY', 'HAF618290000GMF', 'HAF618290000GND', 'HAF618290000GNE', 'HAF618290000GNG',
                    'HAF618290000GNH', 'HAF618290000GNK', 'HAF618290000GNL', 'HAF618290000GNN', 'HAF618290000GNP',
                    'HAF618290000GNR', 'HAF618290000GNT', 'HAF618290000GNU', 'HAF618290000GNZ', 'HAF618290000GP1',
                    'HAF618290000GP2', 'HAF618290000GP3', 'HAF618290000GP5', 'HAF618290000GP7', 'HAF618290000GPC',
                    'HAF618290000GPD', 'HAF618290000GPE', 'HAF6183000001JA', 'HAF6183000001JE', 'HAF6183000001JH',
                    'HAF6183000001JM', 'HAF6183000001JS', 'HAF6183000001KD', 'HAF6183000001KL', 'HAF6183000001M9',
                    'HAF6183000001MG', 'HAF6183000001NF', 'HAF6183000001NJ', 'HAF6183000001NM', 'HAF6183000001NR',
                    'HAF6183000001NW', 'HAF6183000001P0', 'HAF6183000001P5', 'HAF6183000001R3', 'HAF6183000001R4',
                    'HAF6183000001R6', 'HAF6183000001R7', 'HAF6183000001RA', 'HAF6183000001RE', 'HAF6183000001RF',
                    'HAF6183000001RH', 'HAF6183000001RJ', 'HAF6183000001RL', 'HAF6183000001RM', 'HAF6183000001RN',
                    'HAF6183000001RR', 'HAF61830000049N', 'HAF61830000049P', 'HAF61830000049R', 'HAF61830000049S',
                    'HAF61830000049T', 'HAF6183000004CA', 'HAF6183000004CB', 'HAF6183000004CC', 'HAF6183000004CD',
                    'HAF6183000004CF', 'HAF6183000004CH', 'HAF6183000004CR', 'HAF6183000004CS', 'HAF6183000004CT',
                    'HAF6183000004CU', 'HAF6183000004CV', 'HAF6183000004CW', 'HAF6183000004CY', 'HAF6183000004CZ',
                    'HAF6183000004D0', 'HAF618300000621', 'HAF618300000622', 'HAF618300000624', 'HAF618300000ANK',
                    'HAF618300000ANM', 'HAF618300000ANN', 'HAF618300000ANP', 'HAF618300000ANR', 'HAF618300000ANS',
                    'HAF618300000ANT', 'HAF618300000ANU', 'HAF618300000C2J', 'HAF618300000C2M', 'HAF618300000C2N',
                    'HAF618300000C2P', 'HAF618300000C2R', 'HAF618300000C2T', 'HAF618300000C2U', 'HAF618300000C2V',
                    'HAF618300000C2W', 'HAF618300000C2Y', 'HAF6183100003BU', 'HAF6183100003BV', 'HAF6183100003BW',
                    'HAF6183100003BY', 'HAF6183100003BZ', 'HAF6183100003C0', 'HAF6183100003C1', 'HAF6183100003C2',
                    'HAF6183100005YD', 'HAF6183200003EB', 'HAF6183200003EC', 'HAF6183200003ED', 'HAF6183600001LH',
                    'HAF6183600001RP', 'HAF6183600003Y1', 'HAF61836000043H', 'HAF6183600004CZ', 'HAF6183600004DS',
                    'HAF6183600004DU', 'HAF6183600004E3', 'HAF6183600004PA', 'HAF6183600004VM', 'HAF6183600004VS',
                    'HAF6183600004WV', 'HAF6183600004Y0', 'HAF618360000501', 'HAF61836000059N', 'HAF618360000627',
                    'HAF61836000068C', 'HAF61836000068T', 'HAF6183600006AS', 'HAF6183600008SA', 'HAF6183600009HP',
                    'HAF618360000AY4', 'HAF618360000BCJ', 'HAF618360000C5T', 'HAF618360000HR5', 'HAF618360000HY1',
                    'HAF618360000K83', 'HAF618360000KFV', 'HAF618360000PC0', 'HAF618360000PC7', 'HAF618360001366',
                    'HAF61836000137N', 'HAF61836000189L', 'HAF6183600018Y3', 'HAF618360001EUJ', 'HAF618360001J2D',
                    'HAF618360001J2F', 'HAF618360001J2K', 'HAF618360001JD0', 'HAF618360001JPZ', 'HAF618360001LNZ',
                    'HAF618360001LR8', 'HAF618360001LRP', 'HAF618360001MUK', 'HAF618360001R01', 'HAF618360001RKY',
                    'HAF618360001RKZ', 'HAF618360001RLC', 'HAF618360001RLG', 'HAF618360001RS4', 'HAF618360001RUL',
                    'HAF618360001RWV', 'HAF618360001RY4', 'HAF618360001S2F', 'HAF618360001S5E', 'HAF618360001S64',
                    'HAF618360001SSC', 'HAF618360001T7Z', 'HAF618360001T9V', 'HAF618360001TA6', 'HAF618360001UJB',
                    'HAF618360001VLA', 'HAF618360001WC0', 'HAF618360001WWG', 'HAF6183700005SU', 'HAF6183700008BD',
                    'HAF6183700008FM', 'HAF618370000CRY', 'HAF618370000H7Z', 'HAF618380000RY6', 'HAF618380000RZB',
                    'HAF618380000S0Z', 'HAF618380000S1L', 'HAF618380000S35', 'HAF618380000S4C', 'HAF618380000SBG',
                    'HAF618380000SBT', 'HAF618380000SD4', 'HAF618380000SE5', 'HAF618380000SRG', 'HAF618380000SSE',
                    'HAF618380000SU9', 'HAF618380000SV9', 'HAF618380000SZW', 'HAF618380000T0J', 'HAF618380000T2S',
                    'HAF618380000T3T', 'HAF618380000T54', 'HAF618380000T63', 'HAF618380000T69', 'HAF618380000T8Y',
                    'HAF618380000TF7', 'HAF618380000TGF', 'HAF618380000UL1', 'HAF618380000V12', 'HAF618380000V1A',
                    'HAF618380000VBN', 'HAF618380000VJ1', 'HAF618380000WFH', 'HAF618380000WGZ', 'HAF618380000WHU',
                    'HAF618380000WHW', 'HAF618380000WTN', 'HAF618380000YTM', 'HAF618380000ZB4', 'HAF618380000ZEY',
                    'HAF618380000ZGV', 'HAF618380000ZR6', 'HAF618380000ZVD', 'HAF618380000ZW2', 'HAF618380000ZZ2',
                    'HAF61838000100F', 'HAF618380001062', 'HAF61838000107L', 'HAF61838000108M', 'HAF61838000109H',
                    'HAF61838000109J', 'HAF6183800010B8', 'HAF6183800010CW', 'HAF6183800010PM', 'HAF6183800010S4',
                    'HAF6183800010WB', 'HAF61838000112V', 'HAF61838000114Y', 'HAF61838000115Y', 'HAF6183800011A2',
                    'HAF6183800011BT', 'HAF6183800011CP', 'HAF6183800011JS', 'HAF6183800011LV', 'HAF6183800011NR',
                    'HAF6183800011RC', 'HAF618380001251', 'HAF61838000125U', 'HAF61838000127R', 'HAF61838000127Z',
                    'HAF6183800012B4', 'HAF6183800012DN', 'HAF6183800012LK', 'HAF6183800012LS', 'HAF6183800012RF',
                    'HAF61838000137M', 'HAF6183800013C4', 'HAF6183800013JH', 'HAF6183800013SR', 'HAF6183800013W6',
                    'HAF618380001412', 'HAF618380001430', 'HAF6183800014C6', 'HAF6183800014ZP', 'HAF6183800014ZS',
                    'HAF618380001525', 'HAF6183800015EM', 'HAF6183800015EV', 'HAF618380001636', 'HAF6183800016UB',
                    'HAF618380001D3U', 'HAF6183900001WU', 'HAF6183900001Y2', 'HAF6183900001ZW', 'HAF6183900002D3',
                    'HAF618390000642', 'HAF61839000068W', 'HAF618390000698', 'HAF618390000FPN', 'HAF618390000FR4',
                    'HAF618390000FR9', 'HAF618390000FRU', 'HAF618390000FRZ', 'HAF618390000GNB', 'HAF618390000GNR',
                    'HAF618390000GNW', 'HAF618390000GPC', 'HAF618390000H5K', 'HAF618390000H5V', 'HAF618390000H6K',
                    'HAF618390000H71', 'HAF618390000H73', 'HAF618390000H7K', 'HAF618390000H8C', 'HAF618390000HKW',
                    'HAF618390000HL7', 'HAF618390000HS5', 'HAF618390000HSC', 'HAF618390000JHZ', 'HAF618390000K34',
                    'HAF618390000K94', 'HAF618390000MZD', 'HAF618390000V9V', 'HAF618390000ZVD', 'HAF618390000ZZ9',
                    'HAF618390000ZZP', 'HAF61839000106P', 'HAF6183900010F6', 'HAF6183900010G1', 'HAF6183900010GK',
                    'HAF6183900010TM', 'HAF6183900010Y0', 'HAF6183900010Y9', 'HAF6183900010Z6', 'HAF6183900010ZC',
                    'HAF61839000114Z', 'HAF618390001152', 'HAF6183900011F8', 'HAF6183900011FG', 'HAF6183900011G5',
                    'HAF6183900011GU', 'HAF6183900011RU', 'HAF6183900011T3', 'HAF6183900011T7', 'HAF6183900011TN',
                    'HAF61839000121D', 'HAF618390001226', 'HAF61839000124E', 'HAF618390001284', 'HAF61839000129K',
                    'HAF6183900012A4', 'HAF6183900013AK', 'HAF6183900013D5', 'HAF6183900013DS', 'HAF6183900013EJ',
                    'HAF6183900013YK', 'HAF6183900013Z9', 'HAF6183900013ZM', 'HAF618390001422', 'HAF618390001459',
                    'HAF618390001472', 'HAF6183900014AH', 'HAF6183900014AY', 'HAF6183900014C0', 'HAF6183900014E4',
                    'HAF6183900014WK', 'HAF618510000YB6', 'HAF618510000YB9', 'HAF618510000YDP', 'HAF61851000113T',
                    'HAF61851000172F', 'HAF618510001GB3']
