# -*- coding: UTF-8 -*-
import common
import os
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(devObj):
    '''
        健康检查前置脚本
    '''

    try:
        if not verfyRuleConfig():
            return ('', dict(flag=False, des=common.getMsg(LANG, "sign.exception.info")))

        cli = devObj.get("ssh")
        isAdmin, cliRet, errMsg = common.checkIsAdmin(cli)
        if not isAdmin:
            LOGGER.logInfo("checkIsAdmin:is not admin.")

            return ('', dict(flag=False, des=common.getMsg(LANG, "user.level.not.admin")))
        LOGGER.logInfo("checkIsAdmin:is admin.")
        
        if checkIsAgModel(cli):
            return ('', dict(flag=False, des=common.getMsg(LANG, "not.support.ag.model")))
        
        return ('', dict(flag=True, des=common.getMsg(LANG, "check.pass")))
    except Exception, exception:
        LOGGER.logException(exception)
        return ('', dict(flag=False, des=common.getMsg(LANG, "query.result.abnormal")))


def checkIsAgModel(cli):
    AGModel = "Access Gateway Mode"
    cmd = "switchshow"
    cliRet = cli.execCmdWithTimout(cmd, 300)
    if AGModel in cliRet:
        return True
    
    return False


def verfyRuleConfig():
    """
    校验规则配置相关文件
    :return:
    """
    import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils
    import java.io.File
    filePath = os.path.abspath(".") + "{0}packages{0}inspector{0}products{0}pyframe{0}frameone{0}ruleConfig".format(os.sep)
    fileList = os.listdir(filePath)
    try:
        for fileName in fileList:
            # init.py是空文件，主动校验会失败，需忽略
            if fileName.endswith(".sign") or fileName.endswith(".class") or "__init__.py" in fileName:
                LOGGER.logInfo("not check sign, ignore file name:%s" % fileName)
                continue

            tmpFilePath = filePath + os.sep + fileName
            flag = com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils.getInstance().verify(
                java.io.File(tmpFilePath))
            LOGGER.logInfo("verfyRuleConfig flag:%s, filePath:%s" % (flag, tmpFilePath))
            if not flag:
                return False

        return True
    except:
        return True
