#!/usr/bin/python3
# -*- coding: utf-8 -*-
# 版权所有 (c) 华为技术有限公司 2023-2023
from err_msg_dict import ERROR_MSG_DICT
from common import cantian_inspector, RESULT_WARNING, get_err_msg

"""
函数名称: execute
功能说明: 检查归档状态
输入参数: cli
输出参数: 无
返 回 值: flag, cliRet, errMsg
"""


def execute(cli):
    """
    :param cli: cli--Telnet access proxy
    :return: the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    cmd = "su - %s -s /bin/bash -c \"python3 " \
          "/opt/cantian/action/inspection/inspection_task.py ['archive_status_check']\""
    cmd_archive = "python3 /opt/cantian/action/get_config_info.py storage_archive_fs"
    cli_ret = cli.execCmd(cmd_archive)
    storage_archive_fs = cli_ret.strip()
    cmd_line = "mountpoint /mnt/dbdata/remote/archive_{};echo $?".format(storage_archive_fs)
    err_code = ""
    flag = False
    try:
        flag, detail = cantian_inspector(cmd, cli)
    except Exception as err:
        err_code = "cantian.common.error"
        return flag, str(err), get_err_msg(lang, err_code, ERROR_MSG_DICT)
    return_code = cli.execCmd(cmd_line)
    if "db_type is 0" in detail:
        err_code = "cantian.archive.unable"
        return RESULT_WARNING, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
    elif "can not connect to" in detail:
        err_code = "cantian.archive.connection.failed"
        return flag, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
    elif "can not find mount node info" in detail:
        err_code = "cantian.archive.connection.failed"
    elif ("The archive configuration capacity must be less than or " in detail or
            "equal to 45% of the maximum archive file system capacity" in detail):
        err_code = "cantian.archive.threshold.not.properly"
    elif "The used archive file capacity exceeds the threshold, causing archive failure" in detail:
        err_code = "cantian.archive.usage.error"
        return RESULT_WARNING, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
    elif return_code != 0:
        err_code = "cantian.archive.connection.failed"
        return flag, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
    return flag, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
