#!/usr/bin/python3
# -*- coding: utf-8 -*-
# 版权所有 (c) 华为技术有限公司 2023-2023
from err_msg_dict import ERROR_MSG_DICT
from common import cantian_inspector, get_err_msg

"""
函数名称: execute
功能说明: 集群状态检查
输入参数: cli
输出参数: 无
返 回 值: flag, cliRet, errMsg
"""


def execute(cli):
    """
    :param cli: cli--Telnet access proxy
    :return: the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    cmd = "su - %s -s /bin/bash -c \"python3 " \
          "/opt/cantian/action/inspection/inspection_task.py ['cantian_status']\""
    err_code = ""
    flag = False
    try:
        flag, detail = cantian_inspector(cmd, cli)
    except Exception as err:
        err_code = "cantian.common.error"
        return flag, str(err), get_err_msg(lang, err_code, ERROR_MSG_DICT)
    if not flag:
        err_code = "cantian.status.abnormal"
    return flag, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
