# -*- coding: UTF-8 -*-
from err_msg_dict import ERROR_MSG_DICT
from common import mysql_inspector, get_err_msg

"""
函数名称: execute
功能说明: mysql共享内存通信文件检查
输入参数: cli
输出参数: 无
返 回 值: flag, cliRet, errMsg
"""


def execute(cli):
    """
    :param cli: cli--Telnet access proxy
    :return: the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    err_code = ""
    flag = False
    try:
        flag, detail = mysql_inspector("mysql_file_check", cli)
    except Exception as err:
        err_code = "cantian.common.error"
        return flag, str(err), get_err_msg(lang, err_code, ERROR_MSG_DICT)
    if "not all shm files exist" in detail:
        err_code = "mysql.shm.file.not.exist"
    elif "not all files can be read and written" in detail or\
            "not all uid of shm files are 5000 " in detail:
        err_code = "mysql.shm.file.permission.failed"
    elif not flag:
        err_code = "mysql.connection.abnormal"
    return flag, detail, get_err_msg(lang, err_code, ERROR_MSG_DICT)
