#!/usr/bin/python3
# -*- coding: utf-8 -*-
# 版权所有 (c) 华为技术有限公司 2023-2023
import os
import re
from collections import defaultdict
import err_msg_dict

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"


def get_run_user(cli):
    cmd = "runuser=$(cat /opt/cantian/action/env.sh | grep cantian_user | grep -oP '\"\K[^\"]+');echo $runuser"
    run_user = cli.execCmd(cmd).split("\n")[1].strip()
    return run_user


def cantian_inspector(cmd, cli):
    flag = False
    detail = ""
    run_user = get_run_user(cli)
    cli_ret = cli.execCmd(cmd % run_user)
    dir_pattern = r"/opt/cantian/action/inspection/inspections_log/inspection_cantian_[\d.]+_[\d]+"
    dir_match = re.search(dir_pattern, cli_ret)
    file_dir = dir_match.group()
    all_files = cli.execCmd("ls %s" % file_dir)
    file_pattern = r"cantian_[\d.]+_inspection_result_en+\.html"
    file_match = re.search(file_pattern, all_files)
    file_path = file_match.group()
    file_path = file_dir + "/" + file_path
    inspect_res = cli.execCmd("cat %s" % file_path)
    status_pattern = r'<td style="width: 10%;background-color: darkgray;text-align: ' \
                     r'center">\s*result\s*</td>\s*<td.*?>\s*<div style=".*?">\s*(.+?)\s*</div>'
    status_match = re.search(status_pattern, inspect_res)
    if status_match:
        status = status_match.group(1)
        if status == "success":
            flag = True
    detail_pattern = r'<td style="width: 10%;background-color: darkgray;text-align: ' \
                     r'center">\s*information\s*</td>.*?<div style=".*?">\s*({.*?})\s*</div>'
    detail_match = re.search(detail_pattern, inspect_res, re.DOTALL)
    if detail_match:

        detail = detail_match.group(1)
    return flag, detail


def mysql_inspector(inspect_item, cli):
    get_user_cmd = "python3 /opt/cantian/action/get_config_info.py \"deploy_user\""
    deploy_user = cli.execCmd(get_user_cmd)
    deploy_user = deploy_user.split("\n")[1].strip()
    remove_cmd = "su -s /bin/bash - %s -c \"rm -rf /opt/cantian/image/cantian_connector/" \
                 "for_mysql_official/mf_connector_mount_dir/" \
                 "inspection/inspections_log/* \"" % deploy_user
    cli.execCmd(remove_cmd)
    flag = True
    details = []
    namespaces = []
    pod_dict = defaultdict(list)
    kubectl_check_cmd = "kubectl version"
    cli_ret = cli.execCmd(kubectl_check_cmd)
    if "Server Version:" not in cli_ret:
        details.append("No mysql container")
        return flag, details
    metadata_fs_cmd = 'python3 /opt/cantian/action/get_config_info.py storage_metadata_fs'
    cli_ret = cli.execCmd(metadata_fs_cmd)
    metadata_fs = cli_ret.splitlines()[1]
    metadata_fs_file_cmd = "ls /mnt/dbdata/remote/metadata_%s" % metadata_fs
    metadata_fs_file = cli.execCmd(metadata_fs_file_cmd)
    if "No such file or directory" in metadata_fs_file:
        details.append("Cantian engine uninstalled.")
        return False, details
    get_namespaces_and_pods(cli, metadata_fs_file, namespaces, pod_dict)
    if not pod_dict:
        return flag, "No mysql container"
    flag, detail = check_namespace_and_pod(cli, details, inspect_item, pod_dict)
    return flag, detail


def check_namespace_and_pod(cli, details, inspect_item, pod_dict):
    detail = ""
    flag = False
    for namespace, pod_list in pod_dict.items():
        for pod_name in pod_list:
            containers_cmd = r"kubectl get pods -n %s %s  -o=jsonpath='{.spec.containers[*].name}' && echo ''" \
                             % (namespace, pod_name)
            containers_res = cli.execCmd(containers_cmd)
            contains = re.split(r"\s+", containers_res.split("\n")[1].strip())
            _args = [cli, contains, details, inspect_item, namespace, pod_name]
            flag, detail = enter_container(*_args)
    return flag, detail


def enter_container(*args):
    detail = ""
    flag = False
    cli, contains, details, inspect_item, namespace, pod_name = args
    check_pod_status = "kubectl get pods -n %s %s -o=jsonpath='{.status.phase}'" % (namespace, pod_name)
    pod_status = cli.execCmd(check_pod_status)
    if "Running" not in pod_status:
        details.append("namespace: %s  pod_name: %s   \n result: %s\n"
                       % (namespace, pod_name, pod_status))
        return flag, details
    check_file_cmd = "kubectl exec -n %s %s  -- ls /mf_connector/inspection/inspection_task.py;echo last_cmd=$?" \
                     % (namespace, pod_name)
    contain_res = cli.execCmd(check_file_cmd)
    if "last_cmd=0" not in contain_res:
        if "unable to upgrade connection: container not found" not in contain_res:
            detail = "container is offline."
            details.append("namespace: %s  pod_name: %s  \n result: %s\n"
                           % (namespace, pod_name, detail))
        return flag, details
    _args = [cli, detail, details, inspect_item, namespace, pod_name]
    flag, detail = execute_inspection(*_args)
    return flag, detail


def execute_inspection(*args):
    flag = False
    cli, detail, details, inspect_item, namespace, pod_name = args
    inspect_cmd = "kubectl exec -n %s %s -- /usr/bin/python3 /mf_connector/inspection/inspection_task.py " \
                  "['%s'];echo ''" % (namespace, pod_name, inspect_item)
    cli_ret = cli.execCmd(inspect_cmd)
    dir_pattern = r"/mf_connector/inspection/inspections_log/inspection_mysql_[\d.]+_[\d]+"
    dir_match = re.search(dir_pattern, cli_ret)
    file_dir = dir_match.group()
    html_file_path_cmd = "kubectl exec -n %s %s -- ls %s" % (
        namespace, pod_name, file_dir)
    all_files = cli.execCmd(html_file_path_cmd)
    file_pattern = r"mysql_[\d.]+_inspection_result_en+\.html"
    file_match = re.search(file_pattern, all_files)
    file_path = file_match.group()
    file_path = file_dir + "/" + file_path
    html_file_content_cmd = "kubectl exec -n %s %s -- cat %s" % (
        namespace, pod_name, file_path)
    inspect_res = cli.execCmd(html_file_content_cmd)
    status_pattern = r'<td style="width: 10%;background-color: darkgray;text-align: ' \
                     r'center">\s*result\s*</td>\s*<td.*?>\s*<div style=".*?">\s*(.+?)\s*</div>'
    status_match = re.search(status_pattern, inspect_res)
    if status_match:
        status = status_match.group(1)
        if status == "success":
            flag = True
    detail_pattern = r'<td style="width: 10%;background-color: darkgray;text-align: ' \
                     r'center">\s*information\s*</td>.*?<div style=".*?">\s*({.*?})\s*</div>'
    detail_match = re.search(detail_pattern, inspect_res, re.DOTALL)
    if detail_match:
        detail = detail_match.group(1)
        details.append("namespace: %s  pod_name: %s  \n result: %s\n"
                       % (namespace, pod_name, detail))
    return flag, detail


def get_namespaces_and_pods(cli, metadata_fs_file, namespaces, pod_dict):
    namespace_cmd = "kubectl get namespaces"
    namespaces_res = cli.execCmd(namespace_cmd)
    for item in namespaces_res.splitlines()[1:-1]:
        name = re.split(r"\s+", item.strip())[0]
        if name in metadata_fs_file:
            namespaces.append(str(name))
    for namespace in namespaces:
        pod_cmd = "kubectl get pods -n %s" % namespace
        pod_res = cli.execCmd(pod_cmd)
        if "No resources found" in pod_res:
            continue
        for item in pod_res.split("\n")[2:-1]:
            pod_name = re.split(r"\s+", item.strip())[0]
            if pod_name in metadata_fs_file:
                pod_dict[namespace].append(str(pod_name))


def get_err_msg(lang, msg, resource, args=""):
    """
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    """
    err_msg = ""

    local_dict = resource.get(msg)
    if not local_dict:
        return err_msg

    local_msg = local_dict.get(lang)
    if not local_msg:
        return err_msg
    if "%s" in local_msg or "%i" in local_msg:
        return local_msg % args
    else:
        return local_msg
