# coding: UTF-8

import re
import common
from com.huawei.ism.exception import IsmException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ITEM_ID = "checkPangeaSASDriverUpgrade"


def execute(rest):
    """
    检查SAS驱动版本
    :param rest: 集群rest连接
    :return:检查结果
    """
    try:
        LOGGER.logInfo("checkPangeaSASDriverUpgrade begin ...")
        source_info = py_java_env.get("sourceInfo")
        if is_check_pass(source_info):
            return common.INSPECT_PASS, source_info, ""
        dev_version = py_java_env.get("version")
        if is_involve_product_version(dev_version):
            err_code = "checkPangeaSASDriverUpgrade.result.not.pass"
            return common.INSPECT_UNNORMAL, source_info, common.get_err_msg(LANG, err_code)
        return common.INSPECT_PASS, source_info, ""
    except (IsmException, Exception) as exception:
        LOGGER.logException(exception)
        return common.INSPECT_UNNORMAL, exception, common.get_err_msg(LANG,
                                                                      "checkPangeaSASDriverUpgrade.result.not.pass")


def is_check_pass(source_info):
    if "fail" in source_info:
        return False
    return True


def is_involve_product_version(product_version):
    """
    检查版本信息: 目标版本为815, 补丁版本小于SPH036
    """
    version = str(product_version).replace('.', "")
    if "815" in version:
        if "SPH" not in version:
            return True
        version_list = version.split("SPH")
        if len(version_list) < 2:
            return True
        patch = re.findall(r'\d+', version_list[1])
        if (len(patch) == 0):
            return True
        if int(patch[0]) < 36:
            return True
    return False
